/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.repository.PlanRepositoryLink;
import com.atlassian.bamboo.repository.RepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.RepositoryPositionProvider;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import org.jetbrains.annotations.NotNull;

@Internal
public class RepositoryPredicates {
    private RepositoryPredicates() {
    }

    public static Predicate<PlanRepositoryLink> hasPlanRepositoryLinkEqualRepositoryId(long repositoryId) {
        return prl -> repositoryId == ((PlanRepositoryLink)Preconditions.checkNotNull((Object)prl)).getRepositoryDataEntity().getId();
    }

    @Deprecated
    public static Predicate<RepositoryDefinition> hasRepositoryDefinitionEqualPluginKey(@NotNull String pluginKey) {
        return BambooPluginUtils.pluginKeyEquals(pluginKey)::test;
    }

    public static Predicate<RepositoryDefinition> isRepositoryDefinitionDefault() {
        return rd -> 0 == ((RepositoryDefinition)Preconditions.checkNotNull((Object)rd)).getPosition();
    }

    public static Predicate<RepositoryPositionProvider> isPlanRepositoryDefinitionDefault() {
        return rd -> 0 == ((RepositoryPositionProvider)Preconditions.checkNotNull((Object)rd)).getPosition();
    }
}

