/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.repository.PreparableRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.repository.RepositoryManager;
import com.atlassian.bamboo.repository.RequiresRepositoryData;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.agent.capability.AgentContext;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Preconditions;
import io.atlassian.util.concurrent.LazyReference;
import org.apache.commons.configuration.HierarchicalConfiguration;

@Internal
class RepositoryReference
extends LazyReference<Repository> {
    private final RepositoryData repositoryData;

    public RepositoryReference(RepositoryData repositoryData) {
        this.repositoryData = repositoryData;
    }

    protected Repository create() throws Exception {
        RequiresRepositoryData requiresRepositoryData;
        AgentContext agentContext;
        String repositoryPluginKey = this.repositoryData.getPluginKey();
        Repository repository = ((RepositoryManager)ComponentAccessor.REPOSITORY_MANAGER.get()).getNewRepositoryInstance(repositoryPluginKey);
        Preconditions.checkState((repository != null ? 1 : 0) != 0, (String)"Cannot load repository with key %s. Plugins may have been disabled.", (Object[])new Object[]{repositoryPluginKey});
        HierarchicalConfiguration repositoryConfiguration = this.repositoryData.getConfiguration();
        repository.populateFromConfig(repositoryConfiguration);
        PreparableRepository preparableRepository = (PreparableRepository)Narrow.downTo((Object)repository, PreparableRepository.class);
        if (preparableRepository != null && ((agentContext = (AgentContext)ContainerManager.getComponent((String)"agentContext")) == null || agentContext.getBuildAgent() == null)) {
            preparableRepository.onPrepare(repositoryConfiguration);
        }
        if ((requiresRepositoryData = (RequiresRepositoryData)Narrow.downTo((Object)repository, RequiresRepositoryData.class)) != null) {
            requiresRepositoryData.setRepositoryId(this.repositoryData.getId());
        }
        return repository;
    }
}

