/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.webrepository.NoWebRepositoryViewer;
import com.atlassian.bamboo.webrepository.WebRepositoryViewer;
import com.atlassian.bamboo.webrepository.WebRepositoryViewerManager;
import com.atlassian.spring.container.ContainerManager;
import io.atlassian.util.concurrent.LazyReference;
import org.apache.log4j.Logger;

@Internal
class WebRepositoryViewerReference
extends LazyReference<WebRepositoryViewer> {
    private static final Logger log = Logger.getLogger(WebRepositoryViewerReference.class);
    private final RepositoryData repositoryData;

    public WebRepositoryViewerReference(RepositoryData repositoryData) {
        this.repositoryData = repositoryData;
    }

    protected WebRepositoryViewer create() throws Exception {
        String webRepositoryPluginKey = this.repositoryData.getWebRepositoryPluginKey();
        WebRepositoryViewerManager webRepositoryViewerManager = (WebRepositoryViewerManager)ContainerManager.getComponent((String)"webRepositoryViewerManager");
        WebRepositoryViewer webRepositoryViewer = webRepositoryViewerManager.getNewWebRepositoryViewerInstance(webRepositoryPluginKey);
        if (webRepositoryViewer != null) {
            webRepositoryViewer.populateFromConfig(this.repositoryData.getConfiguration());
        } else {
            webRepositoryViewer = new NoWebRepositoryViewer();
        }
        return webRepositoryViewer;
    }
}

