/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.cvsimpl;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildConfigurationValidationUtils;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.repository.AbstractStandaloneRepository;
import com.atlassian.bamboo.repository.AuthenticationType;
import com.atlassian.bamboo.repository.MavenPomAccessorCapableRepository;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.repository.QuietPeriodAwareRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.SelectableAuthenticationRepository;
import com.atlassian.bamboo.repository.cvsimpl.CvsRepositoryManager;
import com.atlassian.bamboo.repository.cvsimpl.CvsRepositoryMavenPomAccessor;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.v2.build.repository.LegacyRepository;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public class CVSRepository
extends AbstractStandaloneRepository
implements LegacyRepository,
SelectableAuthenticationRepository,
QuietPeriodAwareRepository,
MavenPomAccessorCapableRepository {
    private static final Logger log = Logger.getLogger(CVSRepository.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss Z";
    public static final FastDateFormat DEFAULT_LOG_DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss Z", (TimeZone)TimeZone.getDefault());
    private FastDateFormat logDateFormat = DEFAULT_LOG_DATE_FORMAT;
    private static final int DEFAULT_QUIET_PERIOD_SEC = 2;
    private static final int DEFAULT_QUIET_PERIOD = 2;
    private static final int INVALID_QUIET_PERIOD = -1;
    private static final int MAX_NUM_CVS_RETRIES = 5;
    private static final int MAX_QUIET_PERIOD = 180;
    private static final int MAX_DAYS = 365;
    public static final String NAME = "CVS";
    public static final String KEY = "cvs";
    public static final String COMPLETE_PLUGIN_KEY = "com.atlassian.bamboo.plugin.system.repository:cvs";
    public static final String BUILD_MODULE_TRUNK = "head";
    public static final String BUILD_MODULE_BRANCH = "branch";
    private static final String REPO_PREFIX = "repository.cvs.";
    public static final String CVS_VERSION_TYPE = "repository.cvs.selectedVersionType";
    public static final String CVS_ROOT = "repository.cvs.cvsRoot";
    public static final String CVS_PASSWORD = "repository.cvs.password";
    public static final String CVS_QUIET_PERIOD = "repository.cvs.quietPeriod";
    public static final String CVS_MODULE = "repository.cvs.module";
    public static final String CVS_BRANCH = "repository.cvs.branchName";
    public static final String CVS_AUTH_TYPE = "repository.cvs.authType";
    public static final String CVS_KEY_FILE = "repository.cvs.keyFile";
    public static final String CVS_PASSPHRASE = "repository.cvs.passphrase";
    public static final String CVS_LAST_UPDATE = "repository.cvs.lastUpdate";
    private static final String TEMPORARY_CVS_PASSWORD_CHANGE = "temporary.cvs.passwordChange";
    public static final String TEMPORARY_CVS_PASSWORD = "temporary.cvs.password";
    private static final String TEMPORARY_CVS_PASSPHRASE_CHANGE = "temporary.cvs.passphraseChange";
    private static final String TEMPORARY_QUIET_PERIOD_FOR_JOB = "temporary.cvs.empty.quiet.period.for.job.validation";
    private String module;
    private String cvsRoot;
    private String password;
    private String branchName;
    private String passphrase;
    private String keyFile;
    private String authType;
    private int quietPeriod = 2;
    SymbolicNameType symbolicNameType = SymbolicNameType.UNKNOWN;
    public transient CvsRepositoryManager cvsRepositoryManager;

    @NotNull
    public BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, @Nullable String lastVcsRevisionKey) throws RepositoryException {
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((Key)PlanKeys.getPlanKey((String)planKey));
        try {
            String clientPath = this.getSourceCodeDirectory(PlanKeys.getPlanKey((String)planKey)).getAbsolutePath();
            this.symbolicNameType = this.cvsRepositoryManager.getSymbolicNameType(clientPath, buildLogger, this);
            if (this.symbolicNameType == SymbolicNameType.TAG) {
                log.info((Object)buildLogger.addBuildLogEntry("Detected operation on a tag, not searching for changesets"));
                return new BuildRepositoryChangesImpl();
            }
            Date lastUpdate = lastVcsRevisionKey != null ? this.fromVcsKeyToDate(lastVcsRevisionKey) : this.getLastCommitDate(buildLogger, null);
            List<Commit> commits = this.cvsRepositoryManager.getCommitsSince(lastUpdate, clientPath, buildLogger, this);
            Date currentDate = this.cvsRepositoryManager.findLatestDateFromCommits(commits);
            if (currentDate == null) {
                currentDate = lastUpdate;
            }
            log.info((Object)buildLogger.addBuildLogEntry("Found " + commits.size() + " change sets in the change logs"));
            return new BuildRepositoryChangesImpl(-1L, this.fromDateToVcsKey(currentDate), commits);
        }
        catch (Exception e) {
            String errorMessage = buildLogger.addErrorLogEntry("Failed to get change logs: " + e.getMessage());
            log.error((Object)errorMessage, (Throwable)e);
            throw new RepositoryException(errorMessage, (Throwable)e);
        }
    }

    @NotNull
    private Date getLastCommitDate(BuildLogger buildLogger, String sourceDir) throws CommandException, AuthenticationException {
        log.info((Object)buildLogger.addBuildLogEntry("Trying to find the last commit date for repository..."));
        Date today = new Date();
        int i = 1;
        Date lastDateFromCommit = null;
        do {
            Date dateToCheck;
            List<Commit> commits;
            if ((commits = this.cvsRepositoryManager.getCommitsSince(dateToCheck = DateUtils.addDays((Date)today, (int)(-i)), sourceDir, buildLogger, this)).isEmpty() || (lastDateFromCommit = this.cvsRepositoryManager.findLatestDateFromCommits(commits)) != null) continue;
            log.warn((Object)("Comits found but no dates set... " + commits));
        } while ((i += 5) < 365 && lastDateFromCommit == null);
        if (lastDateFromCommit != null) {
            log.info((Object)buildLogger.addBuildLogEntry("Found change logs from '" + lastDateFromCommit + "'. Using as last commit date"));
            return lastDateFromCommit;
        }
        log.info((Object)buildLogger.addBuildLogEntry("No change logs found in the last 365 days. Using '" + today + "' as last commit date."));
        return today;
    }

    @Deprecated
    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey) throws RepositoryException {
        PlanKey planKey = buildContext.getPlanResultKey().getPlanKey();
        try {
            BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)PlanKeys.getPlanResultKey((String)buildContext.getBuildResultKey()));
            File basePath = super.getSourceCodeDirectory(planKey);
            File sourceDirectory = this.getSourceCodeDirectory(planKey);
            if (this.isWorkspaceEmpty(sourceDirectory)) {
                this.cvsRepositoryManager.checkout(vcsRevisionKey, basePath, buildLogger, this, buildContext);
            } else {
                this.cvsRepositoryManager.updateCvs(vcsRevisionKey, sourceDirectory, buildLogger, this, buildContext);
            }
            if (vcsRevisionKey == null) {
                String filePath = sourceDirectory.getAbsolutePath();
                Date lastBuildDate = this.getLastCommitDate(buildLogger, filePath);
                return this.fromDateToVcsKey(lastBuildDate);
            }
            return vcsRevisionKey;
        }
        catch (Exception e) {
            throw new RepositoryException("Unable to retrieve source code to '" + vcsRevisionKey + "' for '" + planKey + "'. " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isRepositoryDifferent(@NotNull Repository repository) {
        if (repository instanceof CVSRepository) {
            CVSRepository cvs = (CVSRepository)repository;
            return !new EqualsBuilder().append((Object)this.getName(), (Object)cvs.getName()).append((Object)this.getModule(), (Object)cvs.getModule()).append((Object)this.getBranchName(), (Object)cvs.getBranchName()).append((Object)this.getCvsRoot(), (Object)cvs.getCvsRoot()).isEquals();
        }
        return true;
    }

    @Override
    protected boolean isWorkspaceEmpty(File sourceCodeDirectory) {
        File workspaceMarker;
        return sourceCodeDirectory == null || !sourceCodeDirectory.exists() || !(workspaceMarker = new File(sourceCodeDirectory, NAME)).isDirectory();
    }

    @NotNull
    public CvsRepositoryMavenPomAccessor getMavenPomAccessor() {
        return new CvsRepositoryMavenPomAccessor(this);
    }

    @Override
    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(CVS_ROOT, (Object)SystemProperty.DEFAULT_CVS_ROOT.getValue());
        buildConfiguration.setProperty(CVS_QUIET_PERIOD, (Object)2);
    }

    @Override
    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(CVS_MODULE, (Object)buildConfiguration.getString(CVS_MODULE, "").trim());
        buildConfiguration.setProperty(CVS_ROOT, (Object)buildConfiguration.getString(CVS_ROOT, "").trim());
        String repositoryKey = buildConfiguration.getString("selectedRepository");
        if (this.getKey().equals(repositoryKey)) {
            String authType = buildConfiguration.getString(CVS_AUTH_TYPE);
            if (authType.equals("password")) {
                boolean passwordChanged = buildConfiguration.getBoolean(TEMPORARY_CVS_PASSWORD_CHANGE);
                if (passwordChanged) {
                    String newPassword = buildConfiguration.getString(TEMPORARY_CVS_PASSWORD);
                    buildConfiguration.setProperty(CVS_PASSWORD, (Object)newPassword);
                }
            } else {
                boolean passphraseChanged = buildConfiguration.getBoolean(TEMPORARY_CVS_PASSPHRASE_CHANGE);
                if (passphraseChanged) {
                    String newPassphrase = buildConfiguration.getString("temporary.cvs.passphrase");
                    buildConfiguration.setProperty(CVS_PASSPHRASE, (Object)newPassphrase);
                }
            }
        }
    }

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        String versionType;
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        String module = buildConfiguration.getString(CVS_MODULE);
        if (StringUtils.isBlank((CharSequence)module) || BambooFieldValidate.findFieldRelaxedXssViolation(errorCollection, this.textProvider, CVS_MODULE, module)) {
            errorCollection.addError(CVS_MODULE, "Please specify the build's CVS module name");
        }
        String cvsRoot = buildConfiguration.getString(CVS_ROOT);
        if (StringUtils.isBlank((CharSequence)(cvsRoot = this.customVariableContext.substituteString(cvsRoot)))) {
            errorCollection.addError(CVS_ROOT, "Please specify the build's CVS root");
        } else if (!BambooFieldValidate.findFieldRelaxedXssViolation(errorCollection, this.textProvider, CVS_ROOT, cvsRoot)) {
            this.authType = buildConfiguration.getString(CVS_AUTH_TYPE);
            if (AuthenticationType.SSH.getKey().equals(this.authType)) {
                this.keyFile = this.customVariableContext.substituteString(buildConfiguration.getString(CVS_KEY_FILE));
                this.passphrase = buildConfiguration.getString(CVS_PASSPHRASE);
                this.cvsRepositoryManager.validateCvsRoot(errorCollection, cvsRoot, this.passphrase, this.keyFile);
                String filename = buildConfiguration.getString(CVS_KEY_FILE);
                File file = new File(filename);
                if (!file.exists()) {
                    errorCollection.addError(CVS_KEY_FILE, this.textProvider.getText("repository.keyFile.error"));
                }
            } else {
                this.password = buildConfiguration.getString(CVS_PASSWORD);
                this.cvsRepositoryManager.validateCvsRoot(errorCollection, cvsRoot, this.password);
            }
        }
        if (!buildConfiguration.getBoolean(TEMPORARY_QUIET_PERIOD_FOR_JOB)) {
            BuildConfigurationValidationUtils.validatePostiveInteger(CVS_QUIET_PERIOD, "Please specify the quiet period (in seconds)", 180, "That is a long time to wait and will slow down normal build detection. This should be 180 seconds or less.", "Please specify the quiet period as an integer (in seconds)", buildConfiguration, errorCollection);
        }
        if (BUILD_MODULE_BRANCH.equals(versionType = buildConfiguration.getString(CVS_VERSION_TYPE))) {
            if (StringUtils.isBlank((CharSequence)buildConfiguration.getString(CVS_BRANCH))) {
                errorCollection.addError(CVS_BRANCH, "Please enter a valid branch name");
            }
            BambooFieldValidate.findFieldRelaxedXssViolation(errorCollection, this.textProvider, CVS_BRANCH, buildConfiguration.getString(CVS_BRANCH));
        }
        return errorCollection;
    }

    @Override
    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        this.setCvsRoot(config.getString(CVS_ROOT));
        this.setQuietPeriod(config.getInt(CVS_QUIET_PERIOD, 2));
        this.setModule(config.getString(CVS_MODULE));
        this.setAuthType(config.getString(CVS_AUTH_TYPE));
        if (this.isSshAuthType()) {
            this.setEncryptedPassphrase(config.getString(CVS_PASSPHRASE));
            this.setKeyFile(config.getString(CVS_KEY_FILE));
        } else {
            this.setPassword(config.getString(CVS_PASSWORD));
        }
        if (BUILD_MODULE_BRANCH.equals(config.getString(CVS_VERSION_TYPE))) {
            this.setBranchName(config.getString(CVS_BRANCH));
        } else {
            this.setBranchName(null);
        }
    }

    @Override
    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration config = super.toConfiguration();
        config.setProperty(CVS_ROOT, (Object)this.getCvsRoot());
        config.setProperty(CVS_PASSWORD, (Object)this.getPassword());
        config.setProperty(CVS_QUIET_PERIOD, (Object)this.getQuietPeriod());
        config.setProperty(CVS_MODULE, (Object)this.getModule());
        config.setProperty(CVS_AUTH_TYPE, (Object)this.getAuthType());
        if (this.isSshAuthType()) {
            config.setProperty(CVS_PASSPHRASE, (Object)this.getPassphrase());
            config.setProperty(CVS_KEY_FILE, (Object)this.getKeyFile());
        } else {
            config.setProperty(CVS_PASSWORD, (Object)this.getPassword());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getBranchName())) {
            config.setProperty(CVS_BRANCH, (Object)this.getBranchName());
            config.setProperty(CVS_VERSION_TYPE, (Object)BUILD_MODULE_BRANCH);
        } else {
            config.setProperty(CVS_VERSION_TYPE, (Object)BUILD_MODULE_TRUNK);
        }
        return config;
    }

    private String fromDateToVcsKey(Date date) {
        return this.getLogDateFormat().format(date);
    }

    private Date fromVcsKeyToDate(String lastVcsRevisionKey) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        return simpleDateFormat.parse(lastVcsRevisionKey);
    }

    public int hashCode() {
        return new HashCodeBuilder(199, 13).append((Object)this.getCvsRoot()).append((Object)this.getBranchName()).append((Object)this.getHost()).append((Object)this.getModule()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CVSRepository)) {
            return false;
        }
        CVSRepository rhs = (CVSRepository)o;
        return new EqualsBuilder().append((Object)this.getCvsRoot(), (Object)rhs.getCvsRoot()).append((Object)this.getBranchName(), (Object)rhs.getBranchName()).append((Object)this.getHost(), (Object)rhs.getHost()).append((Object)this.getModule(), (Object)rhs.getModule()).isEquals();
    }

    public int compareTo(Object obj) {
        CVSRepository o = (CVSRepository)obj;
        return new CompareToBuilder().append((Object)this.getCvsRoot(), (Object)o.getCvsRoot()).append((Object)this.getBranchName(), (Object)o.getBranchName()).append((Object)this.getHost(), (Object)o.getHost()).append((Object)this.getModule(), (Object)o.getModule()).toComparison();
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public String getSubstitutedKeyFile() {
        return this.customVariableContext.substituteString(this.keyFile);
    }

    protected String getPassphrase() {
        return this.passphrase;
    }

    public String getAuthType() {
        return this.authType;
    }

    void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    private void setEncryptedPassphrase(String passPhrase) {
        this.passphrase = passPhrase;
    }

    protected void setAuthType(String authType) {
        this.authType = authType;
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    public String getUrl() {
        return "http://www.cvshome.org";
    }

    @Override
    public int getMaxRetries() {
        return 5;
    }

    @Override
    @Deprecated
    @NotNull
    public File getSourceCodeDirectory(@NotNull PlanKey planKey) throws RepositoryException {
        return new File(super.getSourceCodeDirectory(planKey), this.module);
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String moduleName) {
        this.module = moduleName;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public String getSubstitutedBranchName() {
        return this.customVariableContext.substituteString(this.branchName);
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getPassword() {
        if (StringUtils.isNotEmpty((CharSequence)this.password)) {
            return this.password;
        }
        return null;
    }

    public void setPassword(String password) {
        this.password = StringUtils.isNotEmpty((CharSequence)password) ? password : null;
    }

    public void setQuietPeriod(String quietPeriod) {
        try {
            int integer = Integer.parseInt(StringUtils.trim((String)quietPeriod));
            if (integer >= 0) {
                this.quietPeriod = integer;
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.quietPeriod = -1;
    }

    public void setQuietPeriod(int i) {
        if (i >= 0) {
            this.quietPeriod = i;
            return;
        }
        this.quietPeriod = -1;
    }

    @Override
    public boolean isQuietPeriodEnabled() {
        return true;
    }

    @Override
    public int getQuietPeriod() {
        if (this.quietPeriod == -1) {
            return 0;
        }
        return this.quietPeriod;
    }

    public String getCvsRoot() {
        if (this.cvsRoot == null) {
            return SystemProperty.DEFAULT_CVS_ROOT.getValue();
        }
        return this.cvsRoot;
    }

    public String getHost() {
        CVSRoot cvsRoot;
        if (this.cvsRoot == null) {
            return "unknown-host";
        }
        try {
            cvsRoot = CVSRoot.parse((String)this.getSubstitutedCvsRoot());
        }
        catch (IllegalArgumentException e) {
            return "unknown-host";
        }
        return cvsRoot.getHostName();
    }

    @Override
    @NotNull
    public String getLocationIdentifier() {
        return this.cvsRoot + " (" + this.module + ")";
    }

    public String getSubstitutedCvsRoot() {
        return this.customVariableContext.substituteString(this.cvsRoot);
    }

    public void setCvsRoot(String cvsRoot) {
        this.cvsRoot = cvsRoot;
    }

    public boolean isSshAuthType() {
        return this.authType != null && this.authType.equals(AuthenticationType.SSH.getKey());
    }

    public void setCvsRepositoryManager(CvsRepositoryManager cvsRepositoryManager) {
        this.cvsRepositoryManager = cvsRepositoryManager;
    }

    @NotNull
    public List<NameValuePair> getAuthenticationTypes() {
        return Lists.newArrayList((Object[])new NameValuePair[]{AuthenticationType.PASSWORD.getNameValue(), AuthenticationType.SSH.getNameValue()});
    }

    @NotNull
    public Collection<NameValuePair> getVersionTypes() {
        return ImmutableList.of((Object)new NameValuePair(BUILD_MODULE_TRUNK, this.textProvider.getText("repository.cvs.module.versionType.head")), (Object)new NameValuePair(BUILD_MODULE_BRANCH, this.textProvider.getText("repository.cvs.module.versionType.branch")));
    }

    public FastDateFormat getLogDateFormat() {
        return this.logDateFormat;
    }

    public void setLogDateFormat(FastDateFormat logDateFormat) {
        this.logDateFormat = logDateFormat;
    }

    public SymbolicNameType getSymbolicNameType() {
        return this.symbolicNameType;
    }

    public static enum SymbolicNameType {
        UNKNOWN,
        BRANCH,
        TAG;

    }
}

