/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.cvsimpl;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.repository.cvsimpl.AbstractCvsListener;
import com.atlassian.bamboo.repository.cvsimpl.CVSRepository;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.log.LogInformation;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;

public class CvsChangeLogListener
extends AbstractCvsListener
implements CVSListener {
    private static final Logger log = Logger.getLogger(CvsChangeLogListener.class);
    private static final FastDateFormat ENTRY_KEY_TIMESTAMP_FORMAT = FastDateFormat.getInstance((String)"yyyyMMddHHmm");
    private Map<String, CommitImpl> commits = new TreeMap(Collections.reverseOrder());
    private Set<String> branches = new HashSet<String>();
    private Set<String> tags = new HashSet<String>();
    private String myModule;
    private CVSRoot myCvsRoot;

    public CvsChangeLogListener(CVSRoot cvsRoot, String module) {
        this.myCvsRoot = cvsRoot;
        this.myModule = module;
    }

    @Override
    public void fileInfoGenerated(FileInfoEvent event) {
        LogInformation logInformation = (LogInformation)event.getInfoContainer();
        if (log.isDebugEnabled()) {
            log.debug((Object)("FileInfoGenerated: " + logInformation));
        }
        List revisions = logInformation.getRevisionList();
        for (LogInformation.Revision revision : revisions) {
            String fileRelativeToModule;
            if (this.shouldAddCommits(revision, fileRelativeToModule = this.removeCvsRootFromFileName(logInformation, this.myCvsRoot, this.myModule))) {
                String authorName;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding revision: " + ToStringBuilder.reflectionToString((Object)revision)));
                }
                if (StringUtils.isBlank((CharSequence)(authorName = revision.getAuthor()))) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Author is null.\n fileRelativeToModule: " + logInformation + "\n revision: " + ToStringBuilder.reflectionToString((Object)revision)));
                    }
                    authorName = "[unknown]";
                }
                CommitImpl commit = new CommitImpl();
                commit.setAuthor((Author)new AuthorImpl(authorName));
                commit.setDate(revision.getDate());
                commit.setComment(revision.getMessage());
                commit.setChangeSetId(CVSRepository.DEFAULT_LOG_DATE_FORMAT.format(revision.getDate()));
                CommitFileImpl commitFile = new CommitFileImpl(revision.getNumber(), fileRelativeToModule, commit.getChangeSetId());
                String key = this.generateEntryKey(commit);
                if (!this.commits.containsKey(key)) {
                    this.commits.put(key, commit);
                    commit.addFile(commitFile);
                    continue;
                }
                CommitImpl existingCommit = this.commits.get(key);
                existingCommit.addFile(commitFile);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Not adding revision: " + ToStringBuilder.reflectionToString((Object)revision)));
        }
        for (LogInformation.SymName symbolicName : logInformation.getAllSymbolicNames()) {
            if (symbolicName.isBranch()) {
                this.branches.add(symbolicName.getName());
                continue;
            }
            this.tags.add(symbolicName.getName());
        }
    }

    private boolean shouldAddCommits(LogInformation.Revision revision, @Nullable String fileRelativeToModule) {
        return fileRelativeToModule != null && !StringUtils.containsIgnoreCase((CharSequence)revision.getMessage(), (CharSequence)"was initially added on branch");
    }

    @Nullable
    private String removeCvsRootFromFileName(LogInformation logInformation, CVSRoot cvsRoot, String module) {
        String repositoryFilename = logInformation.getRepositoryFilename();
        if (repositoryFilename != null) {
            String cvsRepositoryString = cvsRoot.getRepository();
            if (repositoryFilename.startsWith(cvsRepositoryString)) {
                String fileName = repositoryFilename.substring(cvsRepositoryString.length());
                return this.trimCvsFileName(fileName);
            }
            log.debug((Object)("File name '" + repositoryFilename + "' doesn't start with CVSROOT '" + cvsRepositoryString + "'."));
            return this.trimCvsFileName(repositoryFilename);
        }
        log.debug((Object)"repositoryFilename is null");
        return null;
    }

    @NotNull
    private String trimCvsFileName(@NotNull String fileName) {
        if (fileName.startsWith("/") || fileName.startsWith("\\")) {
            fileName = fileName.substring(1);
        }
        if (fileName.endsWith(",v")) {
            return fileName.substring(0, fileName.length() - 2);
        }
        return fileName;
    }

    @Override
    public void commandTerminated(TerminationEvent event) {
        if (event.isError()) {
            log.warn((Object)("Finished command with an error " + ToStringBuilder.reflectionToString((Object)event)));
        }
    }

    private String generateEntryKey(Commit commit) {
        return ENTRY_KEY_TIMESTAMP_FORMAT.format(commit.getDate()) + commit.getAuthor().getName() + commit.getComment();
    }

    @NotNull
    public List<Commit> getCommits() {
        return new ArrayList<Commit>(this.commits.values());
    }

    @NotNull
    public Set<String> getBranches() {
        return ImmutableSet.copyOf(this.branches);
    }

    @NotNull
    public Set<String> getTags() {
        return ImmutableSet.copyOf(this.tags);
    }
}

