/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.cvsimpl;

import com.atlassian.bamboo.build.CommandLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.repository.AuthenticationType;
import com.atlassian.bamboo.repository.cvsimpl.CVSRepository;
import com.atlassian.bamboo.repository.cvsimpl.ConnectionFactory;
import com.atlassian.bamboo.repository.cvsimpl.CvsChangeLogListener;
import com.atlassian.bamboo.repository.cvsimpl.CvsUpdateLogListener;
import com.atlassian.bamboo.repository.cvsimpl.ExtConnection;
import com.atlassian.bamboo.repository.cvsimpl.PasswordOverrideCVSRoot;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.checkout.CheckoutCommand;
import org.netbeans.lib.cvsclient.command.log.LogBuilder;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.lib.cvsclient.command.update.UpdateBuilder;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.EventManager;

public class CvsRepositoryManager {
    private static final Logger log = Logger.getLogger(CvsRepositoryManager.class);
    private static final String CVS_CHECKOUT_FORMAT = SystemProperty.CVS_CHECKOUT_FORMAT.getValue("BINARY");
    private ConcurrentHashMap<String, CVSRepository.SymbolicNameType> symbolicNameTypeCache = new ConcurrentHashMap();

    public void updateCvs(@Nullable String vcsRevisionKey, @NotNull File sourceDirectory, @NotNull BuildLogger buildLogger, @NotNull CVSRepository cvsRepository, @NotNull BuildContext buildContext) throws CommandException, AuthenticationException {
        UpdateCommand updateCommand = new UpdateCommand();
        updateCommand.setBuildDirectories(true);
        updateCommand.setPruneDirectories(true);
        updateCommand.setCleanCopy(false);
        if (CVS_CHECKOUT_FORMAT.toUpperCase().equals("BINARY")) {
            updateCommand.setKeywordSubst(KeywordSubstitutionOptions.BINARY);
        } else if (CVS_CHECKOUT_FORMAT.toUpperCase().equals("TEXT")) {
            updateCommand.setKeywordSubst(KeywordSubstitutionOptions.DEFAULT);
        }
        if (vcsRevisionKey != null) {
            updateCommand.setUpdateByDate(vcsRevisionKey);
        }
        if (cvsRepository.getBranchName() != null) {
            updateCommand.setUpdateByRevision(cvsRepository.getSubstitutedBranchName());
        }
        this.executeCvsCommand((BasicCommand)updateCommand, sourceDirectory.getAbsolutePath(), buildLogger, cvsRepository, buildContext);
    }

    public void checkout(@Nullable String vcsRevisionKey, @NotNull File sourceDirectory, @NotNull BuildLogger buildLogger, @NotNull CVSRepository cvsRepository, @Nullable BuildContext buildContext) throws CommandException, AuthenticationException {
        this.checkout(vcsRevisionKey, sourceDirectory, buildLogger, cvsRepository, true, buildContext);
    }

    public void checkout(@Nullable String vcsRevisionKey, @NotNull File sourceDirectory, @NotNull BuildLogger buildLogger, @NotNull CVSRepository cvsRepository, boolean recursive, @Nullable BuildContext buildContext) throws CommandException, AuthenticationException {
        CheckoutCommand checkoutCommand = new CheckoutCommand();
        checkoutCommand.setModule(cvsRepository.getModule());
        checkoutCommand.setPruneDirectories(true);
        checkoutCommand.setRecursive(recursive);
        if (CVS_CHECKOUT_FORMAT.toUpperCase().equals("BINARY")) {
            checkoutCommand.setKeywordSubst(KeywordSubstitutionOptions.BINARY);
        } else if (CVS_CHECKOUT_FORMAT.toUpperCase().equals("TEXT")) {
            checkoutCommand.setKeywordSubst(KeywordSubstitutionOptions.DEFAULT);
        }
        if (vcsRevisionKey != null) {
            if (cvsRepository.getSymbolicNameType() == CVSRepository.SymbolicNameType.TAG) {
                log.info((Object)"CVS checkout operation works on a tag, datestamps will be ignored.");
            } else if (SystemProperty.CVS_FORCE_CHECKOUT_TO_LATEST.getValue(false)) {
                log.info((Object)"The flag CVS_FORCE_CHECKOUT_TO_LATEST is set to true. CVS checkout will ignore datestamp.");
            } else {
                checkoutCommand.setCheckoutByDate(vcsRevisionKey);
            }
        }
        if (cvsRepository.getBranchName() != null) {
            checkoutCommand.setCheckoutByRevision(cvsRepository.getSubstitutedBranchName());
        }
        this.executeCvsCommand((BasicCommand)checkoutCommand, sourceDirectory.getAbsolutePath(), buildLogger, cvsRepository, buildContext);
    }

    public CVSRepository.SymbolicNameType getSymbolicNameType(final @Nullable String clientPath, final @NotNull BuildLogger buildLogger, @NotNull CVSRepository cvsRepository) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)cvsRepository.getBranchName())) {
            final String symbolicName = cvsRepository.getSubstitutedBranchName();
            String symbolicNameKey = cvsRepository.getSubstitutedCvsRoot() + ":" + symbolicName;
            CVSRepository.SymbolicNameType symbolicNameType = this.symbolicNameTypeCache.get(symbolicNameKey);
            if (symbolicNameType == null) {
                symbolicNameType = (CVSRepository.SymbolicNameType)((Object)new CvsOpenConnectionCallable<CVSRepository.SymbolicNameType>(cvsRepository){

                    @Override
                    CVSRepository.SymbolicNameType call(Connection connection) {
                        block7: {
                            Client client = new Client(connection, (AdminHandler)new StandardAdminHandler());
                            if (clientPath != null) {
                                client.setLocalPath(clientPath);
                            }
                            EventManager eventManager = client.getEventManager();
                            CvsChangeLogListener cvsChangeLogListener = new CvsChangeLogListener(CVSRoot.parse((String)this.cvsRepository.getSubstitutedCvsRoot()), this.cvsRepository.getModule());
                            eventManager.addCVSListener((CVSListener)cvsChangeLogListener);
                            RlogCommand logCommand = new RlogCommand();
                            logCommand.setBuilder((Builder)new LogBuilder(eventManager, (BasicCommand)logCommand));
                            logCommand.setModule(this.cvsRepository.getModule());
                            logCommand.setRecursive(false);
                            logCommand.setSuppressWhenNoRevisions(true);
                            logCommand.setHeaderOnly(true);
                            logCommand.setNoTags(false);
                            GlobalOptions globalOptions = CvsRepositoryManager.this.getGlobalOptions(this.cvsRepository);
                            try {
                                log.info((Object)"Finding all branches and tags");
                                log.debug((Object)CvsRepositoryManager.this.logCvsCommand(buildLogger, (BasicCommand)logCommand, client, globalOptions));
                                client.executeCommand((Command)logCommand, globalOptions);
                                Set<String> branches = cvsChangeLogListener.getBranches();
                                if (branches.contains(symbolicName)) {
                                    return CVSRepository.SymbolicNameType.BRANCH;
                                }
                                Set<String> tags = cvsChangeLogListener.getTags();
                                if (tags.contains(symbolicName)) {
                                    return CVSRepository.SymbolicNameType.TAG;
                                }
                            }
                            catch (CommandException e) {
                                log.warn((Object)"Exception while executing cvs rlog command", (Throwable)e);
                                if (!log.isDebugEnabled()) {
                                    log.warn((Object)CvsRepositoryManager.this.logCvsCommand(buildLogger, (BasicCommand)logCommand, client, globalOptions));
                                }
                            }
                            catch (AuthenticationException e) {
                                log.warn((Object)"Authentication exception while executing cvs rlog command", (Throwable)e);
                                if (log.isDebugEnabled()) break block7;
                                log.warn((Object)CvsRepositoryManager.this.logCvsCommand(buildLogger, (BasicCommand)logCommand, client, globalOptions));
                            }
                        }
                        return CVSRepository.SymbolicNameType.UNKNOWN;
                    }
                }.call());
            }
            if (symbolicNameType != null && symbolicNameType != CVSRepository.SymbolicNameType.UNKNOWN) {
                this.symbolicNameTypeCache.put(symbolicNameKey, symbolicNameType);
            }
            return symbolicNameType;
        }
        return CVSRepository.SymbolicNameType.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<Commit> getCommitsSince(@NotNull Date lastUpdate, @Nullable String clientPath, @NotNull BuildLogger buildLogger, @NotNull CVSRepository cvsRepository) throws AuthenticationException, CommandException {
        Connection connection = null;
        try {
            List<Commit> commits;
            connection = this.openConnectionToCvs(cvsRepository);
            Client client = new Client(connection, (AdminHandler)new StandardAdminHandler());
            if (clientPath != null) {
                client.setLocalPath(clientPath);
            }
            EventManager eventManager = client.getEventManager();
            CvsChangeLogListener cvsChangeLogListener = new CvsChangeLogListener(CVSRoot.parse((String)cvsRepository.getSubstitutedCvsRoot()), cvsRepository.getModule());
            eventManager.addCVSListener((CVSListener)cvsChangeLogListener);
            RlogCommand logCommand = new RlogCommand();
            logCommand.setModule(cvsRepository.getModule());
            logCommand.setSuppressWhenNoRevisions(true);
            logCommand.setBuilder((Builder)new LogBuilder(eventManager, (BasicCommand)logCommand));
            logCommand.setDateFilter(this.getDateRange(lastUpdate, null));
            logCommand.setNoTags(true);
            String branchName = cvsRepository.getSubstitutedBranchName();
            if (branchName != null) {
                logCommand.setRevisionFilter(branchName);
            } else {
                logCommand.setRevisionFilter("");
            }
            GlobalOptions globalOptions = this.getGlobalOptions(cvsRepository);
            log.info((Object)("Getting list of commits for " + lastUpdate));
            log.debug((Object)this.logCvsCommand(buildLogger, (BasicCommand)logCommand, client, globalOptions));
            client.executeCommand((Command)logCommand, globalOptions);
            List<Commit> list = commits = cvsChangeLogListener.getCommits();
            return list;
        }
        finally {
            this.closeConnection(connection);
        }
    }

    @Nullable
    public Date findLatestDateFromCommits(@NotNull List<? extends CommitContext> commits) {
        Date lastDate = null;
        for (CommitContext commitContext : commits) {
            Date commitDate = commitContext.getDate();
            if (lastDate == null && commitDate != null) {
                lastDate = commitDate;
                continue;
            }
            if (commitDate == null || lastDate.compareTo(commitDate) >= 0) continue;
            lastDate = commitDate;
        }
        return lastDate;
    }

    @NotNull
    public CVSRoot getPasswordConfiguredCvsRoot(@NotNull String cvsRootString, @Nullable String password) {
        PasswordOverrideCVSRoot cvsRoot = new PasswordOverrideCVSRoot(cvsRootString);
        cvsRoot.setPassword(password);
        return cvsRoot;
    }

    public void validateCvsRoot(ErrorCollection errorCollection, String cvsRoot, String passphrase, String keyFile) {
        this.validateCvsRoot(errorCollection, cvsRoot, true, null, passphrase, keyFile);
    }

    public void validateCvsRoot(ErrorCollection errorCollection, String cvsRoot, String password) {
        this.validateCvsRoot(errorCollection, cvsRoot, false, password, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCvsCommand(BasicCommand command, String clientPath, BuildLogger buildLogger, CVSRepository cvsRepository, @Nullable BuildContext buildContext) throws CommandException, AuthenticationException {
        GlobalOptions globalOptions = this.getGlobalOptions(cvsRepository);
        Connection connection = null;
        try {
            connection = this.openConnectionToCvs(cvsRepository);
            Client client = this.getCvsClient(connection, clientPath);
            EventManager eventManager = client.getEventManager();
            CvsUpdateLogListener listener = new CvsUpdateLogListener(buildLogger);
            eventManager.addCVSListener((CVSListener)listener);
            command.setBuilder((Builder)new UpdateBuilder(eventManager, client.getLocalPath()));
            log.info((Object)this.logCvsCommand(buildLogger, command, client, globalOptions));
            client.executeCommand((Command)command, globalOptions);
        }
        catch (CommandAbortedException e) {
            log.info((Object)buildLogger.addErrorLogEntry("Command '" + command.getCVSCommand() + "' aborted."));
        }
        finally {
            this.closeConnection(connection);
        }
    }

    private Client getCvsClient(Connection connection, String clientPath) {
        Client client = new Client(connection, (AdminHandler)new StandardAdminHandler());
        client.setLocalPath(clientPath);
        return client;
    }

    @Nullable
    String getDateRange(@Nullable Date fromDate, @Nullable Date toDate) {
        int correction = SystemProperty.CVS_TIME_DIFF.getValue(0);
        if (fromDate != null && toDate != null) {
            Date correctedFromDate = DateUtils.addMinutes((Date)fromDate, (int)correction);
            Date correctedToDate = DateUtils.addMinutes((Date)toDate, (int)correction);
            return CVSRepository.DEFAULT_LOG_DATE_FORMAT.format(correctedFromDate) + '<' + CVSRepository.DEFAULT_LOG_DATE_FORMAT.format(correctedToDate);
        }
        if (fromDate != null) {
            Date correctedFromDate = DateUtils.addMinutes((Date)fromDate, (int)correction);
            return CVSRepository.DEFAULT_LOG_DATE_FORMAT.format(correctedFromDate) + '<';
        }
        if (toDate != null) {
            Date correctedFromDate = DateUtils.addMinutes((Date)new Date(), (int)correction);
            Date correctedToDate = DateUtils.addMinutes((Date)toDate, (int)correction);
            return CVSRepository.DEFAULT_LOG_DATE_FORMAT.format(correctedFromDate) + '<' + CVSRepository.DEFAULT_LOG_DATE_FORMAT.format(correctedToDate);
        }
        return null;
    }

    private Connection openConnectionToCvs(@NotNull CVSRepository cvsRepository) throws CommandAbortedException, AuthenticationException {
        CVSRoot root = cvsRepository.isSshAuthType() ? CVSRoot.parse((String)cvsRepository.getSubstitutedCvsRoot()) : this.getPasswordConfiguredCvsRoot(cvsRepository.getSubstitutedCvsRoot(), cvsRepository.getPassword());
        Connection connection = ConnectionFactory.getConnection(root);
        if (connection instanceof ExtConnection) {
            ExtConnection extConnection = (ExtConnection)connection;
            if (cvsRepository.isSshAuthType()) {
                extConnection.setAuthType(AuthenticationType.SSH.getKey());
                extConnection.setKeyFile(cvsRepository.getSubstitutedKeyFile());
                extConnection.setPassphrase(cvsRepository.getPassphrase());
            } else {
                extConnection.setAuthType(AuthenticationType.PASSWORD.getKey());
            }
        }
        connection.open();
        return connection;
    }

    private void closeConnection(@Nullable Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (IOException e) {
                log.warn((Object)"Failed to close CVS server connection", (Throwable)e);
            }
        }
    }

    protected GlobalOptions getGlobalOptions(CVSRepository cvsRepository) {
        GlobalOptions globalOptions = new GlobalOptions();
        globalOptions.setCVSRoot(cvsRepository.getSubstitutedCvsRoot());
        return globalOptions;
    }

    private String getException(Exception e) {
        String exceptionString = e.toString();
        String nastyClassInfo = "org.netbeans.lib.cvsclient.connection.AuthenticationException: ";
        if (exceptionString != null && exceptionString.contains(nastyClassInfo)) {
            return exceptionString.substring(nastyClassInfo.length());
        }
        return exceptionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCvsRoot(ErrorCollection errorCollection, String cvsPath, boolean sshAuthType, String password, String passphrase, String keyFile) {
        CVSRoot cvsRoot;
        try {
            cvsRoot = sshAuthType ? CVSRoot.parse((String)cvsPath) : this.getPasswordConfiguredCvsRoot(cvsPath, password);
        }
        catch (Exception e) {
            errorCollection.addError("repository.cvs.cvsRoot", "Invalid CVS root format: " + e.getMessage());
            return;
        }
        String protocol = cvsRoot.getMethod();
        if (!("ext".equals(protocol) || "pserver".equals(protocol) || "local".equals(protocol) || "fork".equals(protocol) || cvsRoot.isLocal())) {
            errorCollection.addError("repository.cvs.cvsRoot", "Unsupported cvs protocol");
            return;
        }
        if ("ext".equals(protocol)) {
            ExtConnection extConnection = null;
            try {
                Connection connection = ConnectionFactory.getConnection(cvsRoot);
                if (connection instanceof ExtConnection) {
                    extConnection = (ExtConnection)connection;
                    if (sshAuthType) {
                        extConnection.setAuthType(AuthenticationType.SSH.getKey());
                        extConnection.setKeyFile(keyFile);
                        extConnection.setPassphrase(passphrase);
                    } else {
                        extConnection.setAuthType(AuthenticationType.PASSWORD.getKey());
                    }
                    extConnection.verify();
                } else {
                    connection.verify();
                }
                this.closeConnection((Connection)extConnection);
            }
            catch (Exception e) {
                try {
                    errorCollection.addError("repository.cvs.cvsRoot", "Cannot connect to CVS root: " + this.getException(e) + ". Your server details / password may be incorrect");
                    this.closeConnection((Connection)extConnection);
                }
                catch (Throwable throwable) {
                    this.closeConnection((Connection)extConnection);
                    throw throwable;
                }
            }
        } else if ("local".equals(protocol)) {
            String path = cvsPath;
            int index = path.indexOf(File.separatorChar);
            if (index != -1) {
                path = path.substring(index);
            }
            if (!new File(path).exists()) {
                errorCollection.addError("repository.cvs.cvsRoot", "Cannot locate local CVS root (" + cvsPath + ")");
            }
        } else {
            Connection connection = null;
            try {
                connection = ConnectionFactory.getConnection(cvsRoot);
                connection.verify();
            }
            catch (Exception e) {
                errorCollection.addError("repository.cvs.cvsRoot", "Cannot connect to CVS root: " + this.getException(e));
            }
            finally {
                this.closeConnection(connection);
            }
        }
    }

    private String logCvsCommand(@NotNull BuildLogger buildLogger, @NotNull BasicCommand command, @NotNull Client client, @NotNull GlobalOptions globalOptions) {
        StringBuilder logEntryBuilder = new StringBuilder().append("Running CVS command: '").append(command.getCVSCommand()).append("'").append("\\n").append("             ... in: '").append(client.getLocalPath()).append("'").append("\\n").append("        ... CVSROOT: '").append(globalOptions.getCVSRoot()).append("'");
        return buildLogger.addBuildLogEntry((LogEntry)new CommandLogEntry(logEntryBuilder.toString()));
    }

    private abstract class CvsOpenConnectionCallable<V>
    implements Callable<V> {
        protected final CVSRepository cvsRepository;

        protected CvsOpenConnectionCallable(CVSRepository cvsRepository) {
            this.cvsRepository = cvsRepository;
        }

        abstract V call(Connection var1);

        @Override
        public V call() throws Exception {
            Connection connection = null;
            try {
                connection = CvsRepositoryManager.this.openConnectionToCvs(this.cvsRepository);
                V v = this.call(connection);
                return v;
            }
            finally {
                CvsRepositoryManager.this.closeConnection(connection);
            }
        }
    }
}

