/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.cvsimpl;

import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.repository.AuthenticationType;
import com.atlassian.bamboo.repository.MavenPomAccessorAbstract;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.cvsimpl.CVSRepository;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;

public class CvsRepositoryMavenPomAccessor
extends MavenPomAccessorAbstract<CVSRepository> {
    private static final Logger log = Logger.getLogger(CvsRepositoryMavenPomAccessor.class);
    private static final String MAVEN_SCM_PROVIDER_KEY = "cvs";
    private static final Pattern MAVEN_SCM_URL_METHOD_AND_DELIMITER_PATTERN = Pattern.compile("(ext|local|lserver|pserver|sspi|sserver)(.).*");
    private static final Pattern MAVEN_SCM_URL_COLON_AS_DELIMITER_PATTERN = Pattern.compile("([^:]+):(((([\\w\\-\\.\\\\]+)(:(.*))?@)?([^:]+)(:(\\\\d+))?):)?([^:]+):([^:]+)");
    private static final Pattern MAVEN_SCM_URL_PIPE_AS_DELIMITER_PATTERN = Pattern.compile("([^|]+)\\|(((([\\w\\-\\.\\\\]+)(:(.*))?@)?([^:]+)(:(\\d+))?)\\|)?([^|]+)\\|([^|]+)");

    public CvsRepositoryMavenPomAccessor(@NotNull CVSRepository repository) {
        super(repository);
    }

    @NotNull
    public String getMavenScmProviderKey() {
        return MAVEN_SCM_PROVIDER_KEY;
    }

    public void parseMavenScmUrl(@NotNull String mavenScmUrl) throws IllegalArgumentException {
        Matcher matcher = MAVEN_SCM_URL_METHOD_AND_DELIMITER_PATTERN.matcher(mavenScmUrl);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Unrecognized method in SCM URL " + mavenScmUrl);
        }
        String delimiter = matcher.group(2);
        if (delimiter.equals(":")) {
            matcher = MAVEN_SCM_URL_COLON_AS_DELIMITER_PATTERN.matcher(mavenScmUrl);
        } else if (delimiter.equals("|")) {
            matcher = MAVEN_SCM_URL_PIPE_AS_DELIMITER_PATTERN.matcher(mavenScmUrl);
        } else {
            throw new IllegalArgumentException("Too many components in SCM URL " + mavenScmUrl);
        }
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Can't parse SCM URL " + mavenScmUrl);
        }
        String cvsMethod = matcher.group(1);
        String cvsUsername = matcher.group(5);
        String cvsPassword = matcher.group(7);
        String cvsHost = matcher.group(8);
        String cvsPort = matcher.group(10);
        String cvsPathToRepository = matcher.group(11);
        String cvsModule = matcher.group(12);
        StringBuilder cvsRootBuilder = new StringBuilder(cvsMethod).append(delimiter);
        if (StringUtils.isNotEmpty((CharSequence)cvsHost)) {
            if (StringUtils.isNotEmpty((CharSequence)cvsUsername)) {
                cvsRootBuilder.append(cvsUsername).append("@");
            }
            cvsRootBuilder.append(cvsHost);
            if (StringUtils.isNotEmpty((CharSequence)cvsPort)) {
                cvsRootBuilder.append(":").append(cvsPort);
            }
            cvsRootBuilder.append(delimiter);
        }
        cvsRootBuilder.append(cvsPathToRepository);
        ((CVSRepository)this.repository).setCvsRoot(cvsRootBuilder.toString());
        ((CVSRepository)this.repository).setModule(cvsModule);
        ((CVSRepository)this.repository).setAuthType(AuthenticationType.PASSWORD.getKey());
        ((CVSRepository)this.repository).setPassword(cvsPassword);
    }

    @NotNull
    public File checkoutMavenPom(@NotNull File destinationPath) throws RepositoryException {
        try {
            ((CVSRepository)this.repository).cvsRepositoryManager.checkout(null, destinationPath, new NullBuildLogger(), (CVSRepository)this.repository, false, null);
            File pomFile = new File(destinationPath, ((CVSRepository)this.repository).getModule());
            if (pomFile.isDirectory() && !(pomFile = new File(pomFile, "pom.xml")).isFile()) {
                throw new RepositoryException("Cannot find maven pom at " + pomFile.toString());
            }
            return pomFile;
        }
        catch (CommandException e) {
            throw new RepositoryException("Cannot checkout using repository " + this, (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new RepositoryException("Cannot checkout using repository " + this, (Throwable)e);
        }
    }
}

