/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.cvsimpl;

import com.atlassian.bamboo.utils.SystemProperty;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import javax.annotation.concurrent.ThreadSafe;
import javax.net.SocketFactory;
import org.apache.log4j.Logger;

@ThreadSafe
public class CvsTimeoutSocketFactory
extends SocketFactory {
    private static final Logger log = Logger.getLogger(CvsTimeoutSocketFactory.class);
    private static final CvsTimeoutSocketFactory instance = new CvsTimeoutSocketFactory(SystemProperty.CVS_SOCKET_TIMEOUT_MS);
    private final int cvsSocketTimeoutMs;

    public CvsTimeoutSocketFactory(int cvsSocketTimeoutMs) {
        this.cvsSocketTimeoutMs = cvsSocketTimeoutMs;
    }

    @Override
    public Socket createSocket() throws IOException {
        Socket socket = new Socket();
        this.updateSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = new Socket(host, port);
        this.updateSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        Socket socket = new Socket(address, port);
        this.updateSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientAddress, int clientPort) throws IOException, UnknownHostException {
        Socket socket = new Socket(host, port, clientAddress, clientPort);
        this.updateSocket(socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        Socket socket = new Socket(address, port, clientAddress, clientPort);
        this.updateSocket(socket);
        return socket;
    }

    private void updateSocket(Socket socket) throws SocketException {
        socket.setSoTimeout(this.cvsSocketTimeoutMs);
    }

    public static CvsTimeoutSocketFactory getInstance() {
        return instance;
    }
}

