/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.cvsimpl;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.repository.cvsimpl.AbstractCvsListener;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.netbeans.lib.cvsclient.command.DefaultFileInfoContainer;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class CvsUpdateLogListener
extends AbstractCvsListener
implements CVSListener {
    private static final Logger log = Logger.getLogger(CvsUpdateLogListener.class);
    private static final Set<String> IGNORED_TYPES = Sets.newHashSet((Object[])new String[]{"?", "M", "C"});
    private final List<File> updatedFiles = new ArrayList<File>();
    private final BuildLogger buildLogger;

    public CvsUpdateLogListener(BuildLogger buildLogger) {
        this.buildLogger = buildLogger;
    }

    @Override
    public void fileInfoGenerated(FileInfoEvent e) {
        DefaultFileInfoContainer fileInfoContainer = (DefaultFileInfoContainer)e.getInfoContainer();
        if (fileInfoContainer != null) {
            log.info((Object)this.buildLogger.addBuildLogEntry(fileInfoContainer.toString()));
            String type = fileInfoContainer.getType();
            if (!fileInfoContainer.isDirectory() && !IGNORED_TYPES.contains(type)) {
                this.updatedFiles.add(fileInfoContainer.getFile());
            }
        }
    }

    public List getUpdatedFiles() {
        return this.updatedFiles;
    }
}

