/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.cvsimpl;

import com.atlassian.bamboo.utils.SystemProperty;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.connection.AbstractConnection;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class ExtConnection
extends AbstractConnection {
    private static final Logger log = Logger.getLogger(ExtConnection.class);
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_SSH = "ssh";
    private Session mySession;
    private ChannelExec myChannel;
    private int myPort;
    private String myUserName;
    private String myPassword;
    private String myHostName;
    private String authenticationType;
    private String myKeyFile;
    private String myPassphrase;

    public ExtConnection(CVSRoot cvsroot) {
        this.setUserName(cvsroot);
        this.setPassword(cvsroot);
        this.myHostName = cvsroot.getHostName();
        this.setRepository(cvsroot.getRepository());
        this.setPort(cvsroot);
    }

    public void open() throws AuthenticationException, CommandAbortedException {
        this.openConnection(this.myPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verify() throws AuthenticationException {
        try {
            this.open();
            return;
        }
        catch (Exception e) {
            throw new AuthenticationException("Cannot open SSH connection:", e.getMessage());
        }
        finally {
            try {
                if (this.myChannel != null) {
                    this.myChannel.disconnect();
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to disconnect myChannel", (Throwable)e);
            }
            try {
                if (this.mySession != null) {
                    this.mySession.disconnect();
                }
            }
            catch (Exception e) {
                log.error((Object)"Failed to disconnect session", (Throwable)e);
            }
            finally {
                this.reset();
            }
        }
    }

    private void reset() {
        this.mySession = null;
        this.myChannel = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.myChannel.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.mySession.disconnect();
        }
        finally {
            this.reset();
        }
    }

    public boolean isOpen() {
        return this.mySession != null && this.myChannel != null && this.mySession.isConnected();
    }

    public void modifyInputStream(ConnectionModifier connectionmodifier) throws IOException {
        connectionmodifier.modifyInputStream(this.getInputStream());
    }

    public void modifyOutputStream(ConnectionModifier connectionmodifier) throws IOException {
        connectionmodifier.modifyOutputStream(this.getOutputStream());
    }

    private void openConnection(final String password) throws AuthenticationException {
        if (this.myHostName == null) {
            throw new AuthenticationException("Cannot open connection", "host is null");
        }
        try {
            JSch jsch = new JSch();
            this.mySession = jsch.getSession(this.myUserName, this.myHostName, this.getPort());
            if (AUTH_SSH.equals(this.authenticationType)) {
                if (this.myPassphrase != null) {
                    jsch.addIdentity(this.myKeyFile, this.myPassphrase);
                } else {
                    jsch.addIdentity(this.myKeyFile);
                }
            }
            this.mySession.setUserInfo(new UserInfo(){

                public String getPassphrase() {
                    return null;
                }

                public String getPassword() {
                    return password;
                }

                public boolean promptPassword(String message) {
                    return true;
                }

                public boolean promptPassphrase(String message) {
                    return true;
                }

                public boolean promptYesNo(String message) {
                    return true;
                }

                public void showMessage(String message) {
                    log.error((Object)("Message from ssh: " + message));
                }
            });
            this.mySession.connect(SystemProperty.CVS_SOCKET_TIMEOUT_MS);
            this.myChannel = (ChannelExec)this.mySession.openChannel("exec");
            this.myChannel.setCommand("cvs server");
            this.myChannel.setXForwarding(false);
            LoggedDataOutputStream loggeddataoutputstream = new LoggedDataOutputStream(this.myChannel.getOutputStream());
            this.setOutputStream(loggeddataoutputstream);
            LoggedDataInputStream loggeddatainputstream = new LoggedDataInputStream(this.myChannel.getInputStream());
            this.setInputStream(loggeddatainputstream);
            this.myChannel.setErrStream((OutputStream)System.err);
            this.myChannel.connect();
            if (Thread.currentThread().isInterrupted()) {
                this.reset();
                throw new CommandAbortedException("Aborted during connecting to the server.", "`Connection thread was interrupted");
            }
        }
        catch (Exception e) {
            this.reset();
            throw new AuthenticationException("Cannot open connection", (Throwable)e, "");
        }
    }

    private void setPort(CVSRoot cvsroot) {
        this.myPort = cvsroot.getPort();
        if (this.myPort == 0) {
            this.myPort = 22;
        }
    }

    public int getPort() {
        return this.myPort;
    }

    private void setPassword(CVSRoot cvsroot) {
        String password = cvsroot.getPassword();
        if (password != null) {
            this.myPassword = password;
        }
    }

    private void setUserName(CVSRoot cvsroot) {
        this.myUserName = cvsroot.getUserName();
        if (this.myUserName == null) {
            this.myUserName = System.getProperty("user.name");
        }
    }

    public void setKeyFile(String filename) {
        this.myKeyFile = filename;
    }

    public void setPassphrase(String passphrase) {
        this.myPassphrase = passphrase;
    }

    public void setAuthType(String type) {
        this.authenticationType = type;
    }
}

