/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.cvsimpl;

import org.apache.log4j.Logger;
import org.netbeans.lib.cvsclient.command.Builder;

public class LoggingBuilder
implements Builder {
    private static final Logger log = Logger.getLogger(LoggingBuilder.class);
    private final boolean debugEnabled = log.isDebugEnabled();
    private final Builder builder;

    public LoggingBuilder(Builder builder) {
        this.builder = builder;
    }

    public void parseLine(String line, boolean isErrorMessage) {
        if (this.debugEnabled) {
            log.debug((Object)line);
        }
        this.builder.parseLine(line, isErrorMessage);
    }

    public void parseEnhancedMessage(String key, Object value) {
        if (this.debugEnabled) {
            log.debug((Object)("key='" + key + "', value='" + value + "'"));
        }
        this.builder.parseEnhancedMessage(key, value);
    }

    public void outputDone() {
        this.builder.outputDone();
    }
}

