/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.perforce;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorImpl;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Capability;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilitySet;
import com.tek42.perforce.Depot;
import com.tek42.perforce.PerforceException;
import com.tek42.perforce.model.Changelist;
import com.tek42.perforce.model.Workspace;
import com.tek42.perforce.process.CmdLineExecutor;
import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerforceManager {
    private static final Logger log = Logger.getLogger(PerforceManager.class);
    protected static final FastDateFormat dateFormat = FastDateFormat.getInstance((String)"dd/MM/yyyy");
    @GuardedBy(value="this")
    private final ConcurrentHashMap<String, String> depotByView = new ConcurrentHashMap();

    public void syncToRevision(@NotNull Depot perforceDepot, @NotNull String depot, int revisionNumber, boolean forceSync) throws RepositoryException {
        try {
            String path = depot + "@" + revisionNumber;
            perforceDepot.setExecRunningDirectory(new File(this.getClientRoot(perforceDepot)));
            perforceDepot.getWorkspaces().syncTo(path, forceSync);
            perforceDepot.setExecRunningDirectory(null);
        }
        catch (PerforceException e) {
            String message = "Could not obtain source code from Perforce.  Attempt to sync " + depot + "@" + revisionNumber + " failed: " + e.getMessage();
            log.error((Object)message, (Throwable)e);
            throw new RepositoryException(message, (Throwable)e);
        }
    }

    public void syncToHead(@NotNull Depot perforceDepot, @NotNull String depot, boolean forceSync) throws RepositoryException {
        try {
            perforceDepot.setExecRunningDirectory(new File(this.getClientRoot(perforceDepot)));
            perforceDepot.getWorkspaces().syncToHead(depot, forceSync);
            perforceDepot.setExecRunningDirectory(null);
        }
        catch (PerforceException e) {
            String message = "Could not obtain source code from Perforce. Attempt to sync " + depot + " to head failed: " + e.getMessage();
            log.error((Object)message, (Throwable)e);
            throw new RepositoryException(message, (Throwable)e);
        }
    }

    public void setupSync(@NotNull Depot perforceDepot, @NotNull File sourceDirectory) throws RepositoryException {
        try {
            Workspace workspace = this.getPerforceWorkspace(perforceDepot);
            String access = workspace.getAccess();
            if (StringUtils.isEmpty((CharSequence)access)) {
                String message = "Could not access the client configuration to set the source code directory";
                log.error((Object)message);
                throw new RepositoryException(message);
            }
            log.info((Object)("Setting the root for client " + perforceDepot.getClient() + " to " + sourceDirectory.getAbsolutePath()));
            workspace.setRoot(sourceDirectory.getAbsolutePath());
            log.info((Object)("Removing host restrictions from client " + perforceDepot.getClient()));
            workspace.setHost("");
            perforceDepot.getWorkspaces().saveWorkspace(workspace);
        }
        catch (PerforceException e) {
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
    }

    @NotNull
    public String getClientRoot(Depot perforceDepot) throws RepositoryException {
        String message = "Unable to extract client root from Perforce, therefore could not evaluate where the source will be checked out to.";
        try {
            Object[] roots;
            Workspace clientWorkspace = this.getPerforceWorkspace(perforceDepot);
            String mainClientRoot = clientWorkspace.getRoot();
            if (this.isFileExists(mainClientRoot)) {
                return mainClientRoot;
            }
            String altRoots = clientWorkspace.getAltRoots();
            for (String string : roots = altRoots.split("\\t")) {
                if (!this.isFileExists(string.trim())) continue;
                return string.trim();
            }
            log.error((Object)("Unable to extract client root from Perforce, therefore could not evaluate where the source will be checked out to. main root: " + mainClientRoot + " alt roots: " + Arrays.toString(roots)));
            throw new RepositoryException("Unable to extract client root from Perforce, therefore could not evaluate where the source will be checked out to.");
        }
        catch (PerforceException e) {
            log.error((Object)"Unable to extract client root from Perforce, therefore could not evaluate where the source will be checked out to.", (Throwable)e);
            throw new RepositoryException("Unable to extract client root from Perforce, therefore could not evaluate where the source will be checked out to.", (Throwable)e);
        }
    }

    private boolean isFileExists(String file) {
        if (file == null) {
            return false;
        }
        File fileObject = new File(file);
        return fileObject.exists();
    }

    private Workspace getPerforceWorkspace(Depot perforceDepot) throws PerforceException {
        this.ensureClientIsValid(perforceDepot);
        return perforceDepot.getWorkspaces().getWorkspace(perforceDepot.getClient());
    }

    private void ensureClientIsValid(Depot depot) throws PerforceException {
        try {
            String client = depot.getClient();
            if (client == null) {
                throw new PerforceException("Could not validate a null client");
            }
            List perforceClients = depot.getWorkspaces().getWorkspaceList(client);
            if (perforceClients == null) {
                throw new PerforceException("Could not validate client " + client + ", could not retrieve client list from perforce server");
            }
            if (perforceClients.isEmpty()) {
                throw new PerforceException("The client '" + client + "' was not found in the list of clients retrieved from the Perforce server using the 'p4 clients -e' command");
            }
        }
        catch (PerforceException e) {
            throw new PerforceException("Failed to validate perforce client " + depot.getClient(), (Throwable)e);
        }
    }

    @NotNull
    Commit convertToCommitLog(@NotNull Changelist changelist) {
        CommitImpl commitEntry = new CommitImpl();
        commitEntry.setAuthor((Author)new AuthorImpl(changelist.getUser()));
        commitEntry.setComment(this.getDescriptionFromChangelist(changelist));
        commitEntry.setDate(changelist.getDate());
        commitEntry.setChangeSetId(Integer.toString(changelist.getChangeNumber()));
        for (Changelist.FileEntry file : changelist.getFiles()) {
            commitEntry.addFile(this.convertToCommitFile(file, changelist.getChangeNumber()));
        }
        return commitEntry;
    }

    @NotNull
    private String getDescriptionFromChangelist(@NotNull Changelist changelist) {
        StringBuilder description = new StringBuilder();
        description.append(changelist.getDescription());
        List jobEntries = changelist.getJobs();
        if (jobEntries != null && !jobEntries.isEmpty()) {
            description.append("\n\n");
            description.append("Jobs Fixed");
            description.append(" on ").append(dateFormat.format(changelist.getDate()));
            description.append(" by ").append(changelist.getUser());
            description.append("\n\n");
            for (Changelist.JobEntry job : changelist.getJobs()) {
                description.append(job.getJob());
                description.append(" ").append(job.getStatus()).append(":");
                description.append(" ").append(job.getDescription());
                description.append("\n");
            }
        }
        return description.toString();
    }

    @NotNull
    private CommitFile convertToCommitFile(@NotNull Changelist.FileEntry oldFile, int changeNumber) {
        CommitFileImpl newFile = new CommitFileImpl();
        newFile.setName(oldFile.getFilename());
        newFile.setRevision(Integer.toString(changeNumber));
        return newFile;
    }

    @Nullable
    public String getFileNameForUrl(String fileName, String depot, String clientName) {
        String depotName = null;
        if (depot != null && clientName != null && depot.contains(clientName) && depot.contains("/...")) {
            depotName = StringUtils.substringBetween((String)depot, (String)(clientName + "/"), (String)"/...");
        }
        if (fileName != null) {
            if (fileName.startsWith("//")) {
                fileName = StringUtils.substringAfter((String)fileName, (String)"//");
            }
            if (depotName != null && fileName.contains(depotName)) {
                fileName = StringUtils.substringAfter((String)fileName, depotName);
            }
            if (fileName.startsWith("/")) {
                fileName = StringUtils.substringAfter((String)fileName, (String)"/");
            }
            fileName = fileName.trim();
        }
        return fileName;
    }

    public int getLatestChangeNumber(@NotNull Depot perforceDepot, @Nullable String depot, int latestRevisionInBamboo, boolean useClientMapping) throws RepositoryException {
        try {
            List changeNumbers = perforceDepot.getChanges().getChangeNumbers(this.getDepotFromView(perforceDepot, depot, useClientMapping), -1, 1);
            if (changeNumbers.size() == 1) {
                return (Integer)changeNumbers.get(0);
            }
            return latestRevisionInBamboo;
        }
        catch (PerforceException e) {
            String message = "Could not retrieve latest change number for " + depot;
            log.error((Object)message, (Throwable)e);
            throw new RepositoryException(message, (Throwable)e);
        }
    }

    @NotNull
    public List<Integer> getChangeNumsBetweenRevisions(@NotNull Depot perforceDepot, @Nullable String depot, int firstRevision, int secondRevision, boolean useClientMapping) throws RepositoryException {
        try {
            int numberOfChanges = secondRevision - firstRevision;
            if (numberOfChanges > 0) {
                List returnedNumbers = perforceDepot.getChanges().getChangeNumbers(this.getDepotFromView(perforceDepot, depot, useClientMapping), secondRevision, numberOfChanges);
                ArrayList<Integer> numbers = new ArrayList<Integer>();
                for (Integer changeNumber : returnedNumbers) {
                    if (changeNumber.compareTo(firstRevision) <= 0 || changeNumber.compareTo(secondRevision) > 0) continue;
                    numbers.add(changeNumber);
                }
                return numbers;
            }
            return new ArrayList<Integer>();
        }
        catch (PerforceException e) {
            String message = "Could not retrieve changelogs from perforce";
            log.error((Object)message, (Throwable)e);
            throw new RepositoryException(message, (Throwable)e);
        }
    }

    public List<Integer> getChangeNumbersFromRevision(@NotNull Depot perforceDepot, String clientViewDepot, int lastRevisionInBamboo, boolean useClientMapping) throws RepositoryException {
        try {
            String depot = this.getDepotFromView(perforceDepot, clientViewDepot, useClientMapping);
            return perforceDepot.getChanges().getChangeNumbersFrom(depot, ++lastRevisionInBamboo);
        }
        catch (PerforceException e) {
            if (e.getMessage().contains("No output for")) {
                return new ArrayList<Integer>();
            }
            String message = "Could not retrieve changelogs from perforce";
            log.error((Object)message, (Throwable)e);
            throw new RepositoryException(message, (Throwable)e);
        }
    }

    @NotNull
    public List<Commit> getChangeLogEntries(@NotNull Depot perforceDepot, @NotNull List<Integer> changeNumbers) throws RepositoryException {
        ArrayList<Commit> result = new ArrayList<Commit>();
        try {
            List changeLists = perforceDepot.getChanges().getChangelistsFromNumbers(changeNumbers);
            for (Changelist change : changeLists) {
                Commit commit = this.convertToCommitLog(change);
                result.add(commit);
            }
        }
        catch (PerforceException e) {
            String message = "Could not retrieve change lists from perforce";
            log.error((Object)message, (Throwable)e);
            throw new RepositoryException(message, (Throwable)e);
        }
        return result;
    }

    @Nullable
    public String getHostFromInfo(@NotNull Depot perforceDepot) {
        try {
            String infoOut = perforceDepot.info();
            String host = StringUtils.substringBetween((String)infoOut, (String)"Server address: ", (String)":");
            if (host != null) {
                return host.trim();
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Could not extract host from Perforce info command");
            return null;
        }
    }

    public void validateConnection(@NotNull ErrorCollection errorCollection, @NotNull Depot depot) {
        try {
            String infoOut = depot.info();
            if (infoOut.contains("Perforce client error") || infoOut.contains("Connect to server failed")) {
                errorCollection.addError("repository.p4.port", "Unable to connect to the perforce server, please ensure that your port is correct");
            }
        }
        catch (Exception e) {
            log.error((Object)e.toString());
            log.debug(null, (Throwable)e);
            errorCollection.addError("repository.p4.port", "Unable to connect to the perforce server, please ensure that your port is correct");
        }
    }

    private void validateUser(@NotNull ErrorCollection errorCollection, @NotNull Depot depot, @NotNull String user) {
        try {
            List users = depot.getUsers().getUserList();
            if (users != null && !users.isEmpty()) {
                for (String perforceUser : users) {
                    if (!user.equals(perforceUser)) continue;
                    return;
                }
                errorCollection.addError("repository.p4.user", "This user is not available on this port (Perforce server)");
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not extract user information from perforce. " + e.getMessage()));
        }
    }

    public void validateLogin(@NotNull ErrorCollection errorCollection, @NotNull Depot depot) {
        block3: {
            try {
                List perforceClients = depot.getWorkspaces().getWorkspaceList();
                if (perforceClients == null || perforceClients.isEmpty()) {
                    errorCollection.addError("repository.p4.user", "Unable to connect to the perforce server, please ensure that your login details are correct");
                }
            }
            catch (PerforceException e) {
                log.error((Object)e.toString());
                log.debug(null, (Throwable)e);
                this.validateUser(errorCollection, depot, depot.getUser());
                if (errorCollection.hasAnyErrors()) break block3;
                errorCollection.addError("repository.p4.user", "Unable to connect to the perforce server, please ensure that your login details are correct");
            }
        }
    }

    public void validateClient(@NotNull ErrorCollection errorCollection, @NotNull Depot depot, @NotNull String client) {
        try {
            List perforceClients = depot.getWorkspaces().getWorkspaceList();
            if (perforceClients == null || perforceClients.isEmpty()) {
                errorCollection.addError("repository.p4.user", "Unable to connect to the perforce server, please ensure that your login details are correct");
            } else {
                for (String perforceClient : perforceClients) {
                    if (!client.equals(perforceClient)) continue;
                    return;
                }
                errorCollection.addError("repository.p4.client", "Client was not found on the perforce server");
            }
        }
        catch (PerforceException e) {
            log.error((Object)e.toString());
            log.debug(null, (Throwable)e);
            errorCollection.addError("repository.p4.client", "Client was not found on the perforce server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateDepot(@NotNull ErrorCollection errorCollection, @NotNull Depot validationDepot, @NotNull String depot) {
        String workingDirectory = this.getWorkingDir(validationDepot.getClient(), null, depot);
        if ("Bad_Format".equals(workingDirectory)) {
            errorCollection.addError("repository.p4.depot", "Depot view is not in the format //client_name/... or //client_name/workspace_mapping/...");
        } else {
            try (CmdLineExecutor cmdExecutor = new CmdLineExecutor((Map)validationDepot.getSettings());){
                String[] cmd = new String[]{"p4", "files", depot};
                cmdExecutor.exec(validationDepot.getExecutable(), cmd);
                BufferedReader reader = cmdExecutor.getReader();
                String output = reader.readLine();
                if (output.contains("not in client view")) {
                    errorCollection.addError("repository.p4.depot", "Specified depot could not be found for this client");
                }
            }
        }
    }

    @Nullable
    public String getWorkingDir(@Nullable String client, @Nullable String clientRoot, @Nullable String depot) {
        if (StringUtils.contains((CharSequence)depot, (CharSequence)client) && StringUtils.contains((CharSequence)depot, (CharSequence)"/...")) {
            String buildPath = StringUtils.substringBetween((String)depot, (String)client, (String)"/...");
            if (StringUtils.isBlank((CharSequence)buildPath)) {
                return clientRoot;
            }
            if (buildPath.length() > 1) {
                buildPath = buildPath.substring(1);
            }
            return clientRoot + File.separator + buildPath;
        }
        return "Bad_Format";
    }

    @NotNull
    public CapabilitySet addDefaultPerforceExe(@NotNull CapabilitySet capabilitySet) {
        log.debug((Object)"Attempting to extract Perforce Executable");
        String p4Exe = SystemProperty.DEFAULT_P4_EXE.getValue();
        if (p4Exe == null) {
            log.info((Object)"Could not find system variable. If you wish to use perforce please set the location as a capability.");
            return capabilitySet;
        }
        log.debug((Object)"System Variable for Perforce Exists");
        if (new File(p4Exe).exists()) {
            CapabilityImpl perforceCapability = new CapabilityImpl("system.p4Executable", p4Exe);
            capabilitySet.addCapability((Capability)perforceCapability, false);
            log.info((Object)("Setting perforce capability for " + p4Exe));
        } else {
            log.info((Object)"P4Exe specified in system properties does not exist. If you wish to use perforce please set the location as a capability.");
        }
        return capabilitySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDepotFromView(@NotNull Depot perforceDepot, @Nullable String depotView, boolean useClientMapping) {
        if (useClientMapping) {
            return depotView;
        }
        String viewKey = "Client: " + perforceDepot.getClient() + " Port: " + perforceDepot.getPort() + " Depot View: " + depotView;
        String depot = this.depotByView.get(viewKey);
        if (depot != null) {
            return depot;
        }
        PerforceManager perforceManager = this;
        synchronized (perforceManager) {
            return this.depotByView.computeIfAbsent(viewKey, key -> {
                long start = System.currentTimeMillis();
                log.info((Object)("Looking for depot for " + key));
                String depotFromView = this.findDepotFromView(perforceDepot, depotView);
                log.info((Object)("Depot lookup took " + (System.currentTimeMillis() - start) + "ms"));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Depot cache: " + this.depotByView));
                }
                return depotFromView;
            });
        }
    }

    public Map<String, String> getDepotViewCache() {
        return new TreeMap<String, String>(this.depotByView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        PerforceManager perforceManager = this;
        synchronized (perforceManager) {
            this.depotByView.clear();
        }
    }

    @Nullable
    private String findDepotFromView(@NotNull Depot perforceDepot, @Nullable String configuredDepotView) {
        if (configuredDepotView == null) {
            return null;
        }
        try {
            Workspace workspace = this.getPerforceWorkspace(perforceDepot);
            List viewsInWorkspace = workspace.getViews();
            return PerforceManager.getDepotView(viewsInWorkspace, configuredDepotView);
        }
        catch (Exception e) {
            log.error((Object)("Perforce Error, could not extract client information for " + perforceDepot.getClient()), (Throwable)e);
            return configuredDepotView;
        }
    }

    private static String getDepotView(Iterable<String> viewsInWorkspace, String configuredDepotView) {
        Pattern pattern = Pattern.compile("^.*?(//.*?)\\.\\.\\..*?(//.*?)\\.\\.\\.");
        int maxLen = 0;
        String longestMatchView = "";
        String longestMatchDepot = "";
        for (String view : viewsInWorkspace) {
            Matcher matcher = pattern.matcher(view);
            if (!matcher.find()) continue;
            String depot = matcher.group(1);
            String viewString = matcher.group(2);
            if (!configuredDepotView.startsWith(viewString) || maxLen >= viewString.length()) continue;
            maxLen = viewString.length();
            longestMatchView = viewString;
            longestMatchDepot = depot;
        }
        if (maxLen > 0) {
            return configuredDepotView.replace(longestMatchView, longestMatchDepot);
        }
        log.info((Object)("Could not extract the depot name from the client information, using " + configuredDepotView + " instead"));
        return configuredDepotView;
    }
}

