/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.perforce;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitFile;
import com.atlassian.bamboo.commit.CommitFileImpl;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.process.EnvironmentVariableAccessor;
import com.atlassian.bamboo.repository.AbstractStandaloneRepository;
import com.atlassian.bamboo.repository.CustomVariableProviderRepository;
import com.atlassian.bamboo.repository.MavenPomAccessor;
import com.atlassian.bamboo.repository.MavenPomAccessorCapableRepository;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.perforce.PerforceManager;
import com.atlassian.bamboo.repository.perforce.PerforceRepositoryMavenPomAccessor;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.v2.build.agent.capability.CapabilityContext;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.atlassian.bamboo.v2.build.repository.LegacyRepository;
import com.atlassian.bamboo.v2.build.repository.RequirementsAwareRepository;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.tek42.perforce.Depot;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PerforceRepository
extends AbstractStandaloneRepository
implements LegacyRepository,
MavenPomAccessorCapableRepository,
RequirementsAwareRepository,
CustomVariableProviderRepository {
    private static final Logger log = Logger.getLogger(PerforceRepository.class);
    public static final String NAME = "Helix Core (P4D)";
    public static final String KEY = "p4";
    public static final String COMPLETE_PLUGIN_KEY = "com.atlassian.bamboo.plugin.system.repository:p4";
    private static final String P4_REPO_PREFIX = "repository.p4.";
    public static final String P4_PORT = "repository.p4.port";
    public static final String P4_CLIENT = "repository.p4.client";
    public static final String P4_DEPOT = "repository.p4.depot";
    public static final String P4_USER = "repository.p4.user";
    public static final String P4_PASSWD = "repository.p4.password";
    public static final String P4_MANAGE = "repository.p4.manageWorkspace";
    public static final String P4_USECLIENTMAPPING = "repository.p4.useClientMapping";
    public static final String P4_EXTRA_ENVIRONMENT = "repository.p4.environmentVariables";
    public static final String P4_MAVEN_POM_CHECKOUT_POM_RELATIVE_PATH = "repository.p4.mavenPomCheckout.pomRelativePath";
    private static final String TEMPORARY_P4_PASSWORD_CHANGE = "temporary.p4.passwordChange";
    public static final String TEMPORARY_P4_PASSWORD = "temporary.p4.password";
    public static final String BAD_FORMAT = "Bad_Format";
    public static final String P4_CAPABILITY_KEY = "system.p4Executable";
    private static final String VAR_USER_NAME = "username";
    private static final String VAR_PORT = "port";
    private static final String VAR_CLIENT = "client";
    private static final String VAR_DEPOT = "depot";
    private volatile transient Depot perforceDepot;
    private transient CapabilityContext capabilityContext;
    protected transient PerforceManager perforceManager;
    private transient String mavenPomCheckoutPomRelativePath;
    private transient EnvironmentVariableAccessor environmentVariableAccessor;
    private String port;
    private String client;
    private String depot;
    private String host;
    private String environmentVariables;
    private boolean manageWorkspace = false;
    private boolean useClientMapping = false;
    private String password;
    private String user;

    @Override
    @NotNull
    public BuildRepositoryChanges collectChangesForRevision(@NotNull PlanKey planKey, @Nullable String targetRevision) throws RepositoryException {
        this.validateExecutable();
        try {
            Integer numRevision = Integer.parseInt(targetRevision);
            List<Commit> changeLogEntries = this.perforceManager.getChangeLogEntries(this.getPerforceDepot(), Lists.newArrayList((Object[])new Integer[]{numRevision}));
            return new BuildRepositoryChangesImpl(-1L, Integer.toString(numRevision), changeLogEntries);
        }
        catch (NumberFormatException numEx) {
            String message = "Could not obtain change list from Perforce, Format error in last VCS Revision Key: " + targetRevision;
            log.error((Object)message, (Throwable)numEx);
            throw new RepositoryException(message, (Throwable)numEx);
        }
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, @Nullable String lastVcsRevisionKey) throws RepositoryException {
        this.validateExecutable();
        try {
            Depot perforceDepot1 = this.getPerforceDepot();
            String substitutedDepot = this.getSubstitutedDepot();
            int lastBambooRevisionNumber = lastVcsRevisionKey != null ? Integer.parseInt(lastVcsRevisionKey) : this.perforceManager.getLatestChangeNumber(perforceDepot1, substitutedDepot, 1, this.useClientMapping);
            List<Integer> changeLogNumbers = this.perforceManager.getChangeNumbersFromRevision(perforceDepot1, substitutedDepot, lastBambooRevisionNumber, this.useClientMapping);
            if (CollectionUtils.isNotEmpty(changeLogNumbers)) {
                Collections.sort(changeLogNumbers);
                int commitsToSkip = Math.max(0, changeLogNumbers.size() - this.getMaxCommitsToReturn());
                changeLogNumbers.subList(0, commitsToSkip).clear();
                Collections.reverse(changeLogNumbers);
                List<Commit> changeLogEntries = this.perforceManager.getChangeLogEntries(perforceDepot1, changeLogNumbers);
                Integer lastestPerforceRevisionNumber = (Integer)NumberUtils.max(changeLogNumbers);
                BuildRepositoryChangesImpl buildRepositoryChanges = new BuildRepositoryChangesImpl(-1L, Integer.toString(lastestPerforceRevisionNumber), changeLogEntries);
                buildRepositoryChanges.setSkippedCommitsCount(commitsToSkip);
                return buildRepositoryChanges;
            }
            return new BuildRepositoryChangesImpl(-1L, Integer.toString(lastBambooRevisionNumber), Collections.emptyList());
        }
        catch (NumberFormatException numEx) {
            String message = "Could not obtain change list from Perforce, Format error in last VCS Revision Key: " + lastVcsRevisionKey;
            log.error((Object)message, (Throwable)numEx);
            throw new RepositoryException(message, (Throwable)numEx);
        }
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey) throws RepositoryException {
        PlanKey planKey = buildContext.getPlanResultKey().getPlanKey();
        try {
            File sourceDirectory;
            if (!this.isPerforceExecutableSet()) {
                String message = "Could not find the p4 client, please check your capabilities";
                log.error((Object)message);
                throw new RepositoryException(message);
            }
            String substitutedDepot = this.getSubstitutedDepot();
            if (substitutedDepot == null) {
                String message = "The depot view for this build(" + planKey + ") is null.";
                log.error((Object)message);
                throw new RepositoryException(message);
            }
            if (this.manageWorkspace) {
                File workingDirectory = this.buildDirectoryManager.getBuildWorkingDirectory((Key)planKey);
                if (workingDirectory == null) {
                    String message = "Could not figure out the working directory for the " + planKey + " build";
                    log.error((Object)message);
                    throw new RepositoryException(message);
                }
                BambooFileUtils.createDirectoryIfNotExists(workingDirectory);
                this.perforceManager.setupSync(this.getPerforceDepot(), workingDirectory);
            }
            if ((sourceDirectory = this.getSourceCodeDirectory(planKey)) == null) {
                String message = "Could not figure out the source code directory for the " + planKey + " build";
                log.error((Object)message);
                throw new RepositoryException(message);
            }
            boolean forceSync = false;
            if (this.isWorkspaceEmpty(sourceDirectory)) {
                forceSync = true;
            }
            if (vcsRevisionKey == null) {
                this.perforceManager.syncToHead(this.getPerforceDepot(), substitutedDepot, true);
                int revision = this.perforceManager.getLatestChangeNumber(this.getPerforceDepot(), substitutedDepot, 0, this.useClientMapping);
                return Integer.toString(revision);
            }
            int revisionNumber = Integer.parseInt(vcsRevisionKey);
            this.perforceManager.syncToRevision(this.getPerforceDepot(), substitutedDepot, revisionNumber, forceSync);
            return Integer.toString(revisionNumber);
        }
        catch (NumberFormatException numEx) {
            String message = "Could not obtain source code from Perforce";
            log.error((Object)message, (Throwable)numEx);
            throw new RepositoryException(message, (Throwable)numEx);
        }
    }

    @NotNull
    public synchronized Depot getPerforceDepot() {
        Map variables = this.environmentVariableAccessor.splitEnvironmentAssignments(this.getEnvironmentVariables(), false);
        Depot depot = this.perforceDepot != null ? this.perforceDepot : new Depot(variables);
        Depot.Settings settings = new Depot.Settings();
        settings.setExecutable(this.getP4Executable());
        settings.setClient(this.getSubstitutedClient());
        settings.setPort(this.getSubstitutedPort());
        settings.setUser(this.getSubstitutedUser());
        settings.setPassword(this.decryptPassword(this.getEncryptedPassword()));
        depot.setAll(settings);
        if (this.perforceDepot == null) {
            this.perforceDepot = depot;
        }
        return this.perforceDepot;
    }

    @Nullable
    public String getP4Executable() {
        String capP4Exe = this.capabilityContext.getCapabilityValue(P4_CAPABILITY_KEY);
        String p4Exe = capP4Exe != null ? capP4Exe : this.getExecutableFromSystemProperty();
        return p4Exe;
    }

    @Nullable
    private String getExecutableFromSystemProperty() {
        String value = SystemProperty.DEFAULT_P4_EXE.getValue();
        return value != null ? value.trim() : null;
    }

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        String client;
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        String p4exe = this.getP4Executable();
        if (StringUtils.isEmpty((CharSequence)p4exe)) {
            errorCollection.addError(P4_PORT, "Please configure perforce as a server capability");
        } else if (!new File(p4exe).exists()) {
            errorCollection.addError(P4_PORT, "Cannot find " + p4exe + ", please check your server capabilities");
        }
        if (errorCollection.hasAnyErrors()) {
            return errorCollection;
        }
        String depot = buildConfiguration.getString(P4_DEPOT);
        if (StringUtils.isEmpty((CharSequence)depot)) {
            errorCollection.addError(P4_DEPOT, "The build's Perforce Depot has not been defined");
        } else {
            BambooFieldValidate.findFieldRelaxedXssViolation(errorCollection, this.textProvider, P4_DEPOT, depot);
        }
        String port = buildConfiguration.getString(P4_PORT);
        if (StringUtils.isEmpty((CharSequence)port)) {
            port = this.getPort();
            if (StringUtils.isEmpty((CharSequence)port)) {
                errorCollection.addError(P4_PORT, "The Perforce Port has not been defined");
            }
        } else {
            BambooFieldValidate.findFieldRelaxedXssViolation(errorCollection, this.textProvider, P4_PORT, port);
        }
        if (StringUtils.isEmpty((CharSequence)(client = buildConfiguration.getString(P4_CLIENT)))) {
            client = this.getClient();
            if (StringUtils.isEmpty((CharSequence)client)) {
                errorCollection.addError(P4_CLIENT, "The Perforce Client has not been defined");
            }
        } else {
            BambooFieldValidate.findFieldRelaxedXssViolation(errorCollection, this.textProvider, P4_CLIENT, client);
        }
        String user = buildConfiguration.getString(P4_USER);
        BambooFieldValidate.findFieldRelaxedXssViolation(errorCollection, this.textProvider, P4_USER, user);
        String password = buildConfiguration.getString(P4_PASSWD);
        Map variables = this.environmentVariableAccessor.splitEnvironmentAssignments(buildConfiguration.getString(P4_EXTRA_ENVIRONMENT), false);
        Depot testDepot = new Depot(variables);
        if (!errorCollection.hasAnyErrors()) {
            testDepot.setExecutable(p4exe);
            testDepot.setPort(this.customVariableContext.substituteString(port));
            this.perforceManager.validateConnection(errorCollection, testDepot);
        }
        if (!errorCollection.hasAnyErrors()) {
            if (!StringUtils.isEmpty((CharSequence)user)) {
                testDepot.setUser(this.customVariableContext.substituteString(user));
            }
            if (!StringUtils.isEmpty((CharSequence)this.decryptPassword(password))) {
                testDepot.setPassword(this.decryptPassword(password));
            }
            this.perforceManager.validateLogin(errorCollection, testDepot);
        }
        String substitutedClient = this.customVariableContext.substituteString(client);
        if (!errorCollection.hasAnyErrors() && substitutedClient != null) {
            this.perforceManager.validateClient(errorCollection, testDepot, substitutedClient);
        }
        if (!errorCollection.hasAnyErrors()) {
            testDepot.setClient(substitutedClient);
            this.perforceManager.validateDepot(errorCollection, testDepot, this.customVariableContext.substituteString(depot));
        }
        return errorCollection;
    }

    @NotNull
    public Set<Requirement> getRequirements() {
        return Sets.newHashSet((Object[])new Requirement[]{new RequirementImpl(P4_CAPABILITY_KEY, true, ".*", true)});
    }

    public String getClient() {
        if (this.client == null) {
            return SystemProperty.DEFAULT_PERFORCE_CLIENT.getValue();
        }
        return this.client;
    }

    public String getSubstitutedClient() {
        return this.customVariableContext.substituteString(this.getClient());
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getPort() {
        if (this.port == null) {
            return SystemProperty.DEFAULT_PERFORCE_PORT.getValue();
        }
        return this.port;
    }

    public String getSubstitutedPort() {
        return this.customVariableContext.substituteString(this.getPort());
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDepot() {
        return this.depot;
    }

    public String getSubstitutedDepot() {
        return this.customVariableContext.substituteString(this.getDepot());
    }

    public void setDepot(String depot) {
        this.depot = depot;
    }

    public void setUser(String user) {
        if (!StringUtils.isEmpty((CharSequence)user)) {
            this.user = user;
        }
    }

    public String getUser() {
        if (this.user == null) {
            return SystemProperty.DEFAULT_PERFORCE_USER.getValue();
        }
        return this.user;
    }

    public String getSubstitutedUser() {
        return this.customVariableContext.substituteString(this.getUser());
    }

    public boolean isManageWorkspace() {
        return this.manageWorkspace;
    }

    public void setManageWorkspace(boolean manageWorkspace) {
        this.manageWorkspace = manageWorkspace;
    }

    public boolean isUseClientMapping() {
        return this.useClientMapping;
    }

    public void setUseClientMapping(boolean useClientMapping) {
        this.useClientMapping = useClientMapping;
    }

    public String getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(String environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.password = encryptedPassword;
    }

    public String getEncryptedPassword() {
        return this.password;
    }

    public String getMavenPomCheckoutPomRelativePath() {
        return this.mavenPomCheckoutPomRelativePath;
    }

    public void setMavenPomCheckoutPomRelativePath(String mavenPomCheckoutPomRelativePath) {
        this.mavenPomCheckoutPomRelativePath = mavenPomCheckoutPomRelativePath;
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    public String getUrl() {
        return "http://www.perforce.com";
    }

    @Override
    public void setWorkingDir(File workingDir) {
    }

    @Override
    @NotNull
    public File getSourceCodeDirectory(@NotNull PlanKey planKey) throws RepositoryException {
        String root = this.manageWorkspace ? super.getSourceCodeDirectory(planKey).getAbsolutePath() : this.perforceManager.getClientRoot(this.getPerforceDepot());
        String workingDir = this.perforceManager.getWorkingDir(this.getSubstitutedClient(), root, this.getSubstitutedDepot());
        if (workingDir == null || BAD_FORMAT.equals(workingDir)) {
            throw new RepositoryException("Unable to evaluate source code directory. Client: " + this.getSubstitutedClient() + " Root: " + root + " Depot: " + this.getSubstitutedDepot());
        }
        return new File(workingDir);
    }

    private CommitFile convertFileForWebUrl(CommitFile file) {
        CommitFileImpl newFile = (CommitFileImpl)file;
        String newName = this.perforceManager.getFileNameForUrl(file.getName(), this.getSubstitutedDepot(), this.getSubstitutedClient());
        newFile.setName(newName);
        return newFile;
    }

    @NotNull
    public String getHost() {
        if (StringUtils.isBlank((CharSequence)this.host)) {
            try {
                this.host = this.perforceManager.getHostFromInfo(this.getPerforceDepot());
            }
            catch (Exception e) {
                log.error((Object)"Failed to extract host from Peforce info command");
            }
        }
        if (StringUtils.isBlank((CharSequence)this.host)) {
            return "unknown-host";
        }
        assert (this.host != null);
        return this.host;
    }

    public boolean isRepositoryDifferent(@NotNull Repository repository) {
        if (repository instanceof PerforceRepository) {
            PerforceRepository p4 = (PerforceRepository)repository;
            return !new EqualsBuilder().append((Object)this.getName(), (Object)p4.getName()).append((Object)this.getClient(), (Object)p4.getClient()).append((Object)this.getPort(), (Object)p4.getPort()).append((Object)this.getDepot(), (Object)p4.getDepot()).isEquals();
        }
        return true;
    }

    @NotNull
    public MavenPomAccessor getMavenPomAccessor() {
        return new PerforceRepositoryMavenPomAccessor(this);
    }

    @Override
    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(P4_PORT, (Object)SystemProperty.DEFAULT_PERFORCE_PORT.getValue());
        buildConfiguration.setProperty(P4_CLIENT, (Object)SystemProperty.DEFAULT_PERFORCE_CLIENT.getValue());
        buildConfiguration.setProperty(P4_USER, (Object)SystemProperty.DEFAULT_PERFORCE_USER.getValue());
        buildConfiguration.setProperty(P4_MAVEN_POM_CHECKOUT_POM_RELATIVE_PATH, (Object)"pom.xml");
    }

    @Override
    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        this.setPort(config.getString(P4_PORT));
        this.setClient(config.getString(P4_CLIENT));
        this.setDepot(config.getString(P4_DEPOT));
        this.setUser(config.getString(P4_USER));
        this.setEncryptedPassword(config.getString(P4_PASSWD));
        this.setManageWorkspace(config.getBoolean(P4_MANAGE));
        this.setUseClientMapping(config.getBoolean(P4_USECLIENTMAPPING, false));
        this.setEnvironmentVariables(config.getString(P4_EXTRA_ENVIRONMENT));
        this.setMavenPomCheckoutPomRelativePath(config.getString(P4_MAVEN_POM_CHECKOUT_POM_RELATIVE_PATH));
    }

    @Override
    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration config = super.toConfiguration();
        config.setProperty(P4_PORT, (Object)this.getPort());
        config.setProperty(P4_CLIENT, (Object)this.getClient());
        config.setProperty(P4_DEPOT, (Object)this.getDepot());
        config.setProperty(P4_USER, (Object)this.getUser());
        config.setProperty(P4_PASSWD, (Object)this.getEncryptedPassword());
        config.setProperty(P4_MANAGE, (Object)this.isManageWorkspace());
        config.setProperty(P4_USECLIENTMAPPING, (Object)this.isUseClientMapping());
        config.setProperty(P4_EXTRA_ENVIRONMENT, (Object)this.getEnvironmentVariables());
        config.setProperty(P4_MAVEN_POM_CHECKOUT_POM_RELATIVE_PATH, (Object)this.getMavenPomCheckoutPomRelativePath());
        return config;
    }

    @NotNull
    public Map<String, String> getCustomVariables() {
        return Collections.emptyMap();
    }

    @NotNull
    public Map<String, String> getPlanRepositoryVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(VAR_CLIENT, this.getSubstitutedClient());
        variables.put(VAR_USER_NAME, this.getSubstitutedUser());
        variables.put(VAR_PORT, this.getSubstitutedPort());
        variables.put(VAR_DEPOT, this.getSubstitutedDepot());
        return variables;
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 11).append((Object)this.getPort()).append((Object)this.getClient()).append((Object)this.getDepot()).append((Object)this.getUser()).append((Object)this.getEncryptedPassword()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof PerforceRepository)) {
            return false;
        }
        PerforceRepository rhs = (PerforceRepository)o;
        return new EqualsBuilder().append((Object)this.getPort(), (Object)rhs.getPort()).append((Object)this.getClient(), (Object)rhs.getClient()).append((Object)this.getDepot(), (Object)rhs.getDepot()).append((Object)this.getUser(), (Object)rhs.getUser()).append((Object)this.getEncryptedPassword(), (Object)rhs.getEncryptedPassword()).isEquals();
    }

    public int compareTo(Object obj) {
        PerforceRepository o = (PerforceRepository)obj;
        return new CompareToBuilder().append((Object)this.getPort(), (Object)o.getPort()).append((Object)this.getClient(), (Object)o.getClient()).append((Object)this.getDepot(), (Object)o.getDepot()).append((Object)this.getUser(), (Object)o.getUser()).append((Object)this.getEncryptedPassword(), (Object)o.getEncryptedPassword()).toComparison();
    }

    @Override
    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        boolean passwordChanged;
        buildConfiguration.setProperty(P4_PORT, (Object)buildConfiguration.getString(P4_PORT, "").trim());
        buildConfiguration.setProperty(P4_DEPOT, (Object)buildConfiguration.getString(P4_DEPOT, "").trim());
        buildConfiguration.setProperty(P4_CLIENT, (Object)buildConfiguration.getString(P4_CLIENT, "").trim());
        buildConfiguration.setProperty(P4_USER, (Object)buildConfiguration.getString(P4_USER, "").trim());
        buildConfiguration.setProperty(P4_EXTRA_ENVIRONMENT, (Object)buildConfiguration.getString(P4_EXTRA_ENVIRONMENT, "").trim());
        String repositoryKey = buildConfiguration.getString("selectedRepository");
        if (this.getKey().equals(repositoryKey) && (passwordChanged = buildConfiguration.getBoolean(TEMPORARY_P4_PASSWORD_CHANGE))) {
            String newPassword = buildConfiguration.getString(TEMPORARY_P4_PASSWORD);
            buildConfiguration.setProperty(P4_PASSWD, (Object)newPassword);
        }
    }

    public boolean isPerforceExecutableSet() {
        String p4Exe = this.getP4Executable();
        if (p4Exe == null) {
            return false;
        }
        File executable = new File(p4Exe);
        return executable.exists();
    }

    private void validateExecutable() throws RepositoryException {
        if (!this.isPerforceExecutableSet()) {
            String message = "Could not find the p4 client executable - " + this.getP4Executable() + ", please check your capabilities";
            log.error((Object)message);
            throw new RepositoryException(message);
        }
    }

    private String decryptPassword(String password) {
        if (StringUtils.isNotEmpty((CharSequence)password)) {
            return password;
        }
        return null;
    }

    public void setPerforceManager(PerforceManager perforceManager) {
        this.perforceManager = perforceManager;
    }

    public void setCapabilityContext(CapabilityContext capabilityContext) {
        this.capabilityContext = capabilityContext;
    }

    public void setEnvironmentVariableAccessor(EnvironmentVariableAccessor environmentVariableAccessor) {
        this.environmentVariableAccessor = environmentVariableAccessor;
    }
}

