/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.perforce;

import com.atlassian.bamboo.repository.MavenPomAccessorAbstract;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.perforce.PerforceRepository;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PerforceRepositoryMavenPomAccessor
extends MavenPomAccessorAbstract<PerforceRepository> {
    private static final Logger log = Logger.getLogger(PerforceRepositoryMavenPomAccessor.class);
    private static final Pattern MAVEN_SCM_URL_PATTERN = Pattern.compile("((\\w+)@)?((([^:|]+)(:(\\d+))?)(:|\\|))?(//.*)");
    private static final Pattern P4_DEPOT_PATTERN = Pattern.compile("//\\w+/(.+)/\\.\\.\\.");

    public PerforceRepositoryMavenPomAccessor(@NotNull PerforceRepository repository) {
        super(repository);
    }

    @NotNull
    public String getMavenScmProviderKey() {
        return "perforce";
    }

    public void parseMavenScmUrl(@NotNull String mavenScmUrl) throws IllegalArgumentException {
        Matcher matcher = MAVEN_SCM_URL_PATTERN.matcher(mavenScmUrl);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Can't parse SCM URL " + mavenScmUrl);
        }
        String p4User = matcher.group(2);
        String p4Port = matcher.group(4);
        String p4Depot = matcher.group(9);
        ((PerforceRepository)this.repository).setPort(p4Port);
        ((PerforceRepository)this.repository).setClient("");
        ((PerforceRepository)this.repository).setDepot(p4Depot);
        ((PerforceRepository)this.repository).setUser(p4User);
        ((PerforceRepository)this.repository).setEncryptedPassword("");
        ((PerforceRepository)this.repository).setManageWorkspace(true);
    }

    @NotNull
    public File checkoutMavenPom(@NotNull File destinationPath) throws RepositoryException {
        String p4Depot = ((PerforceRepository)this.repository).getSubstitutedDepot();
        ((PerforceRepository)this.repository).perforceManager.setupSync(((PerforceRepository)this.repository).getPerforceDepot(), destinationPath);
        ((PerforceRepository)this.repository).perforceManager.syncToHead(((PerforceRepository)this.repository).getPerforceDepot(), p4Depot, true);
        Matcher matcher = P4_DEPOT_PATTERN.matcher(p4Depot);
        if (!matcher.matches()) {
            throw new RepositoryException("Can't parse depot " + p4Depot);
        }
        return new File(new File(destinationPath, matcher.group(1)), ((PerforceRepository)this.repository).getMavenPomCheckoutPomRelativePath());
    }
}

