/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn;

import com.atlassian.bamboo.security.TrustedKeyDTO;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.trilead.ssh2.crypto.Base64;
import java.io.File;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;

public class BambooSvnSshAuthenticationManager
extends DefaultSVNAuthenticationManager {
    private static final Logger log = Logger.getLogger(BambooSvnSshAuthenticationManager.class);
    private final TrustedKeyHelper trustedKeyHelper;

    public BambooSvnSshAuthenticationManager(File configDirectory, String userName, String password, File privateKey, String passphrase, boolean storeAuth, TrustedKeyHelper trustedKeyHelper) {
        super(configDirectory, storeAuth, userName, password, privateKey, passphrase);
        this.trustedKeyHelper = trustedKeyHelper;
    }

    public void verifyHostKey(String hostName, int port, String keyAlgorithm, byte[] hostKey) throws SVNException {
        String serverPublicKey = keyAlgorithm + " " + new String(Base64.encode((byte[])hostKey));
        if (this.trustedKeyHelper.getTrustedKeys().stream().noneMatch(key -> key.getKey().equals(serverPublicKey))) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.AUTHN_CREDS_NOT_SAVED, (String)"Host key validation failed", (Object)new TrustedKeyDTO(hostName, serverPublicKey));
            throw new SVNAuthenticationException(errorMessage);
        }
        super.verifyHostKey(hostName, port, keyAlgorithm, hostKey);
    }
}

