/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.repository.svn.UpdateEventHandler;
import com.google.common.base.Predicate;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NotNull;

public class BuildLoggerUpdateEventHandler
extends UpdateEventHandler {
    private static final Logger log = Logger.getLogger(BuildLoggerUpdateEventHandler.class);
    private static final Predicate<Priority> DEFAULT_LOG_LEVER_VERIFIER = new Predicate<Priority>(){

        public boolean apply(Priority input) {
            return log.isEnabledFor(input);
        }
    };
    private final BuildLogger buildLogger;
    private final Predicate<Priority> logLevelEnabled;

    public BuildLoggerUpdateEventHandler(@NotNull BuildLogger buildLogger, @NotNull Predicate<Priority> logLevelEnabled) {
        this.buildLogger = buildLogger;
        this.logLevelEnabled = logLevelEnabled;
    }

    public BuildLoggerUpdateEventHandler(@NotNull BuildLogger buildLogger) {
        this(buildLogger, DEFAULT_LOG_LEVER_VERIFIER);
    }

    @Override
    protected void log_error(@NotNull String message) {
        log.error((Object)message);
        this.buildLogger.addErrorLogEntry(message);
    }

    @Override
    protected void log_warn(@NotNull String message) {
        log.warn((Object)message);
        this.buildLogger.addErrorLogEntry(message);
    }

    @Override
    protected void log_debug(@NotNull String message) {
        if (this.isDebugEnabled()) {
            log.debug((Object)message);
            this.buildLogger.addBuildLogEntry(message);
        }
    }

    private boolean isDebugEnabled() {
        return this.logLevelEnabled.apply((Object)Level.DEBUG);
    }
}

