/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitContextImpl;
import com.atlassian.bamboo.commit.CommitFileImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNLogEntry;

public class CommitExtractor
implements ISVNLogEntryHandler {
    private final List<CommitContext> commits = new ArrayList<CommitContext>();
    private final int commitLimit;
    private long highestRevisionFound = 0L;
    private int skippedCommitsCnt;

    public CommitExtractor(int commitLimit) {
        this.commitLimit = commitLimit;
    }

    public void handleLogEntry(SVNLogEntry logEntry) {
        if (logEntry.getRevision() > this.highestRevisionFound) {
            this.highestRevisionFound = logEntry.getRevision();
        }
        if (this.commits.size() >= this.commitLimit) {
            ++this.skippedCommitsCnt;
            return;
        }
        String revision = String.valueOf(logEntry.getRevision());
        Map changedPaths = logEntry.getChangedPaths();
        CommitContextImpl commitContext = CommitContextImpl.builder().author(logEntry.getAuthor()).date(logEntry.getDate()).comment(logEntry.getMessage()).changesetId(revision).files(changedPaths.keySet().stream().map(path -> new CommitFileImpl(revision, (String)path, revision)).collect(Collectors.toList())).build();
        this.commits.add(commitContext);
    }

    public int getSkippedCommitsCnt() {
        return this.skippedCommitsCnt;
    }

    public long getHighestRevisionFound() {
        return this.highestRevisionFound;
    }

    public List<CommitContext> getCommits() {
        ArrayList<CommitContext> copy = new ArrayList<CommitContext>(this.commits);
        Collections.reverse(copy);
        return copy;
    }
}

