/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;

public class SVNClientManagerFactory
implements DisposableBean {
    private static final Logger log = Logger.getLogger(SVNClientManagerFactory.class);
    private final Collection<SVNClientManager> clientManagers = new ArrayList<SVNClientManager>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNClientManager getSVNClientManager(ISVNOptions options, ISVNAuthenticationManager authMgr) {
        SVNClientManager svnClientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authMgr);
        SVNClientManagerFactory sVNClientManagerFactory = this;
        synchronized (sVNClientManagerFactory) {
            this.clientManagers.add(svnClientManager);
        }
        return svnClientManager;
    }

    public synchronized void destroy() throws Exception {
        log.info((Object)"Destroying SVNClientManagerFactories...");
        for (SVNClientManager clientManager : this.clientManagers) {
            clientManager.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(@Nullable SVNClientManager svnClientManager) {
        if (svnClientManager != null) {
            SVNClientManagerFactory sVNClientManagerFactory = this;
            synchronized (sVNClientManagerFactory) {
                this.clientManagers.remove(svnClientManager);
            }
            svnClientManager.dispose();
        }
    }

    Collection<SVNClientManager> getClientManagers() {
        return this.clientManagers;
    }
}

