/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.RepositorySettings;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.repository.AbstractStandaloneRepository;
import com.atlassian.bamboo.repository.AdvancedConfigurationAwareRepository;
import com.atlassian.bamboo.repository.AuthenticationType;
import com.atlassian.bamboo.repository.BranchInformationProvider;
import com.atlassian.bamboo.repository.BranchingAwareRepository;
import com.atlassian.bamboo.repository.CacheId;
import com.atlassian.bamboo.repository.CachingAwareRepository;
import com.atlassian.bamboo.repository.CommitIsolationAwareRepository;
import com.atlassian.bamboo.repository.CustomRevisionDataAwareRepository;
import com.atlassian.bamboo.repository.CustomVariableProviderRepository;
import com.atlassian.bamboo.repository.DeploymentAwareRepository;
import com.atlassian.bamboo.repository.HostKeyVerificationException;
import com.atlassian.bamboo.repository.InitialBuildAwareRepository;
import com.atlassian.bamboo.repository.InvalidRepositoryException;
import com.atlassian.bamboo.repository.MandatoryCleanCheckoutAwareRepository;
import com.atlassian.bamboo.repository.MavenPomAccessorCapableRepository;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.SelectableAuthenticationRepository;
import com.atlassian.bamboo.repository.TaggingAwareRepository;
import com.atlassian.bamboo.repository.TestConnectionAwareRepository;
import com.atlassian.bamboo.repository.svn.BambooSvnSshAuthenticationManager;
import com.atlassian.bamboo.repository.svn.BuildLoggerUpdateEventHandler;
import com.atlassian.bamboo.repository.svn.CommitExtractor;
import com.atlassian.bamboo.repository.svn.ExternalsLockException;
import com.atlassian.bamboo.repository.svn.SVNClientManagerFactory;
import com.atlassian.bamboo.repository.svn.SvnRepositoryMavenPomAccessor;
import com.atlassian.bamboo.repository.svn.SvnRepositoryPathHelper;
import com.atlassian.bamboo.repository.svn.SvnWcFormat;
import com.atlassian.bamboo.repository.svn.SvnWcFormatSelector;
import com.atlassian.bamboo.repository.svn.UpdateEventHandler;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.util.CallableResultCache;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.v2.build.repository.CustomSourceDirectoryAwareRepository;
import com.atlassian.bamboo.v2.build.repository.RepositoryEventAware;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.DefaultHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnRepository
extends AbstractStandaloneRepository
implements SelectableAuthenticationRepository,
InitialBuildAwareRepository,
RepositoryEventAware,
MavenPomAccessorCapableRepository,
CommitIsolationAwareRepository,
BranchingAwareRepository,
TaggingAwareRepository,
CustomSourceDirectoryAwareRepository,
MandatoryCleanCheckoutAwareRepository,
AdvancedConfigurationAwareRepository,
CustomRevisionDataAwareRepository,
CustomVariableProviderRepository,
BranchInformationProvider,
CachingAwareRepository,
DeploymentAwareRepository,
TestConnectionAwareRepository {
    private static final Logger log = Logger.getLogger(SvnRepository.class);
    private static final SVNDepth externalResolutionDepth = SVNDepth.IMMEDIATES;
    private boolean detectedDirtyCheckoutDirectory = false;
    public static final String NAME = "Subversion";
    public static final String KEY = "svn";
    public static final String COMPLETE_PLUGIN_KEY = "com.atlassian.bamboo.plugin.system.repository:svn";
    public static final String SVN_REPO_PREFIX = "repository.svn.";
    public static final String SVN_REPO_URL = "repositoryUrl";
    public static final String SVN_USERNAME = "username";
    public static final String SVN_AUTH_TYPE = "authType";
    public static final String SVN_PASSWORD = "userPassword";
    public static final String SVN_KEYFILE = "keyFile";
    public static final String SVN_PASSPHRASE = "passphrase";
    public static final String SVN_SSL_KEYFILE = "sslKeyFile";
    public static final String SVN_SSL_PASSPHRASE = "sslPassphrase";
    public static final String USE_EXTERNALS = "useExternals";
    public static final String USE_EXPORT = "useExport";
    public static final String TEMPORARY_SVN_REPO_PREFIX = "temporary.svn.";
    public static final String TEMPORARY_SVN_PASSWORD = "password";
    private static final String TEMPORARY_SVN_PASSWORD_CHANGE = "passwordChange";
    private static final String TEMPORARY_SVN_PASSPHRASE = "passphrase";
    private static final String TEMPORARY_SVN_PASSPHRASE_CHANGE = "passphraseChange";
    private static final String TEMPORARY_SVN_SSL_PASSPHRASE = "sslPassphrase";
    private static final String TEMPORARY_SVN_SSL_PASSPHRASE_CHANGE = "sslPassphraseChange";
    public static final String BRANCH_AUTODETECT_ROOT = "branch.autodetectRootUrl";
    public static final String BRANCH_MANUAL_ROOT = "branch.manualRootUrl";
    public static final String TAG_AUTODETECT_ROOT = "tag.autodetectRootUrl";
    public static final String TAG_MANUAL_ROOT = "tag.manualRootUrl";
    private static final String EXTERNAL_PATH_MAPPINGS2 = "externalsToRevisionMappings";
    public static final String BRANCHES_DETECTION_BRANCHES_ROOT = "branchesRoot";
    public static final String BRANCHES_DETECTION_BRANCHES_ROOT_OVERRIDDEN = "branchesRootOverridden";
    public static final ISVNOptions DEFAULT_SVN_OPTIONS;
    private String repositoryUrl;
    private String username;
    private String password;
    private String passphrase;
    private String keyFile;
    private String authType;
    private boolean useExternals;
    private boolean useExport;
    private boolean commitIsolationEnabled;
    private boolean autodetectBranchRoot = true;
    private boolean autodetectTagRoot = true;
    private String manualBranchRoot;
    private String manualTagRoot;
    protected TrustedKeyHelper trustedKeyHelper;
    private transient SVNClientManagerFactory svnClientManagerFactory;
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private transient Map<String, SVNExternal> svnExternals;
    private static final transient Cache<SVNURL, SVNURL> repositoryRootUrls;
    private final transient Lock externalsLock = new ReentrantLock();
    private static final CallableResultCache<SVNInfo> GET_INFO_CACHE;

    private void initializeSvnProperties() {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        RepositorySettings repositorySettings = administrationConfiguration.getRepositorySettings();
        SvnWcFormat svnWcFormat = this.getWorkingCopyFormatFromConfiguration();
        if (svnWcFormat == SvnWcFormat.WC_1_7 || svnWcFormat == SvnWcFormat.WC_1_8) {
            System.clearProperty("svnkit.wc.17");
            SVNAdminAreaFactory.setSelector(null);
        } else {
            System.setProperty("svnkit.wc.17", "false");
            SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new SvnWcFormatSelector(svnWcFormat.getWcFormatVersion()));
        }
        if (repositorySettings.isUseNtlmAuth()) {
            System.setProperty("svnkit.http.methods", "NTLM,Negotiate,Digest,Basic");
        } else {
            System.setProperty("svnkit.http.methods", "Digest,Basic,Negotiate,NTLM");
        }
    }

    @NotNull
    public synchronized BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, @NotNull PlanVcsRevisionData revisionData) throws RepositoryException {
        try {
            Long lastRevisionChecked = revisionData.getVcsRevisionKey() != null ? Long.valueOf(revisionData.getVcsRevisionKey()) : null;
            SVNURL repositorySvnUrl = this.getSubstitutedSvnUrl();
            ArrayList<CommitContext> commits = new ArrayList<CommitContext>();
            Pair<SVNURL, BuildRepositoryChanges> buildChangesAndTheirRoot = this.detectCommitsForUrl(repositorySvnUrl, lastRevisionChecked, commits, planKey, SVNRevision.HEAD);
            BuildRepositoryChanges buildChanges = (BuildRepositoryChanges)buildChangesAndTheirRoot.getSecond();
            String externalsData = null;
            if (this.isUseExternals()) {
                Map<String, Long> externalPathRevisionMappings = new HashMap<String, Long>();
                String customXmlData = revisionData.getCustomXmlData();
                if (StringUtils.isNotEmpty((CharSequence)customXmlData)) {
                    Map stringMaps = ConfigUtils.getMapFromConfiguration((String)SvnRepository.getConfigConstant(EXTERNAL_PATH_MAPPINGS2), (HierarchicalConfiguration)ConfigUtils.getXmlConfigFromXmlString((String)customXmlData));
                    externalPathRevisionMappings = ConfigUtils.toLongMap((Map)stringMaps);
                }
                if (externalPathRevisionMappings.isEmpty()) {
                    this.initExternalsRevisionMapping((SVNURL)buildChangesAndTheirRoot.getFirst(), externalPathRevisionMappings);
                }
                for (Map.Entry entry : this.getExternals((SVNURL)buildChangesAndTheirRoot.getFirst()).entrySet()) {
                    String path = (String)entry.getKey();
                    SVNExternal external = (SVNExternal)entry.getValue();
                    SVNURL svnUrl = external.getResolvedURL();
                    Long latestRevisionCheckedForExternal = externalPathRevisionMappings.get(path);
                    if (null != latestRevisionCheckedForExternal && external.getRevision() != SVNRevision.HEAD && (!external.isRevisionExplicit() || external.getRevision().getNumber() <= latestRevisionCheckedForExternal)) continue;
                    log.info((Object)("Checking if the latest revision on external: [" + path + "]->[" + svnUrl + "], is more recent than " + latestRevisionCheckedForExternal));
                    Pair<SVNURL, BuildRepositoryChanges> changesOfExternalItsRoot = this.detectCommitsForUrl(svnUrl, latestRevisionCheckedForExternal, commits, planKey, SVNRevision.HEAD);
                    externalPathRevisionMappings.put(path, Long.valueOf(((BuildRepositoryChanges)changesOfExternalItsRoot.getSecond()).getVcsRevisionKey()));
                }
                Map stringMap = ConfigUtils.toStringMap(externalPathRevisionMappings);
                XMLConfiguration xMLConfiguration = ConfigUtils.newConfiguration();
                ConfigUtils.addMapToConfiguration((String)SvnRepository.getConfigConstant(EXTERNAL_PATH_MAPPINGS2), (Map)stringMap, (HierarchicalConfiguration)xMLConfiguration);
                externalsData = ConfigUtils.asXmlString((XMLConfiguration)xMLConfiguration);
            }
            buildChanges.setChanges(commits);
            buildChanges.setCustomXmlData(externalsData);
            return buildChanges;
        }
        catch (SVNException e) {
            String message = "Build '" + planKey + "' failed to check SVN repository";
            TrustedKey serverPublicKey = this.extractTrustedKey(e);
            if (serverPublicKey != null) {
                throw new HostKeyVerificationException(message, (Throwable)e, serverPublicKey);
            }
            throw new RepositoryException(message, (Throwable)e);
        }
    }

    @Override
    @NotNull
    public BuildRepositoryChanges collectChangesForRevision(@NotNull PlanKey planKey, @NotNull String targetRevision) throws RepositoryException {
        return this.collectChangesSinceLastBuild(planKey.getKey(), targetRevision, SVNRevision.parse((String)targetRevision));
    }

    @NotNull
    public synchronized BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, @Nullable String lastVcsRevisionKey) throws RepositoryException {
        return this.collectChangesSinceLastBuild(planKey, lastVcsRevisionKey, SVNRevision.HEAD);
    }

    @NotNull
    private synchronized BuildRepositoryChanges collectChangesSinceLastBuild(@NotNull String planKey, @Nullable String lastVcsRevisionKey, @NotNull SVNRevision targetRevision) throws RepositoryException {
        try {
            Long lastRevisionChecked = lastVcsRevisionKey != null ? Long.valueOf(lastVcsRevisionKey) : null;
            SVNURL repositorySvnUrl = this.getSubstitutedSvnUrl();
            ArrayList<CommitContext> commits = new ArrayList<CommitContext>();
            Pair<SVNURL, BuildRepositoryChanges> buildChangesAndTheirRoot = this.detectCommitsForUrl(repositorySvnUrl, lastRevisionChecked, commits, planKey, targetRevision);
            if (this.isUseExternals()) {
                HashMap<String, Long> externalPathRevisionMappings = new HashMap<String, Long>();
                log.warn((Object)"Support for externals in this method is deprecated");
                this.initExternalsRevisionMapping((SVNURL)buildChangesAndTheirRoot.getFirst(), externalPathRevisionMappings);
                for (Map.Entry<String, SVNExternal> externalEntry : this.getExternals((SVNURL)buildChangesAndTheirRoot.getFirst()).entrySet()) {
                    String path = externalEntry.getKey();
                    SVNExternal external = externalEntry.getValue();
                    SVNURL svnUrl = external.getResolvedURL();
                    Long latestRevisionCheckedForExternal = (Long)externalPathRevisionMappings.get(path);
                    if (null != latestRevisionCheckedForExternal && external.getRevision() != SVNRevision.HEAD && (!external.isRevisionExplicit() || external.getRevision().getNumber() <= latestRevisionCheckedForExternal)) continue;
                    log.info((Object)("Checking externals at path '" + path + "' with SVN URL '" + svnUrl + "' from revision " + latestRevisionCheckedForExternal));
                    Pair<SVNURL, BuildRepositoryChanges> changesOfExternal = this.detectCommitsForUrl(svnUrl, latestRevisionCheckedForExternal, commits, planKey, targetRevision);
                    externalPathRevisionMappings.put(path, Long.valueOf(((BuildRepositoryChanges)changesOfExternal.getSecond()).getVcsRevisionKey()));
                }
            }
            BuildRepositoryChanges buildChanges = (BuildRepositoryChanges)buildChangesAndTheirRoot.getSecond();
            buildChanges.setChanges(commits);
            return buildChanges;
        }
        catch (SVNException e) {
            throw new RepositoryException("Build '" + planKey + "' failed to check SVN repository", (Throwable)e);
        }
    }

    private Map<String, SVNExternal> getExternals(SVNURL repositoryRootUrl) throws SVNException {
        this.externalsLock.lock();
        try {
            if (this.svnExternals == null) {
                this.svnExternals = new HashMap<String, SVNExternal>();
                this.discoverExternals(repositoryRootUrl, this.getSubstitutedSvnUrl(), "");
            }
        }
        finally {
            this.externalsLock.unlock();
        }
        return this.svnExternals;
    }

    public boolean usePollingForBranchDetection() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Pair<SVNURL, BuildRepositoryChanges> detectCommitsForUrl(@NotNull SVNURL repositorySvnUrl, @Nullable Long lastRevisionChecked, @NotNull List<CommitContext> commits, @NotNull String planKey, @NotNull SVNRevision targetRevision) throws SVNException, InvalidRepositoryException {
        SVNClientManager clientManager = null;
        try {
            SVNInfo svnInfo;
            clientManager = this.getSvnClientManager();
            try {
                svnInfo = this.doInfo(clientManager, repositorySvnUrl, targetRevision);
            }
            catch (SVNException e) {
                SVNErrorMessage errorMessage = e.getErrorMessage();
                if (SvnRepositoryPathHelper.isPathNotFound(errorMessage)) {
                    throw new InvalidRepositoryException(e.getMessage(), e);
                }
                throw e;
            }
            SVNURL repositoryRootUrl = svnInfo.getRepositoryRootURL();
            long latestRevisionOnServer = svnInfo.getRevision().getNumber();
            BuildRepositoryChangesImpl buildChanges = new BuildRepositoryChangesImpl();
            buildChanges.setVcsRevisionKey(String.valueOf(latestRevisionOnServer));
            if (lastRevisionChecked == null) {
                log.info((Object)("Never checked path [" + repositorySvnUrl + "] for plan " + planKey + ", setting latest revision to " + latestRevisionOnServer));
                Pair pair = Pair.make((Object)repositoryRootUrl, (Object)buildChanges);
                return pair;
            }
            if (latestRevisionOnServer > lastRevisionChecked || lastRevisionChecked.longValue() == targetRevision.getNumber()) {
                long startRevision = lastRevisionChecked.longValue() == targetRevision.getNumber() ? lastRevisionChecked : lastRevisionChecked + 1L;
                SVNRevision endRevision = lastRevisionChecked.longValue() == targetRevision.getNumber() ? SVNRevision.create((long)lastRevisionChecked) : SVNRevision.HEAD;
                log.info((Object)("Collecting changes for '" + planKey + "' on path '" + repositorySvnUrl + "' from version " + startRevision + " to " + endRevision.getNumber()));
                SVNLogClient logClient = clientManager.getLogClient();
                CommitExtractor commitExtractor = new CommitExtractor(this.getMaxCommitsToReturn());
                logClient.doLog(repositorySvnUrl, null, endRevision, endRevision, SVNRevision.create((long)startRevision), true, true, 0L, (ISVNLogEntryHandler)commitExtractor);
                commits.addAll(commitExtractor.getCommits());
                if (commitExtractor.getHighestRevisionFound() > latestRevisionOnServer) {
                    latestRevisionOnServer = commitExtractor.getHighestRevisionFound();
                    buildChanges.setVcsRevisionKey(String.valueOf(latestRevisionOnServer));
                }
                buildChanges.setSkippedCommitsCount(commitExtractor.getSkippedCommitsCnt());
            }
            Pair pair = Pair.make((Object)repositoryRootUrl, (Object)buildChanges);
            return pair;
        }
        finally {
            this.dispose(clientManager);
        }
    }

    @NotNull
    public String retrieveSourceCode(@NotNull BuildContext buildContext, @Nullable String vcsRevisionKey, @NotNull File sourceDirectory) throws RepositoryException {
        ResultKey resultKey = buildContext.getResultKey();
        String entityKey = resultKey.getEntityKey().getKey();
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager();
            String string = this.retrieveSourceCodeWithCleanup(buildContext, vcsRevisionKey, clientManager, sourceDirectory);
            return string;
        }
        catch (SVNException e) {
            if (this.isRecoverableException(e) && clientManager != null) {
                try {
                    BuildLogger buildLogger = this.buildLoggerManager.getLogger(resultKey);
                    log.warn((Object)buildLogger.addErrorLogEntry("Subversion repository for " + entityKey + " failed to update: [" + e.getMessage() + "]. Attempting a clean checkout..."));
                    BambooPathUtils.cleanDirectory((Path)sourceDirectory.toPath());
                    String string = this.retrieveSourceCodeWithException(buildContext, vcsRevisionKey, clientManager, false, sourceDirectory);
                    return string;
                }
                catch (Exception e1) {
                    throw new RepositoryException("Unable to retrieve source code for revision '" + (vcsRevisionKey != null ? vcsRevisionKey : "latest") + "', plan '" + entityKey + "': " + e.getMessage(), (Throwable)e);
                }
            }
            throw new RepositoryException("Unable to retrieve source code for revision '" + (vcsRevisionKey != null ? vcsRevisionKey : "latest") + "', plan '" + entityKey + "': " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.dispose(clientManager);
        }
    }

    private String retrieveSourceCodeWithCleanup(BuildContext buildContext, String vcsRevisionKey, SVNClientManager clientManager, File sourceDirectory) throws SVNException, RepositoryException {
        SVNException lastException;
        File dirtyPath;
        boolean isCleanedPathNew;
        Key entityKey = buildContext.getResultKey().getEntityKey();
        BuildLogger buildLogger = this.buildLoggerManager.getLogger(buildContext.getResultKey());
        int cleanupTries = 5;
        boolean skipUpdateMessage = false;
        do {
            try {
                return this.retrieveSourceCodeWithException(buildContext, vcsRevisionKey, clientManager, skipUpdateMessage, sourceDirectory);
            }
            catch (ExternalsLockException e) {
                if (clientManager == null) {
                    throw e;
                }
                dirtyPath = e.getAffectedLockedDirectory();
                lastException = e;
            }
            catch (SVNException e) {
                if (!this.isSvnLockException(e) || clientManager == null) {
                    throw e;
                }
                dirtyPath = sourceDirectory;
                lastException = e;
            }
            this.cleanUpWorkspace(entityKey, buildLogger, dirtyPath);
            skipUpdateMessage = true;
            boolean bl = isCleanedPathNew = dirtyPath != null;
        } while (isCleanedPathNew && --cleanupTries > 0);
        String reason = isCleanedPathNew ? "too many directories to clean up" : "failed to clean " + dirtyPath + " in one go";
        String msg = "Failed to clean up Subversion workspace for " + buildContext.getDisplayName() + ", reason: " + reason;
        log.error((Object)buildLogger.addErrorLogEntry(msg));
        throw lastException;
    }

    private String retrieveSourceCodeWithException(BuildContext buildContext, String vcsRevisionKey, SVNClientManager svnClientManager, boolean skipUpdateMessage, File sourceDirectory) throws SVNException, RepositoryException {
        SVNRevision revision;
        if (vcsRevisionKey != null) {
            Long vcsRevision = Long.parseLong(vcsRevisionKey);
            revision = SVNRevision.create((long)vcsRevision);
        } else {
            SVNURL repositorySvnUrl = this.getSubstitutedSvnUrl();
            long latestRevisionOnServer = svnClientManager.createRepository(repositorySvnUrl, true).getLatestRevision();
            vcsRevisionKey = String.valueOf(latestRevisionOnServer);
            revision = SVNRevision.HEAD;
        }
        BuildLogger buildLogger = this.buildLoggerManager.getLogger(buildContext.getResultKey());
        if (this.isUseExport()) {
            SVNURL svnUrl = this.getSubstitutedSvnUrl();
            log.info((Object)buildLogger.addBuildLogEntry("Exporting SVN URL '" + svnUrl + "' to directory " + sourceDirectory.getAbsolutePath()));
            this.export(svnUrl, revision, sourceDirectory, true, buildLogger);
        } else if (this.isWorkspaceEmpty(sourceDirectory)) {
            SVNURL svnUrl = this.getSubstitutedSvnUrl();
            log.info((Object)buildLogger.addBuildLogEntry("Working directory '" + sourceDirectory.getAbsolutePath() + "' is empty. Checking out SVN URL '" + svnUrl + "'"));
            this.checkout(svnUrl, revision, sourceDirectory, true, buildLogger);
        } else {
            if (!skipUpdateMessage) {
                log.info((Object)buildLogger.addBuildLogEntry("Existing workspace found at '" + sourceDirectory.getAbsolutePath() + "'. updating..."));
            }
            this.update(sourceDirectory, revision, true, buildLogger);
        }
        return vcsRevisionKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preRetrieveSourceCode(@NotNull BuildContext buildContext, @NotNull File sourceDirectory) {
        SVNClientManager clientManager = null;
        try {
            if (!this.isWorkspaceEmpty(sourceDirectory)) {
                clientManager = this.getSvnClientManager();
                SVNWCClient wcClient = clientManager.getWCClient();
                try {
                    SVNInfo svnInfo = wcClient.doInfo(sourceDirectory, null);
                    SVNURL localSvnRepositoryPath = svnInfo.getURL();
                    SVNURL actualUrl = this.getSubstitutedSvnUrl();
                    if (localSvnRepositoryPath != null && !localSvnRepositoryPath.equals((Object)actualUrl)) {
                        BuildLogger buildLogger = this.buildLoggerManager.getLogger(buildContext.getResultKey());
                        log.info((Object)buildLogger.addBuildLogEntry("Existing source path at '" + sourceDirectory.getAbsolutePath() + "' is '" + localSvnRepositoryPath + "' and differs from '" + actualUrl + "'"));
                        this.detectedDirtyCheckoutDirectory = true;
                    }
                }
                catch (SVNException e) {
                    log.warn((Object)"Exception while obtaining svn info for the directory. Assuming that cleanup is required...", (Throwable)e);
                    this.detectedDirtyCheckoutDirectory = true;
                }
            }
            this.dispose(clientManager);
        }
        catch (Exception e) {
            try {
                log.warn((Object)"Exception while detecting whether source code differs. Ignoring...", (Throwable)e);
                this.dispose(clientManager);
            }
            catch (Throwable throwable) {
                this.dispose(clientManager);
                throw throwable;
            }
        }
    }

    public void postRetrieveSourceCode(@NotNull BuildContext buildContext, @NotNull File sourceDirectory) {
    }

    private boolean isSvnLockException(@NotNull SVNException e) {
        CharSequence[] exceptionMsg = new String[]{"locked; try performing 'cleanup'"};
        return StringUtils.indexOfAny((CharSequence)e.getMessage(), (CharSequence[])exceptionMsg) != -1;
    }

    protected boolean isRecoverableException(@NotNull SVNException e) {
        CharSequence[] exceptionMsg = new String[]{"object of the same name already exists", "containing working copy admin area is missing", "failed to load properties from disk", "checksum mismatch", "can't open file", "is not a working copy"};
        return StringUtils.indexOfAny((CharSequence)StringUtils.lowerCase((String)e.getMessage()), (CharSequence[])exceptionMsg) != -1 || this.isSvnLockException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverExternals(final SVNURL repositoryRootUrl, final SVNURL startingUrl, final @NotNull String relativePath) throws SVNException {
        SVNClientManager clientManager = this.getSvnClientManager();
        try {
            SVNWCClient svnClient = clientManager.getWCClient();
            log.info((Object)("Fetching externals data from '" + startingUrl + "'. This may take some time."));
            svnClient.doGetProperty(startingUrl, "svn:externals", SVNRevision.HEAD, SVNRevision.HEAD, externalResolutionDepth, new ISVNPropertyHandler(){

                public void handleProperty(File path, SVNPropertyData property) {
                }

                public void handleProperty(SVNURL url, SVNPropertyData property) throws SVNException {
                    SVNExternal[] externals;
                    for (SVNExternal external : externals = SVNExternal.parseExternals((Object)url.getPath(), (String)property.getValue().getString())) {
                        external.resolveURL(repositoryRootUrl, url);
                        String wcPath = StringUtils.substring((String)url.getPath(), (int)(startingUrl.getPath().length() + 1));
                        String cumulatedExternalPath = relativePath;
                        if (!StringUtils.isBlank((CharSequence)cumulatedExternalPath)) {
                            cumulatedExternalPath = cumulatedExternalPath + "/";
                        }
                        if (!StringUtils.isBlank((CharSequence)wcPath)) {
                            cumulatedExternalPath = cumulatedExternalPath + wcPath + "/";
                        }
                        cumulatedExternalPath = cumulatedExternalPath + external.getPath();
                        SvnRepository.this.svnExternals.put(cumulatedExternalPath, external);
                        if (!externalResolutionDepth.equals((Object)SVNDepth.INFINITY)) continue;
                        SvnRepository.this.discoverExternals(repositoryRootUrl, external.getResolvedURL(), cumulatedExternalPath);
                    }
                }

                public void handleProperty(long revision, SVNPropertyData property) {
                }
            });
        }
        finally {
            this.dispose(clientManager);
        }
    }

    private void cleanUpWorkspace(Key entityKey, BuildLogger buildLogger, File dirtyWorkspacePath) throws RepositoryException {
        log.warn((Object)buildLogger.addBuildLogEntry("Cleaning up dirty Subversion workspace at '" + dirtyWorkspacePath.getPath() + "'"));
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager();
            SVNWCClient wcClient = clientManager.getWCClient();
            wcClient.setIgnoreExternals(false);
            wcClient.doCleanup(dirtyWorkspacePath);
            log.info((Object)buildLogger.addBuildLogEntry("Clean up of '" + dirtyWorkspacePath.getPath() + "' completed"));
        }
        catch (SVNException e) {
            String msg = "Failed to clean up '" + entityKey + "'";
            log.error((Object)msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
        finally {
            this.dispose(clientManager);
        }
    }

    protected SVNClientManager getSvnClientManager() {
        ISVNAuthenticationManager authManager;
        if (StringUtils.isBlank((CharSequence)this.authType) || this.authType.equals(AuthenticationType.PASSWORD.getKey())) {
            authManager = this.getStandardAuthManager(this.username, this.getUserPassword());
        } else if (this.authType.equals(AuthenticationType.SSH.getKey())) {
            authManager = this.getSshAuthManager(this.username, this.getSubstitutedKeyFile(), this.getPassphrase());
        } else if (this.authType.equals(AuthenticationType.SSL_CLIENT_CERTIFICATE.getKey())) {
            authManager = this.getSslAuthManager(this.getSubstitutedKeyFile(), this.getPassphrase());
        } else {
            throw new IllegalArgumentException("Unexpected authorization type [" + this.authType + "]");
        }
        this.initializeSvnProperties();
        return this.svnClientManagerFactory.getSVNClientManager(DEFAULT_SVN_OPTIONS, authManager);
    }

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        String keyField;
        String substitutedKeyFile;
        File keyFile;
        boolean isKnownAuth;
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        String repoUrl = this.customVariableContext.substituteString(buildConfiguration.getString(SvnRepository.getConfigConstant(SVN_REPO_URL)));
        if (StringUtils.isBlank((CharSequence)repoUrl)) {
            errorCollection.addError(SvnRepository.getConfigConstant(SVN_REPO_URL), "Please specify the build's Subversion repository.");
        } else {
            BambooFieldValidate.findFieldRelaxedXssViolation(errorCollection, this.textProvider, SvnRepository.getConfigConstant(SVN_REPO_URL), repoUrl);
        }
        String authType = buildConfiguration.getString(SvnRepository.getConfigConstant(SVN_AUTH_TYPE));
        boolean isNoAuth = StringUtils.isBlank((CharSequence)authType);
        boolean isPasswordAuth = !isNoAuth && AuthenticationType.PASSWORD.getKey().equals(authType);
        boolean isSshAuth = !isNoAuth && AuthenticationType.SSH.getKey().equals(authType);
        boolean isSslClientCertificateAuth = !isNoAuth && AuthenticationType.SSL_CLIENT_CERTIFICATE.getKey().equals(authType);
        boolean bl = isKnownAuth = isNoAuth || isPasswordAuth || isSshAuth || isSslClientCertificateAuth;
        if (!isKnownAuth) {
            errorCollection.addError(SvnRepository.getConfigConstant(SVN_AUTH_TYPE), "Unknown authorization type: " + authType);
        } else if ((isSshAuth || isSslClientCertificateAuth) && !(keyFile = new File(substitutedKeyFile = this.customVariableContext.substituteString(buildConfiguration.getString(keyField = SvnRepository.getConfigConstant(isSshAuth ? SVN_KEYFILE : SVN_SSL_KEYFILE))))).exists()) {
            errorCollection.addError(keyField, this.textProvider.getText("repository.keyFile.error"));
        }
        if (!buildConfiguration.getBoolean(SvnRepository.getConfigConstant(BRANCH_AUTODETECT_ROOT), false) && StringUtils.isBlank((CharSequence)buildConfiguration.getString(SvnRepository.getConfigConstant(BRANCH_MANUAL_ROOT)))) {
            errorCollection.addError(SvnRepository.getConfigConstant(BRANCH_MANUAL_ROOT), "Please specify the root url for branches");
        }
        if (!buildConfiguration.getBoolean(SvnRepository.getConfigConstant(TAG_AUTODETECT_ROOT), false) && StringUtils.isBlank((CharSequence)buildConfiguration.getString(SvnRepository.getConfigConstant(TAG_MANUAL_ROOT)))) {
            errorCollection.addError(SvnRepository.getConfigConstant(BRANCH_MANUAL_ROOT), "Please specify the root url for tags");
        }
        return errorCollection;
    }

    @NotNull
    private ISVNAuthenticationManager getStandardAuthManager(String userName, String password) {
        return SVNWCUtil.createDefaultAuthenticationManager(null, (String)userName, (String)password, (boolean)SystemProperty.SVN_CACHE_CREDENTIALS.getValue(false));
    }

    @NotNull
    private ISVNAuthenticationManager getSshAuthManager(String userName, String privateKeyFile, String passphrase) {
        boolean cacheCredentials = SystemProperty.SVN_CACHE_CREDENTIALS.getValue(false);
        if (this.trustedKeyHelper.isCustomAcceptedSshHostKeysEnabled() && !SystemProperty.CRYPTO_TRUST_SVN_SSH_ALL.getTypedValue()) {
            return new BambooSvnSshAuthenticationManager(null, userName, null, new File(privateKeyFile), passphrase, cacheCredentials, this.trustedKeyHelper);
        }
        return SVNWCUtil.createDefaultAuthenticationManager(null, (String)userName, null, (File)new File(privateKeyFile), (String)passphrase, (boolean)cacheCredentials);
    }

    @NotNull
    private ISVNAuthenticationManager getSslAuthManager(String sslClientCert, String sslClientCertPassword) {
        File clientCertFile = sslClientCert != null ? new File(sslClientCert) : null;
        return new BasicAuthenticationManager(new SVNAuthentication[]{new SVNSSLAuthentication(clientCertFile, sslClientCertPassword, false)});
    }

    public boolean isRepositoryDifferent(@NotNull Repository repository) {
        if (repository instanceof SvnRepository) {
            SvnRepository svn = (SvnRepository)repository;
            return !new EqualsBuilder().append((Object)this.getName(), (Object)svn.getName()).append((Object)this.getRepositoryUrl(), (Object)svn.getRepositoryUrl()).isEquals();
        }
        return true;
    }

    @Override
    public void prepareConfigObject(@NotNull BuildConfiguration buildConfiguration) {
        buildConfiguration.setProperty(SvnRepository.getConfigConstant(SVN_USERNAME), (Object)buildConfiguration.getString(SvnRepository.getConfigConstant(SVN_USERNAME), "").trim());
        buildConfiguration.setProperty(SvnRepository.getConfigConstant(SVN_REPO_URL), (Object)buildConfiguration.getString(SvnRepository.getConfigConstant(SVN_REPO_URL), "").trim());
        String repositoryKey = buildConfiguration.getString("selectedRepository");
        String authType = buildConfiguration.getString(SvnRepository.getConfigConstant(SVN_AUTH_TYPE));
        if (AuthenticationType.PASSWORD.getKey().equals(authType)) {
            boolean svnPasswordChanged = buildConfiguration.getBoolean(this.getTemporaryConstant(TEMPORARY_SVN_PASSWORD_CHANGE));
            if (svnPasswordChanged) {
                String newPassword = buildConfiguration.getString(this.getTemporaryConstant(TEMPORARY_SVN_PASSWORD));
                if (this.getKey().equals(repositoryKey)) {
                    buildConfiguration.setProperty(SvnRepository.getConfigConstant(SVN_PASSWORD), (Object)newPassword);
                }
            }
        } else if (AuthenticationType.SSH.getKey().equals(authType)) {
            boolean passphraseChanged = buildConfiguration.getBoolean(this.getTemporaryConstant(TEMPORARY_SVN_PASSPHRASE_CHANGE));
            if (passphraseChanged) {
                String newPassphrase = buildConfiguration.getString(this.getTemporaryConstant("passphrase"));
                buildConfiguration.setProperty(SvnRepository.getConfigConstant("passphrase"), (Object)newPassphrase);
            }
        } else if (AuthenticationType.SSL_CLIENT_CERTIFICATE.getKey().equals(authType) && buildConfiguration.getBoolean(this.getTemporaryConstant(TEMPORARY_SVN_SSL_PASSPHRASE_CHANGE))) {
            String newPassphrase = buildConfiguration.getString(this.getTemporaryConstant("sslPassphrase"));
            buildConfiguration.setProperty(SvnRepository.getConfigConstant("sslPassphrase"), (Object)newPassphrase);
        }
    }

    private long checkout(SVNURL url, SVNRevision revision, File dstPath, boolean isRecursive, ISVNEventHandler eventHandler) throws RepositoryException {
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager();
            SVNUpdateClient updateClient = clientManager.getUpdateClient();
            updateClient.setEventHandler(eventHandler);
            updateClient.setIgnoreExternals(false);
            SVNDepth depth = isRecursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES;
            SvnCheckout checkout = updateClient.getOperationsFactory().createCheckout();
            checkout.setUpdateLocksOnDemand(updateClient.isUpdateLocksOnDemand());
            checkout.setSource(SvnTarget.fromURL((SVNURL)url, (SVNRevision)revision));
            checkout.setSingleTarget(SvnTarget.fromFile((File)dstPath));
            checkout.setRevision(revision);
            checkout.setDepth(depth);
            checkout.setAllowUnversionedObstructions(true);
            checkout.setIgnoreExternals(updateClient.isIgnoreExternals());
            checkout.setExternalsHandler(SvnCodec.externalsHandler((ISVNExternalsHandler)updateClient.getExternalsHandler()));
            SvnWcFormat svnWcFormat = this.getWorkingCopyFormatFromConfiguration();
            checkout.setTargetWorkingCopyFormat(svnWcFormat.getWcFormatVersion());
            long l = (Long)checkout.run();
            return l;
        }
        catch (SVNException e) {
            throw new RepositoryException("Failed to checkout source code to revision '" + revision + "' for " + url, (Throwable)e);
        }
        finally {
            this.dispose(clientManager);
        }
    }

    private long checkout(SVNURL url, SVNRevision revision, File dstPath, boolean isRecursive, BuildLogger buildLogger) throws RepositoryException {
        return this.checkout(url, revision, dstPath, isRecursive, new BuildLoggerUpdateEventHandler(buildLogger));
    }

    public long checkout(SVNURL url, SVNRevision revision, File dstPath, boolean isRecursive) throws RepositoryException {
        return this.checkout(url, revision, dstPath, isRecursive, new UpdateEventHandler());
    }

    private long export(SVNURL url, SVNRevision revision, File dstPath, boolean isRecursive, ISVNEventHandler eventHandler) throws RepositoryException {
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager();
            SVNUpdateClient updateClient = clientManager.getUpdateClient();
            updateClient.setEventHandler(eventHandler);
            updateClient.setIgnoreExternals(false);
            SVNDepth depth = isRecursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES;
            boolean allowUnversionedObstructions = true;
            long l = updateClient.doExport(url, dstPath, revision, revision, System.getProperty("line.separator"), allowUnversionedObstructions, depth);
            return l;
        }
        catch (SVNException e) {
            throw new RepositoryException("Failed to checkout source code to revision '" + revision + "' for " + url, (Throwable)e);
        }
        finally {
            this.dispose(clientManager);
        }
    }

    private long export(SVNURL url, SVNRevision revision, File dstPath, boolean isRecursive, BuildLogger buildLogger) throws RepositoryException {
        return this.export(url, revision, dstPath, isRecursive, new BuildLoggerUpdateEventHandler(buildLogger));
    }

    public long export(SVNURL url, SVNRevision revision, File dstPath, boolean isRecursive) throws RepositoryException {
        return this.export(url, revision, dstPath, isRecursive, new UpdateEventHandler());
    }

    @NotNull
    public SvnRepositoryMavenPomAccessor getMavenPomAccessor() {
        return new SvnRepositoryMavenPomAccessor(this);
    }

    @NotNull
    public SVNInfo info(SVNURL url, SVNRevision revision) throws RepositoryException {
        SVNClientManager clientManager = this.getSvnClientManager();
        try {
            SVNInfo sVNInfo = this.doInfo(clientManager, url, revision);
            return sVNInfo;
        }
        catch (SVNException e) {
            throw new RepositoryException("Failed to fetch info for " + url + " on revision '" + revision + "'", (Throwable)e);
        }
        finally {
            this.dispose(clientManager);
        }
    }

    @NotNull
    private SVNInfo doInfo(SVNClientManager clientManager, SVNURL url, SVNRevision revision) throws SVNException {
        Callable<SVNInfo> doInfo = () -> {
            SVNWCClient wcClient = clientManager.getWCClient();
            return wcClient.doInfo(url, revision, revision);
        };
        SVNURL repositoryRootUrl = (SVNURL)repositoryRootUrls.getIfPresent((Object)url);
        try {
            SVNInfo svnInfo;
            SVNInfo sVNInfo = svnInfo = revision == SVNRevision.HEAD && repositoryRootUrl != null ? GET_INFO_CACHE.call(doInfo, repositoryRootUrl, this.username, this.getSubstitutedKeyFile()) : doInfo.call();
            if (repositoryRootUrl == null) {
                repositoryRootUrls.put((Object)url, (Object)svnInfo.getRepositoryRootURL());
            }
            return svnInfo;
        }
        catch (Exception e) {
            throw BambooObjectUtils.rethrowAnyCauseThatIsInstanceOf((Throwable)e, SVNException.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long update(File wcPath, SVNRevision updateToRevision, boolean isRecursive, BuildLogger buildLogger) throws SVNException {
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager();
            SVNUpdateClient updateClient = clientManager.getUpdateClient();
            updateClient.setEventHandler((ISVNEventHandler)new BuildLoggerUpdateEventHandler(buildLogger));
            updateClient.setIgnoreExternals(false);
            SVNDepth depth = isRecursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES;
            boolean allowUnversionedObstructions = true;
            boolean depthIsSticky = true;
            long l = updateClient.doUpdate(wcPath, updateToRevision, depth, allowUnversionedObstructions, depthIsSticky);
            return l;
        }
        finally {
            this.dispose(clientManager);
        }
    }

    @Override
    public void addDefaultValues(@NotNull BuildConfiguration buildConfiguration) {
        super.addDefaultValues(buildConfiguration);
        buildConfiguration.setProperty(SvnRepository.getConfigConstant(BRANCH_AUTODETECT_ROOT), (Object)true);
        buildConfiguration.setProperty(SvnRepository.getConfigConstant(TAG_AUTODETECT_ROOT), (Object)true);
    }

    @Override
    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        this.setCommitIsolationEnabled(config.getBoolean("commit.isolation.option", false));
        this.setRepositoryUrl(config.getString(SvnRepository.getConfigConstant(SVN_REPO_URL)));
        this.setUsername(config.getString(SvnRepository.getConfigConstant(SVN_USERNAME)));
        this.setAuthType(config.getString(SvnRepository.getConfigConstant(SVN_AUTH_TYPE)));
        if (AuthenticationType.PASSWORD.getKey().equals(this.authType)) {
            this.setEncryptedPassword(config.getString(SvnRepository.getConfigConstant(SVN_PASSWORD)));
        } else if (AuthenticationType.SSH.getKey().equals(this.authType)) {
            this.setKeyFile(config.getString(SvnRepository.getConfigConstant(SVN_KEYFILE)));
            this.setEncryptedPassphrase(config.getString(SvnRepository.getConfigConstant("passphrase")));
        } else if (AuthenticationType.SSL_CLIENT_CERTIFICATE.getKey().equals(this.authType)) {
            this.setKeyFile(config.getString(SvnRepository.getConfigConstant(SVN_SSL_KEYFILE)));
            this.setEncryptedPassphrase(config.getString(SvnRepository.getConfigConstant("sslPassphrase")));
        }
        this.setUseExternals(config.getBoolean(SvnRepository.getConfigConstant(USE_EXTERNALS), false));
        this.setUseExport(config.getBoolean(SvnRepository.getConfigConstant(USE_EXPORT), false));
        this.autodetectBranchRoot = config.getBoolean(SvnRepository.getConfigConstant(BRANCH_AUTODETECT_ROOT), false);
        this.manualBranchRoot = config.getString(SvnRepository.getConfigConstant(BRANCH_MANUAL_ROOT), this.getRepositoryUrl());
        this.autodetectTagRoot = config.getBoolean(SvnRepository.getConfigConstant(TAG_AUTODETECT_ROOT), false);
        this.manualTagRoot = config.getString(SvnRepository.getConfigConstant(TAG_MANUAL_ROOT), this.getRepositoryUrl());
    }

    @Override
    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.setProperty("commit.isolation.option", (Object)this.isCommitIsolationEnabled());
        configuration.setProperty(SvnRepository.getConfigConstant(SVN_REPO_URL), (Object)this.getRepositoryUrl());
        configuration.setProperty(SvnRepository.getConfigConstant(SVN_USERNAME), (Object)this.getUsername());
        configuration.setProperty(SvnRepository.getConfigConstant(SVN_AUTH_TYPE), (Object)this.getAuthType());
        if (AuthenticationType.PASSWORD.getKey().equals(this.authType)) {
            configuration.setProperty(SvnRepository.getConfigConstant(SVN_PASSWORD), (Object)this.getEncryptedPassword());
        } else if (AuthenticationType.SSH.getKey().equals(this.authType)) {
            configuration.setProperty(SvnRepository.getConfigConstant(SVN_KEYFILE), (Object)this.getKeyFile());
            configuration.setProperty(SvnRepository.getConfigConstant("passphrase"), (Object)this.getEncryptedPassphrase());
        } else if (AuthenticationType.SSL_CLIENT_CERTIFICATE.getKey().equals(this.authType)) {
            configuration.setProperty(SvnRepository.getConfigConstant(SVN_SSL_KEYFILE), (Object)this.getKeyFile());
            configuration.setProperty(SvnRepository.getConfigConstant("sslPassphrase"), (Object)this.getEncryptedPassphrase());
        }
        configuration.setProperty(SvnRepository.getConfigConstant(USE_EXTERNALS), (Object)this.isUseExternals());
        configuration.setProperty(SvnRepository.getConfigConstant(USE_EXPORT), (Object)this.isUseExport());
        configuration.setProperty(SvnRepository.getConfigConstant(BRANCH_AUTODETECT_ROOT), (Object)this.autodetectBranchRoot);
        configuration.setProperty(SvnRepository.getConfigConstant(BRANCH_MANUAL_ROOT), (Object)this.manualBranchRoot);
        configuration.setProperty(SvnRepository.getConfigConstant(TAG_AUTODETECT_ROOT), (Object)this.autodetectTagRoot);
        configuration.setProperty(SvnRepository.getConfigConstant(TAG_MANUAL_ROOT), (Object)this.manualTagRoot);
        return configuration;
    }

    public void onInitialBuild(BuildContext buildContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExternalsRevisionMapping(SVNURL repositoryRootUrl, @NotNull Map<String, Long> externalPathRevisionMappings) {
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager();
            log.info((Object)"Initialising externals... ");
            Map<String, SVNExternal> externals = this.getExternals(repositoryRootUrl);
            for (Map.Entry<String, SVNExternal> stringSVNExternalEntry : externals.entrySet()) {
                SVNExternal external = stringSVNExternalEntry.getValue();
                SVNURL svnUrl = external.getResolvedURL();
                SVNRepository repository = clientManager.createRepository(svnUrl, true);
                long latestRevisionOnServer = repository.getLatestRevision();
                log.info((Object)("Setting externals path '" + stringSVNExternalEntry.getKey() + "' with SVN URL '" + svnUrl + "' to revision '" + latestRevisionOnServer + "'"));
                externalPathRevisionMappings.put(stringSVNExternalEntry.getKey(), latestRevisionOnServer);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to initialise externals.", (Throwable)e);
        }
        finally {
            this.dispose(clientManager);
        }
    }

    void dispose(@Nullable SVNClientManager clientManager) {
        this.svnClientManagerFactory.dispose(clientManager);
    }

    @Override
    public boolean isAdvancedOptionEnabled(@NotNull BuildConfiguration buildConfiguration) {
        return buildConfiguration.getBoolean(SvnRepository.getConfigConstant(USE_EXTERNALS), false) || buildConfiguration.getBoolean(SvnRepository.getConfigConstant(USE_EXPORT), false) || buildConfiguration.getBoolean("commit.isolation.option", false);
    }

    @NotNull
    public String getName() {
        return NAME;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    public String getEncryptedPassphrase() {
        return this.passphrase;
    }

    public void setEncryptedPassphrase(String encryptedPassphrase) {
        this.passphrase = encryptedPassphrase;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public String getSubstitutedKeyFile() {
        return this.customVariableContext.substituteString(this.keyFile);
    }

    public void setKeyFile(String myKeyFile) {
        this.keyFile = myKeyFile;
    }

    public String getAuthType() {
        if (this.authType == null) {
            this.authType = AuthenticationType.PASSWORD.getKey();
        }
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public String getUrl() {
        return "http://subversion.apache.org/";
    }

    public void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = StringUtils.trim((String)repositoryUrl);
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getSubstitutedRepositoryUrl() {
        return this.customVariableContext.substituteString(this.repositoryUrl);
    }

    public void setUsername(String username) {
        this.username = StringUtils.trim((String)username);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUserPassword(String password) {
        this.password = password;
    }

    public String getUserPassword() {
        return this.password;
    }

    public String getEncryptedPassword() {
        return this.password;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.password = encryptedPassword;
    }

    protected SVNURL getSubstitutedSvnUrl() throws SVNException {
        return SVNURL.parseURIEncoded((String)this.getSubstitutedRepositoryUrl());
    }

    public String getHost() {
        return this.getHost(null);
    }

    public String getHost(BuildContext buildContext) {
        if (this.repositoryUrl == null) {
            return "unknown-host";
        }
        try {
            SVNURL svnurl = this.getSubstitutedSvnUrl();
            return svnurl.getHost();
        }
        catch (SVNException e) {
            return "unknown-host";
        }
    }

    @Override
    @NotNull
    public String getLocationIdentifier() {
        return this.repositoryUrl;
    }

    public boolean isUseExternals() {
        return this.useExternals;
    }

    public void setUseExternals(boolean useExternals) {
        this.useExternals = useExternals;
    }

    public boolean isUseExport() {
        return this.useExport;
    }

    public void setUseExport(boolean useExport) {
        this.useExport = useExport;
    }

    public boolean isCleanCheckoutRequired() {
        return this.detectedDirtyCheckoutDirectory || this.useExport;
    }

    public void setSvnClientManagerFactory(SVNClientManagerFactory svnClientManagerFactory) {
        this.svnClientManagerFactory = svnClientManagerFactory;
    }

    public int hashCode() {
        return new HashCodeBuilder(101, 11).append((Object)this.getKey()).append((Object)this.getRepositoryUrl()).append((Object)this.getUsername()).append((Object)this.getEncryptedPassword()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SvnRepository)) {
            return false;
        }
        SvnRepository rhs = (SvnRepository)o;
        return new EqualsBuilder().append((Object)this.getRepositoryUrl(), (Object)rhs.getRepositoryUrl()).append((Object)this.getUsername(), (Object)rhs.getUsername()).append((Object)this.getEncryptedPassword(), (Object)rhs.getEncryptedPassword()).isEquals();
    }

    public int compareTo(Object obj) {
        SvnRepository o = (SvnRepository)obj;
        return new CompareToBuilder().append((Object)this.getRepositoryUrl(), (Object)o.getRepositoryUrl()).append((Object)this.getUsername(), (Object)o.getUsername()).append((Object)this.getEncryptedPassword(), (Object)o.getEncryptedPassword()).toComparison();
    }

    @NotNull
    public List<NameValuePair> getAuthenticationTypes() {
        return Stream.of(AuthenticationType.PASSWORD, AuthenticationType.SSH, AuthenticationType.SSL_CLIENT_CERTIFICATE).map(AuthenticationType::getNameValue).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean isCommitIsolationEnabled() {
        return this.commitIsolationEnabled;
    }

    public void setCommitIsolationEnabled(boolean commitIsolationEnabled) {
        this.commitIsolationEnabled = commitIsolationEnabled;
    }

    public boolean isAutodetectBranchRootUrl() {
        return this.autodetectBranchRoot;
    }

    public void setAutodetectBranchRoot(boolean autodetectBranchRoot) {
        this.autodetectBranchRoot = autodetectBranchRoot;
    }

    public boolean isAutodetectTagRootUrl() {
        return this.autodetectTagRoot;
    }

    public String getManualBranchRootUrl() {
        return this.manualBranchRoot;
    }

    public void setManualBranchRootUrl(String branchRoot) {
        this.manualBranchRoot = branchRoot;
    }

    public String getManualTagRootUrl() {
        return this.manualTagRoot;
    }

    public void setTrustedKeyHelper(TrustedKeyHelper trustedKeyHelper) {
        this.trustedKeyHelper = trustedKeyHelper;
    }

    @Override
    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    @NotNull
    public List<BuildRepositoryChanges> isolateCommits(@NotNull BuildRepositoryChanges buildChanges) {
        List commits = buildChanges.getChanges();
        if (commits.size() > 1) {
            ArrayList<BuildRepositoryChanges> isolatedChanges = new ArrayList<BuildRepositoryChanges>();
            for (CommitContext commit : commits) {
                BuildRepositoryChangesImpl change = new BuildRepositoryChangesImpl(buildChanges.getRepositoryId(), commit.guessChangeSetId(), Collections.singletonList(commit));
                isolatedChanges.add(change);
            }
            return isolatedChanges;
        }
        return Lists.newArrayList((Object[])new BuildRepositoryChanges[]{buildChanges});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyRepository(long repositoryId, @NotNull SVNURL baseUrl, @NotNull String copyName, @NotNull BuildContext buildContext) throws SVNException {
        SVNClientManager clientManager = null;
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)buildContext.getPlanResultKey());
        try {
            clientManager = this.getSvnClientManager();
            SVNCopyClient copyClient = clientManager.getCopyClient();
            copyClient.setIgnoreExternals(false);
            SVNURL srcURL = this.getSubstitutedSvnUrl();
            SVNURL destUrl = baseUrl.appendPath(copyName, false);
            SVNRevision revision = SVNRevision.create((long)Integer.parseInt(buildContext.getBuildChanges().getVcsRevisionKey(repositoryId)));
            SVNCopySource svnCopySource = new SVNCopySource(revision, revision, srcURL);
            buildLogger.addBuildLogEntry("Copying repository " + srcURL + " to " + destUrl + " at revision " + revision);
            copyClient.doCopy(new SVNCopySource[]{svnCopySource}, destUrl, false, false, true, "", null);
        }
        finally {
            this.dispose(clientManager);
        }
    }

    public void createBranch(long repositoryId, @NotNull String branchName, @NotNull BuildContext buildContext) throws RepositoryException {
        try {
            SvnRepositoryPathHelper pathHelper = new SvnRepositoryPathHelper(this);
            SVNURL destUrl = this.getBranchRootUrl();
            if (!pathHelper.checkPathExists(destUrl)) {
                throw new RepositoryException("Path " + destUrl + " does not exist. Please check configuration of SVN repository in this job.");
            }
            this.copyRepository(repositoryId, destUrl, branchName, buildContext);
        }
        catch (SVNException e) {
            throw new RepositoryException("Error while creating branch", (Throwable)e);
        }
    }

    public void createTag(long repositoryId, @NotNull String tagName, @NotNull BuildContext buildContext) throws RepositoryException {
        try {
            SVNURL destUrl;
            SvnRepositoryPathHelper pathHelper = new SvnRepositoryPathHelper(this);
            SVNURL sVNURL = destUrl = this.autodetectTagRoot ? pathHelper.getTagsRootUrl() : SVNURL.parseURIEncoded((String)this.customVariableContext.substituteString(this.manualTagRoot));
            if (!pathHelper.checkPathExists(destUrl)) {
                throw new RepositoryException("Path " + destUrl + " does not exist. Please check configuration of SVN repository in this job.");
            }
            this.copyRepository(repositoryId, destUrl, tagName, buildContext);
        }
        catch (SVNException e) {
            throw new RepositoryException("Error while creating tag", (Throwable)e);
        }
    }

    @NotNull
    public Map<String, String> getCustomVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(SvnRepository.getConfigConstant(SVN_REPO_URL), this.getSubstitutedRepositoryUrl());
        if (!StringUtils.isBlank((CharSequence)this.username)) {
            variables.put(SvnRepository.getConfigConstant(SVN_USERNAME), this.username);
        }
        return variables;
    }

    @NotNull
    public Map<String, String> getPlanRepositoryVariables() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(SVN_REPO_URL, this.getSubstitutedRepositoryUrl());
        if (!StringUtils.isBlank((CharSequence)this.username)) {
            variables.put(SvnRepository.getConfigConstant(SVN_USERNAME), this.username);
        }
        return variables;
    }

    public SVNURL getBranchRootUrl() throws SVNException {
        SvnRepositoryPathHelper pathHelper = new SvnRepositoryPathHelper(this);
        return this.autodetectBranchRoot ? pathHelper.getBranchesRootUrl() : SVNURL.parseURIEncoded((String)this.customVariableContext.substituteString(this.manualBranchRoot));
    }

    @NotNull
    public List<VcsBranch> getOpenBranches(@Nullable String context) throws RepositoryException {
        try {
            SVNURL branchesRoot = StringUtils.isBlank((CharSequence)context) ? this.getBranchRootUrl() : SVNURL.parseURIEncoded((String)this.customVariableContext.substituteString(context));
            return this.getOpenBranches(branchesRoot);
        }
        catch (SVNException e) {
            throw new RepositoryException("Error while getting open branches", (Throwable)e);
        }
    }

    @NotNull
    private List<VcsBranch> getOpenBranches(SVNURL branchesUrl) throws RepositoryException {
        SVNClientManager clientManager = null;
        try {
            SvnRepositoryPathHelper pathHelper = new SvnRepositoryPathHelper(this);
            if (!pathHelper.checkPathExists(branchesUrl)) {
                throw new RepositoryException("Path " + branchesUrl + " does not exist. Please check configuration of SVN repository in this job.");
            }
            clientManager = this.getSvnClientManager();
            SVNLogClient logClient = clientManager.getLogClient();
            final ArrayList<VcsBranch> branches = new ArrayList<VcsBranch>();
            logClient.doList(branchesUrl, SVNRevision.HEAD, SVNRevision.HEAD, false, SVNDepth.IMMEDIATES, -1, new ISVNDirEntryHandler(){

                public void handleDirEntry(SVNDirEntry entry) throws SVNException {
                    if (!entry.getRelativePath().isEmpty() && entry.getKind().equals(SVNNodeKind.DIR)) {
                        branches.add(new VcsBranchImpl(entry.getRelativePath()));
                    }
                }
            });
            ArrayList<VcsBranch> arrayList = branches;
            this.dispose(clientManager);
            return arrayList;
        }
        catch (SVNException e) {
            try {
                throw new RepositoryException("Error while getting open branches", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.dispose(clientManager);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommitContext getCommit(SVNRevisionRange range) throws SVNException {
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager();
            SVNLogClient logClient = clientManager.getLogClient();
            SVNURL srcURL = this.getSubstitutedSvnUrl();
            CommitExtractor commitExtractor = new CommitExtractor(this.getMaxCommitsToReturn());
            logClient.doLog(srcURL, null, null, Collections.singleton(range), true, false, false, 1L, null, (ISVNLogEntryHandler)commitExtractor);
            CommitContext commitContext = (CommitContext)Iterables.getOnlyElement(commitExtractor.getCommits());
            return commitContext;
        }
        finally {
            this.dispose(clientManager);
        }
    }

    public CommitContext getLastCommit() throws RepositoryException {
        try {
            return this.getCommit(new SVNRevisionRange(SVNRevision.HEAD, SVNRevision.create((long)0L)));
        }
        catch (SVNException e) {
            throw new RepositoryException("Error while getting last commit on branch " + this.repositoryUrl + ".", (Throwable)e);
        }
    }

    public CommitContext getFirstCommit() throws RepositoryException {
        try {
            return this.getCommit(new SVNRevisionRange(SVNRevision.create((long)0L), SVNRevision.HEAD));
        }
        catch (SVNException e) {
            throw new RepositoryException("Error while getting first commit on branch " + this.repositoryUrl + ".", (Throwable)e);
        }
    }

    @NotNull
    public VcsBranch getVcsBranch() {
        return new VcsBranchImpl(this.getRepositoryUrl().substring(this.getRepositoryUrl().lastIndexOf("/") + 1));
    }

    public void setVcsBranch(@NotNull VcsBranch branch) {
        try {
            this.setRepositoryUrl(this.getBranchRootUrl() + "/" + branch.getName());
        }
        catch (SVNException e) {
            log.error((Object)"Failed to setVcsBranch", (Throwable)e);
        }
    }

    public void setVcsBranch(@NotNull VcsBranch branch, @NotNull HierarchicalConfiguration customConfiguration) {
        boolean isBranchesRootOverridden = customConfiguration.getBoolean(BRANCHES_DETECTION_BRANCHES_ROOT_OVERRIDDEN, false);
        if (isBranchesRootOverridden) {
            String branchesRoot = customConfiguration.getString(BRANCHES_DETECTION_BRANCHES_ROOT);
            this.setRepositoryUrl(branchesRoot + (branchesRoot.endsWith("/") ? "" : "/") + branch.getName());
        } else {
            this.setVcsBranch(branch);
        }
    }

    public CacheId getCacheId(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        switch (cachableOperation) {
            case BRANCH_DETECTION: {
                try {
                    String branchesRoot = this.getBranchRootUrl().toString();
                    if (StringUtils.isBlank((CharSequence)this.authType) || this.authType.equals(AuthenticationType.PASSWORD.getKey())) {
                        return CacheId.forContext((CacheId)new CacheId((Repository)this, new String[]{this.getUsername()}), (String)branchesRoot);
                    }
                    if (this.authType.equals(AuthenticationType.SSH.getKey())) {
                        return CacheId.forContext((CacheId)new CacheId((Repository)this, new String[]{this.getUsername(), this.getSubstitutedKeyFile(), this.getPassphrase()}), (String)branchesRoot);
                    }
                    if (this.authType.equals(AuthenticationType.SSL_CLIENT_CERTIFICATE.getKey())) {
                        return CacheId.forContext((CacheId)new CacheId((Repository)this, new String[]{"SSL_CLIENT_CERTIFICATE", this.getSubstitutedKeyFile(), this.getPassphrase()}), (String)branchesRoot);
                    }
                    throw new IllegalArgumentException("Unexpected authorization type [" + this.authType + "]");
                }
                catch (SVNException e) {
                    log.warn((Object)"Unable to determine branchRootUrl", (Throwable)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ErrorCollection testConnection(long timeout, @NotNull TimeUnit unit) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        SVNClientManager clientManager = null;
        try {
            boolean isNoAuth = StringUtils.isBlank((CharSequence)this.authType);
            boolean isPasswordAuth = !isNoAuth && AuthenticationType.PASSWORD.getKey().equals(this.authType);
            boolean isSshAuth = !isNoAuth && AuthenticationType.SSH.getKey().equals(this.authType);
            boolean isSslClientCertificateAuth = !isNoAuth && AuthenticationType.SSL_CLIENT_CERTIFICATE.getKey().equals(this.authType);
            Preconditions.checkState((isNoAuth || isPasswordAuth || isSshAuth || isSslClientCertificateAuth ? 1 : 0) != 0, (Object)"Unknown authorization method");
            if (isSshAuth) {
                String substitutedKeyFile = this.getSubstitutedKeyFile();
                clientManager = this.svnClientManagerFactory.getSVNClientManager(DEFAULT_SVN_OPTIONS, this.getSshAuthManager(this.username, substitutedKeyFile, this.passphrase));
            } else if (isSslClientCertificateAuth) {
                String substitutedKeyFile = this.getSubstitutedKeyFile();
                clientManager = this.svnClientManagerFactory.getSVNClientManager(DEFAULT_SVN_OPTIONS, this.getSslAuthManager(substitutedKeyFile, this.passphrase));
            } else {
                clientManager = this.svnClientManagerFactory.getSVNClientManager(DEFAULT_SVN_OPTIONS, this.getStandardAuthManager(this.username, this.password));
            }
            clientManager.createRepository(this.getSubstitutedSvnUrl(), true).testConnection();
            this.dispose(clientManager);
        }
        catch (SVNException e) {
            TrustedKey serverPublicKey = this.extractTrustedKey(e);
            if (serverPublicKey != null && StringUtils.isNotBlank((CharSequence)serverPublicKey.getKey())) {
                errorCollection.addError(HOST_KEY, this.textProvider.getText("repository.test.connection.error.host.key", new String[]{serverPublicKey.getHost(), serverPublicKey.getKey()}));
            } else {
                errorCollection.addErrorMessage(e.getMessage());
            }
        }
        finally {
            this.dispose(clientManager);
        }
        return errorCollection;
    }

    @Nullable
    private TrustedKey extractTrustedKey(@NotNull SVNException e) {
        SVNAuthenticationException authenticationException;
        List collect = ExceptionUtils.getThrowableList((Throwable)e).stream().filter(t -> t instanceof SVNAuthenticationException).collect(Collectors.toList());
        if (!collect.isEmpty() && (authenticationException = (SVNAuthenticationException)Narrow.to(collect.get(0), SVNAuthenticationException.class)) != null && authenticationException.getErrorMessage().getRelatedObjects().length == 1) {
            return (TrustedKey)Narrow.to((Object)authenticationException.getErrorMessage().getRelatedObjects()[0], TrustedKey.class);
        }
        return null;
    }

    public boolean isCachingSupportedFor(@NotNull CachingAwareRepository.CachableOperation cachableOperation) {
        return cachableOperation == CachingAwareRepository.CachableOperation.BRANCH_DETECTION;
    }

    protected static String getRepoPrefix() {
        return SVN_REPO_PREFIX;
    }

    protected String getTemporaryPrefix() {
        return TEMPORARY_SVN_REPO_PREFIX;
    }

    public static String getConfigConstant(String s) {
        return SvnRepository.getRepoPrefix() + s;
    }

    protected String getTemporaryConstant(String s) {
        return this.getTemporaryPrefix() + s;
    }

    private SvnWcFormat getWorkingCopyFormatFromConfiguration() {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        RepositorySettings repositorySettings = administrationConfiguration.getRepositorySettings();
        String wcFormat = repositorySettings.getSubversionWorkingCopyFormat();
        SvnWcFormat svnWcFormat = SvnWcFormat.parse(wcFormat);
        if (svnWcFormat == null) {
            log.warn((Object)String.format("Unrecognized SVN WC format description specified in configuration: %s. Using defaults (%s).", wcFormat, SvnWcFormat.WC_1_8.getSvnVersion()));
            return SvnWcFormat.WC_1_8;
        }
        return svnWcFormat;
    }

    static {
        DAVRepositoryFactory.setup((IHTTPConnectionFactory)new DefaultHTTPConnectionFactory(null, SystemProperty.SVN_SPOOL_TO_FILE.getValue(true), null));
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        SVNAdminAreaFactory.setUpgradeEnabled((boolean)false);
        DEFAULT_SVN_OPTIONS = SVNWCUtil.createDefaultOptions((boolean)true);
        repositoryRootUrls = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
        GET_INFO_CACHE = CallableResultCache.buildAlwaysInvalidating((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).recordStats(), CacheAwareness.CHANGE_DETECTION);
    }
}

