/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn;

import com.atlassian.bamboo.repository.MavenPomAccessorAbstract;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.svn.SvnRepository;
import java.io.File;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnRepositoryMavenPomAccessor
extends MavenPomAccessorAbstract<SvnRepository> {
    private static final Logger log = Logger.getLogger(SvnRepositoryMavenPomAccessor.class);
    private static final String MAVEN_SCM_PROVIDER_KEY = "svn";

    public SvnRepositoryMavenPomAccessor(@NotNull SvnRepository repository) {
        super(repository);
    }

    @NotNull
    public String getMavenScmProviderKey() {
        return MAVEN_SCM_PROVIDER_KEY;
    }

    public void parseMavenScmUrl(@NotNull String mavenScmUrl) throws IllegalArgumentException {
        ((SvnRepository)this.repository).setRepositoryUrl(mavenScmUrl);
    }

    @NotNull
    public File checkoutMavenPom(@NotNull File destinationPath) throws RepositoryException {
        try {
            SVNURL svnUrl = ((SvnRepository)this.repository).getSubstitutedSvnUrl();
            SVNRevision svnRevision = SVNRevision.HEAD;
            SVNInfo svnInfo = ((SvnRepository)this.repository).info(svnUrl, svnRevision);
            if (svnInfo.getKind().equals(SVNNodeKind.FILE)) {
                ((SvnRepository)this.repository).checkout(svnUrl.removePathTail(), svnRevision, destinationPath, false);
                return new File(destinationPath, SVNPathUtil.tail((String)svnUrl.getPath()));
            }
            ((SvnRepository)this.repository).checkout(svnUrl, svnRevision, destinationPath, false);
            return new File(destinationPath, "pom.xml");
        }
        catch (SVNException e) {
            throw new RepositoryException("Error while parsing SVN url", (Throwable)e);
        }
    }
}

