/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn;

import com.atlassian.bamboo.repository.svn.SvnRepository;
import com.atlassian.bamboo.utils.Pair;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnRepositoryPathHelper {
    private static final Logger log = Logger.getLogger(SvnRepositoryPathHelper.class);
    private static final String BRANCHES = "branches";
    private static final String BRANCH = "branch";
    private static final String TAGS = "tags";
    private static final String TAG = "tag";
    private static final Set<String> matchingDirNames = Sets.newHashSet((Object[])new String[]{"branches", "branch", "tag", "tags"});
    private final SvnRepository repository;

    SvnRepositoryPathHelper(SvnRepository repository) {
        this.repository = repository;
    }

    private Pair<String, String> parseRepositoryUrl() {
        String repositoryUrl = this.repository.getSubstitutedRepositoryUrl().replace(File.separatorChar, '/');
        StringTokenizer st = new StringTokenizer(repositoryUrl, "/", true);
        StringBuilder url = new StringBuilder();
        String lastToken = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (matchingDirNames.contains(token)) {
                url.append(lastToken);
                return Pair.make((Object)url.toString(), (Object)token);
            }
            if (token.equals("/")) {
                if (!st.hasMoreTokens()) continue;
                url.append(lastToken);
                url.append('/');
                lastToken = "";
                continue;
            }
            lastToken = token;
        }
        return Pair.make((Object)url.toString(), (Object)lastToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPathExists(SVNURL url) {
        SVNClientManager clientManager = null;
        try {
            clientManager = this.repository.getSvnClientManager();
            SVNWCClient wcClient = clientManager.getWCClient();
            wcClient.doInfo(url, SVNRevision.HEAD, SVNRevision.HEAD);
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.repository.dispose(clientManager);
        }
        return true;
    }

    public SVNURL getBranchesRootUrl() throws SVNException {
        Pair<String, String> parsedUrl = this.parseRepositoryUrl();
        SVNURL branchUrl = SVNURL.parseURIEncoded((String)((String)parsedUrl.getFirst()));
        if (BRANCHES.equals(parsedUrl.getSecond()) || BRANCH.equals(parsedUrl.getSecond())) {
            return branchUrl.appendPath((String)parsedUrl.getSecond(), true);
        }
        SVNURL singularFormPath = branchUrl.appendPath(BRANCH, true);
        if (this.checkPathExists(singularFormPath)) {
            return singularFormPath;
        }
        return branchUrl.appendPath(BRANCHES, true);
    }

    public SVNURL getTagsRootUrl() throws SVNException {
        Pair<String, String> parsedUrl = this.parseRepositoryUrl();
        SVNURL branchUrl = SVNURL.parseURIEncoded((String)((String)parsedUrl.getFirst()));
        if (TAGS.equals(parsedUrl.getSecond()) || TAG.equals(parsedUrl.getSecond())) {
            return branchUrl.appendPath((String)parsedUrl.getSecond(), true);
        }
        SVNURL singularFormPath = branchUrl.appendPath(TAG, true);
        if (this.checkPathExists(singularFormPath)) {
            return singularFormPath;
        }
        return branchUrl.appendPath(TAGS, true);
    }

    public static boolean isPathNotFound(SVNErrorMessage errorMessage) {
        return errorMessage.getErrorCode() == SVNErrorCode.RA_ILLEGAL_URL && errorMessage.getMessageTemplate().equals("URL ''{0}'' non-existent in revision {1}");
    }
}

