/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public enum SvnWcFormat {
    WC_1_3("1.3", 4),
    WC_1_4("1.4", 8),
    WC_1_5("1.5", 9),
    WC_1_6("1.6", 10),
    WC_1_7("1.7", 29),
    WC_1_8("1.8", 31);

    private static Map<String, SvnWcFormat> wcFormatBySvnVersion;
    private final String svnVersion;
    private final int wcFormatVersion;

    private SvnWcFormat(String svnVersion, int wcFormatVersion) {
        this.svnVersion = svnVersion;
        this.wcFormatVersion = wcFormatVersion;
    }

    public static SvnWcFormat parse(@NotNull String svnVersion) {
        return wcFormatBySvnVersion.get(svnVersion);
    }

    public int getWcFormatVersion() {
        return this.wcFormatVersion;
    }

    public String getSvnVersion() {
        return this.svnVersion;
    }

    static {
        wcFormatBySvnVersion = new HashMap<String, SvnWcFormat>();
        for (SvnWcFormat svnWcFormat : SvnWcFormat.values()) {
            wcFormatBySvnVersion.put(svnWcFormat.svnVersion, svnWcFormat);
        }
    }
}

