/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;

public class SvnWcFormatSelector
implements ISVNAdminAreaFactorySelector {
    private static final Logger log = Logger.getLogger(SvnWcFormatSelector.class);
    private int wcFormat;

    public SvnWcFormatSelector(int wcFormat) {
        this.wcFormat = wcFormat;
    }

    public Collection getEnabledFactories(File path, Collection factories, boolean writeAccess) throws SVNException {
        if (!writeAccess) {
            return factories;
        }
        return this.getEnabledFactories(factories, this.getExistingWCVersion(path));
    }

    private Collection<SVNAdminAreaFactory> getEnabledFactories(Collection<SVNAdminAreaFactory> factories, int existingWCVersion) {
        for (SVNAdminAreaFactory factory : factories) {
            if (factory.getSupportedVersion() != existingWCVersion) continue;
            return Lists.newArrayList((Object[])new SVNAdminAreaFactory[]{factory});
        }
        return factories;
    }

    private int getExistingWCVersion(File path) {
        while (path != null) {
            if (path.isDirectory()) {
                try {
                    int existingWCVersion = SVNAdminAreaFactory.checkWC((File)path, (boolean)false);
                    if (existingWCVersion > 0) {
                        return existingWCVersion;
                    }
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
            }
            path = path.getParentFile();
        }
        return this.wcFormat;
    }
}

