/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn;

import com.atlassian.bamboo.repository.svn.ExternalsLockException;
import java.io.File;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;

public class UpdateEventHandler
implements ISVNEventHandler {
    private static final Logger log = Logger.getLogger(UpdateEventHandler.class);

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
        SVNEventAction action = event.getAction();
        String pathChangeType = " ";
        File file = event.getFile();
        if (action != null) {
            if (action.equals(SVNEventAction.UPDATE_ADD)) {
                pathChangeType = "A";
            } else if (action.equals(SVNEventAction.UPDATE_DELETE)) {
                pathChangeType = "D";
            } else if (!action.equals(SVNEventAction.UPDATE_UPDATE)) {
                if (action.equals(SVNEventAction.UPDATE_EXTERNAL)) {
                    this.log_debug("Fetching external item into '" + file.getAbsolutePath() + "'");
                    if (event.getRevision() != -1L) {
                        this.log_debug("External at revision " + event.getRevision());
                    }
                    return;
                }
                if (action.equals(SVNEventAction.UPDATE_COMPLETED)) {
                    this.log_debug("At revision " + event.getRevision());
                    return;
                }
                if (action.equals(SVNEventAction.ADD)) {
                    this.log_debug("A     " + file.getPath());
                    return;
                }
                if (action.equals(SVNEventAction.DELETE)) {
                    this.log_debug("D     " + file.getPath());
                    return;
                }
                if (action.equals(SVNEventAction.LOCKED)) {
                    this.log_debug("L     " + file.getPath());
                    return;
                }
                if (action.equals(SVNEventAction.LOCK_FAILED)) {
                    this.log_debug("failed to lock    " + file.getPath());
                    return;
                }
                if (action.equals(SVNEventAction.FAILED_EXTERNAL)) {
                    if (event.getErrorMessage().getErrorCode().isAuthentication()) {
                        this.log_warn("Authentication failure on " + file.getPath());
                        throw new SVNException(event.getErrorMessage());
                    }
                    SVNErrorMessage err = event.getErrorMessage();
                    throw new ExternalsLockException(err, file);
                }
            }
        }
        pathChangeType = this.getPathChangeType(event).orElse(pathChangeType);
        String propertiesChangeType = this.getPropertiesChangeType(event).orElse(" ");
        String lockLabel = this.getLockLabel(event).orElse(" ");
        if (SVNEventAction.SKIP.equals(action)) {
            SVNErrorMessage err = event.getErrorMessage();
            if (SVNEventAction.UPDATE_EXTERNAL.equals(event.getExpectedAction()) && err != null && SVNErrorCode.WC_LOCKED.equals((Object)err.getErrorCode())) {
                this.log_warn("Update of external at '" + file + "' failed because it is locked.");
                throw new ExternalsLockException(err, file);
            }
            if (err != null) {
                this.log_warn("Update of '" + file + "' has been skipped: " + err.getFullMessage());
            } else {
                String skipLogMsgunknownReason = SVNStatusType.CONFLICTED.equals(event.getContentsStatus()) ? "Update of '" + file + "' has been skipped due to conflict in its contents status" : (SVNStatusType.CONFLICTED.equals(event.getPropertiesStatus()) ? "Update of '" + file + "' has been skipped due to conflict in its properties status" : "Update of '" + file + "' has been skipped for an unknown reason: [" + event + "], expected action: " + event.getExpectedAction() + " lock status: " + event.getLockStatus());
                this.log_warn(skipLogMsgunknownReason);
            }
        }
        this.log_debug(pathChangeType + propertiesChangeType + lockLabel + "       " + file.getPath());
    }

    public void checkCancelled() throws SVNCancelException {
    }

    protected void log_error(@NotNull String message) {
        log.error((Object)message);
    }

    protected void log_warn(@NotNull String message) {
        log.warn((Object)message);
    }

    protected void log_debug(@NotNull String message) {
        if (log.isDebugEnabled()) {
            log.debug((Object)message);
        }
    }

    private Optional<String> getPathChangeType(SVNEvent event) {
        SVNStatusType contentsStatus = event.getContentsStatus();
        if (SVNStatusType.CHANGED.equals(contentsStatus)) {
            return Optional.of("U");
        }
        if (SVNStatusType.CONFLICTED.equals(contentsStatus)) {
            return Optional.of("C");
        }
        if (SVNStatusType.MERGED.equals(contentsStatus)) {
            return Optional.of("G");
        }
        return Optional.empty();
    }

    private Optional<String> getPropertiesChangeType(SVNEvent event) {
        SVNStatusType propertiesStatus = event.getPropertiesStatus();
        if (SVNStatusType.CHANGED.equals(propertiesStatus)) {
            return Optional.of("U");
        }
        if (SVNStatusType.CONFLICTED.equals(propertiesStatus)) {
            return Optional.of("C");
        }
        if (SVNStatusType.MERGED.equals(propertiesStatus)) {
            return Optional.of("G");
        }
        return Optional.empty();
    }

    private Optional<String> getLockLabel(SVNEvent event) {
        if (SVNStatusType.LOCK_UNLOCKED.equals(event.getLockStatus())) {
            return Optional.of("B");
        }
        return Optional.empty();
    }
}

