/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.RepositorySettings;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.repository.AuthenticationType;
import com.atlassian.bamboo.repository.svn.BambooSvnSshAuthenticationManager;
import com.atlassian.bamboo.repository.svn.CommitExtractor;
import com.atlassian.bamboo.repository.svn.SVNClientManagerFactory;
import com.atlassian.bamboo.repository.svn.SvnWcFormat;
import com.atlassian.bamboo.repository.svn.SvnWcFormatSelector;
import com.atlassian.bamboo.repository.svn.v2.SvnPathHelper;
import com.atlassian.bamboo.repository.svn.v2.SvnRepositoryAccessData;
import com.atlassian.bamboo.repository.svn.v2.configurator.SvnConfigurationConstants;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.security.TrustedKeyHelper;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.util.CacheAwareness;
import com.atlassian.bamboo.util.CallableResultCache;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNAdminAreaFactorySelector;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public abstract class AbstractSvnExecutor {
    private static final transient Cache<SVNURL, SVNURL> repositoryRootUrls = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();
    private static final transient CallableResultCache<SVNInfo> GET_INFO_CACHE = CallableResultCache.buildAlwaysInvalidating((CacheBuilder<Object, Object>)CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).recordStats(), CacheAwareness.CHANGE_DETECTION);
    @Inject
    protected CustomVariableContext customVariableContext;
    @Inject
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    @Inject
    private TrustedKeyHelper trustedKeyHelper;
    @Inject
    protected SVNClientManagerFactory svnClientManagerFactory;
    private static final Logger log = Logger.getLogger(AbstractSvnExecutor.class);
    private static final SvnWcFormat DEFAULT_SVN_WC_FORMAT = SvnWcFormat.WC_1_8;

    private SvnRepositoryAccessData getAccessData(@NotNull VcsRepositoryData vcsRepositoryData) {
        Map serverCfg = vcsRepositoryData.getVcsLocation().getConfiguration();
        String password = null;
        String keyFile = null;
        String passphrase = null;
        AuthenticationType svnAuthenticationType = null;
        String chosenAuthentication = (String)serverCfg.get(SvnConfigurationConstants.SVN_AUTH_TYPE);
        if (AuthenticationType.PASSWORD.getKey().equals(chosenAuthentication)) {
            svnAuthenticationType = AuthenticationType.PASSWORD;
            password = (String)serverCfg.get(SvnConfigurationConstants.SVN_PASSWORD);
        } else if (AuthenticationType.SSH.getKey().equals(chosenAuthentication)) {
            svnAuthenticationType = AuthenticationType.SSH;
            keyFile = (String)serverCfg.get(SvnConfigurationConstants.SVN_KEYFILE);
            passphrase = (String)serverCfg.get(SvnConfigurationConstants.SVN_PASSPHRASE);
        } else if (AuthenticationType.SSL_CLIENT_CERTIFICATE.getKey().equals(chosenAuthentication)) {
            svnAuthenticationType = AuthenticationType.SSL_CLIENT_CERTIFICATE;
            keyFile = (String)serverCfg.get(SvnConfigurationConstants.SVN_SSL_KEYFILE);
            passphrase = (String)serverCfg.get(SvnConfigurationConstants.SVN_SSL_PASSPHRASE);
        }
        HashMap branchDetectionCfg = new HashMap();
        if (vcsRepositoryData.getVcsBranchDetectionOptions() != null) {
            branchDetectionCfg.putAll(vcsRepositoryData.getVcsBranchDetectionOptions().getConfiguration());
        }
        String branchesRoot = (String)branchDetectionCfg.get(SvnConfigurationConstants.BRANCH_DETECTION_PATH);
        HashMap branchCfg = new HashMap();
        VcsBranch vcsBranch = null;
        if (vcsRepositoryData.getBranch() != null) {
            VcsBranchDefinition branch = vcsRepositoryData.getBranch();
            branchCfg.putAll(branch.getConfiguration());
            vcsBranch = branch.getVcsBranch();
        }
        String manualBranchCreationPath = (String)serverCfg.get(SvnConfigurationConstants.BRANCH_CREATE_MANUAL_PATH);
        String manualTagCreationPath = (String)serverCfg.get(SvnConfigurationConstants.TAG_CREATE_MANUAL_ROOT);
        return SvnRepositoryAccessData.builder().repositoryUrl(StringUtils.trimToEmpty((String)((String)serverCfg.get(SvnConfigurationConstants.SVN_REPO_ROOT_URL)))).branchPath(branchCfg.getOrDefault(SvnConfigurationConstants.SVN_BRANCH_PATH, "")).branch(vcsBranch).username((String)StringUtils.defaultIfEmpty((CharSequence)((CharSequence)serverCfg.get(SvnConfigurationConstants.SVN_USERNAME)), (CharSequence)"")).authenticationType(svnAuthenticationType).password(password).keyFile(keyFile).passphrase(passphrase).useExternals(Boolean.valueOf((String)serverCfg.get(SvnConfigurationConstants.USE_EXTERNALS))).useExport(Boolean.valueOf((String)serverCfg.get(SvnConfigurationConstants.USE_EXPORT))).branchDetectionPath(branchesRoot).manualBranchPath(manualBranchCreationPath).autodetectBranchPath(StringUtils.isBlank((CharSequence)manualBranchCreationPath)).manualTagPath(manualTagCreationPath).autodetectTagPath(StringUtils.isBlank((CharSequence)manualTagCreationPath)).build();
    }

    protected SvnRepositoryAccessData.Builder getSubstitutedAccessDataBuilder(@NotNull VcsRepositoryData vcsRepositoryData) {
        SvnRepositoryAccessData accessData = this.getAccessData(vcsRepositoryData);
        return SvnRepositoryAccessData.builder(accessData).repositoryUrl(this.substituteString(accessData.getRepositoryUrl())).branchPath(this.substituteString(accessData.getBranchPath())).branch(new VcsBranchImpl(this.substituteString(accessData.getBranchPath()), this.substituteString(accessData.getBranch().getName()))).username(this.substituteString(accessData.getUsername())).password(StringUtils.isNotBlank((CharSequence)accessData.getPassword()) ? accessData.getPassword() : "").keyFile(this.substituteString(accessData.getKeyFile())).passphrase(accessData.getPassphrase()).branchDetectionPath(this.substituteString(accessData.getBranchDetectionPath()));
    }

    protected SvnRepositoryAccessData getSubstitutedAccessData(@NotNull VcsRepositoryData vcsRepositoryData) {
        return this.getSubstitutedAccessDataBuilder(vcsRepositoryData).build();
    }

    protected String substituteString(@Nullable String stringWithValuesToSubstitute) {
        return this.customVariableContext.substituteString(stringWithValuesToSubstitute);
    }

    protected SVNClientManager getSvnClientManager(@NotNull SvnRepositoryAccessData substitutedAccessData) {
        ISVNAuthenticationManager authManager;
        if (substitutedAccessData.getAuthenticationType() == null) {
            authManager = this.getStandardAuthManager(substitutedAccessData.getUsername(), "");
        } else {
            switch (substitutedAccessData.getAuthenticationType()) {
                case PASSWORD: {
                    authManager = this.getStandardAuthManager(substitutedAccessData.getUsername(), substitutedAccessData.getPassword());
                    break;
                }
                case SSH: {
                    authManager = this.getSshAuthManager(substitutedAccessData.getUsername(), substitutedAccessData.getKeyFile(), substitutedAccessData.getPassphrase());
                    break;
                }
                case SSL_CLIENT_CERTIFICATE: {
                    authManager = this.getSslAuthManager(substitutedAccessData.getKeyFile(), substitutedAccessData.getPassphrase());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected authorization type [" + (Object)((Object)substitutedAccessData.getAuthenticationType()) + "]");
                }
            }
        }
        this.initializeSvnProperties();
        return this.svnClientManagerFactory.getSVNClientManager(SvnConfigurationConstants.DEFAULT_SVN_OPTIONS, authManager);
    }

    @NotNull
    protected SVNInfo doInfo(SVNClientManager clientManager, SVNURL url, SVNRevision revision, @NotNull SvnRepositoryAccessData accessData) throws SVNException {
        Callable<SVNInfo> doInfo = () -> {
            SVNWCClient wcClient = clientManager.getWCClient();
            return wcClient.doInfo(url, revision, revision);
        };
        try {
            SVNURL cachedUrl = (SVNURL)repositoryRootUrls.getIfPresent((Object)url);
            SVNInfo svnInfo = revision == SVNRevision.HEAD && cachedUrl != null ? GET_INFO_CACHE.call(doInfo, url, accessData.getUsername(), accessData.getKeyFile()) : doInfo.call();
            if (repositoryRootUrls.getIfPresent((Object)url) == null) {
                repositoryRootUrls.put((Object)url, (Object)url);
            }
            return svnInfo;
        }
        catch (Exception e) {
            throw BambooObjectUtils.rethrowAnyCauseThatIsInstanceOf((Throwable)e, SVNException.class);
        }
    }

    @NotNull
    protected CommitExtractor getCommits(@NotNull SVNClientManager clientManager, @NotNull SVNURL repositorySvnUrl, SVNRevision startRevision, SVNRevision endRevision, int maxCommitsToReturn) throws SVNException {
        SVNLogClient logClient = clientManager.getLogClient();
        CommitExtractor commitExtractor = new CommitExtractor(maxCommitsToReturn);
        logClient.doLog(repositorySvnUrl, null, endRevision, endRevision, startRevision, true, true, 0L, (ISVNLogEntryHandler)commitExtractor);
        return commitExtractor;
    }

    @NotNull
    private ISVNAuthenticationManager getStandardAuthManager(String userName, @Nullable String password) {
        return SVNWCUtil.createDefaultAuthenticationManager(null, (String)userName, (char[])(password != null ? password.toCharArray() : null), (boolean)SystemProperty.SVN_CACHE_CREDENTIALS.getValue(false));
    }

    @NotNull
    private ISVNAuthenticationManager getSshAuthManager(String userName, String privateKeyFile, @Nullable String passphrase) {
        boolean cacheCredentials = SystemProperty.SVN_CACHE_CREDENTIALS.getValue(false);
        if (this.trustedKeyHelper.isCustomAcceptedSshHostKeysEnabled() && !SystemProperty.CRYPTO_TRUST_SVN_SSH_ALL.getTypedValue()) {
            return new BambooSvnSshAuthenticationManager(null, userName, null, new File(privateKeyFile), passphrase, cacheCredentials, this.trustedKeyHelper);
        }
        return SVNWCUtil.createDefaultAuthenticationManager(null, (String)userName, null, (File)new File(privateKeyFile), (char[])(passphrase != null ? passphrase.toCharArray() : null), (boolean)cacheCredentials);
    }

    @NotNull
    private ISVNAuthenticationManager getSslAuthManager(String sslClientCert, String sslClientCertPassword) {
        File clientCertFile = sslClientCert != null ? new File(sslClientCert) : null;
        return new BasicAuthenticationManager(new SVNAuthentication[]{SVNSSLAuthentication.newInstance((File)clientCertFile, (char[])sslClientCertPassword.toCharArray(), (boolean)false, null, (boolean)false)});
    }

    private void initializeSvnProperties() {
        SvnWcFormat svnWcFormat = this.getWorkingCopyFormatFromConfiguration();
        if (svnWcFormat == SvnWcFormat.WC_1_7 || svnWcFormat == SvnWcFormat.WC_1_8) {
            System.clearProperty("svnkit.wc.17");
            SVNAdminAreaFactory.setSelector(null);
        } else {
            System.setProperty("svnkit.wc.17", "false");
            SVNAdminAreaFactory.setSelector((ISVNAdminAreaFactorySelector)new SvnWcFormatSelector(svnWcFormat.getWcFormatVersion()));
        }
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        RepositorySettings repositorySettings = administrationConfiguration.getRepositorySettings();
        if (repositorySettings.isUseNtlmAuth()) {
            System.setProperty("svnkit.http.methods", "NTLM,Negotiate,Digest,Basic");
        } else {
            System.setProperty("svnkit.http.methods", "Digest,Basic,Negotiate,NTLM");
        }
    }

    protected SvnWcFormat getWorkingCopyFormatFromConfiguration() {
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        RepositorySettings repositorySettings = administrationConfiguration.getRepositorySettings();
        String wcFormat = repositorySettings.getSubversionWorkingCopyFormat();
        return this.getWorkingCopyFormatFromConfiguration(wcFormat);
    }

    @Nullable
    protected TrustedKey extractTrustedKey(@NotNull SVNException e) {
        Optional<SVNAuthenticationException> exception = ExceptionUtils.getThrowableList((Throwable)e).stream().filter(t -> t instanceof SVNAuthenticationException).map(t -> (SVNAuthenticationException)Narrow.to((Object)t, SVNAuthenticationException.class)).findFirst();
        return exception.map(e1 -> Arrays.stream(e1.getErrorMessage().getRelatedObjects()).filter(o -> o instanceof TrustedKey).findFirst().map(k -> (TrustedKey)Narrow.to((Object)k, TrustedKey.class)).orElse(null)).orElse(null);
    }

    protected void copyRepository(SVNClientManager clientManager, @NotNull SVNURL fromUrl, @NotNull SVNRevision revision, @NotNull SVNURL toUrl, @NotNull BuildLogger buildLogger) throws SVNException {
        SVNCopyClient copyClient = clientManager.getCopyClient();
        copyClient.setIgnoreExternals(false);
        SVNCopySource svnCopySource = new SVNCopySource(revision, revision, fromUrl);
        buildLogger.addBuildLogEntry("Copying repository " + fromUrl + " to " + toUrl + " at revision " + revision);
        copyClient.doCopy(new SVNCopySource[]{svnCopySource}, toUrl, false, false, true, "", null);
    }

    protected boolean checkPathExists(SVNClientManager clientManager, SVNURL url) {
        try {
            SVNWCClient wcClient = clientManager.getWCClient();
            wcClient.doInfo(url, SVNRevision.HEAD, SVNRevision.HEAD);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected SVNURL getBranchDetectionRootUrl(SVNClientManager clientManager, SvnRepositoryAccessData accessData) throws SVNException {
        return accessData.getBranchDetectionUrl() != null ? accessData.getBranchDetectionUrl() : this.getBranchRootUrl(clientManager, accessData);
    }

    protected SVNURL getBranchRootUrl(SVNClientManager clientManager, SvnRepositoryAccessData accessData) throws SVNException {
        return accessData.getManualBranchUrl() != null ? accessData.getManualBranchUrl() : SvnPathHelper.getBranchesRootUrl(clientManager, accessData.getUrl().toString());
    }

    protected SVNURL getTagRootUrl(SVNClientManager clientManager, SvnRepositoryAccessData accessData) throws SVNException {
        return accessData.getManualTagUrl() != null ? accessData.getManualTagUrl() : SvnPathHelper.getTagsRootUrl(clientManager, accessData.getUrl().toString());
    }

    private SvnWcFormat getWorkingCopyFormatFromConfiguration(@NotNull String wcFormat) {
        SvnWcFormat svnWcFormat = SvnWcFormat.parse(wcFormat);
        if (svnWcFormat == null) {
            log.warn((Object)String.format("Unrecognized SVN WC format description specified in configuration: %s. Using defaults (%s).", wcFormat, DEFAULT_SVN_WC_FORMAT.getSvnVersion()));
            return DEFAULT_SVN_WC_FORMAT;
        }
        return svnWcFormat;
    }

    @NotNull
    protected VcsBranch svnUrltoVcsBranch(SVNURL svnurl, String repositoryUrl) {
        String modulePath;
        String entryURLString = svnurl.toString();
        if (entryURLString.startsWith(repositoryUrl)) {
            modulePath = entryURLString.substring(repositoryUrl.length());
            while (modulePath.startsWith("/")) {
                modulePath = modulePath.substring(1);
            }
        } else {
            modulePath = entryURLString;
            log.warn((Object)String.format("svn branch detected: %s, but doesn't start with root %s", entryURLString, repositoryUrl));
        }
        int afterLastSlashPosition = modulePath.lastIndexOf(47) + 1;
        String branchDisplayName = modulePath.substring(afterLastSlashPosition);
        return new VcsBranchImpl(modulePath, branchDisplayName);
    }
}

