/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.repository.InvalidRepositoryException;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.svn.SvnRepositoryPathHelper;
import com.atlassian.bamboo.repository.svn.v2.AbstractSvnExecutor;
import com.atlassian.bamboo.repository.svn.v2.SvnRepositoryAccessData;
import com.atlassian.bamboo.repository.svn.v2.configurator.SvnConfigurationConstants;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import com.atlassian.bamboo.vcs.BambooSpecsHandler;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnBambooSpecsHandler
extends AbstractSvnExecutor
implements BambooSpecsHandler {
    private static final Logger log = Logger.getLogger(SvnBambooSpecsHandler.class);
    @Inject
    private VariableSubstitutorFactory variableSubstitutorFactory;

    @NotNull
    public Optional<String> detectSpecRevision(@NotNull VcsRepositoryData repositoryData, @NotNull Object source) throws RepositoryException {
        SvnRepositoryAccessData accessData = (SvnRepositoryAccessData)this.customVariableContext.withVariableSubstitutor(this.variableSubstitutorFactory.newSubstitutorForGlobalContext(), () -> this.getSubstitutedAccessData(repositoryData));
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager(accessData);
            SVNURL repositorySvnUrl = accessData.getUrl().appendPath(BambooSpecsHandler.BAMBOO_SPECS_DIRECTORY, false);
            SVNInfo svnInfo = this.doInfo(clientManager, repositorySvnUrl, SVNRevision.HEAD, accessData);
            long latestRevisionForSubpath = svnInfo.getCommittedRevision().getNumber();
            Optional<String> optional = Optional.of(String.valueOf(latestRevisionForSubpath));
            return optional;
        }
        catch (SVNException e) {
            SVNErrorMessage errorMessage = e.getErrorMessage();
            if (SvnRepositoryPathHelper.isPathNotFound(errorMessage)) {
                log.info((Object)errorMessage);
                Optional<String> optional = Optional.empty();
                return optional;
            }
            throw new RepositoryException((Throwable)e, repositoryData.getId());
        }
        finally {
            this.svnClientManagerFactory.dispose(clientManager);
        }
    }

    public boolean isNewer(@NotNull VcsRepositoryData repositoryData, @NotNull String rev1, @NotNull String rev2) {
        try {
            return NumberUtils.stringToLong((String)rev1) > NumberUtils.stringToLong((String)rev2);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @NotNull
    public List<CommitContext> findCommitsToSpecs(@NotNull VcsRepositoryData repositoryData, @NotNull String rev1, @NotNull String rev2) throws RepositoryException {
        SvnRepositoryAccessData accessData = (SvnRepositoryAccessData)this.customVariableContext.withVariableSubstitutor(this.variableSubstitutorFactory.newSubstitutorForGlobalContext(), () -> this.getSubstitutedAccessData(repositoryData));
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager(accessData);
            Long startRevisionLong = Long.valueOf(rev1);
            Long endRevisionLong = Long.valueOf(rev2);
            SVNRevision startRevision = startRevisionLong < endRevisionLong ? SVNRevision.create((long)(startRevisionLong + 1L)) : SVNRevision.create((long)startRevisionLong);
            SVNRevision endRevision = SVNRevision.create((long)endRevisionLong);
            SVNURL bambooSpecsFolderUrl = accessData.getUrl().appendPath(BambooSpecsHandler.BAMBOO_SPECS_DIRECTORY, false);
            List<CommitContext> list = this.getCommits(clientManager, bambooSpecsFolderUrl, startRevision, endRevision, SvnConfigurationConstants.MAX_COMMITS_TO_RETURN).getCommits();
            return list;
        }
        catch (SVNException e) {
            SVNErrorMessage errorMessage = e.getErrorMessage();
            if (SvnRepositoryPathHelper.isPathNotFound(errorMessage)) {
                throw new InvalidRepositoryException(e.getMessage(), e);
            }
            throw new RepositoryException((Throwable)e, repositoryData.getId());
        }
        finally {
            this.svnClientManagerFactory.dispose(clientManager);
        }
    }

    public boolean isWebhookRequired() {
        return true;
    }
}

