/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.svn.v2.AbstractSvnExecutor;
import com.atlassian.bamboo.repository.svn.v2.SvnRepositoryAccessData;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.VcsBranchCreator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnBranchCreator
extends AbstractSvnExecutor
implements VcsBranchCreator {
    public void createBranch(@NotNull VcsRepositoryData repositoryData, @NotNull String branchName, @NotNull String vcsRevisionKey, @Nullable String checkoutLocation, @Nullable BuildLogger buildLogger) throws RepositoryException {
        SvnRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager(substitutedAccessData);
            SVNURL branchesRoot = this.getBranchRootUrl(clientManager, substitutedAccessData);
            if (!this.checkPathExists(clientManager, branchesRoot)) {
                throw new RepositoryException("Path " + branchesRoot + " does not exist. Please check configuration of SVN repository in this job.", repositoryData.getId());
            }
            SVNURL fromUrl = substitutedAccessData.getUrl();
            SVNRevision revision = SVNRevision.create((long)Integer.parseInt(vcsRevisionKey));
            SVNURL toUrl = branchesRoot.appendPath(branchName, false);
            this.copyRepository(clientManager, fromUrl, revision, toUrl, (BuildLogger)(buildLogger != null ? buildLogger : new NullBuildLogger()));
        }
        catch (SVNException e) {
            throw new RepositoryException("Error while creating branch", (Throwable)e);
        }
        finally {
            this.svnClientManagerFactory.dispose(clientManager);
        }
    }
}

