/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.svn.CommitExtractor;
import com.atlassian.bamboo.repository.svn.v2.AbstractSvnExecutor;
import com.atlassian.bamboo.repository.svn.v2.SvnRepositoryAccessData;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.IdentifyingExecutor;
import com.atlassian.bamboo.vcs.runtime.VcsBranchDetector;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;

public class SvnBranchDetector
extends AbstractSvnExecutor
implements VcsBranchDetector {
    private static final int SVN_COMMITS_LIMIT = 100;
    private static final Logger log = Logger.getLogger(SvnBranchDetector.class);

    @NotNull
    public List<VcsBranch> getOpenBranches(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        SvnRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager(substitutedAccessData);
            SVNURL branchesRoot = this.getBranchDetectionRootUrl(clientManager, substitutedAccessData);
            Set<VcsBranch> openBranches = this.getOpenBranches(clientManager, branchesRoot, substitutedAccessData.getRepositoryUrl(), substitutedAccessData.getUrl(), substitutedAccessData.getBranch(), substitutedAccessData.getBranchDetectionUrl() != null || substitutedAccessData.getManualBranchUrl() != null);
            ArrayList<VcsBranch> arrayList = new ArrayList<VcsBranch>(openBranches);
            return arrayList;
        }
        catch (SVNException e) {
            throw new RepositoryException("Error while getting open branches", (Throwable)e);
        }
        finally {
            this.svnClientManagerFactory.dispose(clientManager);
        }
    }

    @NotNull
    public CommitContext getLastCommit(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        SvnRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        String urlString = substitutedAccessData.getUrlAsString();
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager(substitutedAccessData);
            SVNURL repositorySvnUrl = substitutedAccessData.getUrl();
            urlString = repositorySvnUrl.toString();
            CommitContext commitContext = this.getCommit(clientManager, repositorySvnUrl, new SVNRevisionRange(SVNRevision.HEAD, SVNRevision.create((long)0L)));
            return commitContext;
        }
        catch (SVNException e) {
            throw new RepositoryException("Error while getting last commit on branch " + urlString + ".", (Throwable)e);
        }
        finally {
            this.svnClientManagerFactory.dispose(clientManager);
        }
    }

    @NotNull
    public CommitContext getFirstCommitApproximation(@NotNull VcsRepositoryData repositoryData) throws RepositoryException {
        SvnRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        String urlString = substitutedAccessData.getUrlAsString();
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager(substitutedAccessData);
            SVNURL repositorySvnUrl = substitutedAccessData.getUrl();
            urlString = repositorySvnUrl.toString();
            CommitContext commitContext = this.getCommit(clientManager, repositorySvnUrl, new SVNRevisionRange(SVNRevision.create((long)0L), SVNRevision.HEAD));
            return commitContext;
        }
        catch (SVNException e) {
            throw new RepositoryException("Error while getting first commit on branch " + urlString + ".", (Throwable)e);
        }
        finally {
            this.svnClientManagerFactory.dispose(clientManager);
        }
    }

    @Nullable
    public ContextualVcsId<VcsBranchDetector> getVcsIdForExecutor(@NotNull VcsRepositoryData vcsRepositoryData) {
        SvnRepositoryAccessData accessData = this.getSubstitutedAccessData(vcsRepositoryData);
        try {
            return new ContextualVcsId((IdentifyingExecutor)this, vcsRepositoryData, new String[]{accessData.getRepositoryUrl(), accessData.getUsername(), accessData.getBranchDetectionUrl() != null ? accessData.getBranchDetectionUrl().toString() : null});
        }
        catch (SVNException e) {
            return null;
        }
    }

    @NotNull
    private Set<VcsBranch> getOpenBranches(SVNClientManager clientManager, SVNURL branchesUrl, final String repositoryUrl, SVNURL svnRepositoryUrl, VcsBranch defaultBranch, boolean manuallyDefinedDetectionPath) throws RepositoryException {
        try {
            if (!this.checkPathExists(clientManager, branchesUrl)) {
                if (manuallyDefinedDetectionPath) {
                    throw new RepositoryException("Path " + branchesUrl + " does not exist. Please check configuration of SVN repository in this job.");
                }
                try {
                    clientManager.createRepository(svnRepositoryUrl, true).testConnection();
                }
                catch (SVNException e) {
                    throw new RepositoryException("Error connecting to the repository", (Throwable)e);
                }
                log.info((Object)("Path " + branchesUrl + " does not exist. Please check configuration of SVN repository. No branches found."));
                return Collections.singleton(defaultBranch);
            }
            SVNLogClient logClient = clientManager.getLogClient();
            final TreeSet<VcsBranch> branches = new TreeSet<VcsBranch>(Comparator.comparing(VcsBranch::getName));
            if (!StringUtils.isEmpty((CharSequence)defaultBranch.getName())) {
                branches.add(defaultBranch);
            }
            logClient.doList(branchesUrl, SVNRevision.HEAD, SVNRevision.HEAD, false, SVNDepth.IMMEDIATES, -1, new ISVNDirEntryHandler(){

                public void handleDirEntry(SVNDirEntry entry) {
                    SVNURL svnurl;
                    VcsBranch vcsBranch;
                    if (!entry.getRelativePath().isEmpty() && entry.getKind().equals(SVNNodeKind.DIR) && !StringUtils.isBlank((CharSequence)(vcsBranch = SvnBranchDetector.this.svnUrltoVcsBranch(svnurl = entry.getURL(), repositoryUrl)).getName())) {
                        branches.add(vcsBranch);
                    }
                }
            });
            return branches;
        }
        catch (SVNException e) {
            throw new RepositoryException("Error while getting open branches", (Throwable)e);
        }
    }

    @NotNull
    private CommitContext getCommit(SVNClientManager clientManager, SVNURL srcURL, SVNRevisionRange range) throws SVNException {
        SVNLogClient logClient = clientManager.getLogClient();
        CommitExtractor commitExtractor = new CommitExtractor(100);
        logClient.doLog(srcURL, null, null, Collections.singleton(range), true, false, false, 1L, null, (ISVNLogEntryHandler)commitExtractor);
        return (CommitContext)Iterables.getOnlyElement(commitExtractor.getCommits());
    }
}

