/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2;

import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.repository.HostKeyVerificationException;
import com.atlassian.bamboo.repository.InvalidRepositoryException;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.svn.CommitExtractor;
import com.atlassian.bamboo.repository.svn.SvnRepositoryPathHelper;
import com.atlassian.bamboo.repository.svn.v2.AbstractSvnExecutor;
import com.atlassian.bamboo.repository.svn.v2.SvnRepositoryAccessData;
import com.atlassian.bamboo.repository.svn.v2.configurator.SvnConfigurationConstants;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.BuildRepositoryChangesImpl;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.CommitsIsolatingVcsChangeDetector;
import com.atlassian.bamboo.vcs.runtime.ContextualVcsId;
import com.atlassian.bamboo.vcs.runtime.IdentifyingExecutor;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnChangeDetector
extends AbstractSvnExecutor
implements CommitsIsolatingVcsChangeDetector {
    private static final Logger log = Logger.getLogger(SvnChangeDetector.class);
    private static final SVNDepth EXTERNAL_RESOLUTION_DEPTH = SVNDepth.IMMEDIATES;

    @NotNull
    public BuildRepositoryChanges collectChangesForRevision(@NotNull PlanKey planKey, @NotNull VcsRepositoryData repositoryData, @NotNull String customRevision) throws RepositoryException {
        PlanVcsRevisionData revisionData = new PlanVcsRevisionData(customRevision, null, repositoryData.getBranch().getVcsBranch());
        return this.collectChangesBetweenRevisions(planKey, repositoryData, revisionData, SVNRevision.parse((String)customRevision));
    }

    @NotNull
    public BuildRepositoryChanges collectChangesSinceRevision(@NotNull PlanKey planKey, @NotNull VcsRepositoryData repositoryData, @NotNull PlanVcsRevisionData revisionData) throws RepositoryException {
        return this.collectChangesBetweenRevisions(planKey, repositoryData, revisionData, SVNRevision.HEAD);
    }

    private BuildRepositoryChanges collectChangesBetweenRevisions(@NotNull PlanKey planKey, @NotNull VcsRepositoryData repositoryData, @NotNull PlanVcsRevisionData revisionData, @NotNull SVNRevision targetRevision) throws RepositoryException {
        SVNClientManager clientManager = null;
        try {
            Long lastRevisionChecked = revisionData.getVcsRevisionKey() != null ? Long.valueOf(revisionData.getVcsRevisionKey()) : null;
            SvnRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
            clientManager = this.getSvnClientManager(substitutedAccessData);
            SVNURL repositorySvnUrl = substitutedAccessData.getUrl();
            ArrayList<CommitContext> commits = new ArrayList<CommitContext>();
            Pair<SVNURL, BuildRepositoryChanges> buildChangesAndTheirRoot = this.detectCommitsForUrl(clientManager, repositorySvnUrl, lastRevisionChecked, commits, planKey, targetRevision, substitutedAccessData);
            BuildRepositoryChanges buildChanges = (BuildRepositoryChanges)buildChangesAndTheirRoot.getSecond();
            String externalsData = null;
            if (substitutedAccessData.isUseExternals()) {
                HashMap<String, Long> externalPathRevisionMappings = new HashMap();
                String customXmlData = revisionData.getCustomXmlData();
                if (StringUtils.isNotEmpty((CharSequence)customXmlData)) {
                    Map stringMaps = ConfigUtils.getMapFromConfiguration((String)SvnConfigurationConstants.EXTERNAL_PATH_MAPPINGS2, (HierarchicalConfiguration)ConfigUtils.getXmlConfigFromXmlString((String)customXmlData));
                    externalPathRevisionMappings = ConfigUtils.toLongMap((Map)stringMaps);
                }
                if (externalPathRevisionMappings.isEmpty()) {
                    this.initExternalsRevisionMapping(clientManager, (SVNURL)buildChangesAndTheirRoot.getFirst(), repositorySvnUrl, externalPathRevisionMappings);
                }
                for (Map.Entry entry : this.getExternals(clientManager, (SVNURL)buildChangesAndTheirRoot.getFirst(), repositorySvnUrl).entrySet()) {
                    String path = (String)entry.getKey();
                    SVNExternal external = (SVNExternal)entry.getValue();
                    SVNURL svnUrl = external.getResolvedURL();
                    Long latestRevisionCheckedForExternal = (Long)externalPathRevisionMappings.get(path);
                    if (null != latestRevisionCheckedForExternal && external.getRevision() != SVNRevision.HEAD && (!external.isRevisionExplicit() || external.getRevision().getNumber() <= latestRevisionCheckedForExternal)) continue;
                    log.info((Object)("Checking if the latest revision on external: [" + path + "]->[" + svnUrl + "], is more recent than " + latestRevisionCheckedForExternal));
                    Pair<SVNURL, BuildRepositoryChanges> changesOfExternalItsRoot = this.detectCommitsForUrl(clientManager, svnUrl, latestRevisionCheckedForExternal, commits, planKey, SVNRevision.HEAD, substitutedAccessData);
                    externalPathRevisionMappings.put(path, Long.valueOf(((BuildRepositoryChanges)changesOfExternalItsRoot.getSecond()).getVcsRevisionKey()));
                }
                Map stringMap = ConfigUtils.toStringMap(externalPathRevisionMappings);
                XMLConfiguration xMLConfiguration = ConfigUtils.newConfiguration();
                ConfigUtils.addMapToConfiguration((String)SvnConfigurationConstants.EXTERNAL_PATH_MAPPINGS2, (Map)stringMap, (HierarchicalConfiguration)xMLConfiguration);
                externalsData = ConfigUtils.asXmlString((XMLConfiguration)xMLConfiguration);
            }
            buildChanges.setChanges(commits);
            buildChanges.setCustomXmlData(externalsData);
            BuildRepositoryChanges buildRepositoryChanges = buildChanges;
            this.svnClientManagerFactory.dispose(clientManager);
            return buildRepositoryChanges;
        }
        catch (SVNException e) {
            try {
                String message = "Build '" + planKey + "' failed to check SVN repository";
                TrustedKey serverPublicKey = this.extractTrustedKey(e);
                if (serverPublicKey != null) {
                    throw new HostKeyVerificationException(message, (Throwable)e, serverPublicKey);
                }
                throw new RepositoryException(message, (Throwable)e);
            }
            catch (Throwable throwable) {
                this.svnClientManagerFactory.dispose(clientManager);
                throw throwable;
            }
        }
    }

    @Nullable
    public ContextualVcsId getVcsIdForExecutor(@NotNull VcsRepositoryData vcsRepositoryData) {
        SvnRepositoryAccessData accessData = this.getSubstitutedAccessData(vcsRepositoryData);
        try {
            return new ContextualVcsId((IdentifyingExecutor)this, vcsRepositoryData, new String[]{accessData.getUrl().toString(), accessData.getUsername()});
        }
        catch (SVNException e) {
            return null;
        }
    }

    @NotNull
    private Pair<SVNURL, BuildRepositoryChanges> detectCommitsForUrl(@NotNull SVNClientManager clientManager, @NotNull SVNURL repositorySvnUrl, @Nullable Long lastRevisionChecked, @NotNull List<CommitContext> commits, @NotNull PlanKey planKey, @NotNull SVNRevision targetRevision, @NotNull SvnRepositoryAccessData substitutedAccessData) throws SVNException, InvalidRepositoryException {
        SVNInfo svnInfo;
        try {
            svnInfo = this.doInfo(clientManager, repositorySvnUrl, targetRevision, substitutedAccessData);
        }
        catch (SVNException e) {
            SVNErrorMessage errorMessage = e.getErrorMessage();
            if (SvnRepositoryPathHelper.isPathNotFound(errorMessage)) {
                throw new InvalidRepositoryException(e.getMessage(), e);
            }
            throw e;
        }
        SVNURL repositoryRootUrl = svnInfo.getRepositoryRootURL();
        long latestRevisionOnServer = svnInfo.getRevision().getNumber();
        if (lastRevisionChecked == null) {
            log.info((Object)("Never checked path [" + repositorySvnUrl + "] for plan " + planKey + ", setting latest revision to " + latestRevisionOnServer));
            return Pair.make((Object)repositoryRootUrl, (Object)new BuildRepositoryChangesImpl(String.valueOf(latestRevisionOnServer)));
        }
        BuildRepositoryChangesImpl buildChanges = new BuildRepositoryChangesImpl();
        buildChanges.setVcsRevisionKey(String.valueOf(latestRevisionOnServer));
        if (latestRevisionOnServer > lastRevisionChecked || lastRevisionChecked.longValue() == targetRevision.getNumber()) {
            long startRevision = lastRevisionChecked.longValue() == targetRevision.getNumber() ? lastRevisionChecked : lastRevisionChecked + 1L;
            SVNRevision endRevision = lastRevisionChecked.longValue() == targetRevision.getNumber() ? SVNRevision.create((long)lastRevisionChecked) : SVNRevision.HEAD;
            log.info((Object)("Collecting changes for '" + planKey + "' on path '" + repositorySvnUrl + "' from version " + startRevision + " to " + endRevision.getNumber()));
            CommitExtractor commitExtractor = this.getCommits(clientManager, repositorySvnUrl, SVNRevision.create((long)startRevision), endRevision, SvnConfigurationConstants.MAX_COMMITS_TO_RETURN);
            commits.addAll(commitExtractor.getCommits());
            buildChanges.setVcsRevisionKey(String.valueOf(Math.max(latestRevisionOnServer, commitExtractor.getHighestRevisionFound())));
            buildChanges.setSkippedCommitsCount(commitExtractor.getSkippedCommitsCnt());
        }
        return Pair.make((Object)repositoryRootUrl, (Object)buildChanges);
    }

    private void initExternalsRevisionMapping(@NotNull SVNClientManager clientManager, @NotNull SVNURL repositoryRootUrl, @NotNull SVNURL repositorySvnUrl, @NotNull Map<String, Long> externalPathRevisionMappings) {
        try {
            log.info((Object)"Initialising externals... ");
            Map<String, SVNExternal> externals = this.getExternals(clientManager, repositoryRootUrl, repositorySvnUrl);
            for (Map.Entry<String, SVNExternal> stringSVNExternalEntry : externals.entrySet()) {
                SVNExternal external = stringSVNExternalEntry.getValue();
                SVNURL svnUrl = external.getResolvedURL();
                SVNRepository repository = clientManager.createRepository(svnUrl, true);
                long latestRevisionOnServer = repository.getLatestRevision();
                log.info((Object)("Setting externals path '" + stringSVNExternalEntry.getKey() + "' with SVN URL '" + svnUrl + "' to revision '" + latestRevisionOnServer + "'"));
                externalPathRevisionMappings.put(stringSVNExternalEntry.getKey(), latestRevisionOnServer);
            }
        }
        catch (Exception e) {
            log.warn((Object)"Unable to initialise externals.", (Throwable)e);
        }
    }

    private Map<String, SVNExternal> getExternals(@NotNull SVNClientManager clientManager, @NotNull SVNURL repositoryRootUrl, @NotNull SVNURL repositorySvnUrl) throws SVNException {
        HashMap<String, SVNExternal> svnExternals = new HashMap<String, SVNExternal>();
        this.discoverExternals(svnExternals, clientManager, repositoryRootUrl, repositorySvnUrl, "");
        return svnExternals;
    }

    private void discoverExternals(final Map<String, SVNExternal> svnExternals, final @NotNull SVNClientManager clientManager, final SVNURL repositoryRootUrl, final SVNURL startingUrl, final @NotNull String relativePath) throws SVNException {
        SVNWCClient svnClient = clientManager.getWCClient();
        log.info((Object)("Fetching externals data from '" + startingUrl + "'. This may take some time."));
        svnClient.doGetProperty(startingUrl, "svn:externals", SVNRevision.HEAD, SVNRevision.HEAD, EXTERNAL_RESOLUTION_DEPTH, new ISVNPropertyHandler(){

            public void handleProperty(File file, SVNPropertyData svnPropertyData) {
            }

            public void handleProperty(SVNURL ownerUrl, SVNPropertyData svnPropertyData) throws SVNException {
                ArrayList externals = Lists.newArrayList(Arrays.asList(SVNExternal.parseExternals((Object)ownerUrl.getPath(), (String)svnPropertyData.getValue().getString())));
                for (SVNExternal external : externals) {
                    external.resolveURL(repositoryRootUrl, ownerUrl);
                    String wcPath = StringUtils.substring((String)ownerUrl.getPath(), (int)(startingUrl.getPath().length() + 1));
                    String cumulatedExternalPath = relativePath;
                    if (!StringUtils.isBlank((CharSequence)cumulatedExternalPath)) {
                        cumulatedExternalPath = cumulatedExternalPath + "/";
                    }
                    if (!StringUtils.isBlank((CharSequence)wcPath)) {
                        cumulatedExternalPath = cumulatedExternalPath + wcPath + "/";
                    }
                    cumulatedExternalPath = cumulatedExternalPath + external.getPath();
                    svnExternals.put(cumulatedExternalPath, external);
                    if (!EXTERNAL_RESOLUTION_DEPTH.equals((Object)SVNDepth.INFINITY)) continue;
                    SvnChangeDetector.this.discoverExternals(svnExternals, clientManager, repositoryRootUrl, external.getResolvedURL(), cumulatedExternalPath);
                }
            }

            public void handleProperty(long l, SVNPropertyData svnPropertyData) {
            }
        });
    }

    @NotNull
    public List<BuildRepositoryChanges> isolateCommits(@NotNull BuildRepositoryChanges changes, @NotNull VcsRepositoryData vcsRepositoryData) {
        List commits = changes.getChanges();
        if (commits.size() <= 1) {
            return Lists.newArrayList((Object[])new BuildRepositoryChanges[]{changes});
        }
        ArrayList<BuildRepositoryChanges> isolatedChanges = new ArrayList<BuildRepositoryChanges>();
        for (CommitContext commit : commits) {
            BuildRepositoryChangesImpl change = new BuildRepositoryChangesImpl(changes.getRepositoryId(), commit.guessChangeSetId(), Collections.singletonList(commit), changes.getActualBranch());
            isolatedChanges.add(change);
        }
        return isolatedChanges;
    }
}

