/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2;

import com.atlassian.bamboo.repository.svn.v2.AbstractSvnExecutor;
import com.atlassian.bamboo.repository.svn.v2.SvnRepositoryAccessData;
import com.atlassian.bamboo.security.TrustedKey;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.VcsConnectionTester;
import com.opensymphony.xwork2.TextProvider;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNClientManager;

public class SvnConnectionTester
extends AbstractSvnExecutor
implements VcsConnectionTester {
    @Inject
    private TextProvider textProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ErrorCollection testConnection(@NotNull VcsRepositoryData repositoryData, long timeout, @NotNull TimeUnit unit) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        SvnRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager(substitutedAccessData);
            SVNURL repositorySvnUrl = substitutedAccessData.getUrl();
            clientManager.createRepository(repositorySvnUrl, true).testConnection();
        }
        catch (SVNException e) {
            TrustedKey serverPublicKey = this.extractTrustedKey(e);
            if (serverPublicKey != null && StringUtils.isNotBlank((CharSequence)serverPublicKey.getKey())) {
                errorCollection.addError("hostkey", this.textProvider.getText("repository.test.connection.error.host.key", serverPublicKey.getHost(), serverPublicKey.getKey()));
            } else {
                errorCollection.addErrorMessage(e.getMessage());
            }
        }
        finally {
            this.svnClientManagerFactory.dispose(clientManager);
        }
        return errorCollection;
    }
}

