/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2;

import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.repository.svn.v2.SvnPathHelper;
import com.atlassian.bamboo.repository.svn.v2.configurator.SvnConfigurationConstants;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.configurator.VcsMavenPomAccessor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvnMavenPomAccessor
implements VcsMavenPomAccessor {
    @NotNull
    public String getMavenScmProviderKey() {
        return "svn";
    }

    public Map<String, String> parseMavenScmUrlToVcsLocation(@NotNull String mavenScmUrl, @Nullable VcsRepositoryData existingData) throws IllegalArgumentException {
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        if (existingData != null) {
            Map configuration = existingData.getVcsLocation().getConfiguration();
            cfgMap.putAll(configuration);
            String rootUrl = (String)cfgMap.get(SvnConfigurationConstants.SVN_REPO_ROOT_URL);
            if (!mavenScmUrl.startsWith(rootUrl)) {
                Pair<String, String> repoPathPair = SvnPathHelper.parseRepositoryUrl(mavenScmUrl);
                cfgMap.put(SvnConfigurationConstants.SVN_REPO_ROOT_URL, (String)repoPathPair.getLeft());
            }
        } else {
            Pair<String, String> repoPathPair = SvnPathHelper.parseRepositoryUrl(mavenScmUrl);
            cfgMap.put(SvnConfigurationConstants.SVN_REPO_ROOT_URL, (String)repoPathPair.getLeft());
            cfgMap.put(SvnConfigurationConstants.BRANCH_CREATE_AUTODETECT_PATH, Boolean.TRUE.toString());
            cfgMap.put(SvnConfigurationConstants.TAG_CREATE_AUTODETECT_PATH, Boolean.TRUE.toString());
            cfgMap.put(SvnConfigurationConstants.USE_EXTERNALS, Boolean.FALSE.toString());
            cfgMap.put(SvnConfigurationConstants.USE_EXPORT, Boolean.FALSE.toString());
        }
        return cfgMap;
    }

    public VcsBranch parseMavenScmUrlToVcsBranch(@NotNull String mavenScmUrl, @Nullable VcsRepositoryData existingData) throws IllegalArgumentException {
        if (existingData != null && existingData.getBranch() != null) {
            VcsBranch oldVcsBranch = existingData.getBranch().getVcsBranch();
            Map locationConfiguration = existingData.getVcsLocation().getConfiguration();
            String rootUrl = (String)locationConfiguration.get(SvnConfigurationConstants.SVN_REPO_ROOT_URL);
            if (mavenScmUrl.startsWith(rootUrl)) {
                String branchPath = mavenScmUrl.substring(rootUrl.length());
                return new VcsBranchImpl(branchPath, oldVcsBranch.getDisplayName());
            }
            Pair<String, String> repoPathPair = SvnPathHelper.parseRepositoryUrl(mavenScmUrl);
            return new VcsBranchImpl((String)repoPathPair.getRight(), oldVcsBranch.getDisplayName());
        }
        Pair<String, String> repoPathPair = SvnPathHelper.parseRepositoryUrl(mavenScmUrl);
        return new VcsBranchImpl((String)repoPathPair.getRight());
    }
}

