/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SvnPathHelper {
    private static final Logger log = Logger.getLogger(SvnPathHelper.class);
    private static final String BRANCHES = "branches";
    private static final String BRANCH = "branch";
    private static final String TAGS = "tags";
    private static final String TAG = "tag";
    private static final Set<String> matchingDirNames = Sets.newHashSet((Object[])new String[]{"branches", "branch", "tag", "tags"});

    private SvnPathHelper() {
    }

    public static SVNURL getBranchesRootUrl(SVNClientManager clientManager, String url) throws SVNException {
        Pair<String, String> parsedUrl = SvnPathHelper.parseRepositoryUrl(url);
        SVNURL branchUrl = SVNURL.parseURIEncoded((String)((String)parsedUrl.getLeft()));
        if (BRANCHES.equals(parsedUrl.getRight()) || BRANCH.equals(parsedUrl.getRight())) {
            return branchUrl.appendPath((String)parsedUrl.getRight(), true);
        }
        SVNURL singularFormPath = branchUrl.appendPath(BRANCH, true);
        if (SvnPathHelper.checkPathExists(clientManager, singularFormPath)) {
            return singularFormPath;
        }
        return branchUrl.appendPath(BRANCHES, true);
    }

    public static SVNURL getTagsRootUrl(SVNClientManager clientManager, String url) throws SVNException {
        Pair<String, String> parsedUrl = SvnPathHelper.parseRepositoryUrl(url);
        SVNURL branchUrl = SVNURL.parseURIEncoded((String)((String)parsedUrl.getLeft()));
        if (TAGS.equals(parsedUrl.getRight()) || TAG.equals(parsedUrl.getRight())) {
            return branchUrl.appendPath((String)parsedUrl.getRight(), true);
        }
        SVNURL singularFormPath = branchUrl.appendPath(TAG, true);
        if (SvnPathHelper.checkPathExists(clientManager, singularFormPath)) {
            return singularFormPath;
        }
        return branchUrl.appendPath(TAGS, true);
    }

    public static Pair<String, String> parseRepositoryUrl(String url) {
        String repositoryUrl = url.replace(File.separatorChar, '/');
        StringTokenizer st = new StringTokenizer(repositoryUrl, "/", true);
        StringBuilder parsedUrl = new StringBuilder();
        String lastToken = "";
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (matchingDirNames.contains(token)) {
                parsedUrl.append(lastToken);
                return ImmutablePair.of((Object)parsedUrl.toString(), (Object)token);
            }
            if (token.equals("/")) {
                if (!st.hasMoreTokens()) continue;
                parsedUrl.append(lastToken);
                parsedUrl.append('/');
                lastToken = "";
                continue;
            }
            lastToken = token;
        }
        return ImmutablePair.of((Object)parsedUrl.toString(), (Object)lastToken);
    }

    private static boolean checkPathExists(SVNClientManager clientManager, SVNURL url) {
        try {
            SVNWCClient wcClient = clientManager.getWCClient();
            wcClient.doInfo(url, SVNRevision.HEAD, SVNRevision.HEAD);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

