/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2;

import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.repository.AuthenticationType;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public final class SvnRepositoryAccessData
implements Serializable {
    private String repositoryUrl;
    private String branchPath;
    private VcsBranch branch;
    private String username;
    private String password;
    private String keyFile;
    private String passphrase;
    private AuthenticationType authenticationType;
    private boolean useExternals;
    private boolean useExport;
    private boolean autodetectBranchPath = true;
    private boolean autodetectTagPath = true;
    private String manualBranchPath;
    private String manualTagPath;
    private String branchDetectionPath;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(@NotNull SvnRepositoryAccessData accessData) {
        return new Builder().clone(accessData);
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getBranchPath() {
        return this.branchPath;
    }

    public VcsBranch getBranch() {
        return this.branch;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    @Nullable
    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public boolean isUseExternals() {
        return this.useExternals;
    }

    public boolean isUseExport() {
        return this.useExport;
    }

    public boolean isAutodetectBranchPath() {
        return this.autodetectBranchPath;
    }

    public boolean isAutodetectTagPath() {
        return this.autodetectTagPath;
    }

    public String getManualBranchPath() {
        return this.manualBranchPath;
    }

    public String getManualTagPath() {
        return this.manualTagPath;
    }

    public String getBranchDetectionPath() {
        return this.branchDetectionPath;
    }

    @Nullable
    public SVNURL getManualBranchUrl() throws SVNException {
        return this.isAutodetectBranchPath() ? null : this.buildFullUrl(this.getManualBranchPath());
    }

    @Nullable
    public SVNURL getManualTagUrl() throws SVNException {
        return this.isAutodetectTagPath() ? null : this.buildFullUrl(this.getManualTagPath());
    }

    @Nullable
    public SVNURL getBranchDetectionUrl() throws SVNException {
        if (this.getBranchDetectionPath() == null) {
            return null;
        }
        return this.buildFullUrl(this.getBranchDetectionPath());
    }

    public SVNURL getUrl() throws SVNException {
        return this.buildFullUrl(this.getBranchPath());
    }

    public String getUrlAsString() {
        return this.buildFullUrlString(this.getBranchPath());
    }

    private String buildFullUrlString(String path) {
        String repositoryPart = (String)StringUtils.defaultIfBlank((CharSequence)this.getRepositoryUrl(), (CharSequence)"");
        String branchPart = (String)StringUtils.defaultIfBlank((CharSequence)path, (CharSequence)"");
        String separatorPart = repositoryPart.endsWith("/") || branchPart.startsWith("/") ? "" : "/";
        return repositoryPart + separatorPart + branchPart;
    }

    private SVNURL buildFullUrl(String path) throws SVNException {
        if (StringUtils.contains((CharSequence)path, (CharSequence)"://")) {
            try {
                return SVNURL.parseURIEncoded((String)path);
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
        }
        return SVNURL.parseURIEncoded((String)this.buildFullUrlString(path));
    }

    public static final class Builder {
        private String repositoryUrl;
        private String branchPath;
        private VcsBranch branch;
        private String username;
        private String password;
        private String keyFile;
        private String passphrase;
        private AuthenticationType authenticationType;
        private boolean useExternals;
        private boolean useExport;
        private boolean autodetectBranchPath = true;
        private boolean autodetectTagPath = true;
        private String manualBranchPath;
        private String manualTagPath;
        private String branchDetectionPath;

        public Builder clone(SvnRepositoryAccessData svnRepositoryAccessData) {
            this.repositoryUrl = svnRepositoryAccessData.repositoryUrl;
            this.branchPath = svnRepositoryAccessData.branchPath;
            this.branch = svnRepositoryAccessData.branch;
            this.username = svnRepositoryAccessData.username;
            this.password = svnRepositoryAccessData.password;
            this.keyFile = svnRepositoryAccessData.keyFile;
            this.passphrase = svnRepositoryAccessData.passphrase;
            this.authenticationType = svnRepositoryAccessData.authenticationType;
            this.useExternals = svnRepositoryAccessData.useExternals;
            this.useExport = svnRepositoryAccessData.useExport;
            this.autodetectBranchPath = svnRepositoryAccessData.autodetectBranchPath;
            this.autodetectTagPath = svnRepositoryAccessData.autodetectTagPath;
            this.manualBranchPath = svnRepositoryAccessData.manualBranchPath;
            this.manualTagPath = svnRepositoryAccessData.manualTagPath;
            this.branchDetectionPath = svnRepositoryAccessData.branchDetectionPath;
            return this;
        }

        public Builder repositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            return this;
        }

        public Builder branchPath(String branchPath) {
            this.branchPath = branchPath;
            return this;
        }

        public Builder branch(VcsBranch branch) {
            this.branch = branch;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder keyFile(String keyFile) {
            this.keyFile = keyFile;
            return this;
        }

        public Builder passphrase(String passphrase) {
            this.passphrase = passphrase;
            return this;
        }

        public Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public Builder useExternals(boolean useExternals) {
            this.useExternals = useExternals;
            return this;
        }

        public Builder useExport(boolean useExport) {
            this.useExport = useExport;
            return this;
        }

        public Builder autodetectBranchPath(boolean autodetectBranchPath) {
            this.autodetectBranchPath = autodetectBranchPath;
            return this;
        }

        public Builder autodetectTagPath(boolean autodetectTagPath) {
            this.autodetectTagPath = autodetectTagPath;
            return this;
        }

        public Builder manualBranchPath(String manualBranchPath) {
            this.manualBranchPath = manualBranchPath;
            return this;
        }

        public Builder manualTagPath(String manualTagPath) {
            this.manualTagPath = manualTagPath;
            return this;
        }

        public Builder branchDetectionPath(String branchDetectionPath) {
            this.branchDetectionPath = branchDetectionPath;
            return this;
        }

        public SvnRepositoryAccessData build() {
            SvnRepositoryAccessData data = new SvnRepositoryAccessData();
            data.repositoryUrl = this.repositoryUrl;
            data.branchPath = this.branchPath;
            data.branch = this.branch;
            data.username = this.username;
            data.password = this.password;
            data.keyFile = this.keyFile;
            data.passphrase = this.passphrase;
            data.authenticationType = this.authenticationType;
            data.useExternals = this.useExternals;
            data.useExport = this.useExport;
            data.autodetectBranchPath = this.autodetectBranchPath;
            data.autodetectTagPath = this.autodetectTagPath;
            data.manualBranchPath = this.manualBranchPath;
            data.manualTagPath = this.manualTagPath;
            data.branchDetectionPath = this.branchDetectionPath;
            return data;
        }
    }
}

