/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2;

import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.repository.svn.v2.AbstractSvnExecutor;
import com.atlassian.bamboo.repository.svn.v2.SvnRepositoryAccessData;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.VcsVariableGenerator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNException;

public class SvnVariableGenerator
extends AbstractSvnExecutor
implements VcsVariableGenerator {
    private static final Logger log = Logger.getLogger(SvnVariableGenerator.class);
    private static final String URL = "url";
    private static final String ROOT_URL = "rootUrl";
    private static final String BRANCH_PATH = "branchPath";
    private static final String BRANCH_DISPLAY_NAME = "branchName";
    private static final String USERNAME = "username";
    private static final String REPOSITORY_URL = "repositoryUrl";

    @Nullable
    public String getLegacyPrefix() {
        return "repository.svn";
    }

    @NotNull
    public Map<String, String> getPlanRepositoryVariables(@NotNull VcsRepositoryData vcsRepositoryData) {
        String username;
        SvnRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(vcsRepositoryData);
        HashMap<String, String> variables = new HashMap<String, String>();
        try {
            variables.put(URL, substitutedAccessData.getUrl().toString());
            variables.put(REPOSITORY_URL, substitutedAccessData.getUrl().toString());
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        variables.put(ROOT_URL, substitutedAccessData.getRepositoryUrl());
        variables.put(BRANCH_PATH, substitutedAccessData.getBranchPath());
        VcsBranch branch = substitutedAccessData.getBranch();
        if (branch != null) {
            variables.put(BRANCH_DISPLAY_NAME, branch.getDisplayName());
        }
        if (!StringUtils.isBlank((CharSequence)(username = substitutedAccessData.getUsername()))) {
            variables.put(USERNAME, username);
        }
        return variables;
    }
}

