/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.NullBuildLogger;
import com.atlassian.bamboo.plan.vcsRevision.PlanVcsRevisionData;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.repository.svn.BuildLoggerUpdateEventHandler;
import com.atlassian.bamboo.repository.svn.ExternalsLockException;
import com.atlassian.bamboo.repository.svn.SvnWcFormat;
import com.atlassian.bamboo.repository.svn.v2.AbstractSvnExecutor;
import com.atlassian.bamboo.repository.svn.v2.SvnRepositoryAccessData;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.utils.BambooPathUtils;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.runtime.NoContextVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.StatusProvidingVcsWorkingCopyManager;
import com.atlassian.bamboo.vcs.runtime.VcsWorkingCopy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNExternalsHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc2.SvnCheckout;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnWorkingCopyManager
extends AbstractSvnExecutor
implements NoContextVcsWorkingCopyManager,
StatusProvidingVcsWorkingCopyManager {
    private static final Logger log = Logger.getLogger(SvnWorkingCopyManager.class);
    private static final List<SVNStatusType> UNMODIFIED_STATUSES = ImmutableList.of((Object)SVNStatusType.INAPPLICABLE, (Object)SVNStatusType.UNKNOWN, (Object)SVNStatusType.UNCHANGED, (Object)SVNStatusType.LOCK_INAPPLICABLE, (Object)SVNStatusType.LOCK_UNKNOWN, (Object)SVNStatusType.LOCK_UNCHANGED, (Object)SVNStatusType.STATUS_NONE, (Object)SVNStatusType.STATUS_NORMAL, (Object)SVNStatusType.STATUS_EXTERNAL);
    @Inject
    private BuildLoggerManager buildLoggerManager;

    @NotNull
    public VcsWorkingCopy getWorkingCopyInfo(@NotNull VcsRepositoryData repositoryData, @NotNull File checkoutPath) throws RepositoryException {
        SvnRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        SVNClientManager clientManager = this.getSvnClientManager(substitutedAccessData);
        try {
            SVNStatus status = clientManager.getStatusClient().doStatus(checkoutPath, false);
            if (status != null) {
                String revisionKey = String.valueOf(status.getRevision().getNumber());
                boolean isDirty = !this.isWorkingCopyClean(clientManager, checkoutPath);
                SVNURL currentUrl = status.getURL();
                return new VcsWorkingCopy(repositoryData.getId(), checkoutPath, revisionKey, isDirty, this.svnUrltoVcsBranch(currentUrl, substitutedAccessData.getRepositoryUrl()), !substitutedAccessData.getUrl().equals((Object)currentUrl));
            }
            throw new RepositoryException("Unable to retrieve working copy information", repositoryData.getId());
        }
        catch (SVNException e) {
            throw new RepositoryException("An error occurred while trying to obtain repository working copy status", (Throwable)e);
        }
    }

    private boolean isModified(SVNStatusType svnStatusType) {
        return !UNMODIFIED_STATUSES.contains(svnStatusType);
    }

    @VisibleForTesting
    boolean isWorkingCopyClean(@NotNull SVNClientManager clientManager, @NotNull File checkoutPath) throws SVNException {
        class DirtyFileFoundException
        extends RuntimeException {
            DirtyFileFoundException() {
            }
        }
        try {
            clientManager.getStatusClient().doStatus(checkoutPath, SVNRevision.HEAD, SVNDepth.INFINITY, false, false, false, false, status -> {
                if (this.isModified(status.getNodeStatus()) || this.isModified(status.getPropertiesStatus())) {
                    throw new DirtyFileFoundException();
                }
            }, null);
            return true;
        }
        catch (DirtyFileFoundException e) {
            return false;
        }
    }

    @NotNull
    public VcsWorkingCopy updateToLatestRevision(@NotNull VcsRepositoryData repositoryData, @NotNull File targetPath) throws RepositoryException {
        return this.retrieveSourceCodeInternal(repositoryData, targetPath, null, null);
    }

    @NotNull
    public VcsWorkingCopy retrieveSourceCode(@NotNull CommonContext commonContext, @NotNull VcsRepositoryData repositoryData, @NotNull PlanVcsRevisionData targetRevision, @NotNull File targetPath) throws RepositoryException {
        return this.retrieveSourceCodeInternal(repositoryData, targetPath, commonContext, targetRevision);
    }

    @NotNull
    public VcsWorkingCopy updateToLatestRevision(@NotNull CommonContext commonContext, @NotNull VcsRepositoryData repositoryData, @NotNull File targetPath) throws RepositoryException {
        return this.retrieveSourceCodeInternal(repositoryData, targetPath, commonContext, null);
    }

    @NotNull
    private VcsWorkingCopy retrieveSourceCodeInternal(@NotNull VcsRepositoryData repositoryData, @NotNull File targetPath, @Nullable CommonContext commonContext, @Nullable PlanVcsRevisionData targetRevision) throws RepositoryException {
        ResultKey resultKey = commonContext != null ? commonContext.getResultKey() : null;
        String entityKey = resultKey != null ? resultKey.getEntityKey().getKey() : null;
        String vcsRevisionKey = targetRevision != null ? targetRevision.getVcsRevisionKey() : null;
        NullBuildLogger buildLogger = resultKey != null ? this.buildLoggerManager.getLogger(resultKey) : new NullBuildLogger();
        SvnRepositoryAccessData substitutedAccessData = this.getSubstitutedAccessData(repositoryData);
        SVNClientManager clientManager = null;
        try {
            clientManager = this.getSvnClientManager(substitutedAccessData);
            this.preRetrieveSourceCode(substitutedAccessData, clientManager, buildLogger, targetPath, entityKey);
            String retrievedRevisionKey = this.retrieveSourceCodeWithCleanup(substitutedAccessData, clientManager, buildLogger, targetPath, commonContext, vcsRevisionKey);
            VcsWorkingCopy vcsWorkingCopy = new VcsWorkingCopy(repositoryData.getId(), targetPath, retrievedRevisionKey);
            return vcsWorkingCopy;
        }
        catch (SVNException e) {
            if (this.isRecoverableException(e) && clientManager != null) {
                try {
                    log.warn((Object)buildLogger.addErrorLogEntry(String.format("Subversion repository %1$s failed to update: [%2$s]. Attempting a clean checkout...", entityKey != null ? "for " + entityKey : "", e.getMessage())));
                    BambooPathUtils.cleanDirectory((Path)targetPath.toPath());
                    String retrievedRevisionKey = this.retrieveSourceCodeWithException(substitutedAccessData, clientManager, buildLogger, false, targetPath, vcsRevisionKey);
                    VcsWorkingCopy vcsWorkingCopy = new VcsWorkingCopy(repositoryData.getId(), targetPath, retrievedRevisionKey);
                    return vcsWorkingCopy;
                }
                catch (Exception e1) {
                    String exceptionMessage = "Unable to retrieve source code for revision '";
                    exceptionMessage = exceptionMessage + (vcsRevisionKey != null ? vcsRevisionKey : "latest");
                    exceptionMessage = exceptionMessage + "'";
                    exceptionMessage = exceptionMessage + (entityKey != null ? ", plan '" + entityKey + "'" : "");
                    exceptionMessage = exceptionMessage + ": " + e.getMessage();
                    throw new RepositoryException(exceptionMessage, (Throwable)e);
                }
            }
            String exceptionMessage = "Unable to retrieve source code for revision '";
            exceptionMessage = exceptionMessage + (vcsRevisionKey != null ? vcsRevisionKey : "latest");
            exceptionMessage = exceptionMessage + "'";
            exceptionMessage = exceptionMessage + (entityKey != null ? ", plan '" + entityKey + "'" : "");
            exceptionMessage = exceptionMessage + ": " + e.getMessage();
            throw new RepositoryException(exceptionMessage, (Throwable)e);
        }
        finally {
            this.svnClientManagerFactory.dispose(clientManager);
        }
    }

    private void preRetrieveSourceCode(SvnRepositoryAccessData substitutedAccessData, SVNClientManager clientManager, BuildLogger buildLogger, @NotNull File targetPath, @Nullable String entityKey) throws RepositoryException {
        boolean cleanCheckoutRequired;
        boolean detectedDirtyCheckoutDirectory;
        block10: {
            detectedDirtyCheckoutDirectory = false;
            Preconditions.checkNotNull((Object)targetPath);
            try {
                if (this.isWorkspaceEmpty(targetPath)) break block10;
                SVNWCClient wcClient = clientManager.getWCClient();
                try {
                    SVNInfo svnInfo = wcClient.doInfo(targetPath, null);
                    SVNURL localSvnRepositoryPath = svnInfo.getURL();
                    SVNURL actualUrl = substitutedAccessData.getUrl();
                    if (localSvnRepositoryPath != null && !localSvnRepositoryPath.equals((Object)actualUrl)) {
                        log.info((Object)buildLogger.addBuildLogEntry("Existing source path at '" + targetPath.getAbsolutePath() + "' is '" + localSvnRepositoryPath + "' and differs from '" + actualUrl + "'"));
                        detectedDirtyCheckoutDirectory = true;
                    }
                }
                catch (SVNException e) {
                    log.warn((Object)"Exception while obtaining svn info for the directory. Assuming that cleanup is required...", (Throwable)e);
                    detectedDirtyCheckoutDirectory = true;
                }
            }
            catch (Exception e) {
                log.warn((Object)"Exception while detecting whether source code differs. Ignoring...", (Throwable)e);
            }
        }
        boolean bl = cleanCheckoutRequired = detectedDirtyCheckoutDirectory || substitutedAccessData.isUseExport();
        if (cleanCheckoutRequired) {
            log.info((Object)buildLogger.addBuildLogEntry("Clean checkout enforced by repository configuration"));
            if (BambooFileUtils.isDirectoryImportant(targetPath)) {
                String errorMessage = String.format("A clean build cannot be forced%1$s as the plan's source directory %2$s is reserved by the system. Please amend your build configuration.", entityKey != null ? " for " + entityKey : "", targetPath.getAbsolutePath());
                log.warn((Object)buildLogger.addErrorLogEntry(errorMessage));
                throw new RepositoryException(errorMessage);
            }
            if (targetPath.exists()) {
                try {
                    BambooFileUtils.cleanDirectory(targetPath);
                }
                catch (IOException e) {
                    String errorMessage = "Unable to clean source directory '" + targetPath.getAbsolutePath() + "' " + e.getMessage();
                    log.warn((Object)buildLogger.addErrorLogEntry(errorMessage), (Throwable)e);
                    throw new RepositoryException(errorMessage, (Throwable)e);
                }
            }
        }
    }

    private String retrieveSourceCodeWithCleanup(SvnRepositoryAccessData substitutedAccessData, SVNClientManager clientManager, BuildLogger buildLogger, File sourceDirectory, @Nullable CommonContext commonContext, @Nullable String vcsRevisionKey) throws SVNException, RepositoryException {
        SVNException lastException;
        File dirtyPath;
        boolean isCleanedPathNew;
        ResultKey resultKey = commonContext != null ? commonContext.getResultKey() : null;
        Key entityKey = resultKey != null ? resultKey.getEntityKey() : null;
        int cleanupTries = 5;
        boolean skipUpdateMessage = false;
        do {
            try {
                return this.retrieveSourceCodeWithException(substitutedAccessData, clientManager, buildLogger, skipUpdateMessage, sourceDirectory, vcsRevisionKey);
            }
            catch (ExternalsLockException e) {
                if (clientManager == null) {
                    throw e;
                }
                dirtyPath = e.getAffectedLockedDirectory();
                lastException = e;
            }
            catch (SVNException e) {
                if (!this.isSvnLockException(e) || clientManager == null) {
                    throw e;
                }
                dirtyPath = sourceDirectory;
                lastException = e;
            }
            this.cleanUpWorkspace(clientManager, buildLogger, dirtyPath, entityKey);
            skipUpdateMessage = true;
            boolean bl = isCleanedPathNew = dirtyPath != null;
        } while (isCleanedPathNew && --cleanupTries > 0);
        String reason = isCleanedPathNew ? "too many directories to clean up" : "failed to clean " + dirtyPath + " in one go";
        String msg = "Failed to clean up Subversion workspace for ";
        msg = msg + (commonContext != null ? commonContext.getDisplayName() : sourceDirectory.getAbsolutePath());
        msg = msg + ", reason: " + reason;
        log.error((Object)buildLogger.addErrorLogEntry(msg));
        throw lastException;
    }

    private String retrieveSourceCodeWithException(SvnRepositoryAccessData substitutedAccessData, SVNClientManager svnClientManager, BuildLogger buildLogger, boolean skipUpdateMessage, @NotNull File sourceDirectory, @Nullable String vcsRevisionKey) throws SVNException, RepositoryException {
        SVNRevision revision;
        SVNURL repositorySvnUrl = substitutedAccessData.getUrl();
        if (vcsRevisionKey != null) {
            Long vcsRevision = Long.parseLong(vcsRevisionKey);
            revision = SVNRevision.create((long)vcsRevision);
        } else {
            long latestRevisionOnServer = svnClientManager.createRepository(repositorySvnUrl, true).getLatestRevision();
            vcsRevisionKey = String.valueOf(latestRevisionOnServer);
            revision = SVNRevision.HEAD;
        }
        if (substitutedAccessData.isUseExport()) {
            log.info((Object)buildLogger.addBuildLogEntry("Exporting SVN URL '" + repositorySvnUrl + "' to directory " + sourceDirectory.getAbsolutePath()));
            this.export(svnClientManager, repositorySvnUrl, revision, sourceDirectory, true, buildLogger);
        } else if (this.isWorkspaceEmpty(sourceDirectory)) {
            log.info((Object)buildLogger.addBuildLogEntry("Working directory '" + sourceDirectory.getAbsolutePath() + "' is empty. Checking out SVN URL '" + repositorySvnUrl + "'"));
            this.checkout(svnClientManager, repositorySvnUrl, revision, sourceDirectory, true, buildLogger);
        } else {
            if (!skipUpdateMessage) {
                log.info((Object)buildLogger.addBuildLogEntry("Existing workspace found at '" + sourceDirectory.getAbsolutePath() + "'. updating..."));
            }
            this.update(svnClientManager, sourceDirectory, revision, true, buildLogger);
        }
        return vcsRevisionKey;
    }

    private long export(SVNClientManager clientManager, SVNURL url, SVNRevision revision, File dstPath, boolean isRecursive, BuildLogger buildLogger) throws RepositoryException {
        return this.export(clientManager, url, revision, dstPath, isRecursive, new BuildLoggerUpdateEventHandler(buildLogger));
    }

    private long export(SVNClientManager clientManager, SVNURL url, SVNRevision revision, File dstPath, boolean isRecursive, ISVNEventHandler eventHandler) throws RepositoryException {
        try {
            SVNUpdateClient updateClient = clientManager.getUpdateClient();
            updateClient.setEventHandler(eventHandler);
            updateClient.setIgnoreExternals(false);
            SVNDepth depth = isRecursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES;
            boolean allowUnversionedObstructions = true;
            return updateClient.doExport(url, dstPath, revision, revision, System.getProperty("line.separator"), allowUnversionedObstructions, depth);
        }
        catch (SVNException e) {
            throw new RepositoryException("Failed to checkout source code to revision '" + revision + "' for " + url, (Throwable)e);
        }
    }

    private long checkout(SVNClientManager clientManager, SVNURL url, SVNRevision revision, File dstPath, boolean isRecursive, BuildLogger buildLogger) throws RepositoryException {
        return this.checkout(clientManager, url, revision, dstPath, isRecursive, new BuildLoggerUpdateEventHandler(buildLogger));
    }

    private long checkout(SVNClientManager clientManager, SVNURL url, SVNRevision revision, File dstPath, boolean isRecursive, ISVNEventHandler eventHandler) throws RepositoryException {
        try {
            SVNUpdateClient updateClient = clientManager.getUpdateClient();
            updateClient.setEventHandler(eventHandler);
            updateClient.setIgnoreExternals(false);
            SVNDepth depth = isRecursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES;
            SvnCheckout checkout = updateClient.getOperationsFactory().createCheckout();
            checkout.setUpdateLocksOnDemand(updateClient.isUpdateLocksOnDemand());
            checkout.setSource(SvnTarget.fromURL((SVNURL)url, (SVNRevision)revision));
            checkout.setSingleTarget(SvnTarget.fromFile((File)dstPath));
            checkout.setRevision(revision);
            checkout.setDepth(depth);
            checkout.setAllowUnversionedObstructions(true);
            checkout.setIgnoreExternals(updateClient.isIgnoreExternals());
            checkout.setExternalsHandler(SvnCodec.externalsHandler((ISVNExternalsHandler)updateClient.getExternalsHandler()));
            SvnWcFormat svnWcFormat = this.getWorkingCopyFormatFromConfiguration();
            checkout.setTargetWorkingCopyFormat(svnWcFormat.getWcFormatVersion());
            return (Long)checkout.run();
        }
        catch (SVNException e) {
            throw new RepositoryException("Failed to checkout source code to revision '" + revision + "' for " + url, (Throwable)e);
        }
    }

    private long update(SVNClientManager clientManager, File wcPath, SVNRevision updateToRevision, boolean isRecursive, BuildLogger buildLogger) throws SVNException {
        SVNUpdateClient updateClient = clientManager.getUpdateClient();
        updateClient.setEventHandler((ISVNEventHandler)new BuildLoggerUpdateEventHandler(buildLogger));
        updateClient.setIgnoreExternals(false);
        SVNDepth depth = isRecursive ? SVNDepth.INFINITY : SVNDepth.IMMEDIATES;
        boolean allowUnversionedObstructions = true;
        boolean depthIsSticky = true;
        return updateClient.doUpdate(wcPath, updateToRevision, depth, allowUnversionedObstructions, depthIsSticky);
    }

    private boolean isWorkspaceEmpty(@NotNull File sourceCodeDirectory) {
        File[] files;
        if (sourceCodeDirectory.exists() && (files = sourceCodeDirectory.listFiles()) != null) {
            return files.length == 0 || files.length == 1 && files[0].getName().equals("build-number.txt");
        }
        return true;
    }

    private void cleanUpWorkspace(SVNClientManager clientManager, BuildLogger buildLogger, File dirtyWorkspacePath, @Nullable Key entityKey) throws RepositoryException {
        log.warn((Object)buildLogger.addBuildLogEntry("Cleaning up dirty Subversion workspace at '" + dirtyWorkspacePath.getPath() + "'"));
        try {
            SVNWCClient wcClient = clientManager.getWCClient();
            wcClient.setIgnoreExternals(false);
            wcClient.doCleanup(dirtyWorkspacePath);
            log.info((Object)buildLogger.addBuildLogEntry("Clean up of '" + dirtyWorkspacePath.getPath() + "' completed"));
        }
        catch (SVNException e) {
            String msg = "Failed to clean up '" + (entityKey != null ? entityKey.getKey() : dirtyWorkspacePath.getPath()) + "'";
            log.error((Object)msg, (Throwable)e);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    private boolean isSvnLockException(@NotNull SVNException e) {
        CharSequence[] exceptionMsg = new String[]{"locked; try performing 'cleanup'"};
        return StringUtils.indexOfAny((CharSequence)e.getMessage(), (CharSequence[])exceptionMsg) != -1;
    }

    private boolean isRecoverableException(@NotNull SVNException e) {
        CharSequence[] exceptionMsg = new String[]{"object of the same name already exists", "containing working copy admin area is missing", "failed to load properties from disk", "checksum mismatch", "can't open file", "is not a working copy"};
        return StringUtils.indexOfAny((CharSequence)StringUtils.lowerCase((String)e.getMessage()), (CharSequence[])exceptionMsg) != -1 || this.isSvnLockException(e);
    }
}

