/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2.configurator;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plan.branch.VcsBranch;
import com.atlassian.bamboo.plan.branch.VcsBranchImpl;
import com.atlassian.bamboo.repository.svn.v2.configurator.SvnConfigurationConstants;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDefinition;
import com.atlassian.bamboo.vcs.configurator.VcsBranchConfigurator;
import com.opensymphony.xwork2.TextProvider;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvnBranchConfigurator
implements VcsBranchConfigurator {
    @Inject
    private TextProvider textProvider;
    @Inject
    private CustomVariableContext customVariableContext;

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull VcsBranchDefinition branchDefinition) {
        this.populateContextCommon(context, branchDefinition);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull VcsBranchDefinition branchDefinition) {
        this.populateContextCommon(context, branchDefinition);
    }

    private void populateContextCommon(@NotNull Map<String, Object> context, @NotNull VcsBranchDefinition vcsLocationDefinition) {
        Map cfg = vcsLocationDefinition.getConfiguration();
        context.put(SvnConfigurationConstants.SVN_BRANCH_DISPLAY_NAME, cfg.get(SvnConfigurationConstants.SVN_BRANCH_DISPLAY_NAME));
        context.put(SvnConfigurationConstants.SVN_BRANCH_PATH, cfg.get(SvnConfigurationConstants.SVN_BRANCH_PATH));
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, @NotNull ErrorCollection errorCollection) {
        String branchUrl = this.customVariableContext.substituteString(actionParametersMap.getString(SvnConfigurationConstants.SVN_BRANCH_PATH));
        BambooFieldValidate.findFieldRelaxedXssViolation(errorCollection, this.textProvider, SvnConfigurationConstants.SVN_BRANCH_PATH, branchUrl);
    }

    @NotNull
    public Map<String, String> generateConfigMap(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsBranchDefinition previousBranchDefinition, @NotNull Map<String, String> locationConfiguration) {
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        String branchPath = actionParametersMap.getString(SvnConfigurationConstants.SVN_BRANCH_PATH, "");
        String branchName = actionParametersMap.getString(SvnConfigurationConstants.SVN_BRANCH_DISPLAY_NAME);
        if (StringUtils.isBlank((CharSequence)branchName)) {
            int afterLastSlashPosition = branchPath.lastIndexOf(47) + 1;
            branchName = branchPath.substring(afterLastSlashPosition);
        }
        if (StringUtils.isBlank((CharSequence)branchName)) {
            String repoRootUrl = actionParametersMap.getString(SvnConfigurationConstants.SVN_REPO_ROOT_URL, "");
            int afterLastSlashPosition = repoRootUrl.lastIndexOf(47) + 1;
            branchName = repoRootUrl.substring(afterLastSlashPosition);
        }
        cfgMap.put(SvnConfigurationConstants.SVN_BRANCH_DISPLAY_NAME, branchName);
        cfgMap.put(SvnConfigurationConstants.SVN_BRANCH_PATH, branchPath);
        return cfgMap;
    }

    @NotNull
    public VcsBranch getVcsBranchFromConfig(@NotNull Map<String, String> configMap) {
        return new VcsBranchImpl((String)StringUtils.defaultIfBlank((CharSequence)configMap.get(SvnConfigurationConstants.SVN_BRANCH_PATH), (CharSequence)""), (String)StringUtils.defaultIfBlank((CharSequence)configMap.get(SvnConfigurationConstants.SVN_BRANCH_DISPLAY_NAME), (CharSequence)SvnConfigurationConstants.DEFAULT_BRANCH));
    }

    @NotNull
    public Map<String, String> setVcsBranchInConfig(@NotNull Map<String, String> configMap, @NotNull VcsBranch vcsBranch) {
        configMap.put(SvnConfigurationConstants.SVN_BRANCH_PATH, vcsBranch.getName());
        configMap.put(SvnConfigurationConstants.SVN_BRANCH_DISPLAY_NAME, vcsBranch.getDisplayName());
        return configMap;
    }

    @NotNull
    public VcsBranch createVcsBranchFromName(@NotNull String name) {
        int afterLastSlashPosition = name.lastIndexOf(47) + 1;
        String displayName = name.substring(afterLastSlashPosition);
        return new VcsBranchImpl(name, displayName);
    }
}

