/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2.configurator;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.repository.svn.v2.configurator.SvnConfigurationConstants;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.vcs.configuration.VcsBranchDetectionOptions;
import com.atlassian.bamboo.vcs.configurator.VcsBranchDetectionOptionsConfigurator;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvnBranchDetectionOptionsConfigurator
implements VcsBranchDetectionOptionsConfigurator {
    public void populateContextForCreate(@NotNull Map<String, Object> context) {
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull VcsBranchDetectionOptions vcsBranchDetectionOptions) {
        this.populateContextCommon(context, vcsBranchDetectionOptions);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull VcsBranchDetectionOptions vcsBranchDetectionOptions) {
        this.populateContextCommon(context, vcsBranchDetectionOptions);
    }

    private void populateContextCommon(@NotNull Map<String, Object> context, @NotNull VcsBranchDetectionOptions vcsBranchDetectionOptions) {
        Map cfg = vcsBranchDetectionOptions.getConfiguration();
        if (cfg.containsKey(SvnConfigurationConstants.BRANCH_DETECTION_PATH)) {
            context.put(SvnConfigurationConstants.BRANCH_DETECTION_PATH_OVERRIDDEN, true);
            context.put(SvnConfigurationConstants.BRANCH_DETECTION_PATH, cfg.get(SvnConfigurationConstants.BRANCH_DETECTION_PATH));
        }
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, @NotNull ErrorCollection errorCollection) {
    }

    @NotNull
    public Map<String, String> generateConfigMap(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsBranchDetectionOptions previousVcsBranchDetectionOptions) {
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        boolean branchDetectionBranchesRootOverridden = Boolean.parseBoolean(actionParametersMap.getString(SvnConfigurationConstants.BRANCH_DETECTION_PATH_OVERRIDDEN, Boolean.FALSE.toString()));
        if (branchDetectionBranchesRootOverridden) {
            cfgMap.put(SvnConfigurationConstants.BRANCH_DETECTION_PATH, actionParametersMap.getString(SvnConfigurationConstants.BRANCH_DETECTION_PATH, ""));
        }
        return cfgMap;
    }
}

