/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2.configurator;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.repository.AuthenticationType;
import com.atlassian.bamboo.repository.NameValuePair;
import com.atlassian.bamboo.repository.svn.v2.configurator.SvnConfigurationConstants;
import com.atlassian.bamboo.utils.BambooFieldValidate;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.vcs.configuration.VcsLocationDefinition;
import com.atlassian.bamboo.vcs.configurator.VcsLocationConfigurator;
import com.opensymphony.xwork2.TextProvider;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvnServerConfigurator
implements VcsLocationConfigurator {
    private static final Logger log = Logger.getLogger(SvnServerConfigurator.class);
    @Inject
    private CustomVariableContext customVariableContext;
    @Inject
    private TextProvider textProvider;

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        context.put(SvnConfigurationConstants.BRANCH_CREATE_AUTODETECT_PATH, true);
        context.put(SvnConfigurationConstants.TAG_CREATE_AUTODETECT_PATH, true);
        context.put(SvnConfigurationConstants.SVN_AUTH_TYPE, AuthenticationType.PASSWORD.getKey());
        this.populateSelectListItems(context);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        this.populateContextCommon(context, vcsLocationDefinition);
        this.populateSelectListItems(context);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        this.populateContextCommon(context, vcsLocationDefinition);
        this.populateSelectListItems(context);
    }

    public void validate(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousVcsLocationDefinition, @NotNull ErrorCollection errorCollection) {
        String keyField;
        String substitutedKeyFile;
        File keyFile;
        boolean isKnownAuth;
        String repoUrl = this.customVariableContext.substituteString(actionParametersMap.getString(SvnConfigurationConstants.SVN_REPO_ROOT_URL));
        if (StringUtils.isBlank((CharSequence)repoUrl)) {
            errorCollection.addError(SvnConfigurationConstants.SVN_REPO_ROOT_URL, this.textProvider.getText("repository.svn.specify.repository.root"));
        } else {
            BambooFieldValidate.findFieldRelaxedXssViolation(errorCollection, this.textProvider, SvnConfigurationConstants.SVN_REPO_ROOT_URL, repoUrl);
        }
        String authType = actionParametersMap.getString(SvnConfigurationConstants.SVN_AUTH_TYPE);
        boolean isNoAuth = StringUtils.isBlank((CharSequence)authType);
        boolean isPasswordAuth = !isNoAuth && AuthenticationType.PASSWORD.getKey().equals(authType);
        boolean isSshAuth = !isNoAuth && AuthenticationType.SSH.getKey().equals(authType);
        boolean isSslClientCertificateAuth = !isNoAuth && AuthenticationType.SSL_CLIENT_CERTIFICATE.getKey().equals(authType);
        boolean bl = isKnownAuth = isNoAuth || isPasswordAuth || isSshAuth || isSslClientCertificateAuth;
        if (!isKnownAuth) {
            errorCollection.addError(SvnConfigurationConstants.SVN_AUTH_TYPE, this.textProvider.getText("repository.svn.unknown.authorization.type", authType));
        } else if ((isSshAuth || isSslClientCertificateAuth) && !(keyFile = new File(substitutedKeyFile = this.customVariableContext.substituteString(actionParametersMap.getString(keyField = isSshAuth ? SvnConfigurationConstants.SVN_KEYFILE : SvnConfigurationConstants.SVN_SSL_KEYFILE)))).exists()) {
            errorCollection.addError(keyField, this.textProvider.getText("repository.keyFile.error"));
        }
        boolean advancedOptionsShown = actionParametersMap.getBoolean(SvnConfigurationConstants.ADVANCED_OPTIONS_ON_MARKER);
        if (advancedOptionsShown) {
            boolean tagAutodetectRoot;
            boolean branchAutodetectRoot = actionParametersMap.getBoolean(SvnConfigurationConstants.BRANCH_CREATE_AUTODETECT_PATH);
            if (!branchAutodetectRoot && StringUtils.isBlank((CharSequence)actionParametersMap.getString(SvnConfigurationConstants.BRANCH_CREATE_MANUAL_PATH))) {
                errorCollection.addError(SvnConfigurationConstants.BRANCH_CREATE_MANUAL_PATH, this.textProvider.getText("repository.svn.branch.specify.url"));
            }
            if (!(tagAutodetectRoot = actionParametersMap.getBoolean(SvnConfigurationConstants.TAG_CREATE_AUTODETECT_PATH)) && StringUtils.isBlank((CharSequence)actionParametersMap.getString(SvnConfigurationConstants.TAG_CREATE_MANUAL_ROOT))) {
                errorCollection.addError(SvnConfigurationConstants.BRANCH_CREATE_MANUAL_PATH, this.textProvider.getText("repository.svn.tag.specify.url"));
            }
        }
    }

    @NotNull
    public Map<String, String> generateConfigMap(@NotNull ActionParametersMap actionParametersMap, @Nullable VcsLocationDefinition previousVcsLocationDefinition) {
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        if (previousVcsLocationDefinition != null) {
            cfgMap.putAll(previousVcsLocationDefinition.getConfiguration());
        }
        cfgMap.put(SvnConfigurationConstants.SVN_REPO_ROOT_URL, actionParametersMap.getString(SvnConfigurationConstants.SVN_REPO_ROOT_URL));
        cfgMap.put(SvnConfigurationConstants.SVN_USERNAME, actionParametersMap.getString(SvnConfigurationConstants.SVN_USERNAME));
        String authType = actionParametersMap.getString(SvnConfigurationConstants.SVN_AUTH_TYPE);
        cfgMap.put(SvnConfigurationConstants.SVN_AUTH_TYPE, authType);
        if (AuthenticationType.PASSWORD.getKey().equals(authType)) {
            if (actionParametersMap.getBoolean(SvnConfigurationConstants.TEMPORARY_SVN_PASSWORD_CHANGE)) {
                cfgMap.put(SvnConfigurationConstants.SVN_PASSWORD, actionParametersMap.getString(SvnConfigurationConstants.TEMPORARY_SVN_PASSWORD));
            }
        } else if (AuthenticationType.SSH.getKey().equals(authType)) {
            cfgMap.put(SvnConfigurationConstants.SVN_KEYFILE, actionParametersMap.getString(SvnConfigurationConstants.SVN_KEYFILE));
            if (actionParametersMap.getBoolean(SvnConfigurationConstants.TEMPORARY_SVN_PASSPHRASE_CHANGE)) {
                cfgMap.put(SvnConfigurationConstants.SVN_PASSPHRASE, actionParametersMap.getString(SvnConfigurationConstants.TEMPORARY_SVN_PASSPHRASE));
            }
        } else if (AuthenticationType.SSL_CLIENT_CERTIFICATE.getKey().equals(authType)) {
            cfgMap.put(SvnConfigurationConstants.SVN_SSL_KEYFILE, actionParametersMap.getString(SvnConfigurationConstants.SVN_SSL_KEYFILE));
            if (actionParametersMap.getBoolean(SvnConfigurationConstants.TEMPORARY_SVN_SSL_PASSPHRASE_CHANGE)) {
                cfgMap.put(SvnConfigurationConstants.SVN_SSL_PASSPHRASE, actionParametersMap.getString(SvnConfigurationConstants.TEMPORARY_SVN_SSL_PASSPHRASE));
            }
        }
        cfgMap.put(SvnConfigurationConstants.USE_EXTERNALS, Boolean.toString(actionParametersMap.getBoolean(SvnConfigurationConstants.USE_EXTERNALS)));
        cfgMap.put(SvnConfigurationConstants.USE_EXPORT, Boolean.toString(actionParametersMap.getBoolean(SvnConfigurationConstants.USE_EXPORT)));
        boolean advancedOptionsShown = actionParametersMap.getBoolean(SvnConfigurationConstants.ADVANCED_OPTIONS_ON_MARKER);
        boolean branchAutodetectRoot = advancedOptionsShown ? actionParametersMap.getBoolean(SvnConfigurationConstants.BRANCH_CREATE_AUTODETECT_PATH) : true;
        cfgMap.put(SvnConfigurationConstants.BRANCH_CREATE_AUTODETECT_PATH, Boolean.toString(branchAutodetectRoot));
        if (!branchAutodetectRoot) {
            cfgMap.put(SvnConfigurationConstants.BRANCH_CREATE_MANUAL_PATH, actionParametersMap.getString(SvnConfigurationConstants.BRANCH_CREATE_MANUAL_PATH, ""));
        } else {
            cfgMap.remove(SvnConfigurationConstants.BRANCH_CREATE_MANUAL_PATH);
        }
        boolean tagAutodetectRoot = advancedOptionsShown ? actionParametersMap.getBoolean(SvnConfigurationConstants.TAG_CREATE_AUTODETECT_PATH) : true;
        cfgMap.put(SvnConfigurationConstants.TAG_CREATE_AUTODETECT_PATH, Boolean.toString(tagAutodetectRoot));
        if (!tagAutodetectRoot) {
            cfgMap.put(SvnConfigurationConstants.TAG_CREATE_MANUAL_ROOT, actionParametersMap.getString(SvnConfigurationConstants.TAG_CREATE_MANUAL_ROOT, ""));
        } else {
            cfgMap.remove(SvnConfigurationConstants.TAG_CREATE_MANUAL_ROOT);
        }
        return cfgMap;
    }

    public void addDefaultsForAdvancedOptions(@NotNull Map<String, String> cfgMap) {
        cfgMap.computeIfAbsent(SvnConfigurationConstants.BRANCH_CREATE_AUTODETECT_PATH, key -> Boolean.TRUE.toString());
        cfgMap.computeIfAbsent(SvnConfigurationConstants.TAG_CREATE_AUTODETECT_PATH, key -> Boolean.TRUE.toString());
    }

    @NotNull
    public String getServerHost(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        try {
            String url = this.customVariableContext.substituteString((String)vcsLocationDefinition.getConfiguration().get(SvnConfigurationConstants.SVN_REPO_ROOT_URL));
            return new URL(url).getHost();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    @NotNull
    public String getLocationIdentifier(@NotNull VcsLocationDefinition vcsLocationDefinition) {
        return (String)vcsLocationDefinition.getConfiguration().get(SvnConfigurationConstants.SVN_REPO_ROOT_URL);
    }

    private void populateSelectListItems(@NotNull Map<String, Object> context) {
        ArrayList<NameValuePair> authTypes = new ArrayList<NameValuePair>();
        for (AuthenticationType svnAuthenticationType : AuthenticationType.values()) {
            authTypes.add(svnAuthenticationType.getNameValue());
        }
        context.put(SvnConfigurationConstants.SVN_AUTHENTICATION_TYPES, authTypes);
    }

    private void populateContextCommon(@NotNull Map<String, Object> context, @NotNull VcsLocationDefinition vcsLocationDefinition) {
        Map cfg = vcsLocationDefinition.getConfiguration();
        context.put(SvnConfigurationConstants.SVN_REPO_ROOT_URL, cfg.get(SvnConfigurationConstants.SVN_REPO_ROOT_URL));
        context.put(SvnConfigurationConstants.SVN_USERNAME, cfg.get(SvnConfigurationConstants.SVN_USERNAME));
        context.put(SvnConfigurationConstants.USE_EXTERNALS, Boolean.parseBoolean((String)cfg.get(SvnConfigurationConstants.USE_EXTERNALS)));
        context.put(SvnConfigurationConstants.USE_EXPORT, Boolean.parseBoolean((String)cfg.get(SvnConfigurationConstants.USE_EXPORT)));
        String svnAuthTypeKey = StringUtils.defaultString((String)((String)cfg.get(SvnConfigurationConstants.SVN_AUTH_TYPE)), (String)AuthenticationType.PASSWORD.getKey());
        context.put(SvnConfigurationConstants.SVN_AUTH_TYPE, svnAuthTypeKey);
        if (svnAuthTypeKey.equals(AuthenticationType.PASSWORD.getKey())) {
            this.putDummyIfValueIsNotBlank(context, cfg, SvnConfigurationConstants.SVN_PASSWORD);
        } else if (svnAuthTypeKey.equals(AuthenticationType.SSH.getKey())) {
            context.put(SvnConfigurationConstants.SVN_KEYFILE, cfg.get(SvnConfigurationConstants.SVN_KEYFILE));
            this.putDummyIfValueIsNotBlank(context, cfg, SvnConfigurationConstants.SVN_PASSPHRASE);
        } else if (svnAuthTypeKey.equals(AuthenticationType.SSL_CLIENT_CERTIFICATE.getKey())) {
            context.put(SvnConfigurationConstants.SVN_SSL_KEYFILE, cfg.get(SvnConfigurationConstants.SVN_SSL_KEYFILE));
            this.putDummyIfValueIsNotBlank(context, cfg, SvnConfigurationConstants.SVN_SSL_PASSPHRASE);
        }
        context.put(SvnConfigurationConstants.BRANCH_CREATE_AUTODETECT_PATH, Boolean.parseBoolean((String)cfg.get(SvnConfigurationConstants.BRANCH_CREATE_AUTODETECT_PATH)));
        context.put(SvnConfigurationConstants.BRANCH_CREATE_MANUAL_PATH, cfg.getOrDefault(SvnConfigurationConstants.BRANCH_CREATE_MANUAL_PATH, ""));
        context.put(SvnConfigurationConstants.TAG_CREATE_AUTODETECT_PATH, Boolean.parseBoolean((String)cfg.get(SvnConfigurationConstants.TAG_CREATE_AUTODETECT_PATH)));
        context.put(SvnConfigurationConstants.TAG_CREATE_MANUAL_ROOT, cfg.getOrDefault(SvnConfigurationConstants.TAG_CREATE_MANUAL_ROOT, ""));
    }

    private void putDummyIfValueIsNotBlank(@NotNull Map<String, Object> context, @NotNull Map<String, String> cfg, String key) {
        if (StringUtils.isNotBlank((CharSequence)cfg.get(key))) {
            context.put(key, "dummy");
        }
    }
}

