/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.repository.svn.v2.converter;

import com.atlassian.bamboo.repository.AuthenticationType;
import com.atlassian.bamboo.repository.svn.SvnRepository;
import com.atlassian.bamboo.repository.svn.v2.AbstractSvnExecutor;
import com.atlassian.bamboo.repository.svn.v2.SvnPathHelper;
import com.atlassian.bamboo.repository.svn.v2.SvnRepositoryAccessData;
import com.atlassian.bamboo.repository.svn.v2.configurator.SvnConfigurationConstants;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.converter.Repository2VcsTypeConverter;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;

public class SvnConfigConverter
extends AbstractSvnExecutor
implements Repository2VcsTypeConverter {
    private static final Logger log = Logger.getLogger(SvnConfigConverter.class);

    public String acceptedRepositoryPluginKey() {
        return "com.atlassian.bamboo.plugin.system.repository:svn";
    }

    public String producedVcsTypePluginKey() {
        return "com.atlassian.bamboo.plugin.system.repository:svnv2";
    }

    private String getOldConfigConstant(String key) {
        return SvnRepository.getConfigConstant(key);
    }

    private String cutOffBranchPathFromRootUrl(@NotNull String rootUrl) {
        try {
            SVNURL svnurl = SVNURL.parseURIEncoded((String)rootUrl);
            Pair<String, String> splitUrl = SvnPathHelper.parseRepositoryUrl(rootUrl);
            return (String)splitUrl.getLeft();
        }
        catch (SVNException sVNException) {
            return rootUrl;
        }
    }

    @VisibleForTesting
    protected static String getCommonPart(@NotNull String first, @NotNull String second) {
        String secondToken;
        String firstToken;
        StringTokenizer firstTokenizer = new StringTokenizer(first, "/", true);
        StringTokenizer secondTokenizer = new StringTokenizer(second, "/", true);
        StringBuilder resultBuilder = new StringBuilder();
        while (firstTokenizer.hasMoreTokens() && secondTokenizer.hasMoreTokens() && (firstToken = firstTokenizer.nextToken()).equals(secondToken = secondTokenizer.nextToken())) {
            resultBuilder.append(firstToken);
        }
        String result = resultBuilder.toString();
        if (result.endsWith("://")) {
            return "";
        }
        return result;
    }

    private String getCommonRoot(@NotNull HierarchicalConfiguration repositoryConfiguration) {
        boolean tagAutodetectRoot;
        String rootUrl;
        String commonPath = rootUrl = repositoryConfiguration.getString(this.getOldConfigConstant("repositoryUrl"));
        String manualBranchCreatePath = null;
        String manualTagCreatePath = null;
        boolean otherUrlsExistInConfig = false;
        boolean branchAutodetectRoot = repositoryConfiguration.getBoolean(this.getOldConfigConstant("branch.autodetectRootUrl"));
        if (!branchAutodetectRoot) {
            manualBranchCreatePath = repositoryConfiguration.getString(this.getOldConfigConstant("branch.manualRootUrl"), "");
        }
        if (!(tagAutodetectRoot = repositoryConfiguration.getBoolean(this.getOldConfigConstant("tag.autodetectRootUrl")))) {
            manualTagCreatePath = repositoryConfiguration.getString(this.getOldConfigConstant("tag.manualRootUrl"), "");
        }
        if (manualBranchCreatePath != null) {
            commonPath = SvnConfigConverter.getCommonPart(commonPath, manualBranchCreatePath);
            otherUrlsExistInConfig = true;
        }
        if (manualTagCreatePath != null) {
            commonPath = SvnConfigConverter.getCommonPart(commonPath, manualTagCreatePath);
            otherUrlsExistInConfig = true;
        }
        if (otherUrlsExistInConfig) {
            return commonPath;
        }
        return this.cutOffBranchPathFromRootUrl(rootUrl);
    }

    @NotNull
    public Map<String, String> extractServerConfiguration(@NotNull HierarchicalConfiguration repositoryConfiguration) {
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        String rootUrl = repositoryConfiguration.getString(this.getOldConfigConstant("repositoryUrl"));
        String branchPath = "";
        String manualBranchCreatePath = null;
        String manualTagCreatePath = null;
        String commonPath = this.getCommonRoot(repositoryConfiguration);
        cfgMap.put(SvnConfigurationConstants.SVN_REPO_ROOT_URL, rootUrl);
        cfgMap.put(SvnConfigurationConstants.SVN_USERNAME, repositoryConfiguration.getString(this.getOldConfigConstant("username")));
        String authType = repositoryConfiguration.getString(this.getOldConfigConstant("authType"));
        cfgMap.put(SvnConfigurationConstants.SVN_AUTH_TYPE, authType);
        if (AuthenticationType.PASSWORD.getKey().equals(authType)) {
            cfgMap.put(SvnConfigurationConstants.SVN_PASSWORD, repositoryConfiguration.getString(this.getOldConfigConstant("userPassword")));
        } else if (AuthenticationType.SSH.getKey().equals(authType)) {
            cfgMap.put(SvnConfigurationConstants.SVN_KEYFILE, repositoryConfiguration.getString(this.getOldConfigConstant("keyFile")));
            cfgMap.put(SvnConfigurationConstants.SVN_PASSPHRASE, repositoryConfiguration.getString(this.getOldConfigConstant("passphrase")));
        } else if (AuthenticationType.SSL_CLIENT_CERTIFICATE.getKey().equals(authType)) {
            cfgMap.put(SvnConfigurationConstants.SVN_SSL_KEYFILE, repositoryConfiguration.getString(this.getOldConfigConstant("sslKeyFile")));
            cfgMap.put(SvnConfigurationConstants.SVN_SSL_PASSPHRASE, repositoryConfiguration.getString(this.getOldConfigConstant("sslPassphrase")));
        }
        cfgMap.put(SvnConfigurationConstants.USE_EXTERNALS, Boolean.toString(repositoryConfiguration.getBoolean(this.getOldConfigConstant("useExternals"))));
        cfgMap.put(SvnConfigurationConstants.USE_EXPORT, Boolean.toString(repositoryConfiguration.getBoolean(this.getOldConfigConstant("useExport"))));
        boolean branchAutodetectRoot = repositoryConfiguration.getBoolean(this.getOldConfigConstant("branch.autodetectRootUrl"));
        cfgMap.put(SvnConfigurationConstants.BRANCH_CREATE_AUTODETECT_PATH, Boolean.toString(branchAutodetectRoot));
        if (!branchAutodetectRoot) {
            manualBranchCreatePath = repositoryConfiguration.getString(this.getOldConfigConstant("branch.manualRootUrl"), "");
            cfgMap.put(SvnConfigurationConstants.BRANCH_CREATE_MANUAL_PATH, manualBranchCreatePath);
        }
        boolean tagAutodetectRoot = repositoryConfiguration.getBoolean(this.getOldConfigConstant("tag.autodetectRootUrl"));
        cfgMap.put(SvnConfigurationConstants.TAG_CREATE_AUTODETECT_PATH, Boolean.toString(tagAutodetectRoot));
        if (!tagAutodetectRoot) {
            manualTagCreatePath = repositoryConfiguration.getString(this.getOldConfigConstant("tag.manualRootUrl"), "");
            cfgMap.put(SvnConfigurationConstants.TAG_CREATE_MANUAL_ROOT, manualTagCreatePath);
        }
        if (StringUtils.isNotBlank((CharSequence)commonPath)) {
            cfgMap.put(SvnConfigurationConstants.SVN_REPO_ROOT_URL, commonPath);
            if (manualBranchCreatePath != null) {
                cfgMap.put(SvnConfigurationConstants.BRANCH_CREATE_MANUAL_PATH, manualBranchCreatePath.substring(commonPath.length()));
            }
            if (manualTagCreatePath != null) {
                cfgMap.put(SvnConfigurationConstants.TAG_CREATE_MANUAL_ROOT, manualTagCreatePath.substring(commonPath.length()));
            }
        }
        return cfgMap;
    }

    @Nullable
    public Map<String, String> extractBranchConfiguration(@NotNull HierarchicalConfiguration repositoryConfiguration) {
        HashMap<String, String> result = new HashMap<String, String>();
        String commonPath = this.getCommonRoot(repositoryConfiguration);
        String rootUrl = repositoryConfiguration.getString(this.getOldConfigConstant("repositoryUrl"));
        if (StringUtils.isNotBlank((CharSequence)commonPath)) {
            String branchPath = rootUrl.substring(commonPath.length());
            result.put(SvnConfigurationConstants.SVN_BRANCH_PATH, branchPath);
            result.put(SvnConfigurationConstants.SVN_BRANCH_DISPLAY_NAME, StringUtils.isBlank((CharSequence)branchPath) ? this.extractDisplayName(rootUrl) : this.extractDisplayName(branchPath));
        } else {
            result.put(SvnConfigurationConstants.SVN_BRANCH_PATH, "");
            result.put(SvnConfigurationConstants.SVN_BRANCH_DISPLAY_NAME, this.extractDisplayName(rootUrl));
        }
        return result;
    }

    private String extractDisplayName(String urlOrBranchPath) {
        int afterLastSlashPosition = urlOrBranchPath.lastIndexOf(47) + 1;
        return urlOrBranchPath.substring(afterLastSlashPosition);
    }

    public HierarchicalConfiguration asLegacyData(@NotNull VcsRepositoryData vcsRepositoryData) {
        Map serverCfg = vcsRepositoryData.getVcsLocation().getConfiguration();
        SvnRepositoryAccessData accessData = this.getSubstitutedAccessData(vcsRepositoryData);
        XMLConfiguration configuration = ConfigUtils.newConfiguration();
        try {
            configuration.addProperty(this.getOldConfigConstant("repositoryUrl"), (Object)accessData.getUrl().toString());
            configuration.addProperty(this.getOldConfigConstant("username"), (Object)accessData.getUsername());
            if (accessData.getAuthenticationType() != null) {
                configuration.addProperty(this.getOldConfigConstant("authType"), (Object)accessData.getAuthenticationType().getKey());
                switch (accessData.getAuthenticationType()) {
                    case PASSWORD: {
                        configuration.addProperty(this.getOldConfigConstant("userPassword"), serverCfg.get(SvnConfigurationConstants.SVN_PASSWORD));
                        break;
                    }
                    case SSH: {
                        configuration.addProperty(this.getOldConfigConstant("keyFile"), (Object)accessData.getKeyFile());
                        configuration.addProperty(this.getOldConfigConstant("passphrase"), serverCfg.get(SvnConfigurationConstants.SVN_PASSPHRASE));
                        break;
                    }
                    case SSL_CLIENT_CERTIFICATE: {
                        configuration.addProperty(this.getOldConfigConstant("sslKeyFile"), (Object)accessData.getKeyFile());
                        configuration.addProperty(this.getOldConfigConstant("sslPassphrase"), serverCfg.get(SvnConfigurationConstants.SVN_SSL_PASSPHRASE));
                    }
                }
            }
            configuration.addProperty(this.getOldConfigConstant("useExternals"), (Object)accessData.isUseExternals());
            configuration.addProperty(this.getOldConfigConstant("useExport"), (Object)accessData.isUseExport());
            configuration.addProperty(this.getOldConfigConstant("branch.autodetectRootUrl"), (Object)accessData.isAutodetectBranchPath());
            if (!accessData.isAutodetectBranchPath()) {
                configuration.addProperty(this.getOldConfigConstant("branch.manualRootUrl"), (Object)accessData.getManualBranchUrl().toString());
            }
            configuration.addProperty(this.getOldConfigConstant("tag.autodetectRootUrl"), (Object)accessData.isAutodetectTagPath());
            if (!accessData.isAutodetectTagPath()) {
                configuration.addProperty(this.getOldConfigConstant("tag.manualRootUrl"), (Object)accessData.getManualTagUrl().toString());
            }
        }
        catch (SVNException e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
        return configuration;
    }
}

