/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.rest;

import com.atlassian.bamboo.rest.BambooRemoteException;
import com.atlassian.bamboo.rest.SessionManager;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.bamboo.utils.BambooRandomStringUtils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class DefaultSessionManager
implements SessionManager {
    private final BambooUserManager bambooUserManager;
    private final ConcurrentMap<String, String> sessions;

    public DefaultSessionManager(BambooUserManager bambooUserManager) {
        this(bambooUserManager, 30, TimeUnit.MINUTES);
    }

    public DefaultSessionManager(BambooUserManager bambooUserManager, int sessionTimeout, TimeUnit timeUnit) {
        this.bambooUserManager = bambooUserManager;
        LoadingCache build = CacheBuilder.newBuilder().expireAfterAccess((long)sessionTimeout, timeUnit).build((CacheLoader)new CacheLoader<String, String>(){

            @Nullable
            public String load(String key) throws Exception {
                return null;
            }
        });
        this.sessions = build.asMap();
    }

    public String login(String username, String password) throws BambooRemoteException {
        if (this.bambooUserManager.getBambooUser(username) != null && this.bambooUserManager.authenticate(username, password)) {
            return this.createToken(username);
        }
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new BambooRemoteException("Invalid username or password.");
        }
        String loggedInUserName = authentication.getName();
        if ("anonymousUser".equals(loggedInUserName) || StringUtils.isBlank((CharSequence)loggedInUserName)) {
            throw new BambooRemoteException("Invalid username or password.");
        }
        return this.createToken(loggedInUserName);
    }

    public void logout(String sessionId) {
        this.sessions.remove(sessionId);
    }

    public String getUserNameFromSession(String sessionId) throws BambooRemoteException {
        String userName = (String)this.sessions.get(sessionId);
        if (userName == null) {
            throw new BambooRemoteException("User not authenticated yet, or session timed out.");
        }
        return userName;
    }

    private String createToken(String userName) throws BambooRemoteException {
        for (int i = 0; i < 10; ++i) {
            String sessionId = this.generateSessionId();
            if (this.sessions.putIfAbsent(sessionId, userName) != null) continue;
            return sessionId;
        }
        throw new BambooRemoteException("Error generating authentication sessionId, please try again.");
    }

    private String generateSessionId() {
        return BambooRandomStringUtils.randomAlphanumeric(10);
    }
}

