/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.rest.adapter;

import com.atlassian.bamboo.rest.entity.NamedEntity;
import com.atlassian.security.xml.SecureXmlParserFactory;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class NamedEntityAdapter<T>
extends XmlAdapter<Element, NamedEntity<T>> {
    private static final Logger log = Logger.getLogger(NamedEntityAdapter.class);
    private JAXBContext jaxbContext;
    private DocumentBuilder documentBuilder;

    public abstract Class<T> getEntityType();

    public abstract NamedEntity<T> createNamedEntity(@NotNull String var1, @NotNull T var2);

    public Element marshal(@Nullable NamedEntity<T> entity) throws Exception {
        if (null == entity) {
            return null;
        }
        QName rootElement = new QName(entity.getName());
        T value = entity.getValue();
        Class<T> type = this.getEntityType();
        JAXBElement jaxbElement = new JAXBElement(rootElement, this.getEntityType(), value);
        Document document = this.getDocumentBuilder().newDocument();
        Marshaller marshaller = this.getJAXBContext(type).createMarshaller();
        marshaller.marshal((Object)jaxbElement, (Node)document);
        return document.getDocumentElement();
    }

    public NamedEntity<T> unmarshal(@Nullable Element element) throws Exception {
        if (null == element) {
            return null;
        }
        Class<T> type = this.getEntityType();
        DOMSource source = new DOMSource(element);
        Unmarshaller unmarshaller = this.getJAXBContext(type).createUnmarshaller();
        JAXBElement jaxbElement = unmarshaller.unmarshal((Source)source, type);
        return this.createNamedEntity(element.getLocalName(), jaxbElement.getValue());
    }

    private DocumentBuilder getDocumentBuilder() throws Exception {
        if (null == this.documentBuilder) {
            this.documentBuilder = SecureXmlParserFactory.newDocumentBuilder();
        }
        return this.documentBuilder;
    }

    private JAXBContext getJAXBContext(Class<?> type) throws Exception {
        if (null == this.jaxbContext) {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{type});
        }
        return this.jaxbContext;
    }
}

