/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.rest.entity;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class NamedEntity<T> {
    private static final Logger log = Logger.getLogger(NamedEntity.class);
    private String name;
    private T value;

    protected NamedEntity() {
    }

    public NamedEntity(String name, T value) {
        this.name = name;
        this.value = value;
    }

    public static <T> Function<NamedEntity<? extends T>, T> extract() {
        return new ExtractFunction();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    private static class ExtractFunction<T>
    implements Function<NamedEntity<? extends T>, T> {
        private ExtractFunction() {
        }

        public T apply(@Nullable NamedEntity<? extends T> entity) {
            return ((NamedEntity)Preconditions.checkNotNull(entity)).getValue();
        }
    }
}

