/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.rest.entity;

import com.atlassian.bamboo.rest.adapter.FormErrorsEntityAdapter;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@XmlRootElement(name="response")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RestResponse {
    private static final Logger log = Logger.getLogger(RestResponse.class);
    @XmlElement(name="status")
    private String status;
    @XmlElementWrapper(name="errors")
    @XmlElement(name="error")
    private List<String> errors;
    @XmlElement(name="fieldErrors")
    @XmlJavaTypeAdapter(value=FormErrorsEntityAdapter.class)
    private Multimap<String, String> fieldErrors;
    @XmlElementWrapper(name="messages")
    @XmlElement(name="message")
    private List<String> messages;
    @XmlElementWrapper(name="warnings")
    @XmlElement(name="warning")
    private List<String> warnings;

    public static Builder builder() {
        return new Builder();
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public void setFieldErrors(Multimap<String, String> fieldErrors) {
        this.fieldErrors = fieldErrors;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    public static class Builder {
        private List<String> errors = new ArrayList<String>();
        private Multimap<String, String> fieldErrors = LinkedHashMultimap.create();
        private List<String> messages = new ArrayList<String>();
        private List<String> warnings = new ArrayList<String>();

        public Builder error(@NotNull String error) {
            this.errors.add(error);
            return this;
        }

        public Builder fieldError(@NotNull String fieldname, @NotNull String error) {
            this.fieldErrors.put((Object)fieldname, (Object)error);
            return this;
        }

        public Builder message(@NotNull String message) {
            this.messages.add(message);
            return this;
        }

        public Builder warning(@NotNull String warning) {
            this.warnings.add(warning);
            return this;
        }

        private boolean hasErrors() {
            return !this.errors.isEmpty() || !this.fieldErrors.isEmpty();
        }

        public <T extends RestResponse> T build(Class<T> responseType) {
            try {
                RestResponse response = (RestResponse)responseType.newInstance();
                response.setStatus(this.hasErrors() ? "ERROR" : "OK");
                if (!this.errors.isEmpty()) {
                    response.setErrors(Lists.newArrayList(this.errors));
                }
                if (!this.fieldErrors.isEmpty()) {
                    response.setFieldErrors((Multimap<String, String>)LinkedHashMultimap.create(this.fieldErrors));
                }
                if (!this.messages.isEmpty()) {
                    response.setMessages(Lists.newArrayList(this.messages));
                }
                if (!this.warnings.isEmpty()) {
                    response.setWarnings(Lists.newArrayList(this.warnings));
                }
                return (T)response;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

