/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.rest.util;

import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.HttpUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public abstract class RESTCall<M extends HttpMethod> {
    private static final Logger log = Logger.getLogger(RESTCall.class);
    private final HttpClient client;
    private final M method;
    private boolean executed = false;
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;

    protected RESTCall(HttpClient client, M method) {
        this.client = client;
        this.method = method;
    }

    protected RESTCall(M method) {
        this(new HttpClient(), method);
    }

    public void setMarshalledClasses(Class ... classes) throws JAXBException {
        JAXBContext jaxb = JAXBContext.newInstance((Class[])classes);
        Unmarshaller um = jaxb.createUnmarshaller();
        Marshaller m = jaxb.createMarshaller();
        this.unmarshaller = um;
        this.marshaller = m;
    }

    protected void marshal(Object obj, OutputStream out) throws JAXBException {
        Preconditions.checkState((this.marshaller != null ? 1 : 0) != 0, (Object)"setMarshalledClasses needs to be called first");
        this.marshaller.marshal(obj, out);
    }

    protected Object unmarshal(InputStream in) throws JAXBException {
        Preconditions.checkState((this.unmarshaller != null ? 1 : 0) != 0, (Object)"setMarshalledClasses needs to be called first");
        return this.unmarshaller.unmarshal(in);
    }

    public <T> T unmarshal(Class<T> responseType) throws IOException, JAXBException {
        this.assertExecuted();
        return (T)Narrow.to((Object)this.unmarshal(this.getResponseAsStream()), responseType);
    }

    public void setBasicCredentials(String username, String password) {
        this.assertNotExecuted();
        this.client.getParams().setAuthenticationPreemptive(true);
        this.client.getState().setCredentials(new AuthScope(AuthScope.ANY), (Credentials)new UsernamePasswordCredentials(username, password));
        this.method.setDoAuthentication(true);
    }

    public void setClientProxy() {
        this.assertNotExecuted();
        try {
            RESTCall.setProxy(this.client, this.method.getURI().getScheme());
        }
        catch (URIException e) {
            log.error((Object)("Unable to set up proxy settings, invalid URI encountered: " + (Object)((Object)e)));
        }
    }

    private static void setProxy(@NotNull HttpClient client, @Nullable String scheme) throws URIException {
        HttpUtils.EndpointSpec proxyForScheme = HttpUtils.getProxyForScheme((String)scheme);
        if (proxyForScheme != null) {
            client.getHostConfiguration().setProxy(proxyForScheme.host, proxyForScheme.port.intValue());
        }
    }

    public void addRequestHeader(String key, String value) {
        this.assertNotExecuted();
        this.method.addRequestHeader(key, value);
    }

    public void execute() {
        this.assertNotExecuted();
        this.setClientProxy();
        try {
            this.client.executeMethod(this.method);
            this.executed = true;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
        finally {
            int statusCode = this.method.getStatusCode();
            if (statusCode != 200) {
                this.logCall(statusCode, Level.WARN);
            } else if (this.executed && log.isDebugEnabled()) {
                this.logCall(statusCode, Level.DEBUG);
            }
        }
    }

    private void logCall(int statusCode, Level logLevel) {
        if (this.getResponseBody() != null) {
            log.log((Priority)logLevel, (Object)String.format("Response from %s %s %s (%d): %s", this.method.getName(), this.method.getPath(), this.method.getQueryString(), statusCode, new String(this.getResponseBody())));
        } else {
            log.log((Priority)logLevel, (Object)String.format("HTTP request from %s %s %s returned code: %d", this.method.getName(), this.method.getPath(), this.method.getQueryString(), statusCode));
        }
    }

    public int getStatusCode() {
        this.assertExecuted();
        return this.method.getStatusCode();
    }

    public byte[] getResponseBody() {
        this.assertExecuted();
        try {
            return this.method.getResponseBody();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe.getMessage());
        }
    }

    public InputStream getResponseAsStream() throws IOException {
        return this.method.getResponseBodyAsStream();
    }

    public URI getURI() throws URIException {
        try {
            new URI(this.method.getURI().getURI());
        }
        catch (URISyntaxException e) {
            log.warn((Object)"Incorrect URI", (Throwable)e);
        }
        return null;
    }

    public void release() {
        this.method.releaseConnection();
    }

    protected void assertExecuted() {
        Preconditions.checkState((boolean)this.executed, (Object)"Not executed");
    }

    protected void assertNotExecuted() {
        Preconditions.checkState((!this.executed ? 1 : 0) != 0);
    }

    public M getMethod() {
        return this.method;
    }
}

