/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.rest.utils;

import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.HttpUtils;
import com.atlassian.bamboo.utils.SystemProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import io.atlassian.util.concurrent.Lazy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.function.Supplier;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RESTCall<M extends HttpRequestBase>
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(RESTCall.class);
    private final HttpClient client;
    private final M method;
    private boolean executed = false;
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;
    private HttpResponse response;
    private final Supplier<byte[]> responseBody = Lazy.supplier((Supplier)new Supplier<byte[]>(){

        @Override
        @Nullable
        public byte[] get() {
            try {
                HttpEntity entity = RESTCall.this.response.getEntity();
                return entity == null ? null : EntityUtils.toByteArray((HttpEntity)entity);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error in call " + RESTCall.this.toString(), ioe);
            }
        }
    });
    private final Supplier<Multimap<String, String>> requestHeaders = Lazy.supplier((Supplier)new Supplier<Multimap<String, String>>(){

        @Override
        public Multimap<String, String> get() {
            HashMultimap responseHeaders = HashMultimap.create();
            for (Header header : RESTCall.this.response.getAllHeaders()) {
                responseHeaders.put((Object)header.getName(), (Object)header.getValue());
            }
            return ImmutableMultimap.copyOf((Multimap)responseHeaders);
        }
    });

    protected RESTCall(HttpClient client, M method) {
        this.client = client;
        this.method = method;
    }

    protected RESTCall(M method) {
        this((HttpClient)new DefaultHttpClient(), method);
        this.setClientProxy();
    }

    public static HttpClient getHttpClientWithTimeout(String scheme) {
        int timeout = Math.toIntExact(SystemProperty.DEFAULT_TIMEOUT_FOR_HTTP_CLIENT.getTypedValue());
        RequestConfig.Builder requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout);
        HttpUtils.EndpointSpec proxyForScheme = HttpUtils.getProxyForScheme((String)scheme);
        if (proxyForScheme != null) {
            requestConfig.setProxy(new HttpHost(proxyForScheme.host, proxyForScheme.port.intValue()));
        }
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig.build()).build();
    }

    public void setMarshalledClasses(Class ... classes) throws JAXBException {
        JAXBContext jaxb = JAXBContext.newInstance((Class[])classes);
        Unmarshaller um = jaxb.createUnmarshaller();
        Marshaller m = jaxb.createMarshaller();
        this.unmarshaller = um;
        this.marshaller = m;
    }

    protected void marshal(Object obj, OutputStream out) throws JAXBException {
        Preconditions.checkState((this.marshaller != null ? 1 : 0) != 0, (Object)"setMarshalledClasses needs to be called first");
        this.marshaller.marshal(obj, out);
    }

    protected Object unmarshal(InputStream in) throws JAXBException {
        Preconditions.checkState((this.unmarshaller != null ? 1 : 0) != 0, (Object)"setMarshalledClasses needs to be called first");
        return this.unmarshaller.unmarshal(in);
    }

    public <T> T unmarshal(Class<T> responseType) throws IOException, JAXBException {
        this.assertExecuted();
        return (T)Narrow.to((Object)this.unmarshal(this.getResponseAsStream()), responseType);
    }

    public void setBasicCredentials(String username, String password) {
        this.assertNotExecuted();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
        try {
            this.method.addHeader(new BasicScheme().authenticate((Credentials)credentials, this.method, (HttpContext)new BasicHttpContext()));
        }
        catch (AuthenticationException e) {
            throw BambooObjectUtils.asRuntimeException((Throwable)e);
        }
    }

    public void setClientProxy() {
        this.assertNotExecuted();
        RESTCall.setProxy(this.client, this.method.getURI().getScheme());
    }

    private static void setProxy(@NotNull HttpClient client, @Nullable String scheme) {
        HttpUtils.EndpointSpec proxyForScheme = HttpUtils.getProxyForScheme((String)scheme);
        if (proxyForScheme != null) {
            client.getParams().setParameter("http.route.default-proxy", (Object)new HttpHost(proxyForScheme.host, proxyForScheme.port.intValue()));
        }
    }

    public void addRequestHeader(String key, String value) {
        this.assertNotExecuted();
        this.method.addHeader(key, value);
    }

    public void execute() {
        this.assertNotExecuted();
        try {
            this.beforeExecute();
            this.response = this.client.execute(this.method);
            this.executed = true;
            int statusCode = this.response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                log.warn((Object)String.format("Response from %s %s (%d)", this.method.getMethod(), this.method.getURI(), statusCode));
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Response body:\n" + new String(this.getResponseBody())));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Response from %s %s (%d)", this.method.getMethod(), this.method.getURI(), statusCode));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void beforeExecute() {
    }

    public int getStatusCode() {
        return this.getStatusLine().getStatusCode();
    }

    public StatusLine getStatusLine() {
        this.assertExecuted();
        return this.response.getStatusLine();
    }

    public byte[] getResponseBody() {
        this.assertExecuted();
        return this.responseBody.get();
    }

    public InputStream getResponseAsStream() {
        return new ByteArrayInputStream(this.getResponseBody());
    }

    public String getResponseAsString() {
        return new String(this.getResponseBody());
    }

    public URI getURI() {
        return this.method.getURI();
    }

    public Multimap<String, String> getResponseHeaders() {
        this.assertExecuted();
        return this.requestHeaders.get();
    }

    public void release() {
        this.method.releaseConnection();
    }

    protected void assertExecuted() {
        Preconditions.checkState((boolean)this.executed, (Object)"Not executed");
    }

    protected void assertNotExecuted() {
        Preconditions.checkState((!this.executed ? 1 : 0) != 0);
    }

    public M getMethod() {
        return this.method;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("method", this.method).add("executed", this.executed).toString();
    }

    @Override
    public void close() {
        this.release();
    }
}

