/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.DeltaState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.comment.Comment;
import com.atlassian.bamboo.core.BambooCustomDataAware;
import com.atlassian.bamboo.deletion.Deletable;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.artifact.ConsumedSubscription;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableDeletable;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.resultsummary.BaseResultSummary;
import com.atlassian.bamboo.resultsummary.CustomDataRow;
import com.atlassian.bamboo.resultsummary.MutableBuildKeyResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestClassResult;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.BuildUtils;
import com.atlassian.bamboo.util.TextProviderUtils;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import com.atlassian.bamboo.v2.build.trigger.TriggerReasonRenderer;
import com.atlassian.bamboo.v2.build.trigger.UnknownTriggerReason;
import com.atlassian.bamboo.variable.VariableContextSnapshot;
import com.atlassian.bamboo.variable.VariableSubstitution;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.variable.baseline.VariableBaselineItem;
import com.atlassian.bamboo.variable.baseline.VariableContextBaseline;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.hibernate.annotations.GenericGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="BUILDRESULTSUMMARY")
@GenericGenerator(name="ImportAwareGenerator", strategy="com.atlassian.bamboo.persistence.ImportAwareGenerator")
public abstract class AbstractResultsSummary
extends BaseResultSummary
implements ImmutableDeletable,
Deletable,
MutableBuildKeyResultsSummary {
    private static final Logger log = Logger.getLogger(AbstractResultsSummary.class);
    private String discriminator;
    private String reasonSummary;
    private String changesListSummary;
    private TestResultsSummary testResultsSummary;
    private long duration;
    private long processingDuration;
    private PlanKey planKey;
    private String planName;
    private int buildNumber;
    protected boolean markedForDeletion;
    private boolean onceOff;
    private boolean customBuild;
    private boolean rebuild;
    private Long logSize;
    private Date queueTime;
    private Date buildDate;
    private Date buildCancelledDate;
    private Date buildCompletedDate;
    private DeltaState deltaState;
    private Set<LinkedJiraIssue> jiraIssues = new HashSet<LinkedJiraIssue>();
    private Map<String, String> customBuildData = new HashMap<String, String>();
    private List<Labelling> labellings = new ArrayList<Labelling>();
    private List<ArtifactLink> artifactLinks;
    private Set<TestClassResult> testClassResults = new HashSet<TestClassResult>();
    private List<CustomDataRow> customBuildDataRows = new ArrayList<CustomDataRow>();
    private Long timeToFix;
    private Long buildAgentId;
    private List<Comment> comments;
    List<RepositoryChangeset> repositoryChangesets;
    private List<ConsumedSubscription> subscriptions;
    private List<VariableSubstitution> substitutedVariables;
    private List<VariableContextSnapshot> variableContextLogs;
    private VariableContextBaseline variableContextBaseline;
    private String triggerReasonKey;
    private transient TriggerReason triggerReason;
    protected BuildState buildState;
    protected LifeCycleState lifeCycleState;
    private Long stageResultId;
    private AtomicInteger restartCount = new AtomicInteger(0);
    private int formatVersion = Integer.parseInt(BuildUtils.getCurrentBuildNumber());
    protected static final Supplier<CachedPlanManager> cachedPlanManagerRef = ComponentAccessor.CACHED_PLAN_MANAGER;
    private final transient Supplier<TriggerManager> triggerManagerRef = ComponentAccessor.TRIGGER_MANAGER;
    private final ResettableLazyReference<Optional<ImmutablePlan>> immutablePlanLazyReference = new ResettableLazyReference<Optional<ImmutablePlan>>(){

        @NotNull
        protected Optional<ImmutablePlan> create() {
            ImmutablePlan plan = ((CachedPlanManager)cachedPlanManagerRef.get()).getPlanByKey(AbstractResultsSummary.this.getPlanKey());
            return Optional.ofNullable(plan);
        }
    };

    @NotNull
    public ImmutablePlan getImmutablePlan() {
        return (ImmutablePlan)((Optional)this.immutablePlanLazyReference.get()).orElseThrow(() -> new IllegalStateException("Unable to find Plan for " + this.getPlanResultKey()));
    }

    @NotNull
    public Optional<? extends ImmutablePlan> getPlanIfExists() {
        return (Optional)this.immutablePlanLazyReference.get();
    }

    @NotNull
    public String getBuildResultKey() {
        return this.getPlanKey() + "-" + this.getBuildNumber();
    }

    @NotNull
    public String getBuildKey() {
        return this.getPlanKey().getKey();
    }

    @NotNull
    public String getPlanName() {
        return StringUtils.defaultString((String)this.planName, (String)this.planKey.getKey());
    }

    public void setPlanName(@NotNull String planName) {
        this.planName = planName;
    }

    public String getReasonSummary() {
        if (!StringUtils.isEmpty((CharSequence)this.reasonSummary)) {
            return this.reasonSummary;
        }
        if (this.getTriggerReason() != null) {
            TriggerReasonRenderer reasonRenderer;
            if (this.getTriggerManager() != null && StringUtils.isEmpty((CharSequence)this.reasonSummary) && (reasonRenderer = this.getTriggerManager().getTriggerReasonRenderer(this.getTriggerReason(), (ResultsSummary)this)) != null) {
                this.reasonSummary = reasonRenderer.getShortDescriptionHtml();
                if (this.reasonSummary != null) {
                    this.reasonSummary = this.reasonSummary.trim();
                }
                return this.reasonSummary;
            }
            return this.getTriggerReason().getName();
        }
        return TextProviderUtils.getText("global.unknown");
    }

    @Override
    public void setBuildKey(String buildKey) {
        this.immutablePlanLazyReference.reset();
        this.planKey = PlanKeys.getPlanKey((String)buildKey);
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    public Date getBuildDate() {
        return this.buildDate;
    }

    public void setBuildDate(Date buildDate) {
        this.buildDate = buildDate;
    }

    public Date getQueueTime() {
        return this.queueTime;
    }

    public void setQueueTime(Date queueTime) {
        this.queueTime = queueTime;
    }

    public Date getBuildCompletedDate() {
        return this.buildCompletedDate;
    }

    public void setBuildCompletedDate(Date buildCompletedDate) {
        this.buildCompletedDate = buildCompletedDate;
    }

    public DeltaState getDeltaState() {
        return this.deltaState;
    }

    public void setDeltaState(DeltaState deltaState) {
        this.deltaState = deltaState;
    }

    public boolean isOnceOff() {
        return this.onceOff;
    }

    public void setOnceOff(boolean onceOff) {
        this.onceOff = onceOff;
    }

    public boolean isCustomBuild() {
        return this.customBuild;
    }

    public void setCustomBuild(boolean customBuild) {
        this.customBuild = customBuild;
    }

    public boolean isRebuild() {
        return this.rebuild;
    }

    public void setRebuild(boolean rebuild) {
        this.rebuild = rebuild;
    }

    @Nullable
    public Long getLogSize() {
        return this.logSize;
    }

    public void setLogSize(@Nullable Long logSize) {
        this.logSize = logSize;
    }

    @NotNull
    public Set<LinkedJiraIssue> getJiraIssues() {
        return this.jiraIssues;
    }

    public void setJiraIssues(Set<LinkedJiraIssue> jiraIssues) {
        this.jiraIssues = jiraIssues;
    }

    @NotNull
    public Map<String, String> getCustomBuildData() {
        return this.customBuildData;
    }

    public void setCustomBuildData(Map<String, String> customBuildData) {
        this.customBuildData = customBuildData;
    }

    public void updateCustomDataEntry(@NotNull String key, @NotNull String value) {
        this.customBuildData.put(key, value);
    }

    public Long getTimeToFix() {
        return this.timeToFix;
    }

    public void setTimeToFix(Long timeToFix) {
        this.timeToFix = timeToFix;
    }

    public List<Labelling> getLabellings() {
        return this.labellings;
    }

    public void setLabellings(List<Labelling> labellings) {
        this.labellings = labellings;
    }

    public void setComments(List<Comment> comments) {
        this.comments = comments;
    }

    @NotNull
    public List<ArtifactLink> getArtifactLinks() {
        if (this.artifactLinks == null) {
            this.artifactLinks = new ArrayList<ArtifactLink>();
        }
        return this.artifactLinks;
    }

    public void setArtifactLinks(List<ArtifactLink> artifactLinks) {
        this.artifactLinks = artifactLinks;
    }

    @NotNull
    public List<ConsumedSubscription> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<ConsumedSubscription>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(List<ConsumedSubscription> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public String getTriggerReasonKey() {
        return this.triggerReasonKey;
    }

    public void setTriggerReasonKey(String triggerReasonKey) {
        if (!"com.atlassian.bamboo.plugin.system.triggerReason:UnknownTriggerReason".equals(triggerReasonKey)) {
            this.triggerReasonKey = triggerReasonKey;
        }
    }

    @NotNull
    public TriggerReason getTriggerReason() {
        if (this.triggerReason == null) {
            this.triggerReason = this.getTriggerManager().getTriggerReason(this.triggerReasonKey, (ResultsSummary)this);
        }
        return this.triggerReason;
    }

    public void setTriggerReason(TriggerReason triggerReason) {
        this.triggerReason = triggerReason;
        if (triggerReason != null && !(triggerReason instanceof UnknownTriggerReason)) {
            String key = triggerReason.getKey();
            this.setTriggerReasonKey(key);
            triggerReason.updateCustomData((BambooCustomDataAware)this);
        }
    }

    public Long getBuildAgentId() {
        return this.buildAgentId;
    }

    public void setBuildAgentId(long buildAgentId) {
        this.buildAgentId = buildAgentId;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getProcessingDuration() {
        return this.processingDuration;
    }

    public void setProcessingDuration(long processingDuration) {
        this.processingDuration = processingDuration;
    }

    @Nullable
    public Date getBuildCancelledDate() {
        return this.buildCancelledDate;
    }

    public void setBuildCancelledDate(Date buildCancelledDate) {
        this.buildCancelledDate = buildCancelledDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getChangesListSummary() {
        if (this.changesListSummary == null) {
            AbstractResultsSummary abstractResultsSummary = this;
            synchronized (abstractResultsSummary) {
                this.changesListSummary = this.createChangeListSummary();
            }
        }
        return this.changesListSummary;
    }

    @Override
    protected TriggerManager getTriggerManager() {
        return (TriggerManager)this.triggerManagerRef.get();
    }

    public BuildState getBuildState() {
        return this.buildState;
    }

    public void setBuildState(BuildState buildState) {
        this.buildState = buildState;
    }

    public LifeCycleState getLifeCycleState() {
        return this.lifeCycleState;
    }

    public void setLifeCycleState(LifeCycleState lifeCycleState) {
        this.lifeCycleState = lifeCycleState;
    }

    public void updateLifeCycleState(@NotNull LifeCycleState lifeCycleState, @NotNull BuildState buildState) {
        if (lifeCycleState == LifeCycleState.NOT_BUILT && buildState != BuildState.UNKNOWN) {
            throw new IllegalArgumentException("When setting lifeCycleState to NOT_BUILT the only accepted buildState is UNKNOWN");
        }
        this.lifeCycleState = lifeCycleState;
        this.buildState = buildState;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(String discriminator) {
        this.discriminator = discriminator;
    }

    @NotNull
    public List<RepositoryChangeset> getRepositoryChangesets() {
        if (this.repositoryChangesets == null) {
            this.repositoryChangesets = new ArrayList<RepositoryChangeset>();
        }
        return this.repositoryChangesets;
    }

    @NotNull
    public List<VariableSubstitution> getSubstitutedVariables() {
        if (this.substitutedVariables == null) {
            this.substitutedVariables = new ArrayList<VariableSubstitution>();
        }
        return this.substitutedVariables;
    }

    public void setSubstitutedVariables(List<VariableSubstitution> substitutedVariables) {
        this.substitutedVariables = substitutedVariables;
    }

    @NotNull
    public List<VariableContextSnapshot> getVariableContextLogs() {
        if (this.variableContextLogs == null) {
            this.variableContextLogs = new ArrayList<VariableContextSnapshot>();
        }
        return this.variableContextLogs;
    }

    public void setVariableContextLogs(List<VariableContextSnapshot> variableContextLogs) {
        this.variableContextLogs = variableContextLogs;
    }

    @NotNull
    public Iterable<VariableContextSnapshot> getResultVariables() {
        return Iterables.filter(this.getVariableContextLogs(), (Predicate)VariableType.RESULT.isTypeEqual());
    }

    @NotNull
    public ImmutableList<VariableBaselineItem> getVariableContext() {
        return this.variableContextBaseline != null ? this.variableContextBaseline.getVariables() : ImmutableList.of();
    }

    public Long getVariableContextBaselineId() {
        return this.variableContextBaseline != null ? Long.valueOf(this.variableContextBaseline.getId()) : null;
    }

    public void setVariableContextBaseline(@Nullable VariableContextBaseline variableContextBaseline) {
        this.variableContextBaseline = variableContextBaseline;
    }

    @Nullable
    public VariableContextBaseline getVariableContextBaseline() {
        return this.variableContextBaseline;
    }

    @NotNull
    public TestResultsSummary getTestResultsSummary() {
        if (this.testResultsSummary == null) {
            this.testResultsSummary = new TestResultsSummaryImpl();
        }
        return this.testResultsSummary;
    }

    public void setTestResultsSummary(@NotNull TestResultsSummary testResultsSummary) {
        this.testResultsSummary = testResultsSummary;
    }

    @NotNull
    public List<TestClassResult> getTestClassResults() {
        return ImmutableList.copyOf(this.testClassResults);
    }

    public void resetTestClassResults(@NotNull List<TestClassResult> testClassResults) {
        this.testClassResults.clear();
        this.testClassResults.addAll(testClassResults);
    }

    public List<CustomDataRow> getCustomBuildDataRows() {
        return this.customBuildDataRows;
    }

    private void setCustomBuildDataRows(List<CustomDataRow> customBuildDataRows) {
        this.customBuildDataRows = customBuildDataRows;
    }

    public Long getStageResultId() {
        return this.stageResultId;
    }

    public void setStageResultId(Long stageResultId) {
        this.stageResultId = stageResultId;
    }

    public int getRestartCount() {
        return this.restartCount.get();
    }

    public int incrementRestartCount() {
        return this.restartCount.addAndGet(1);
    }

    public void setRestartCount(int restartCount) {
        this.restartCount = new AtomicInteger(restartCount);
    }

    @NotNull
    public PlanKey getPlanKey() {
        return this.planKey;
    }

    @Override
    public void setPlanKey(PlanKey planKey) {
        this.planKey = planKey;
    }

    public int getFormatVersion() {
        return this.formatVersion;
    }

    public void updateFormatVersion() {
        this.formatVersion = Integer.parseInt(BuildUtils.getCurrentBuildNumber());
    }

    public void setFormatVersion(int formatVersion) {
        this.formatVersion = formatVersion;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("planKey", (Object)this.planKey).append("buildNumber", this.buildNumber).toString();
    }
}

