/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.resultsummary.AgentBuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.AgentResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.google.common.collect.Iterables;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AgentBuildResultsSummaryManagerImpl
implements AgentResultsSummaryManager {
    private AgentBuildResultsSummaryDao agentBuildResultsSummaryDao;
    private BuildResultsSummaryDao buildResultsSummaryDao;

    public AgentBuildResultsSummaryManagerImpl(@NotNull AgentBuildResultsSummaryDao agentBuildResultsSummaryDao, @NotNull BuildResultsSummaryDao buildResultsSummaryDao) {
        this.agentBuildResultsSummaryDao = agentBuildResultsSummaryDao;
        this.buildResultsSummaryDao = buildResultsSummaryDao;
    }

    @Nullable
    public BuildResultsSummary getLastBuildForAgent(@NotNull String planKey, @NotNull Long agentId) {
        BuildResultsSummaryCriteria criteria = new BuildResultsSummaryCriteria(planKey);
        criteria.setAgentId(agentId);
        criteria.setMaxRowCount(1);
        criteria.setSortAscending(false);
        List buildResults = this.buildResultsSummaryDao.findResultsSummaries((ResultsSummaryCriteria)criteria);
        return (BuildResultsSummary)Iterables.getOnlyElement((Iterable)buildResults, null);
    }

    @Nullable
    public BuildResultsSummary getLastSuccessfulBuildForAgent(@NotNull String planKey, @NotNull Long agentId) {
        BuildResultsSummaryCriteria criteria = new BuildResultsSummaryCriteria(planKey);
        criteria.setAgentId(agentId);
        criteria.setMaxRowCount(1);
        criteria.setSortAscending(false);
        criteria.setBuildState(BuildState.SUCCESS);
        List buildResults = this.buildResultsSummaryDao.findResultsSummaries((ResultsSummaryCriteria)criteria);
        return (BuildResultsSummary)Iterables.getFirst((Iterable)buildResults, null);
    }

    public int countBuildResultsSummariesForAgent(@NotNull BuildAgent buildAgent) {
        BuildResultsSummaryCriteria criteria = new BuildResultsSummaryCriteria();
        criteria.setAgentId(Long.valueOf(buildAgent.getId()));
        return Math.toIntExact(this.buildResultsSummaryDao.countResultSummaries((ResultsSummaryCriteria)criteria));
    }

    public int countFailedBuildResultsSummariesForAgent(@NotNull BuildAgent buildAgent) {
        BuildResultsSummaryCriteria criteria = new BuildResultsSummaryCriteria();
        criteria.setAgentId(Long.valueOf(buildAgent.getId()));
        criteria.setBuildState(BuildState.FAILED);
        return Math.toIntExact(this.buildResultsSummaryDao.countResultSummaries((ResultsSummaryCriteria)criteria));
    }

    @NotNull
    public List<BuildResultsSummary> getAllBuildResultsSummariesForAgent(@NotNull Long agentId) {
        BuildResultsSummaryCriteria criteria = new BuildResultsSummaryCriteria();
        criteria.setAgentId(agentId);
        return this.buildResultsSummaryDao.findResultsSummaries((ResultsSummaryCriteria)criteria);
    }

    @NotNull
    public List<BuildResultsSummary> getBuildResultsSummariesForAgent(@NotNull Long agentId, int firstResult, int maxResult) {
        BuildResultsSummaryCriteria criteria = new BuildResultsSummaryCriteria();
        criteria.setAgentId(agentId);
        criteria.setFirstResult(firstResult);
        criteria.setMaxRowCount(maxResult);
        return this.buildResultsSummaryDao.findResultsSummaries((ResultsSummaryCriteria)criteria);
    }

    public long getNumberOfSummariesForAgent(long agentId) {
        BuildResultsSummaryCriteria criteria = new BuildResultsSummaryCriteria();
        criteria.setAgentId(Long.valueOf(agentId));
        return this.buildResultsSummaryDao.countResultSummaries((ResultsSummaryCriteria)criteria);
    }

    @NotNull
    public List<BuildResultsSummary> getLatestSummariesForAgent(@NotNull Long agentId, @NotNull Date fromDate) {
        BuildResultsSummaryCriteria criteria = new BuildResultsSummaryCriteria();
        criteria.setAgentId(agentId);
        criteria.setFromDate(fromDate);
        return this.buildResultsSummaryDao.findResultsSummaries((ResultsSummaryCriteria)criteria);
    }

    @NotNull
    public List<BuildResultsSummary> getLatestSummariesForAgent(@NotNull Long agentId, int maxCount) {
        BuildResultsSummaryCriteria criteria = new BuildResultsSummaryCriteria();
        criteria.setAgentId(agentId);
        criteria.setMaxRowCount(maxCount);
        return this.buildResultsSummaryDao.findResultsSummaries((ResultsSummaryCriteria)criteria);
    }

    @Nullable
    public BuildResultsSummary getLatestSummaryForAgent(long agentId) {
        List<BuildResultsSummary> results = this.getLatestSummariesForAgent((Long)agentId, 1);
        return (BuildResultsSummary)Iterables.getFirst(results, null);
    }

    public long calculateUtilisedAgentTime(@NotNull long agentId) {
        return this.agentBuildResultsSummaryDao.calculateUtilisedAgentTime(agentId);
    }
}

