/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.artifact.Artifact;
import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkDataProvider;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.comment.CommentManager;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitPredicates;
import com.atlassian.bamboo.core.BambooEntityObject;
import com.atlassian.bamboo.jira.jiraissues.JiraIssuePredicates;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.labels.Labelling;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.trigger.TriggerManager;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.util.HtmlUtils;
import com.atlassian.bamboo.util.TextProviderUtils;
import com.atlassian.bamboo.utils.DurationUtils;
import com.atlassian.bamboo.variable.VariableSubstitution;
import com.atlassian.bamboo.variable.VariableType;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jetbrains.annotations.NotNull;

public abstract class BaseResultSummary
extends BambooEntityObject
implements ImmutableResultsSummary {
    private static final int MAX_POPUP_LINE_COUNT = 15;
    protected static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");

    public boolean isFailed() {
        return this.getBuildState() == BuildState.FAILED;
    }

    public boolean isSuccessful() {
        return this.getBuildState() == BuildState.SUCCESS;
    }

    public boolean isPending() {
        return LifeCycleState.isPending((LifeCycleState)this.getLifeCycleState());
    }

    public boolean isQueued() {
        return LifeCycleState.isQueued((LifeCycleState)this.getLifeCycleState());
    }

    public boolean isInProgress() {
        return LifeCycleState.isInProgress((LifeCycleState)this.getLifeCycleState());
    }

    public boolean isNotBuilt() {
        return LifeCycleState.isNotBuilt((LifeCycleState)this.getLifeCycleState());
    }

    public boolean isFinalized() {
        return LifeCycleState.isFinalized((LifeCycleState)this.getLifeCycleState());
    }

    public boolean isFinished() {
        return LifeCycleState.isFinished((LifeCycleState)this.getLifeCycleState());
    }

    public boolean isWaiting() {
        return LifeCycleState.isWaiting((LifeCycleState)this.getLifeCycleState());
    }

    public boolean isActive() {
        return LifeCycleState.isActive((LifeCycleState)this.getLifeCycleState());
    }

    @NotNull
    public PlanResultKey getPlanResultKey() {
        return PlanKeys.getPlanResultKey((PlanKey)this.getPlanKey(), (int)this.getBuildNumber());
    }

    @NotNull
    public String getDurationDescription() {
        double duration = this.getDuration();
        if (duration > 0.0) {
            return DurationUtils.getPrettyPrint((long)((long)duration));
        }
        return TextProviderUtils.getText("global.unknown");
    }

    public String getRelativeBuildDate() {
        String buildDate = this.getRelativeBuildDate(new Date());
        return StringUtils.replace((String)buildDate, (String)"before", (String)"ago");
    }

    public String getRelativeQueueDate() {
        String queueDate = this.getRelativeQueueDate(new Date());
        return StringUtils.replace((String)queueDate, (String)"before", (String)"ago");
    }

    public String getRelativeBuildStartedDate() {
        String buildDate = this.getRelativeBuildStartedDate(new Date());
        return StringUtils.replace((String)buildDate, (String)"before", (String)"ago");
    }

    public String getRelativeBuildDate(Date comparedTo) {
        return this.getBuildCompletedDate() == null ? "" : DurationUtils.getRelativeDate((Date)this.getBuildCompletedDate(), (Date)comparedTo) + " " + "before";
    }

    public String getRelativeQueueDate(Date comparedTo) {
        return this.getQueueTime() == null ? "" : DurationUtils.getRelativeDate((Date)this.getQueueTime(), (Date)comparedTo) + " " + "before";
    }

    public String getRelativeBuildStartedDate(Date comparedTo) {
        return this.getBuildDate() == null ? "" : DurationUtils.getRelativeDate((Date)this.getBuildDate(), (Date)comparedTo) + " " + "before";
    }

    public String getShortReasonSummary() {
        if (this.getTriggerReason() != null) {
            return this.getTriggerReason().getName();
        }
        return TextProviderUtils.getText("global.unknown");
    }

    protected abstract TriggerManager getTriggerManager();

    @NotNull
    public Set<LinkedJiraIssue> getFixingJiraIssues() {
        return this.getJiraIssues().stream().filter(JiraIssuePredicates::isIssueFixed).collect(Collectors.toCollection(TreeSet::new));
    }

    @NotNull
    public Set<LinkedJiraIssue> getRelatedJiraIssues() {
        return this.getJiraIssues().stream().filter(JiraIssuePredicates::isIssueRelated).collect(Collectors.toCollection(TreeSet::new));
    }

    public boolean hasChanges() {
        return CollectionUtils.isNotEmpty(this.getUniqueAuthors());
    }

    @NotNull
    public Date getStatDate() {
        Date buildDate1 = this.getBuildDate();
        if (buildDate1 != null) {
            return buildDate1;
        }
        Date queueTime1 = this.getQueueTime();
        if (queueTime1 != null) {
            return queueTime1;
        }
        return this.getCreationDate();
    }

    public Set<String> getJiraIssueKeys() {
        HashSet<String> issueKeys = new HashSet<String>();
        Set issues = this.getJiraIssues();
        for (LinkedJiraIssue issue : issues) {
            issueKeys.add(issue.getIssueKey());
        }
        return issueKeys;
    }

    @NotNull
    public List<String> getLabelNames() {
        List labellings = this.getLabellings();
        if (labellings != null) {
            return labellings.stream().map(Labelling::getLabel).map(Label::getName).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public Set<Author> getUniqueAuthors() {
        return this.getCommits().stream().filter(CommitPredicates::isCommitRelevantToBranch).map(Commit::getAuthor).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Deprecated
    public Collection<ArtifactLink> getArtifactLinksThatExist() {
        ArrayList<ArtifactLink> existingArtifactLinks = new ArrayList<ArtifactLink>();
        for (ArtifactLink artifactLink : this.getArtifactLinks()) {
            ArtifactLinkDataProvider artifactLinkDataProvider = ((ArtifactLinkManager)ComponentAccessor.ARTIFACT_LINK_MANAGER.get()).getArtifactLinkDataProvider((Artifact)artifactLink.getArtifact());
            if (artifactLinkDataProvider == null || !artifactLinkDataProvider.exists()) continue;
            existingArtifactLinks.add(artifactLink);
        }
        return existingArtifactLinks;
    }

    public String getProcessingDurationDescription() {
        double processingDuration = this.getProcessingDuration();
        if (processingDuration > 0.0) {
            return DurationUtils.getPrettyPrint((long)((long)processingDuration));
        }
        return TextProviderUtils.getText("global.unknown");
    }

    public String getBuildTime() {
        return DATE_FORMAT.format(this.getBuildDate());
    }

    protected String createChangeListSummary() {
        StringBuilder changeListPopup = new StringBuilder();
        int changeListPopupLineCount = 0;
        Iterator iterator = Iterables.filter(this.getCommits(), CommitPredicates::isCommitRelevantToBranch).iterator();
        while (iterator.hasNext()) {
            Commit commit = (Commit)iterator.next();
            Author author = commit.getAuthor();
            if (author == null) continue;
            changeListPopupLineCount = this.addPopupLine(changeListPopup, changeListPopupLineCount, "<strong>Who:</strong> ", HtmlUtils.getAsPreformattedText((Object)author.getFullName()));
            changeListPopupLineCount = this.addPopupLine(changeListPopup, changeListPopupLineCount, "<strong>Why:</strong> ", HtmlUtils.getAsPreformattedText((Object)commit.getComment()));
            if (!iterator.hasNext()) continue;
            this.addLineToPopup(changeListPopup, "<hr />", changeListPopupLineCount++);
        }
        String summaryText = changeListPopup.toString();
        summaryText = StringUtils.replace((String)summaryText, (String)"'", (String)"\"");
        summaryText = StringUtils.replace((String)summaryText, (String)"\r\n", (String)"");
        summaryText = StringUtils.replace((String)summaryText, (String)"\n", (String)"");
        return summaryText;
    }

    public ImmutableList<Commit> getCommits() {
        ImmutableList.Builder b = ImmutableList.builder();
        for (RepositoryChangeset repositoryChangeset : this.getRepositoryChangesets()) {
            b.addAll((Iterable)repositoryChangeset.getCommits());
        }
        return b.build();
    }

    @NotNull
    public String getTestSummary() {
        return this.getTestResultsSummary().getTestSummaryDescription();
    }

    private int addPopupLine(StringBuilder changeListPopup, int changeListPopupLineCount, String lineHeading, String lineInfo) {
        String line = lineHeading;
        if (lineInfo != null) {
            line = line + lineInfo;
        }
        this.addLineToPopup(changeListPopup, line, changeListPopupLineCount++);
        return changeListPopupLineCount;
    }

    private void addLineToPopup(StringBuilder changeListPopup, String line, int changeListPopupLineCount) {
        if (changeListPopupLineCount < 15) {
            changeListPopup.append(line);
            if (!"<hr />".equals(line)) {
                changeListPopup.append("<br />");
            }
        } else if (changeListPopupLineCount == 15) {
            changeListPopup.append("... ");
        }
    }

    public int compareTo(ImmutableResultsSummary resultsSummary) {
        if (resultsSummary == null) {
            return -1;
        }
        return new CompareToBuilder().append((Object)this.getBuildCompletedDate(), (Object)resultsSummary.getBuildCompletedDate()).toComparison();
    }

    public boolean equals(Object object) {
        if (!(object instanceof ImmutableResultsSummary)) {
            return false;
        }
        ImmutableResultsSummary summary = (ImmutableResultsSummary)object;
        return new EqualsBuilder().append((Object)this.getPlanKey(), (Object)summary.getPlanKey()).append(this.getBuildNumber(), summary.getBuildNumber()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(23, 71).append((Object)this.getPlanKey()).append(this.getBuildNumber()).toHashCode();
    }

    public List<VariableSubstitution> getManuallyOverriddenVariables() {
        return this.getSubstitutedVariables().stream().filter(arg_0 -> ((Predicate)VariableType.MANUAL.isTypeEqual()).apply(arg_0)).collect(Collectors.toList());
    }

    public boolean hasComments() {
        return ((CommentManager)ComponentAccessor.COMMENT_MANAGER.get()).getEntityCommentCount(this.getId()) > 0;
    }
}

