/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.container.PersisterFactory;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.results.ExtraBuildResultsData;
import com.atlassian.bamboo.resultsummary.AbstractResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.FilteredTestResults;
import com.atlassian.bamboo.resultsummary.tests.FilteredTestResultsImpl;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.v2.build.trigger.TriggerReason;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildResultsSummaryImpl
extends AbstractResultsSummary
implements BuildResultsSummary {
    private Date vcsUpdateTime;
    private ChainResultsSummary chainResultsSummary;
    private transient FilteredTestResults filteredTestResults;
    private List<ArtifactLink> producedArtifactLinks;
    private List<RepositoryChangeset> relevantChangesets;
    private final ResettableLazyReference<Optional<ImmutableChain>> immutableChainLazyReference = new ResettableLazyReference<Optional<ImmutableChain>>(){

        @NotNull
        protected Optional<ImmutableChain> create() {
            ImmutableChain plan = (ImmutableChain)((CachedPlanManager)AbstractResultsSummary.cachedPlanManagerRef.get()).getPlanByKey(PlanKeys.getChainKeyFromJobKey((PlanKey)BuildResultsSummaryImpl.this.getPlanKey()), ImmutableChain.class);
            return Optional.ofNullable(plan);
        }
    };

    @NotNull
    public ImmutableChain getImmutableChain() {
        return (ImmutableChain)((Optional)this.immutableChainLazyReference.get()).orElseThrow(() -> new IllegalStateException("Unable to find chain for " + this.getPlanResultKey()));
    }

    @Nullable
    public FilteredTestResults getFilteredTestResults() {
        if (this.filteredTestResults == null && this.isFinished()) {
            this.filteredTestResults = new FilteredTestResultsImpl(this);
        }
        return this.filteredTestResults;
    }

    @Nullable
    public ExtraBuildResultsData getExtraBuildResultsData() {
        return PersisterFactory.getInstance().getBuildResults((Key)this.getPlanKey(), this.getBuildNumber());
    }

    @Nullable
    public ChainResultsSummary getChainResultsSummary() {
        return this.chainResultsSummary;
    }

    @NotNull
    public String getFullPlanName() {
        if (this.chainResultsSummary != null) {
            return this.chainResultsSummary.getFullPlanName() + " - " + this.getPlanName();
        }
        return this.getPlanName();
    }

    public void setChainResultsSummary(@NotNull ChainResultsSummary chainResultsSummary) {
        this.chainResultsSummary = chainResultsSummary;
    }

    @NotNull
    public List<ArtifactLink> getProducedArtifactLinks() {
        if (this.producedArtifactLinks == null) {
            this.producedArtifactLinks = new ArrayList<ArtifactLink>();
        }
        return this.producedArtifactLinks;
    }

    protected void setProducedArtifactLinks(@Nullable List<ArtifactLink> producedArtifactLinks) {
        this.producedArtifactLinks = producedArtifactLinks;
    }

    public long getQueueDuration() {
        return this.getTimeDelta(this.getQueueTime(), this.getVcsUpdateTime());
    }

    public Date getVcsUpdateTime() {
        return this.vcsUpdateTime;
    }

    public long getVcsUpdateDuration() {
        return this.getTimeDelta(this.getVcsUpdateTime(), this.getBuildDate());
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public void setMarkedForDeletion(boolean markedForDeletion) {
        this.markedForDeletion = markedForDeletion;
    }

    @Override
    @NotNull
    public List<RepositoryChangeset> getRepositoryChangesets() {
        if (this.relevantChangesets == null) {
            this.relevantChangesets = new ArrayList<RepositoryChangeset>();
        }
        return this.relevantChangesets;
    }

    @Override
    public void setTriggerReason(TriggerReason triggerReason) {
        if (this.chainResultsSummary != null) {
            throw new UnsupportedOperationException("Cannot set TriggerReason on Job result");
        }
        super.setTriggerReason(triggerReason);
    }

    @Override
    @NotNull
    public TriggerReason getTriggerReason() {
        return this.chainResultsSummary != null ? this.getTriggerManager().getTriggerReason(this.chainResultsSummary, (BuildResultsSummary)this) : super.getTriggerReason();
    }

    public boolean isNotRunYet() {
        ChainResultsSummary chainResultsSummary = this.getChainResultsSummary();
        if (chainResultsSummary != null) {
            for (ChainStageResult stageResult : chainResultsSummary.getStageResults()) {
                if (stageResult.isRunnable()) {
                    return true;
                }
                for (BuildResultsSummary jobResult : stageResult.getBuildResults()) {
                    if (!jobResult.getPlanResultKey().equals((Object)this.getPlanResultKey())) continue;
                    return false;
                }
            }
        }
        return false;
    }

    public void setVcsUpdateTime(Date vcsUpdateTime) {
        this.vcsUpdateTime = vcsUpdateTime;
    }

    private long getTimeDelta(@Nullable Date a, @Nullable Date b) {
        if (a == null) {
            return 0L;
        }
        if (b == null) {
            if (!this.isActive()) {
                return 0L;
            }
            b = new Date();
        }
        return b.getTime() - a.getTime();
    }
}

