/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.ExtendedAuthor;
import com.atlassian.bamboo.author.ExtendedAuthorManager;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.build.artifact.ArtifactLinkManager;
import com.atlassian.bamboo.build.monitoring.BuildHungDetails;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.DeltaState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainResultsSummaryImpl;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.chains.branches.MergeResultSummary;
import com.atlassian.bamboo.comment.CommentManager;
import com.atlassian.bamboo.commit.Commit;
import com.atlassian.bamboo.commit.CommitContext;
import com.atlassian.bamboo.commit.CommitDao;
import com.atlassian.bamboo.commit.CommitImpl;
import com.atlassian.bamboo.commit.UnassociatedCommit;
import com.atlassian.bamboo.container.PersisterFactory;
import com.atlassian.bamboo.core.BambooCustomDataAware;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.core.BambooObject;
import com.atlassian.bamboo.event.BuildResultDeletedEvent;
import com.atlassian.bamboo.event.ChainResultDeletedEvent;
import com.atlassian.bamboo.index.BuildResultsIndexer;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueHelper;
import com.atlassian.bamboo.jira.jiraissues.JiraIssueUtils;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssueImpl;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.persister.Persister;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanClassHelper;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.artifact.ArtifactContext;
import com.atlassian.bamboo.plan.artifact.ArtifactPublishingResult;
import com.atlassian.bamboo.plan.branch.BranchIntegrationConfiguration;
import com.atlassian.bamboo.plan.branch.BranchIntegrationService;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.RepositoryData;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.results.BuildResults;
import com.atlassian.bamboo.resultsummary.AbstractResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryDao;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.ExpiryCriteria;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.IncorrectResultSummaryTypeException;
import com.atlassian.bamboo.resultsummary.MergeResultSummaryDao;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultSummaryClassHelper;
import com.atlassian.bamboo.resultsummary.ResultSummaryHelper;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCreationException;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteriaBuilder;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummary;
import com.atlassian.bamboo.resultsummary.tests.TestResultsSummaryImpl;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangesetImpl;
import com.atlassian.bamboo.serialization.ServerSideOnly;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.atlassian.bamboo.util.BambooDateUtils;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.FirstException;
import com.atlassian.bamboo.utils.Pair;
import com.atlassian.bamboo.utils.Range;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.atlassian.bamboo.v2.build.BuildRepositoryChanges;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.variable.StageVariableContextImpl;
import com.atlassian.bamboo.variable.VariableContext;
import com.atlassian.bamboo.variable.VariableContextSnapshotImpl;
import com.atlassian.bamboo.variable.VariableDefinitionContext;
import com.atlassian.bamboo.variable.VariableType;
import com.atlassian.bamboo.variable.baseline.VariableContextBaselineDao;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.configuration.VcsRepositoryData;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ServerSideOnly
public class BuildResultsSummaryManagerImpl
implements BuildResultsSummaryManager,
ResultsSummaryManager {
    private static final Logger log = Logger.getLogger(BuildResultsSummaryManagerImpl.class);
    private final Map<Class, Class> typeRegistry = new ImmutableMap.Builder().put(BuildResultsSummary.class, BuildResultsSummaryImpl.class).put(ChainResultsSummary.class, ChainResultsSummaryImpl.class).build();
    private BuildResultsSummaryDao buildResultsSummaryDao;
    private ExtendedAuthorManager extendedAuthorManager;
    private BuildResultsIndexer buildResultsIndexer;
    private EventPublisher eventPublisher;
    private JiraIssueHelper jiraIssueUtils;
    private ArtifactLinkManager artifactLinkManager;
    private CommitDao commitDao;
    private BuildExecutionManager buildExecutionManager;
    private MergeResultSummaryDao mergeResultSummaryDao;
    private RepositoryDefinitionManager repositoryDefinitionManager;
    private CommentManager commentManager;
    private BranchIntegrationService branchIntegrationService;
    private VariableContextBaselineDao variableContextBaselineDao;
    private PlanManager planManager;
    private VcsRepositoryManager vcsRepositoryManager;
    @Inject
    private StorageLocationService storageLocationService;

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesForPlanByLifeCycleState(@NotNull Plan plan, @NotNull LifeCycleState lifeCycleState, int firstResult, int maxResults) {
        return this.buildResultsSummaryDao.getResultSummariesForPlanByLifeCycleState(plan, lifeCycleState, firstResult, maxResults);
    }

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesForPlan(@NotNull ImmutablePlan plan, int firstResult, int maxResults) {
        return this.buildResultsSummaryDao.getResultSummariesForPlan(plan, firstResult, maxResults);
    }

    @Nullable
    public ChainStageResult getChainStageResultById(@NotNull Long id) {
        return this.buildResultsSummaryDao.getChainStageResultById(id.longValue());
    }

    @Nullable
    public ResultsSummary getResultsSummary(@NotNull PlanResultKey planResultKey) {
        return this.getResultsSummary(planResultKey, ResultsSummary.class, ResultDataRead.LAZY);
    }

    @Nullable
    public ResultsSummary getResultsSummary(@NotNull PlanResultKey planResultKey, ResultDataRead dataRead) {
        return this.getResultsSummary(planResultKey, ResultsSummary.class, dataRead);
    }

    @Nullable
    public <T extends ResultsSummary> T getResultsSummary(@NotNull PlanResultKey planResultKey, @NotNull Class<T> aClass) {
        return this.getResultsSummary(planResultKey, aClass, ResultDataRead.LAZY);
    }

    @Nullable
    public <T extends ResultsSummary> T getResultsSummary(@NotNull PlanResultKey planResultKey, @NotNull Class<T> aClass, ResultDataRead dataRead) {
        ResultsSummary resultsSummary = this.buildResultsSummaryDao.getResultsSummary(planResultKey, ResultsSummary.class, dataRead);
        if (resultsSummary != null && (resultsSummary = (ResultsSummary)Narrow.to((Object)resultsSummary, aClass)) == null) {
            throw new IncorrectResultSummaryTypeException("Result cannot be found by key '" + planResultKey + "' with type '" + aClass + "'");
        }
        return (T)resultsSummary;
    }

    public ResultsSummary getResultsSummary(long id) {
        return (ResultsSummary)this.buildResultsSummaryDao.findById(id, ResultsSummary.class);
    }

    @NotNull
    private List<RepositoryChangeset> getRepositoryChangesets(ChainResultsSummary resultsSummary, Iterable<BuildRepositoryChanges> repositoryChanges) throws ResultsSummaryCreationException {
        ArrayList<RepositoryChangeset> repositoryChangesets = new ArrayList<RepositoryChangeset>();
        ImmutableChain plan = resultsSummary.getImmutablePlan();
        List chainRepositories = plan.getPlanRepositoryDefinitions();
        BranchIntegrationConfiguration branchIntegrationConfiguration = plan.getBuildDefinition().getBranchIntegrationConfiguration();
        VcsRepositoryData integrationRepositoryDefinition = null;
        if (branchIntegrationConfiguration.isEnabled()) {
            integrationRepositoryDefinition = this.branchIntegrationService.getIntegrationRepository((ImmutablePlan)plan);
        }
        for (BuildRepositoryChanges repositoryChange : repositoryChanges) {
            long repositoryId = repositoryChange.getRepositoryId();
            if (repositoryId == -1L) continue;
            RepositoryDataEntity repositoryDataEntity = this.repositoryDefinitionManager.getRepositoryDataEntity(repositoryId);
            if (repositoryDataEntity == null) {
                throw new ResultsSummaryCreationException(String.format("Build changes refer repository id %d which does not exist in the database", repositoryId));
            }
            PlanRepositoryDefinition repositoryDefinition = (PlanRepositoryDefinition)chainRepositories.stream().collect(Collectors.toMap(BambooIdProvider::getId, java.util.function.Function.identity())).get(repositoryId);
            if (repositoryDefinition == null && integrationRepositoryDefinition != null && repositoryId == integrationRepositoryDefinition.getId()) continue;
            if (repositoryDefinition == null && !ResultSummaryHelper.isBambooSpecResult((ImmutableResultsSummary)resultsSummary)) {
                throw new ResultsSummaryCreationException(String.format("Build changes refer repository id %d which does not exist in the plan", repositoryId));
            }
            int position = repositoryDefinition == null ? 0 : chainRepositories.indexOf(repositoryDefinition);
            RepositoryChangesetImpl repositoryChangeset = new RepositoryChangesetImpl(repositoryDataEntity, (ResultsSummary)resultsSummary, repositoryChange.getVcsRevisionKey(), repositoryChange.getSkippedCommitsCount(), position, false);
            for (CommitContext commit : repositoryChange.getChanges()) {
                Commit processedCommit = this.generateCommitFromChangeLogs(commit, repositoryChangeset);
                repositoryChangeset.getCommits().add(processedCommit);
                String commitComment = processedCommit.getComment();
                LinkedHashSet<String> keys = this.jiraIssueUtils.findPotentialIssueKeys(commitComment, false, JiraIssueUtils.RESTRICTIVE_ISSUE_KEY_BOUNDARY_REGEX, JiraIssueUtils.LENIENT_ISSUE_KEY_BOUNDARY_REGEX);
                for (String key : keys) {
                    LinkedJiraIssueImpl issue = new LinkedJiraIssueImpl(key);
                    issue.setResultsSummary((ResultsSummary)resultsSummary);
                    resultsSummary.getJiraIssues().add(issue);
                }
            }
            repositoryChangesets.add(repositoryChangeset);
        }
        return repositoryChangesets;
    }

    public ResultsSummary resetResultSummary(@NotNull BuildResultsSummary resultsSummary) throws IOException {
        resultsSummary.setBuildAgentId(0L);
        resultsSummary.setBuildCancelledDate(null);
        resultsSummary.setBuildCompletedDate(null);
        resultsSummary.setBuildDate(null);
        resultsSummary.setDuration(0L);
        resultsSummary.setProcessingDuration(0L);
        resultsSummary.setQueueTime(null);
        resultsSummary.resetTestClassResults(new ArrayList());
        resultsSummary.setTestResultsSummary((TestResultsSummary)new TestResultsSummaryImpl());
        resultsSummary.setTimeToFix(Long.valueOf(0L));
        this.artifactLinkManager.removeProducedArtifactLinks(resultsSummary);
        this.removeBuildLogs(resultsSummary.getImmutablePlan(), resultsSummary.getBuildNumber());
        resultsSummary.getVariableContextLogs().clear();
        this.buildResultsIndexer.deIndexBuildResults((ResultsSummary)resultsSummary, true);
        return resultsSummary;
    }

    public void addVariableContextSnapshotToResultSummary(@NotNull ResultsSummary resultsSummary, @NotNull VariableContext variableContext) {
        if (resultsSummary instanceof ChainResultsSummary) {
            for (VariableDefinitionContext contextEntry : Iterables.filter(variableContext.getEffectiveVariables().values(), (Predicate)VariableType.MANUAL.isTypeEqual())) {
                resultsSummary.getVariableContextLogs().add(new VariableContextSnapshotImpl(contextEntry.getKey(), contextEntry.getValue(), contextEntry.getVariableType(), resultsSummary));
            }
        }
        ((AbstractResultsSummary)resultsSummary).setVariableContextBaseline(this.variableContextBaselineDao.resolveVariableContextBaseline(variableContext));
    }

    public void updateVariablesOnContinuedBuild(@NotNull ResultsSummary resultsSummary, @NotNull VariableContext variableContext) {
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)Narrow.downTo((Object)resultsSummary, ChainResultsSummary.class);
        if (chainResultsSummary != null) {
            for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
                if (!chainStageResult.isPending()) continue;
                chainStageResult.getManualVariables().clear();
                for (VariableDefinitionContext contextEntry : Iterables.filter(variableContext.getEffectiveVariables().values(), (Predicate)VariableType.MANUAL.isTypeEqual())) {
                    chainStageResult.getManualVariables().add(new StageVariableContextImpl(contextEntry.getKey(), contextEntry.getValue(), contextEntry.getVariableType(), chainStageResult));
                }
            }
        }
    }

    public void clearVariablesOnRerunBuild(@NotNull ResultsSummary resultsSummary) {
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)Narrow.downTo((Object)resultsSummary, ChainResultsSummary.class);
        if (chainResultsSummary != null) {
            for (ChainStageResult chainStageResult : chainResultsSummary.getStageResults()) {
                chainStageResult.getManualVariables().clear();
            }
        }
    }

    public void postBuildVariableSnapshotUpdate(@NotNull ResultsSummary resultsSummary, @NotNull VariableContext variableContext) {
        if (resultsSummary instanceof BuildResultsSummary && resultsSummary.isSuccessful()) {
            resultsSummary.getVariableContextLogs().clear();
            for (VariableDefinitionContext contextEntry : variableContext.getResultVariables().values()) {
                resultsSummary.getVariableContextLogs().add(new VariableContextSnapshotImpl(contextEntry.getKey(), contextEntry.getValue(), contextEntry.getVariableType(), resultsSummary));
            }
        }
    }

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllPendingResultSummaries(Class<T> aClass) {
        return this.buildResultsSummaryDao.getAllPendingResultSummaries(aClass);
    }

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllQueuedResultSummaries(Class<T> aClass) {
        return this.buildResultsSummaryDao.getAllQueuedResultSummaries(aClass);
    }

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllInProgressResultSummaries(Class<T> aClass) {
        return this.buildResultsSummaryDao.getAllInProgressResultSummaries(aClass);
    }

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllActiveResultSummariesForPlan(PlanKey planKey, Class<T> aClass) {
        return this.buildResultsSummaryDao.getAllActiveResultSummariesForPlan(planKey, aClass);
    }

    @NotNull
    public <T extends ResultsSummary> List<T> getFinalizedResultSummariesForPlan(PlanKey planKey, Class<T> aClass, int firstResult, int maxResults) {
        return this.buildResultsSummaryDao.getFinalizedResultSummariesForPlan(planKey, aClass, firstResult, maxResults);
    }

    public int getNumberOfConcurrentlyRunningBuilds(PlanKey planKey) {
        return this.buildResultsSummaryDao.getNumberOfConcurrentlyRunningBuilds(planKey);
    }

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllBuildResultSummariesInUnknownState(Class<T> aClass) {
        return this.buildResultsSummaryDao.getAllBuildResultSummariesInUnknownState(aClass);
    }

    public <T extends ResultsSummary> T createResultsSummary(@NotNull BuildContext buildContext, @NotNull Class<T> aClass) throws ResultsSummaryCreationException {
        return this.createResultsSummary(null, buildContext, aClass);
    }

    public <T extends ResultsSummary> T createResultsSummary(@Nullable ChainResultsSummary chainResultsSummary, @NotNull BuildContext buildContext, @NotNull Class<T> aClass) throws ResultsSummaryCreationException {
        if (this.getResultsSummary(buildContext.getPlanResultKey(), aClass) != null) {
            throw new ResultsSummaryCreationException("Build Result '" + buildContext.getBuildResultKey() + "' could not be created because one already exists");
        }
        buildContext.getBuildResult().setBuildState(BuildState.UNKNOWN);
        AbstractResultsSummary resultsSummary = this.createNewInstance(buildContext.getPlanResultKey(), aClass);
        try {
            resultsSummary.setBuildNumber(buildContext.getBuildNumber());
            resultsSummary.setBuildKey(buildContext.getTypedPlanKey().getKey());
            resultsSummary.setPlanName(buildContext.getShortName());
            resultsSummary.setBuildState(buildContext.getBuildResult().getBuildState());
            resultsSummary.setLifeCycleState(buildContext.getBuildResult().getLifeCycleState());
            resultsSummary.setCustomBuildData(new HashMap<String, String>(buildContext.getBuildResult().getCustomBuildData()));
            resultsSummary.setBuildDate(null);
            resultsSummary.setBuildCompletedDate(null);
            resultsSummary.setDuration(0L);
            resultsSummary.setProcessingDuration(0L);
            Collection<Object> changesets = null;
            resultsSummary.setOnceOff(buildContext.isOnceOff());
            resultsSummary.setCustomBuild(buildContext.isCustomBuild());
            if (resultsSummary instanceof ChainResultsSummary) {
                changesets = this.getRepositoryChangesets((ChainResultsSummary)resultsSummary, buildContext.getBuildChanges().getRepositoryChanges());
            } else if (resultsSummary instanceof BuildResultsSummary) {
                Set repositoriesUsedInJob = buildContext.getRelevantRepositoryIds();
                changesets = Collections2.filter((Collection)((ChainResultsSummary)Preconditions.checkNotNull((Object)chainResultsSummary, (Object)"Chain results summary was null")).getRepositoryChangesets(), input -> repositoriesUsedInJob.contains(input.getRepositoryData().getId()));
            }
            if (changesets != null) {
                resultsSummary.getRepositoryChangesets().addAll(changesets);
            }
            this.addVariableContextSnapshotToResultSummary(resultsSummary, buildContext.getVariableContext());
            resultsSummary.setTriggerReason(buildContext.getTriggerReason());
            return (T)resultsSummary;
        }
        catch (Exception e) {
            throw new ResultsSummaryCreationException("Build Result '" + buildContext.getBuildResultKey() + "' could not be created due to error:" + e, (Throwable)e);
        }
    }

    public void updateResultSummaryWithBuildChanges(@NotNull BuildContext buildContext) throws ResultsSummaryCreationException {
        ResultsSummary existingResultSummary = this.getResultsSummary(buildContext.getPlanResultKey(), ResultsSummary.class);
        if (existingResultSummary == null) {
            throw new ResultsSummaryCreationException("Can't update a results summary (" + buildContext.getPlanResultKey() + ") that doesn't exist.");
        }
        if (!existingResultSummary.getRepositoryChangesets().isEmpty()) {
            return;
        }
        Collection<Object> changesets = null;
        if (existingResultSummary instanceof ChainResultsSummary) {
            changesets = this.getRepositoryChangesets((ChainResultsSummary)existingResultSummary, buildContext.getBuildChanges().getRepositoryChanges());
        } else if (existingResultSummary instanceof BuildResultsSummary) {
            final Set repositoriesUsedInJob = buildContext.getRelevantRepositoryIds();
            ChainResultsSummary parentSummary = this.getParentResultSummary(existingResultSummary);
            changesets = Collections2.filter((Collection)((ChainResultsSummary)Preconditions.checkNotNull((Object)parentSummary, (Object)"Chain results summary was null")).getRepositoryChangesets(), (Predicate)new Predicate<RepositoryChangeset>(){

                public boolean apply(RepositoryChangeset input) {
                    return repositoriesUsedInJob.contains(input.getRepositoryData().getId());
                }
            });
        }
        if (changesets != null) {
            existingResultSummary.getRepositoryChangesets().addAll(changesets);
            buildContext.getTriggerReason().updateCustomData((BambooCustomDataAware)existingResultSummary);
        }
    }

    @NotNull
    public BuildResultsSummary updateBuildSummaryFromBuildResults(BuildContext buildContext, @NotNull CurrentlyBuilding currentlyBuilding, BuildResults buildResults) {
        Long currentlyBuildingAgent;
        PlanKey planKey = currentlyBuilding.getBuildIdentifier().getPlanResultKey().getPlanKey();
        BuildResultsSummaryImpl resultsSummary = (BuildResultsSummaryImpl)this.getBuildResultsSummary(planKey, buildResults.getBuildNumber());
        if (resultsSummary == null) {
            throw new IllegalStateException("No build result summary for plan: " + planKey + " and build number: " + buildResults.getBuildNumber() + " in updateBuildSummaryFromBuildResults");
        }
        ResultSummaryHelper.updateCancellationDetails(resultsSummary, currentlyBuilding.getBuildCancelledDetails());
        Date buildStartDate = buildResults.getStartTime();
        resultsSummary.setBuildDate(buildStartDate);
        resultsSummary.setBuildCompletedDate(buildResults.getBuildCompletedTimeStamp());
        resultsSummary.setDuration(buildResults.getBuildDurationInMilliseconds());
        resultsSummary.setProcessingDuration(buildResults.getBuildDurationInMilliseconds());
        resultsSummary.setQueueTime(currentlyBuilding.getQueueTime());
        resultsSummary.setVcsUpdateTime(currentlyBuilding.getVcsUpdateTime());
        resultsSummary.setLogSize(null);
        resultsSummary.setBuildState(buildResults.getBuildState());
        resultsSummary.setLifeCycleState(buildContext.getBuildResult().getLifeCycleState());
        if (buildStartDate != null) {
            buildContext.getBuildResult().getCustomBuildData().put("buildTimeStamp", BambooDateUtils.toIsoTimestampString((Date)buildStartDate));
        }
        this.calculateAndSetDeltaState(resultsSummary);
        resultsSummary.getCustomBuildData().putAll(buildResults.getCustomBuildData());
        BuildHungDetails buildHungDetails = currentlyBuilding.getBuildHangDetails();
        if (buildHungDetails != null) {
            resultsSummary.getCustomBuildData().putAll(buildHungDetails.getDataMap());
        }
        if (resultsSummary.getChainResultsSummary() == null) {
            resultsSummary.setTriggerReason(buildContext.getTriggerReason());
        }
        if ((currentlyBuildingAgent = currentlyBuilding.getBuildAgentId()) != null) {
            resultsSummary.setBuildAgentId(currentlyBuildingAgent);
        }
        ArtifactContext artifactContext = buildContext.getArtifactContext();
        for (ArtifactPublishingResult result : artifactContext.getPublishingResults()) {
            this.artifactLinkManager.addArtifactLinks((BuildResultsSummary)resultsSummary, result);
        }
        return resultsSummary;
    }

    public void calculateAndSetDeltaState(ResultsSummary resultsSummary) {
        ResultsSummary breaking;
        if (resultsSummary.getBuildNumber() <= 1) {
            resultsSummary.setDeltaState(DeltaState.NONE);
            return;
        }
        ResultsSummary previousResultsSummary = this.findLastResultBefore(resultsSummary.getPlanResultKey(), ResultsSummary.class, false);
        BuildState lastBuildState = null;
        if (previousResultsSummary != null) {
            lastBuildState = previousResultsSummary.getBuildState();
        }
        DeltaState deltaState = DeltaState.determineDeltaState((BuildState)lastBuildState, (BuildState)resultsSummary.getBuildState());
        resultsSummary.setDeltaState(deltaState);
        if (deltaState == DeltaState.FIXED && (breaking = this.buildResultsSummaryDao.getBreakingBuild(resultsSummary)) != null) {
            Date breakingBuildDate = breaking.getBuildDate();
            Date currentBuildDate = resultsSummary.getBuildDate();
            if (breakingBuildDate != null && currentBuildDate != null) {
                long end = currentBuildDate.getTime();
                long start = breakingBuildDate.getTime();
                long timeToFix = end - start;
                resultsSummary.setTimeToFix(Long.valueOf(timeToFix));
            }
        }
    }

    public void updateLifeCycleState(@NotNull ResultsSummary resultsSummary, @NotNull LifeCycleState lifeCycleState, @NotNull BuildState buildState) {
        if (LifeCycleState.isExpectedStateTransition((LifeCycleState)resultsSummary.getLifeCycleState(), (LifeCycleState)lifeCycleState)) {
            resultsSummary.updateLifeCycleState(lifeCycleState, buildState);
        }
        this.saveResultSummary(resultsSummary);
    }

    public void cleanPendingLifeCycleStateNewTx(@NotNull PlanResultKey planResultKey) {
        ResultsSummary resultsSummary = this.getResultsSummary(planResultKey);
        if (resultsSummary.getBuildCompletedDate() == null) {
            resultsSummary.setBuildCompletedDate(new Date());
        }
        this.updateLifeCycleState(resultsSummary, LifeCycleState.NOT_BUILT, BuildState.UNKNOWN);
    }

    public void updateLifeCycleState(@NotNull BuildIdentifier buildIdentifier, @NotNull LifeCycleState lifeCycleState, @NotNull BuildState buildState) {
        ResultsSummary resultsSummary = this.getResultsSummary(buildIdentifier.getPlanResultKey());
        if (resultsSummary instanceof BuildResultsSummaryImpl) {
            CurrentlyBuilding currentlyBuilding = this.buildExecutionManager.getCurrentlyBuildingByBuildResult(buildIdentifier);
            resultsSummary.setQueueTime(currentlyBuilding.getQueueTime());
            ((BuildResultsSummaryImpl)resultsSummary).setVcsUpdateTime(currentlyBuilding.getVcsUpdateTime());
            Long currentlyBuildingAgent = currentlyBuilding.getBuildAgentId();
            if (currentlyBuildingAgent != null) {
                resultsSummary.setBuildAgentId(currentlyBuildingAgent.longValue());
            }
            resultsSummary.setBuildDate(currentlyBuilding.getStartTime());
        }
        if (resultsSummary != null) {
            this.updateLifeCycleState(resultsSummary, lifeCycleState, buildState);
        }
    }

    public void updatePlanCompletedDate(@NotNull ChainResultsSummary resultSummary, @NotNull Date completionDate) {
        resultSummary.setBuildCompletedDate(completionDate);
        Date buildDate = resultSummary.getBuildDate();
        long previousDuration = resultSummary.getDuration();
        long currentDuration = buildDate != null ? completionDate.getTime() - buildDate.getTime() : 0L;
        resultSummary.setDuration(previousDuration + currentDuration);
        this.updateProcessingDuration(resultSummary);
        this.saveResultSummary((ResultsSummary)resultSummary);
    }

    public void updateProcessingDuration(ChainResultsSummary resultSummary) {
        long duration = 0L;
        for (ChainStageResult stageResult : resultSummary.getStageResults()) {
            long maxJobDuration = 0L;
            for (ResultsSummary jobResult : stageResult.getBuildResults()) {
                maxJobDuration = Math.max(maxJobDuration, this.calculateJobDurationIncludingQueuedTime(jobResult));
            }
            stageResult.setProcessingDuration(maxJobDuration);
            duration += maxJobDuration;
        }
        resultSummary.setProcessingDuration(duration);
    }

    public int markResultSummariesForDeletion(@NotNull PlanKey planKey) {
        return this.buildResultsSummaryDao.markResultSummariesForDeletion(planKey);
    }

    private long calculateJobDurationIncludingQueuedTime(ResultsSummary resultSummary) {
        Date endTime;
        Date startTime = resultSummary.getQueueTime() == null ? resultSummary.getBuildDate() : resultSummary.getQueueTime();
        Date date = endTime = resultSummary.getBuildCompletedDate() == null ? resultSummary.getBuildCancelledDate() : resultSummary.getBuildCompletedDate();
        if (endTime != null && startTime != null) {
            return Math.max(0L, endTime.getTime() - startTime.getTime());
        }
        return 0L;
    }

    private Commit generateCommitFromChangeLogs(CommitContext changeLogEntry, RepositoryChangeset repositoryChangeset) {
        CommitImpl commit = new CommitImpl();
        commit.setDate(changeLogEntry.getDate());
        commit.setChangeSetId(changeLogEntry.getChangeSetId());
        commit.setRepositoryChangeset(repositoryChangeset);
        commit.setComment(changeLogEntry.getComment());
        commit.setFiles(changeLogEntry.getFiles());
        commit.setForeignCommit(changeLogEntry.isForeignCommit());
        String authorName = StringUtils.defaultString((String)changeLogEntry.getAuthorContext().getName()).trim();
        ExtendedAuthor author = this.extendedAuthorManager.getExtendedAuthorByName(authorName);
        if (author == null) {
            throw new RuntimeException("Author '" + authorName + "' does not exists. Author must be created prior to generating BuildResultSummary.");
        }
        commit.setAuthor((Author)author);
        return commit;
    }

    @Nullable
    public ResultsSummary getBreakingBuild(ResultsSummary buildResultsSummary) {
        return this.buildResultsSummaryDao.getBreakingBuild(buildResultsSummary);
    }

    @Nullable
    public ResultsSummary getFixingBuild(ResultsSummary buildResultsSummary) {
        return this.buildResultsSummaryDao.getFixingBuild(buildResultsSummary);
    }

    @NotNull
    public <T extends ResultsSummary> T getAnyResultSummary(@NotNull ResultsSummaryCriteria criteria, ResultDataRead dataRead) {
        return (T)this.buildResultsSummaryDao.findAnyResultSummary(criteria, dataRead);
    }

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummaries(@NotNull ResultsSummaryCriteria resultsSummaryCriteria) {
        return this.buildResultsSummaryDao.findResultsSummaries(resultsSummaryCriteria);
    }

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesForExpiry(@NotNull ExpiryCriteria expiryCriteria) {
        return this.buildResultsSummaryDao.findResultSummariesForExpiry(expiryCriteria);
    }

    @NotNull
    public List<ResultsSummary> getLastNResultsSummaries(@NotNull ImmutablePlan plan, int numberOfResults) {
        ResultsSummaryCriteria criteria = new ResultsSummaryCriteriaBuilder().setPlanKey(plan.getKey()).setSortField("buildNumber").setSortAscending(false).setMaxRowCount(numberOfResults).buildCriteria();
        return this.buildResultsSummaryDao.findResultsSummaries(criteria);
    }

    @NotNull
    public List<ResultsSummary> getLastNFailedResultsSummaries(@NotNull Plan plan, int numberOfResults) {
        ResultsSummaryCriteria criteria = new ResultsSummaryCriteriaBuilder().setPlanKey(plan.getKey()).setBuildState(BuildState.FAILED).setSortField("buildNumber").setSortAscending(false).setMaxRowCount(numberOfResults).buildCriteria();
        return this.getResultSummaries(criteria);
    }

    @NotNull
    public List<? extends ResultsSummary> findResultsSummariesByJiraIssues(@Nullable List<String> issueKeys) {
        return this.buildResultsSummaryDao.findBuildResultsSummariesByJiraIssues(issueKeys);
    }

    @NotNull
    public List<? extends ResultsSummary> findResultsSummariesByProjectKey(@Nullable String projectKey) {
        return this.buildResultsSummaryDao.findBuildResultsSummariesByProjectKey(projectKey);
    }

    @NotNull
    public List<LinkedJiraIssue> findJiraIssuesForResults(@NotNull List<ResultsSummary> buildResults) {
        return this.buildResultsSummaryDao.getJiraIssuesForBuildResults(buildResults);
    }

    @NotNull
    public List<LinkedJiraIssue> findJiraIssuesForPlanKey(@NotNull PlanKey planKey) {
        return this.buildResultsSummaryDao.getJiraIssuesForPlanKey(planKey);
    }

    public void removeResultSummary(@NotNull ImmutablePlan plan, int buildNumber) {
        ImmutableChain chain = (ImmutableChain)Narrow.downTo((Object)plan, ImmutableChain.class);
        ImmutableBuildable buildable = (ImmutableBuildable)Narrow.downTo((Object)plan, ImmutableBuildable.class);
        if (buildable != null) {
            BuildResultsSummary buildResultsSummary = this.getBuildResultsSummary(buildable.getPlanKey(), buildNumber);
            if (buildResultsSummary != null) {
                this.removeBuildResult(buildResultsSummary, true);
            } else {
                log.warn((Object)("Trying to remove non existent build result " + plan + " #" + buildNumber));
            }
        } else if (chain != null) {
            ChainResultsSummary chainResultsSummary = (ChainResultsSummary)this.buildResultsSummaryDao.getResultsSummary(PlanKeys.getPlanResultKey((PlanKey)plan.getPlanKey(), (int)buildNumber), ChainResultsSummary.class);
            if (chainResultsSummary != null) {
                this.removeChainResult(chainResultsSummary);
            } else {
                log.warn((Object)("Trying to remove non existent chain result " + plan + " #" + buildNumber));
            }
        } else {
            throw new IllegalStateException("Can't handle Plan that is neither Chain nor Buildable in removeResultSummary: " + plan.getClass());
        }
    }

    public void removeResultSummary(@Nullable ImmutablePlan plan, @NotNull ResultsSummary resultsSummary) {
        this.removeResultSummary(resultsSummary);
    }

    public void removeResultSummary(@NotNull PlanResultKey planResultKey) {
        ResultsSummary resultsSummary = this.buildResultsSummaryDao.getResultsSummary(planResultKey, ResultsSummary.class);
        if (resultsSummary != null) {
            this.removeResultSummary(resultsSummary);
        }
    }

    public void removeResultSummary(@NotNull ResultsSummary resultsSummary) {
        if (ResultSummaryClassHelper.isChainResult((ImmutableResultsSummary)resultsSummary)) {
            this.removeChainResult((ChainResultsSummary)resultsSummary);
        } else if (ResultSummaryClassHelper.isJobResult((ImmutableResultsSummary)resultsSummary)) {
            BuildResultsSummary buildResultsSummary = (BuildResultsSummary)resultsSummary;
            this.removeBuildResult(buildResultsSummary, true);
        } else {
            throw new IllegalStateException("Can't handle ResultsSummary that is neither ChainResultsSummary nor BuildResultsSummary in removeResultSummary");
        }
    }

    private void removeChainResult(@NotNull ChainResultsSummary chainResultsSummary) {
        ChainResultDeletedEvent event = new ChainResultDeletedEvent(this, chainResultsSummary.getPlanResultKey(), chainResultsSummary.getId());
        Set jiraIssueKeys = chainResultsSummary.getJiraIssueKeys();
        this.removeBuildLogs((ResultsSummary)chainResultsSummary);
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryManagerImpl#removeChainResult");){
            for (ChainStageResult stageResult : chainResultsSummary.getStageResults()) {
                for (BuildResultsSummary buildResultsSummary : stageResult.getBuildResults()) {
                    Buildable buildable = (Buildable)this.planManager.getPlanByKey(buildResultsSummary.getPlanKey(), Buildable.class);
                    this.removeBuildResult(buildResultsSummary, false);
                }
            }
            try {
                this.artifactLinkManager.removeArtifactLinks(chainResultsSummary);
            }
            catch (IOException e) {
                log.warn((Object)("Unable to remove artifact links for " + chainResultsSummary.getPlanResultKey()), (Throwable)e);
            }
            this.commentManager.deleteAllCommentsForEntity((BambooIdProvider)chainResultsSummary);
            this.buildResultsIndexer.deIndexChainResults(chainResultsSummary, jiraIssueKeys, false);
            this.buildResultsSummaryDao.removeResultsSummary((ResultsSummary)chainResultsSummary);
        }
        this.eventPublisher.publish((Object)event);
    }

    private void removeBuildResult(@NotNull BuildResultsSummary buildResultsSummary, boolean performDbDelete) {
        BuildResultDeletedEvent event = new BuildResultDeletedEvent(this, buildResultsSummary.getPlanResultKey(), buildResultsSummary.getId());
        try (Ticker ignored = Timers.start((String)"BuildResultsSummaryManagerImpl#removeBuildResult");){
            int buildNumber = buildResultsSummary.getBuildNumber();
            if (performDbDelete) {
                this.buildResultsSummaryDao.removeResultsSummary((ResultsSummary)buildResultsSummary);
            }
            this.buildResultsIndexer.deIndexBuildResults((ResultsSummary)buildResultsSummary, true);
            Persister persister = PersisterFactory.getInstance();
            persister.deleteBuildResults(buildResultsSummary.getPlanKey(), (long)buildNumber);
            this.artifactLinkManager.removeArtifactLinks(buildResultsSummary);
            this.commentManager.deleteAllCommentsForEntity((BambooIdProvider)buildResultsSummary);
            this.removeJobResultLogs(buildResultsSummary, -1L);
        }
        this.eventPublisher.publish((Object)event);
    }

    public void removeBuildLogs(ImmutablePlan plan, int buildNumber) {
        this.removeBuildLogs(plan, buildNumber, -1L);
    }

    public void removeBuildLogs(ImmutablePlan plan, int buildNumber, long maxIgnoredSize) {
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)plan.getPlanKey(), (int)buildNumber);
        if (PlanClassHelper.isChain((ImmutablePlan)plan)) {
            ChainResultsSummary chainResultsSummary = (ChainResultsSummary)this.buildResultsSummaryDao.getResultsSummary(planResultKey, ChainResultsSummary.class);
            if (chainResultsSummary != null) {
                this.removeChainResultLogs(chainResultsSummary, maxIgnoredSize);
            }
        } else if (PlanClassHelper.isJob((ImmutablePlan)plan)) {
            BuildResultsSummary buildResultsSummary = (BuildResultsSummary)this.buildResultsSummaryDao.getResultsSummary(planResultKey, BuildResultsSummary.class);
            if (buildResultsSummary != null) {
                this.removeJobResultLogs(buildResultsSummary, maxIgnoredSize);
            }
        } else {
            throw new IllegalArgumentException("Couldn't remove logs for an ImmutablePlan which was neither a chain nor a job: " + plan.getPlanKey());
        }
    }

    public void removeBuildLogs(@NotNull ResultsSummary resultsSummary) {
        this.removeBuildLogs(resultsSummary, -1L);
    }

    public void removeBuildLogs(@NotNull ResultsSummary resultsSummary, long maxIgnoredSize) {
        if (ResultSummaryClassHelper.isChainResult((ImmutableResultsSummary)resultsSummary)) {
            this.removeChainResultLogs((ChainResultsSummary)resultsSummary, maxIgnoredSize);
        } else if (ResultSummaryClassHelper.isJobResult((ImmutableResultsSummary)resultsSummary)) {
            this.removeJobResultLogs((BuildResultsSummary)resultsSummary, maxIgnoredSize);
        } else {
            throw new IllegalArgumentException("Couldn't remove logs for a ResultsSummary which was neither a chain result nor a job result: " + resultsSummary.getPlanResultKey());
        }
    }

    private void removeChainResultLogs(ChainResultsSummary chainResultsSummary, long maxIgnoredSize) {
        if (BuildResultsSummaryManagerImpl.qualifiesForLogExpiration((ImmutableResultsSummary)chainResultsSummary, maxIgnoredSize)) {
            long maxLogSize = -1L;
            for (ChainStageResult stageResult : chainResultsSummary.getStageResults()) {
                for (BuildResultsSummary buildResultsSummary : stageResult.getBuildResults()) {
                    this.removeJobResultLogs(buildResultsSummary, maxIgnoredSize);
                    maxLogSize = Math.max(maxLogSize, buildResultsSummary.getLogSize());
                }
            }
            this.removeLog(chainResultsSummary.getPlanKey(), chainResultsSummary.getBuildNumber(), maxIgnoredSize);
            chainResultsSummary.setLogSize(Long.valueOf(maxLogSize));
            this.buildResultsSummaryDao.save((BambooObject)chainResultsSummary);
        }
    }

    private void removeJobResultLogs(BuildResultsSummary buildResultsSummary, long maxIgnoredSize) {
        if (BuildResultsSummaryManagerImpl.qualifiesForLogExpiration((ImmutableResultsSummary)buildResultsSummary, maxIgnoredSize)) {
            this.removeLog(buildResultsSummary.getPlanKey(), buildResultsSummary.getBuildNumber(), maxIgnoredSize);
            File logFile = this.getLogFile(buildResultsSummary.getPlanKey(), buildResultsSummary.getBuildNumber());
            buildResultsSummary.setLogSize(Long.valueOf(logFile.exists() ? logFile.length() : -1L));
            this.buildResultsSummaryDao.save((BambooObject)buildResultsSummary);
        }
    }

    public void removeMatchingArtifacts(@NotNull ResultsSummary resultsSummary, @NotNull Predicate<ArtifactLink> predicate) throws IOException {
        ChainResultsSummary chainResultsSummary = (ChainResultsSummary)Narrow.to((Object)resultsSummary, ChainResultsSummary.class);
        if (chainResultsSummary != null) {
            for (ChainStageResult stageResult : chainResultsSummary.getStageResults()) {
                for (BuildResultsSummary jobResultsSummary : stageResult.getBuildResults()) {
                    this.removeMatchingArtifacts((ResultsSummary)jobResultsSummary, predicate);
                }
            }
        } else {
            List matchingArtifacts = resultsSummary.getArtifactLinks().stream().filter(arg_0 -> predicate.apply(arg_0)).collect(Collectors.toList());
            FirstException firstException = new FirstException();
            for (ArtifactLink artifactLink : matchingArtifacts) {
                try {
                    this.artifactLinkManager.removeArtifactLink(artifactLink);
                }
                catch (IOException e) {
                    firstException.setIfFirst((Throwable)e);
                }
            }
            firstException.throwIfPresent();
        }
    }

    public void removeArtifacts(@NotNull ImmutablePlan plan, int buildNumber) throws IOException {
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((PlanKey)plan.getPlanKey(), (int)buildNumber);
        if (PlanClassHelper.isChain((ImmutablePlan)plan)) {
            ChainResultsSummary chainResultsSummary = (ChainResultsSummary)this.buildResultsSummaryDao.getResultsSummary(planResultKey, ChainResultsSummary.class);
            if (chainResultsSummary != null) {
                this.removeChainArtifacts(chainResultsSummary);
            }
        } else if (PlanClassHelper.isJob((ImmutablePlan)plan)) {
            BuildResultsSummary buildResultsSummary = this.getBuildResultsSummary(planResultKey);
            if (buildResultsSummary != null) {
                this.removeJobArtifacts(buildResultsSummary);
            }
        } else {
            log.warn((Object)"Trying to delete artifact of Plan which is neither a Chain nor a Job in removeArtifacts");
        }
    }

    public void removeArtifacts(@NotNull ResultsSummary resultsSummary) throws IOException {
        if (ResultSummaryClassHelper.isChainResult((ImmutableResultsSummary)resultsSummary)) {
            this.removeChainArtifacts((ChainResultsSummary)resultsSummary);
        } else if (ResultSummaryClassHelper.isJobResult((ImmutableResultsSummary)resultsSummary)) {
            this.removeJobArtifacts((BuildResultsSummary)resultsSummary);
        } else {
            log.warn((Object)"Trying to delete artifact of ResultsSummary which is neither a ChainResultsSummary nor a BuildResultsSummary in removeArtifacts");
        }
    }

    private void removeChainArtifacts(@NotNull ChainResultsSummary chainResultsSummary) throws IOException {
        for (ChainStageResult stageResult : chainResultsSummary.getStageResults()) {
            for (BuildResultsSummary buildResultsSummary : stageResult.getBuildResults()) {
                log.debug((Object)("Removing artifacts for " + buildResultsSummary.getPlanResultKey()));
                this.artifactLinkManager.removeArtifactLinks(buildResultsSummary);
            }
        }
        log.debug((Object)("Removing artifacts for " + chainResultsSummary.getPlanResultKey()));
        this.artifactLinkManager.removeArtifactLinks(chainResultsSummary);
    }

    private void removeJobArtifacts(@NotNull BuildResultsSummary buildResultsSummary) {
        if (!buildResultsSummary.getArtifactLinks().isEmpty()) {
            log.debug((Object)("Removing job artifacts for " + buildResultsSummary.getPlanResultKey()));
            this.artifactLinkManager.removeArtifactLinks(buildResultsSummary);
        }
    }

    public List<ChainResultsSummary> findChainResultsWithJobLabelled(ResultsSummaryCriteria criteria, List<Label> labels) {
        return this.buildResultsSummaryDao.findChainResultsWithJobLabelled(criteria, labels);
    }

    @NotNull
    public List<ResultsSummary> getNeighbouringSummaries(Plan plan, int buildNumber) {
        return this.buildResultsSummaryDao.getNeighbouringSummaries(plan, buildNumber);
    }

    @NotNull
    public List<ResultsSummary> getNeighbouringSummaries(@NotNull ImmutablePlan plan, int buildNumber, int maxCount) {
        return this.buildResultsSummaryDao.getNeighbouringSummaries(plan, buildNumber, maxCount);
    }

    @NotNull
    public List<ResultsSummary> getBeforeSummaries(@NotNull ImmutablePlan plan, int buildNumber, int maxCount) {
        return this.buildResultsSummaryDao.getBeforeSummaries(plan, buildNumber, maxCount);
    }

    @NotNull
    public List<ResultsSummary> getAfterSummaries(@NotNull ImmutablePlan plan, int buildNumber, int maxCount) {
        return this.buildResultsSummaryDao.getAfterSummaries(plan, buildNumber, maxCount);
    }

    public int removeResultsSummariesForPlan(@NotNull Plan plan) {
        return this.removeResultsForPlan(plan.getPlanKey());
    }

    public int removeAllOrphanedResultSummaries() {
        Iterable planKeysOfOrphanedResults = this.buildResultsSummaryDao.findPlanKeysFromAllOrphanedResultSummaries();
        int resultsDeleted = 0;
        for (PlanKey planKey : planKeysOfOrphanedResults) {
            log.info((Object)("Deleting orphaned results for " + planKey + ". Plan has already been deleted."));
            int deletedForPlan = this.removeResultsForPlan(planKey);
            log.info((Object)("Deleted " + deletedForPlan + " orphaned results for " + planKey + "."));
            resultsDeleted += deletedForPlan;
        }
        return resultsDeleted;
    }

    private int removeResultsForPlan(PlanKey planKey) {
        return this.buildResultsSummaryDao.removeResultsSummariesForPlan(planKey);
    }

    @Nullable
    private BuildResultsSummary getBuildResultsSummary(PlanKey planKey, int buildNumber) {
        return this.getBuildResultsSummary(PlanKeys.getPlanResultKey((PlanKey)planKey, (int)buildNumber));
    }

    @Nullable
    private BuildResultsSummary getBuildResultsSummary(PlanResultKey planResultKey) {
        return (BuildResultsSummary)this.buildResultsSummaryDao.getResultsSummary(planResultKey, BuildResultsSummary.class);
    }

    public void saveResultSummary(@NotNull ResultsSummary resultsSummary) {
        this.buildResultsSummaryDao.save((BambooObject)resultsSummary);
    }

    public ResultsSummary getLastSuccessfulResultSummary(@NotNull PlanKey planKey) {
        ResultsSummaryCriteria criteria = new ResultsSummaryCriteria(planKey.getKey());
        criteria.setResultSummaryClass(ResultsSummary.class);
        criteria.setMaxRowCount(1);
        criteria.setBuildState(BuildState.SUCCESS);
        criteria.setSpecsResult(false);
        List buildResults = this.buildResultsSummaryDao.findResultsSummaries(criteria);
        return (ResultsSummary)Iterables.getFirst((Iterable)buildResults, null);
    }

    @Nullable
    public ResultsSummary findLastSuccessfulBuildResultBefore(@NotNull PlanResultKey planResultKey) {
        return this.buildResultsSummaryDao.findLastBuildResultWithBuildStateBefore(planResultKey.getPlanKey().getKey(), planResultKey.getBuildNumber(), BuildState.SUCCESS, true);
    }

    @Nullable
    public ResultsSummary findLastSuccessfulBuildResultBefore(@NotNull PlanResultKey planResultKey, boolean includeOnceOffBuilds) {
        return this.buildResultsSummaryDao.findLastBuildResultWithBuildStateBefore(planResultKey.getPlanKey().getKey(), planResultKey.getBuildNumber(), BuildState.SUCCESS, includeOnceOffBuilds);
    }

    @Nullable
    public <T extends ResultsSummary> T findFirstResultAfter(@NotNull PlanResultKey planResultKey, Class<T> aClass) {
        return (T)this.buildResultsSummaryDao.findFirstResultAfter(planResultKey.getPlanKey().getKey(), planResultKey.getBuildNumber(), aClass);
    }

    @Nullable
    public <T extends ResultsSummary> T findLastResultBefore(@NotNull PlanResultKey planResultKey, Class<T> aClass) {
        return (T)this.buildResultsSummaryDao.findLastResultBefore(planResultKey.getPlanKey().getKey(), planResultKey.getBuildNumber(), aClass, true);
    }

    @Nullable
    public <T extends ResultsSummary> T findLastResultBefore(@NotNull PlanResultKey planResultKey, Class<T> aClass, boolean includeOnceOffBuilds) {
        return (T)this.buildResultsSummaryDao.findLastResultBefore(planResultKey.getPlanKey().getKey(), planResultKey.getBuildNumber(), aClass, includeOnceOffBuilds);
    }

    public <T extends ResultsSummary> T findLastResultSummaryWithState(@NotNull PlanKey planKey, @NotNull BuildState buildState, @NotNull Class<T> aClass) {
        return (T)this.buildResultsSummaryDao.findLastResultSummaryWithState(planKey, buildState, aClass);
    }

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesByChangeSetId(@NotNull String changeSetId, @NotNull Class<T> discriminator) {
        return this.buildResultsSummaryDao.getResultSummariesByChangeSetId(changeSetId, discriminator);
    }

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesByCheckoutChangesetId(@NotNull String changeSetId, @NotNull Class<T> discriminator) {
        return this.buildResultsSummaryDao.getResultSummariesByCheckoutChangesetId(changeSetId, discriminator);
    }

    public <T extends ResultsSummary> List<T> getResultSummariesByChangeSetIdAndRepository(long repositoryId, @NotNull String changeSetId, @NotNull Class<T> discriminator) {
        return this.buildResultsSummaryDao.getResultSummariesByChangeSetIdAndRepository(repositoryId, changeSetId, discriminator);
    }

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesByChangeSetIds(@NotNull List<String> changeSetIds, Class<T> discriminator) {
        return changeSetIds.isEmpty() ? Collections.emptyList() : this.buildResultsSummaryDao.getResultSummariesByChangeSetIds(changeSetIds, discriminator);
    }

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesByChangeSetIds(@NotNull Iterable<Pair<String, RepositoryData>> changeSetIds, Class<T> discriminator) {
        ArrayList result = new ArrayList();
        for (Pair<String, RepositoryData> changeSetIdPair : changeSetIds) {
            if (changeSetIdPair == null || changeSetIdPair.first == null || changeSetIdPair.second == null) continue;
            long desiredRepositoryId = ((RepositoryData)changeSetIdPair.second).getId();
            VcsRepositoryModuleDescriptor vcsRepositoryModuleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(((RepositoryData)changeSetIdPair.getSecond()).getPluginKey());
            List resultSummariesByChangeSetId = this.buildResultsSummaryDao.getResultSummariesByChangeSetId((String)changeSetIdPair.first, discriminator);
            if (vcsRepositoryModuleDescriptor != null && vcsRepositoryModuleDescriptor.revisionIdsAreUnique()) {
                result.addAll(resultSummariesByChangeSetId);
                continue;
            }
            resultSummariesByChangeSetId.stream().filter(resultSummary -> resultSummary.getRepositoryChangesets().stream().anyMatch(rc -> rc.getRepositoryData().getId() == desiredRepositoryId)).forEach(result::add);
        }
        return result;
    }

    @NotNull
    public List<UnassociatedCommit> getCommitsForUser(@NotNull String username, int max) {
        return new ArrayList<UnassociatedCommit>(new LinkedHashSet(this.commitDao.getCommitsForUser(username, max)));
    }

    @Nullable
    public ResultsSummary findLastBuildResultBefore(@NotNull String buildKey, int buildNumber) {
        return this.buildResultsSummaryDao.findLastResultBefore(buildKey, buildNumber, ResultsSummary.class, true);
    }

    public <T extends ResultsSummary> T findLastBuildResultBeforeWithTests(@NotNull PlanResultKey planResultKey, @NotNull Class<T> aClass, boolean includeOnceOffBuilds) {
        return (T)this.buildResultsSummaryDao.findLastBuildResultBeforeWithTests(planResultKey, aClass, includeOnceOffBuilds);
    }

    @Nullable
    public ResultsSummary findFirstFailedBuildResultAfter(@NotNull String buildKey, int buildNumber) {
        return this.buildResultsSummaryDao.findFirstBuildResultWithBuildStateAfter(buildKey, buildNumber, BuildState.FAILED);
    }

    @Nullable
    public ResultsSummary findFirstSuccessfulBuildResultAfter(@NotNull PlanResultKey planResultKey) {
        return this.buildResultsSummaryDao.findFirstBuildResultWithBuildStateAfter(planResultKey.getPlanKey().getKey(), planResultKey.getBuildNumber(), BuildState.SUCCESS);
    }

    @Nullable
    public ResultsSummary findLastFailingBuildResultBefore(@NotNull ImmutablePlan build, int buildNumber) {
        return this.buildResultsSummaryDao.findLastBuildResultWithBuildStateBefore(build.getKey(), buildNumber, BuildState.FAILED, true);
    }

    @Nullable
    public ResultsSummary findLastFailingBuildResultBefore(@NotNull PlanKey planKey, int buildNumber) {
        return this.buildResultsSummaryDao.findLastBuildResultWithBuildStateBefore(planKey.getKey(), buildNumber, BuildState.FAILED, true);
    }

    @Nullable
    public ResultsSummary findFirstFailedBuildResultBetween(@NotNull ImmutablePlan build, int lowerBuildNumber, int upperBuildNumber) {
        return this.buildResultsSummaryDao.findFirstBuildResultWithBuildStateBetween(build.getKey(), lowerBuildNumber, upperBuildNumber, BuildState.FAILED);
    }

    @Nullable
    public ResultsSummary findFirstFailedBuildResultBetween(@NotNull PlanKey planKey, int lowerBuildNumber, int upperBuildNumber) {
        return this.buildResultsSummaryDao.findFirstBuildResultWithBuildStateBetween(planKey.getKey(), lowerBuildNumber, upperBuildNumber, BuildState.FAILED);
    }

    @Nullable
    public ChainResultsSummary getParentResultSummary(ResultsSummary resultsSummary) {
        return this.buildResultsSummaryDao.getParentResultSummary(resultsSummary);
    }

    @Nullable
    public ChainStageResult getStageForResult(ResultsSummary resultsSummary) {
        return this.buildResultsSummaryDao.getStageForResult(resultsSummary);
    }

    public long getNumberOfResults() {
        return this.buildResultsSummaryDao.countBuildResultsSummaries();
    }

    public long getNumberOfFinishedResults(@NotNull Plan plan) {
        return this.buildResultsSummaryDao.getNumberOfFinishedResults(plan);
    }

    public long getNumberOfFinalizedResults(@NotNull ImmutablePlan plan) {
        return this.buildResultsSummaryDao.getNumberOfFinalizedResults(plan);
    }

    public long getNumberOfFinalizedResults(@NotNull PlanKey planKey) {
        return this.buildResultsSummaryDao.getNumberOfFinalizedResults(planKey);
    }

    public List<ResultsSummary> getLatestResultSummaries() {
        return this.buildResultsSummaryDao.findLatestResultsSummaries();
    }

    public List<ResultsSummary> getLatestFailedResultSummaries() {
        return this.buildResultsSummaryDao.findLatestFailedResultSummaries();
    }

    public long getAverageBuildTime(@NotNull ImmutableBuildable plan, int numberOfResults) {
        return this.getAveragePlanExecutionDuration((ImmutablePlan)plan, numberOfResults);
    }

    public long getAveragePlanExecutionDuration(@NotNull ImmutablePlan plan, int numberOfResults) {
        String planKey = plan.getKey();
        ResultsSummaryCriteria criteria = new ResultsSummaryCriteria(planKey, BuildState.SUCCESS);
        criteria.setMaxRowCount(numberOfResults);
        criteria.setSpecsResult(false);
        List resultSummaries = this.buildResultsSummaryDao.findResultsSummaries(criteria);
        if (resultSummaries.isEmpty()) {
            ResultsSummaryCriteria includingBroken = new ResultsSummaryCriteria(planKey, numberOfResults);
            includingBroken.setSpecsResult(false);
            resultSummaries = this.buildResultsSummaryDao.findResultsSummaries(includingBroken);
            if (resultSummaries.isEmpty()) {
                return 0L;
            }
        }
        int totalNumOfResults = 0;
        int totalDuration = 0;
        for (ResultsSummary buildSummary : resultSummaries) {
            totalDuration = (int)((long)totalDuration + buildSummary.getProcessingDuration());
            ++totalNumOfResults;
        }
        if (totalNumOfResults != 0) {
            return totalDuration / totalNumOfResults;
        }
        return 0L;
    }

    public int countResultsWithState(@NotNull PlanKey planKey, int lowerBuildNumber, int upperBuildNumber, @NotNull BuildState buildState) {
        return this.buildResultsSummaryDao.countResultsWithState(planKey, lowerBuildNumber, upperBuildNumber, buildState);
    }

    @Nullable
    public <T extends ResultsSummary> T getLastResultsSummary(@NotNull String planKey, Class<T> aClass) {
        ResultsSummary resultsSummary = this.buildResultsSummaryDao.getLastResultSummary(planKey, ResultsSummary.class);
        if (resultsSummary != null && (resultsSummary = (ResultsSummary)Narrow.to((Object)resultsSummary, aClass)) == null) {
            throw new IncorrectResultSummaryTypeException("Cannot find last result for '" + planKey + "' with type '" + aClass + "'");
        }
        return (T)resultsSummary;
    }

    private <T extends ResultsSummary> AbstractResultsSummary createNewInstance(PlanResultKey planResultKey, Class<T> aClass) throws ResultsSummaryCreationException {
        Class resultsSummaryClass = this.typeRegistry.get(aClass);
        if (resultsSummaryClass == null) {
            throw new ResultsSummaryCreationException("Build Result '" + planResultKey + "' could not be created because Class '" + aClass.getName() + "' does not have any mapping that extends com.atlassian.bamboo.resultsummary.AbstractResultsSummary");
        }
        try {
            return (AbstractResultsSummary)resultsSummaryClass.newInstance();
        }
        catch (Exception e) {
            throw new ResultsSummaryCreationException("Build Result '" + planResultKey + "' could not be created because of error '" + e.getMessage() + "'", (Throwable)e);
        }
    }

    public void moveResultSummaries(@NotNull Plan newParentPlan, @NotNull PlanKey oldPlanKey, @NotNull PlanKey newPlanKey) {
        PlanKey planKeyUsedForAuthorisation = newParentPlan.getPlanKey();
        if (!planKeyUsedForAuthorisation.equals((Object)newPlanKey) && !planKeyUsedForAuthorisation.equals((Object)PlanKeys.getChainKeyFromJobKey((PlanKey)newPlanKey))) {
            throw new IllegalArgumentException(newPlanKey + " does not match " + planKeyUsedForAuthorisation);
        }
        this.moveResultSummaries(oldPlanKey, newPlanKey);
    }

    private void moveResultSummaries(PlanKey oldPlanKey, PlanKey newPlanKey) {
        int resultSummariesMoved = this.buildResultsSummaryDao.moveResultSummaries(oldPlanKey, newPlanKey);
        log.info((Object)("Moved " + resultSummariesMoved + " result summaries from " + oldPlanKey.getKey() + " to " + newPlanKey.getKey()));
    }

    public long scrollResultSummaries(@NotNull String buildKey, @NotNull Function<ResultsSummary, Void> function) {
        return this.buildResultsSummaryDao.scrollResultSummaries(buildKey, ResultDataRead.LAZY, arg_0 -> function.apply(arg_0));
    }

    public long scrollResultSummaries(@NotNull String buildKey, ResultDataRead resultDataRead, @NotNull Function<ResultsSummary, Void> function) {
        return this.buildResultsSummaryDao.scrollResultSummaries(buildKey, resultDataRead, arg_0 -> function.apply(arg_0));
    }

    public void logVariablesForSubstitution(@NotNull BuildContext buildContext, @NotNull ResultsSummary resultsSummary) {
    }

    public void logSubstitutedVariables(@NotNull BuildContext buildContext, @NotNull ResultsSummary resultsSummary) {
    }

    public void removeMergeResultSummary(@NotNull MergeResultSummary mergeResult) {
        this.mergeResultSummaryDao.delete((BambooObject)mergeResult);
    }

    @NotNull
    public List<PlanKey> getPlanKeysSortedByNumberOfFinalizedResultSummaries() {
        return this.buildResultsSummaryDao.getPlanKeysSortedByNumberOfFinalizedResultSummaries();
    }

    @Nullable
    public Long calculateQueueDuration(@NotNull ChainResultsSummary resultsSummary) {
        return this.buildResultsSummaryDao.calculateQueueDuration(resultsSummary);
    }

    @Nullable
    public Long calculateVcsUpdateDuration(@NotNull ChainResultsSummary resultsSummary) {
        return this.buildResultsSummaryDao.calculateVcsUpdateDuration(resultsSummary);
    }

    @NotNull
    public List<Integer> findAllBuildResultsNumbers(PlanKey planKey) {
        return this.buildResultsSummaryDao.findAllBuildResultsNumbers(planKey);
    }

    public void invalidateLogSize(@NotNull PlanResultKey planResultKey) {
        ChainResultsSummary chainResultsSummary;
        BuildResultsSummary buildResultsSummary;
        ResultsSummary resultsSummary = this.buildResultsSummaryDao.getResultsSummary(planResultKey, ResultsSummary.class);
        if (resultsSummary == null) {
            return;
        }
        if (resultsSummary.getLogSize() != null) {
            resultsSummary.setLogSize(null);
            this.saveResultSummary(resultsSummary);
        }
        if ((buildResultsSummary = (BuildResultsSummary)Narrow.to((Object)resultsSummary, BuildResultsSummary.class)) != null && (chainResultsSummary = buildResultsSummary.getChainResultsSummary()) != null && chainResultsSummary.getLogSize() != null) {
            chainResultsSummary.setLogSize(null);
            this.saveResultSummary((ResultsSummary)chainResultsSummary);
        }
    }

    @NotNull
    public List<PlanResultKey> findChainResultsWithFormatVersionLessThan(int formatVersion, int maxResults) {
        return this.buildResultsSummaryDao.findChainResultsWithFormatVersionLessThan(formatVersion, maxResults);
    }

    @NotNull
    public Range<Integer> findBuildResultNumbersRange(@NotNull PlanKey planKey) {
        return this.buildResultsSummaryDao.findBuildResultsNumberRange(planKey);
    }

    @NotNull
    public List<PlanKey> findJobKeysFromExistingChainResults(@NotNull PlanKey chainKey) {
        return this.buildResultsSummaryDao.findJobKeysFromExistingChainResults(chainKey);
    }

    private static boolean qualifiesForLogExpiration(@NotNull ImmutableResultsSummary resultsSummary, long maxIgnoredLogSize) {
        return resultsSummary.getLogSize() == null || resultsSummary.getLogSize() > maxIgnoredLogSize;
    }

    @NotNull
    private File getLogFile(@NotNull PlanKey key, int buildNumber) {
        return this.storageLocationService.getLogFile((Key)key, (long)buildNumber);
    }

    private void removeLog(@NotNull PlanKey key, int buildNumber, long maxIgnoredSize) {
        boolean deleted;
        File logsFile = this.getLogFile(key, buildNumber);
        if (logsFile.length() > maxIgnoredSize && !(deleted = BambooFileUtils.deleteQuietly(logsFile)) && logsFile.exists()) {
            log.warn((Object)String.format("Couldn't delete log file for plan [%s], build [%s], file [%s]", key, buildNumber, logsFile.getAbsolutePath()));
        }
    }

    public void setBuildResultsSummaryDao(BuildResultsSummaryDao buildResultsSummaryDao) {
        this.buildResultsSummaryDao = buildResultsSummaryDao;
    }

    public void setExtendedAuthorManager(ExtendedAuthorManager extendedAuthorManager) {
        this.extendedAuthorManager = extendedAuthorManager;
    }

    public void setBuildResultsIndexer(BuildResultsIndexer buildResultsIndexer) {
        this.buildResultsIndexer = buildResultsIndexer;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setJiraIssueUtils(JiraIssueUtils jiraIssueUtils) {
        this.jiraIssueUtils = jiraIssueUtils;
    }

    public void setArtifactLinkManager(ArtifactLinkManager artifactLinkManager) {
        this.artifactLinkManager = artifactLinkManager;
    }

    public void setCommitDao(CommitDao commitDao) {
        this.commitDao = commitDao;
    }

    public void setBuildExecutionManager(BuildExecutionManager buildExecutionManager) {
        this.buildExecutionManager = buildExecutionManager;
    }

    public void setRepositoryDefinitionManager(RepositoryDefinitionManager repositoryDefinitionManager) {
        this.repositoryDefinitionManager = repositoryDefinitionManager;
    }

    public void setCommentManager(CommentManager commentManager) {
        this.commentManager = commentManager;
    }

    public void setBranchIntegrationService(BranchIntegrationService branchIntegrationService) {
        this.branchIntegrationService = branchIntegrationService;
    }

    public void setMergeResultSummaryDao(MergeResultSummaryDao mergeResultSummaryDao) {
        this.mergeResultSummaryDao = mergeResultSummaryDao;
    }

    public void setVariableContextBaselineDao(VariableContextBaselineDao variableContextBaselineDao) {
        this.variableContextBaselineDao = variableContextBaselineDao;
    }

    public void setVcsRepositoryManager(VcsRepositoryManager vcsRepositoryManager) {
        this.vcsRepositoryManager = vcsRepositoryManager;
    }

    public void setPlanManager(PlanManager planManager) {
        this.planManager = planManager;
    }
}

